/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;

public class FsIndexCollection_impl
extends MetaDataObject_impl
implements FsIndexCollection {
    private static final long serialVersionUID = -7687383527183197102L;
    private static final FsIndexDescription[] EMPTY_FS_INDEX_DESCRIPTION_ARRAY = new FsIndexDescription[0];
    private String mName;
    private String mVersion;
    private String mDescription;
    private String mVendor;
    private Import[] mImports = Import.EMPTY_IMPORTS;
    private FsIndexDescription[] mFsIndexes = EMPTY_FS_INDEX_DESCRIPTION_ARRAY;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("fsIndexCollection", new PropertyXmlInfo[]{new PropertyXmlInfo("name", true), new PropertyXmlInfo("description", true), new PropertyXmlInfo("version", true), new PropertyXmlInfo("vendor", true), new PropertyXmlInfo("imports", true), new PropertyXmlInfo("fsIndexes", "fsIndexes")});

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String aName) {
        this.mName = aName;
    }

    @Override
    public String getVersion() {
        return this.mVersion;
    }

    @Override
    public void setVersion(String aVersion) {
        this.mVersion = aVersion;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    @Override
    public String getVendor() {
        return this.mVendor;
    }

    @Override
    public void setVendor(String aVendor) {
        this.mVendor = aVendor;
    }

    @Override
    public Import[] getImports() {
        return this.mImports == null ? Import.EMPTY_IMPORTS : this.mImports;
    }

    @Override
    public void setImports(Import[] aImports) {
        if (aImports == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aImports", "setImports"});
        }
        this.mImports = aImports;
    }

    @Override
    public FsIndexDescription[] getFsIndexes() {
        if (this.mFsIndexes == null) {
            this.mFsIndexes = EMPTY_FS_INDEX_DESCRIPTION_ARRAY;
        }
        return this.mFsIndexes;
    }

    @Override
    public void setFsIndexes(FsIndexDescription[] aFSIndexes) {
        if (aFSIndexes == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aFSIndexes", "setImports"});
        }
        this.mFsIndexes = aFSIndexes;
    }

    @Override
    public void addFsIndex(FsIndexDescription aFsIndexDescription) {
        FsIndexDescription[] current = this.getFsIndexes();
        FsIndexDescription[] newArr = new FsIndexDescription[current.length + 1];
        System.arraycopy(current, 0, newArr, 0, current.length);
        newArr[current.length] = aFsIndexDescription;
        this.setFsIndexes(newArr);
    }

    @Override
    public void removeFsIndex(FsIndexDescription aFsIndexDescription) {
        FsIndexDescription[] current = this.getFsIndexes();
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != aFsIndexDescription) continue;
            FsIndexDescription[] newArr = new FsIndexDescription[current.length - 1];
            System.arraycopy(current, 0, newArr, 0, i);
            System.arraycopy(current, i + 1, newArr, i, current.length - i - 1);
            this.setFsIndexes(newArr);
            break;
        }
    }

    @Override
    public synchronized void resolveImports() throws InvalidXMLException {
        if (this.getImports().length == 0) {
            this.resolveImports(null, null);
        } else {
            this.resolveImports(new TreeSet<String>(), UIMAFramework.newDefaultResourceManager());
        }
    }

    @Override
    public synchronized void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
        this.resolveImports(this.getImports().length == 0 ? null : new TreeSet<String>(), aResourceManager);
    }

    @Override
    public synchronized void resolveImports(Collection<String> aAlreadyImportedFsIndexURLs, ResourceManager aResourceManager) throws InvalidXMLException {
        FsIndexDescription[] existingIndexes;
        ArrayList<FsIndexDescription> importedIndexes = null;
        if (this.getImports().length != 0) {
            if (this.getSourceUrl() != null) {
                aAlreadyImportedFsIndexURLs.add(this.getSourceUrl().toString());
            }
            importedIndexes = new ArrayList<FsIndexDescription>();
            Import[] imports = this.getImports();
            for (int i = 0; i < imports.length; ++i) {
                URL url;
                if (imports[i] instanceof Import_impl) {
                    ((Import_impl)imports[i]).setSourceUrlIfNull(this.getSourceUrl());
                }
                if (aAlreadyImportedFsIndexURLs.contains((url = imports[i].findAbsoluteUrl(aResourceManager)).toString())) continue;
                aAlreadyImportedFsIndexURLs.add(url.toString());
                try {
                    this.resolveImport(url, aAlreadyImportedFsIndexURLs, importedIndexes, aResourceManager);
                    continue;
                }
                catch (IOException e) {
                    throw new InvalidXMLException("import_failed_could_not_read_from_url", new Object[]{url, imports[i].getSourceUrlString()}, e);
                }
            }
        }
        if ((existingIndexes = this.getFsIndexes()) == null) {
            existingIndexes = FsIndexDescription.EMPTY_FS_INDEX_DESCRIPTIONS;
            this.setFsIndexes(FsIndexDescription.EMPTY_FS_INDEX_DESCRIPTIONS);
        }
        if (null != importedIndexes) {
            FsIndexDescription[] newIndexes = new FsIndexDescription[existingIndexes.length + importedIndexes.size()];
            System.arraycopy(existingIndexes, 0, newIndexes, 0, existingIndexes.length);
            for (int i = 0; i < importedIndexes.size(); ++i) {
                newIndexes[existingIndexes.length + i] = (FsIndexDescription)importedIndexes.get(i);
            }
            this.setFsIndexes(newIndexes);
        }
        this.setImports(Import.EMPTY_IMPORTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveImport(URL aURL, Collection<String> aAlreadyImportedFsIndexCollectionURLs, Collection<FsIndexDescription> aResults, ResourceManager aResourceManager) throws InvalidXMLException, IOException {
        FsIndexCollection desc;
        String urlString = aURL.toString();
        Map<String, XMLizable> importCache = ((ResourceManager_impl)aResourceManager).getImportCache();
        Map<String, Set<String>> importUrlsCache = ((ResourceManager_impl)aResourceManager).getImportUrlsCache();
        Map<String, XMLizable> map = importCache;
        synchronized (map) {
            XMLizable cachedObject = importCache.get(urlString);
            if (cachedObject instanceof FsIndexCollection) {
                desc = (FsIndexCollection)cachedObject;
                aAlreadyImportedFsIndexCollectionURLs.addAll((Collection<String>)importUrlsCache.get(urlString));
            } else {
                XMLInputSource input = new XMLInputSource(aURL);
                desc = UIMAFramework.getXMLParser().parseFsIndexCollection(input);
                TreeSet<String> previouslyImported = new TreeSet<String>(aAlreadyImportedFsIndexCollectionURLs);
                desc.resolveImports(aAlreadyImportedFsIndexCollectionURLs, aResourceManager);
                importCache.put(urlString, desc);
                TreeSet<String> locallyImported = new TreeSet<String>(aAlreadyImportedFsIndexCollectionURLs);
                locallyImported.removeAll(previouslyImported);
                importUrlsCache.put(urlString, locallyImported);
            }
        }
        aResults.addAll(Arrays.asList(desc.getFsIndexes()));
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }
}

