/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

public class Level {
    private int level;
    private String levelText;
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int SEVERE_INT = 70000;
    public static final int WARNING_INT = 60000;
    public static final int INFO_INT = 50000;
    public static final int CONFIG_INT = 40000;
    public static final int FINE_INT = 30000;
    public static final int FINER_INT = 20000;
    public static final int FINEST_INT = 10000;
    public static final int ALL_INT = Integer.MIN_VALUE;
    public static final int ERROR_INT = 70000;
    public static final int WARN_INT = 60000;
    public static final int DEBUG_INT = 30000;
    public static final int TRACE_INT = 20000;
    public static final Level OFF = new Level(Integer.MAX_VALUE, "OFF");
    public static final Level SEVERE;
    public static final Level ERROR;
    public static final Level WARNING;
    public static final Level WARN;
    public static final Level INFO;
    public static final Level CONFIG;
    public static final Level FINE;
    public static final Level DEBUG;
    public static final Level FINER;
    public static final Level TRACE;
    public static final Level FINEST;
    public static final Level ALL;

    protected Level(int level, String levelText) {
        this.level = level;
        this.levelText = levelText;
    }

    public boolean equals(Object o) {
        if (o instanceof Level) {
            Level r = (Level)o;
            return this.level == r.level;
        }
        return false;
    }

    public int hashCode() {
        return this.level;
    }

    public boolean isOn() {
        return this.level < Integer.MAX_VALUE;
    }

    public boolean isGreaterOrEqual(Level r) {
        if (r == null) {
            return false;
        }
        return this.level <= r.level;
    }

    public final String toString() {
        return this.levelText;
    }

    public final int toInteger() {
        return this.level;
    }

    static {
        ERROR = SEVERE = new Level(70000, "SEVERE");
        WARN = WARNING = new Level(60000, "WARNING");
        INFO = new Level(50000, "INFO");
        CONFIG = new Level(40000, "CONFIG");
        DEBUG = FINE = new Level(30000, "FINE");
        TRACE = FINER = new Level(20000, "FINER");
        FINEST = new Level(10000, "FINEST");
        ALL = new Level(Integer.MIN_VALUE, "ALL");
    }
}

