/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FloatArrayFSImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.TOP;

public final class FloatArray
extends TOP
implements CommonPrimitiveArray<Float>,
Iterable<Float>,
FloatArrayFSImpl {
    public static final String _TypeName = "uima.cas.FloatArray";
    public static final int typeIndexID;
    public static final int type;
    private final float[] theArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private FloatArray() {
        this.theArray = null;
    }

    public FloatArray(JCas jcas, int length) {
        super(jcas);
        this.theArray = new float[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2Size_arrays(length);
        }
    }

    public FloatArray(TypeImpl t, CASImpl c, int length) {
        super(t, c);
        this.theArray = new float[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2Size_arrays(length);
        }
    }

    @Override
    public float get(int i) {
        return this.theArray[i];
    }

    @Override
    public void set(int i, float v) {
        this.theArray[i] = v;
        this._casView.maybeLogArrayUpdate(this, null, i);
    }

    @Override
    public void copyFromArray(float[] src, int srcPos, int destPos, int length) {
        System.arraycopy(src, srcPos, this.theArray, destPos, length);
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    @Override
    public void copyToArray(int srcPos, float[] dest, int destPos, int length) {
        System.arraycopy(this.theArray, srcPos, dest, destPos, length);
    }

    @Override
    public float[] toArray() {
        return Arrays.copyOf(this.theArray, this.theArray.length);
    }

    @Override
    public int size() {
        return this.theArray.length;
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this._casView.checkArrayBounds(this.theArray.length, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Float.toString(this.theArray[i + srcOffset]);
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this._casView.checkArrayBounds(this.theArray.length, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.set(i + destOffset, Float.parseFloat(src[i + srcOffset]));
        }
    }

    public float[] _getTheArray() {
        return this.theArray;
    }

    @Override
    public void copyValuesFrom(CommonArrayFS v) {
        FloatArray bv = (FloatArray)v;
        System.arraycopy(bv.theArray, 0, this.theArray, 0, this.theArray.length);
        this._casView.maybeLogArrayUpdates(this, 0, this.size());
    }

    @Override
    public void setArrayValueFromString(int i, String v) {
        this.set(i, Float.parseFloat(v));
    }

    public static FloatArray create(JCas jcas, float[] a) {
        FloatArray floatArray = new FloatArray(jcas, a.length);
        floatArray.copyFromArray(a, 0, 0, a.length);
        return floatArray;
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < FloatArray.this.size();
            }

            @Override
            public Float next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Float.valueOf(FloatArray.this.get(this.i++));
            }
        };
    }

    public boolean contains(float item) {
        for (float b : this.theArray) {
            if (b != item) continue;
            return true;
        }
        return false;
    }

    static {
        type = typeIndexID = JCasRegistry.register(FloatArray.class);
    }
}

