/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CasInitializerDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.resource.CustomResourceSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;

public class UIMAUtil {
    public static final String ANALYSIS_ENGINE_CTG = "AE";
    public static final String CAS_CONSUMER_CTG = "CC";
    public static final String CAS_INITIALIZER_CTG = "CI";
    public static final String COLLECTION_READER_CTG = "CR";
    public static final String CPE_CONFIGURATION_CTG = "CPE";
    public static final String TYPE_SYSTEM_CTG = "TS";
    public static final String REUSABLE_RESOURCE_CTG = "RR";
    private static Hashtable<String, Exception> __errTableByUri = new Hashtable();

    public static Exception getLastErrorForXmlDesc(File xmlDescFile) {
        return __errTableByUri.get(xmlDescFile.getAbsolutePath());
    }

    public static Exception getLastErrorForXmlDesc(URL xmlDescUrl) {
        return __errTableByUri.get(xmlDescUrl.toString());
    }

    public static synchronized String identifyUimaComponentCategory(File xmlDescFile) throws IOException {
        return UIMAUtil.identifyUimaComponentCategory(xmlDescFile, null);
    }

    public static synchronized String identifyUimaComponentCategory(URL xmlDescUrl) throws IOException {
        return UIMAUtil.identifyUimaComponentCategory(null, xmlDescUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String identifyUimaComponentCategory(File xmlDescFile, URL xmlDescUrl) throws IOException {
        String uimaCompCtg;
        block43: {
            uimaCompCtg = null;
            XMLInputSource xmlSource = null;
            String xmlDescUri = xmlDescFile != null ? xmlDescFile.getAbsolutePath() : xmlDescUrl.toString();
            try {
                __errTableByUri.remove(xmlDescUri);
                XMLParser xmlParser = UIMAFramework.getXMLParser();
                xmlSource = xmlDescFile != null ? new XMLInputSource(xmlDescFile) : new XMLInputSource(xmlDescUrl);
                ResourceSpecifier resourceSpec = null;
                try {
                    resourceSpec = xmlParser.parseResourceSpecifier(xmlSource);
                }
                catch (UIMAException err) {
                    __errTableByUri.put(xmlDescUri, err);
                }
                catch (UIMARuntimeException exc) {
                    __errTableByUri.put(xmlDescUri, exc);
                }
                if (resourceSpec != null) {
                    if (resourceSpec instanceof AnalysisEngineDescription) {
                        uimaCompCtg = ANALYSIS_ENGINE_CTG;
                    } else if (resourceSpec instanceof CollectionReaderDescription) {
                        uimaCompCtg = COLLECTION_READER_CTG;
                    } else if (resourceSpec instanceof CasInitializerDescription) {
                        uimaCompCtg = CAS_INITIALIZER_CTG;
                    } else if (resourceSpec instanceof CasConsumerDescription) {
                        uimaCompCtg = CAS_CONSUMER_CTG;
                    } else if (resourceSpec instanceof CustomResourceSpecifier) {
                        uimaCompCtg = ANALYSIS_ENGINE_CTG;
                    }
                }
                if (uimaCompCtg == null) {
                    try {
                        xmlSource.getInputStream().close();
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    xmlSource = xmlDescFile != null ? new XMLInputSource(xmlDescFile) : new XMLInputSource(xmlDescUrl);
                    try {
                        xmlParser.parseCpeDescription(xmlSource);
                        uimaCompCtg = CPE_CONFIGURATION_CTG;
                        __errTableByUri.remove(xmlDescUri);
                    }
                    catch (UIMAException err) {
                        __errTableByUri.put(xmlDescUri, err);
                    }
                    catch (UIMARuntimeException exc) {
                        __errTableByUri.put(xmlDescUri, exc);
                    }
                }
                if (uimaCompCtg == null) {
                    try {
                        xmlSource.getInputStream().close();
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    xmlSource = xmlDescFile != null ? new XMLInputSource(xmlDescFile) : new XMLInputSource(xmlDescUrl);
                    try {
                        xmlParser.parseTypeSystemDescription(xmlSource);
                        uimaCompCtg = TYPE_SYSTEM_CTG;
                        __errTableByUri.remove(xmlDescUri);
                    }
                    catch (UIMAException err) {
                        __errTableByUri.put(xmlDescUri, err);
                    }
                    catch (UIMARuntimeException exc) {
                        __errTableByUri.put(xmlDescUri, exc);
                    }
                }
                if (uimaCompCtg != null) break block43;
                try {
                    xmlSource.getInputStream().close();
                }
                catch (Exception exc) {
                    // empty catch block
                }
                xmlSource = xmlDescFile != null ? new XMLInputSource(xmlDescFile) : new XMLInputSource(xmlDescUrl);
                try {
                    xmlParser.parseResourceManagerConfiguration(xmlSource);
                    uimaCompCtg = REUSABLE_RESOURCE_CTG;
                    __errTableByUri.remove(xmlDescUri);
                }
                catch (UIMAException err) {
                    __errTableByUri.put(xmlDescUri, err);
                }
                catch (UIMARuntimeException exc) {
                    __errTableByUri.put(xmlDescUri, exc);
                }
            }
            catch (IOException exc) {
                throw exc;
            }
            catch (Exception err) {
                __errTableByUri.put(xmlDescUri, err);
            }
            finally {
                if (xmlSource != null && xmlSource.getInputStream() != null) {
                    try {
                        xmlSource.getInputStream().close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return uimaCompCtg;
    }
}

