/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CasSerializerSupport;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.function.Consumer_withSaxException;
import org.apache.uima.jcas.cas.EmptyList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.NonEmptyFloatList;
import org.apache.uima.jcas.cas.NonEmptyIntegerList;
import org.apache.uima.jcas.cas.NonEmptyList;
import org.apache.uima.jcas.cas.NonEmptyStringList;
import org.apache.uima.jcas.cas.TOP;
import org.xml.sax.SAXException;

public interface CommonList
extends FeatureStructure {
    public static final String _FeatName_head = "head";
    public static final String _FeatName_tail = "tail";
    public static final List<String> EMPTY_LIST_STRING;

    default public CommonList getNthNode(int i) {
        if (this instanceof EmptyList) {
            throw new CASRuntimeException("JCAS_GET_NTH_ON_EMPTY_LIST", "EmptyList");
        }
        if (i < 0) {
            throw new CASRuntimeException("JCAS_GET_NTH_NEGATIVE_INDEX", i);
        }
        int originali = i;
        CommonList node = this;
        while (i != 0) {
            if ((node = node.getCommonTail()) instanceof EmptyList) {
                throw new CASRuntimeException("JCAS_GET_NTH_PAST_END", originali);
            }
            --i;
        }
        return node;
    }

    default public CommonList getNonEmptyNthNode(int i) {
        CommonList node = this.getNthNode(i);
        if (node instanceof EmptyList) {
            throw new CASRuntimeException("JCAS_GET_NTH_PAST_END", i);
        }
        return node;
    }

    default public int getLength() {
        int[] length = new int[]{0};
        this.walkList(n -> {
            length[0] = length[0] + 1;
        }, () -> {});
        return length[0];
    }

    default public void walkList_saxException(Consumer_withSaxException<NonEmptyList> consumer, Runnable foundLoop) throws SAXException {
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        CommonList node = this;
        while (node instanceof NonEmptyList) {
            consumer.accept((NonEmptyList)node);
            node = node.getCommonTail();
            if (node == null) break;
            if (!visited.contains(node) || foundLoop == null) continue;
            foundLoop.run();
        }
    }

    default public void walkList(Consumer<NonEmptyList> consumer, Runnable foundLoop) {
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        CommonList node = this;
        while (node instanceof NonEmptyList) {
            consumer.accept((NonEmptyList)node);
            node = node.getCommonTail();
            if (node == null) break;
            if (!visited.contains(node) || foundLoop == null) continue;
            foundLoop.run();
        }
    }

    public CommonList createNonEmptyNode();

    public CommonList emptyList();

    default public String get_headAsString() {
        throw new UnsupportedOperationException();
    }

    default public void set_headFromString(String v) {
        throw new UnsupportedOperationException();
    }

    default public CommonList insertNode() {
        if (!1.$assertionsDisabled && !(this instanceof NonEmptyList)) {
            throw new AssertionError();
        }
        CommonList newNode = this.createNonEmptyNode();
        CommonList tail = this.getCommonTail();
        this.setTail(newNode);
        newNode.setTail(tail);
        return newNode;
    }

    default public CommonList pushNode() {
        CommonList newNode = this.createNonEmptyNode();
        newNode.setTail(this);
        return newNode;
    }

    default public CommonList getCommonTail() {
        if (this instanceof NonEmptyFloatList) {
            return ((NonEmptyFloatList)this).getTail();
        }
        if (this instanceof NonEmptyIntegerList) {
            return ((NonEmptyIntegerList)this).getTail();
        }
        if (this instanceof NonEmptyStringList) {
            return ((NonEmptyStringList)this).getTail();
        }
        if (this instanceof NonEmptyFSList) {
            return ((NonEmptyFSList)this).getTail();
        }
        throw new UnsupportedOperationException();
    }

    default public void setTail(CommonList v) {
        throw new UnsupportedOperationException();
    }

    default public void anyListToOutput(XmiSerializationSharedData sharedData, CasSerializerSupport.CasDocSerializer cds, Consumer<String> out) {
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        for (CommonList curNode = this; curNode != null && !(curNode instanceof EmptyList) && visited.add(curNode); curNode = curNode.getCommonTail()) {
            if (curNode instanceof NonEmptyFSList) {
                Object val = ((NonEmptyFSList)curNode).getHead();
                if (val == null) {
                    if (sharedData != null) {
                        XmiSerializationSharedData.OotsElementData oed = sharedData.getOutOfTypeSystemFeatures((TOP)((Object)curNode));
                        if (oed != null) {
                            if (!1.$assertionsDisabled && oed.attributes.size() != 1) {
                                throw new AssertionError();
                            }
                            XmlAttribute attr = oed.attributes.get(0);
                            if (!1.$assertionsDisabled && !_FeatName_head.equals(attr.name)) {
                                throw new AssertionError();
                            }
                            out.accept(attr.value);
                            continue;
                        }
                        out.accept("0");
                        continue;
                    }
                    out.accept("0");
                    continue;
                }
                out.accept(cds.getXmiId((TOP)val));
                continue;
            }
            out.accept(curNode.get_headAsString());
        }
    }

    default public List<String> anyListToStringList(XmiSerializationSharedData sharedData, CasSerializerSupport.CasDocSerializer cds) {
        ArrayList<String> list = new ArrayList<String>();
        this.anyListToOutput(sharedData, cds, s -> list.add((String)s));
        return list;
    }

    default public boolean isEmpty() {
        return this instanceof EmptyList;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        EMPTY_LIST_STRING = Collections.emptyList();
    }
}

