/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.lexicalpreservation;

import com.github.javaparser.JavaParser;
import com.github.javaparser.JavaToken;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.Provider;
import com.github.javaparser.Range;
import com.github.javaparser.TokenTypes;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.observer.AstObserver;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.observer.PropagatingAstObserver;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.visitor.TreeVisitor;
import com.github.javaparser.printer.ConcreteSyntaxModel;
import com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import com.github.javaparser.printer.concretesyntaxmodel.CsmToken;
import com.github.javaparser.printer.lexicalpreservation.ChildTextElement;
import com.github.javaparser.printer.lexicalpreservation.LexicalDifferenceCalculator;
import com.github.javaparser.printer.lexicalpreservation.NodeText;
import com.github.javaparser.printer.lexicalpreservation.PhantomNodeLogic;
import com.github.javaparser.printer.lexicalpreservation.TextElement;
import com.github.javaparser.printer.lexicalpreservation.TextElementIteratorsFactory;
import com.github.javaparser.printer.lexicalpreservation.TextElementMatcher;
import com.github.javaparser.printer.lexicalpreservation.TokenTextElement;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class LexicalPreservingPrinter {
    private Map<Node, NodeText> textForNodes = new IdentityHashMap<Node, NodeText>();

    public static <N extends Node> Pair<ParseResult<N>, LexicalPreservingPrinter> setup(ParseStart<N> parseStart, Provider provider) {
        ParseResult<N> parseResult = new JavaParser().parse(parseStart, provider);
        if (!parseResult.isSuccessful()) {
            throw new RuntimeException("Parsing failed, unable to setup the lexical preservation printer: " + parseResult.getProblems());
        }
        LexicalPreservingPrinter lexicalPreservingPrinter = new LexicalPreservingPrinter(parseResult);
        return new Pair<ParseResult<N>, LexicalPreservingPrinter>(parseResult, lexicalPreservingPrinter);
    }

    private LexicalPreservingPrinter(ParseResult<? extends Node> parseResult) {
        this.storeInitialText(parseResult);
        AstObserver observer = LexicalPreservingPrinter.createObserver(this);
        Node root = parseResult.getResult().get();
        root.registerForSubtree(observer);
    }

    private static AstObserver createObserver(final LexicalPreservingPrinter lpp) {
        return new PropagatingAstObserver(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void concretePropertyChange(Node observedNode, ObservableProperty property, Object oldValue, Object newValue) {
                NodeText nodeText;
                if (oldValue != null && oldValue.equals(newValue) || oldValue == null && newValue == null) {
                    return;
                }
                if (property == ObservableProperty.RANGE || property == ObservableProperty.COMMENTED_NODE) {
                    return;
                }
                if (property == ObservableProperty.COMMENT) {
                    if (!observedNode.getParentNode().isPresent()) {
                        throw new IllegalStateException();
                    }
                    nodeText = lpp.getOrCreateNodeText(observedNode.getParentNode().get());
                    if (oldValue == null && newValue != null) {
                        int index = nodeText.findChild(observedNode);
                        nodeText.addChild(index, (Comment)newValue);
                        nodeText.addToken(index + 1, TokenTypes.eolToken(), Utils.EOL);
                    } else if (oldValue != null && newValue == null) {
                        if (!(oldValue instanceof JavadocComment)) throw new UnsupportedOperationException();
                        JavadocComment javadocComment = (JavadocComment)oldValue;
                        List matchingTokens = nodeText.getElements().stream().filter(e -> e.isToken(35) && ((TokenTextElement)e).getText().equals("/**" + javadocComment.getContent() + "*/")).map(e -> (TokenTextElement)e).collect(Collectors.toList());
                        if (matchingTokens.size() != 1) {
                            throw new IllegalStateException();
                        }
                        int index = nodeText.findElement((TextElementMatcher)matchingTokens.get(0));
                        nodeText.removeElement(index);
                        if (nodeText.getElements().get(index).isNewline()) {
                            nodeText.removeElement(index);
                        }
                    } else if (oldValue != null && newValue != null) {
                        if (!(oldValue instanceof JavadocComment)) throw new UnsupportedOperationException();
                        JavadocComment oldJavadocComment = (JavadocComment)oldValue;
                        List matchingTokens = nodeText.getElements().stream().filter(e -> e.isToken(35) && ((TokenTextElement)e).getText().equals("/**" + oldJavadocComment.getContent() + "*/")).map(e -> (TokenTextElement)e).collect(Collectors.toList());
                        if (matchingTokens.size() != 1) {
                            throw new IllegalStateException();
                        }
                        JavadocComment newJavadocComment = (JavadocComment)newValue;
                        nodeText.replace((TextElementMatcher)matchingTokens.get(0), new TokenTextElement(35, "/**" + newJavadocComment.getContent() + "*/"));
                    }
                }
                if ((nodeText = lpp.getOrCreateNodeText(observedNode)) == null) {
                    throw new NullPointerException(observedNode.getClass().getSimpleName());
                }
                new LexicalDifferenceCalculator().calculatePropertyChange(nodeText, observedNode, property, oldValue, newValue);
            }

            @Override
            public void concreteListChange(NodeList changedList, AstObserver.ListChangeType type, int index, Node nodeAddedOrRemoved) {
                NodeText nodeText = lpp.getTextForNode(changedList.getParentNodeForChildren());
                if (type == AstObserver.ListChangeType.REMOVAL) {
                    new LexicalDifferenceCalculator().calculateListRemovalDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index, nodeAddedOrRemoved).apply(nodeText, changedList.getParentNodeForChildren());
                } else if (type == AstObserver.ListChangeType.ADDITION) {
                    new LexicalDifferenceCalculator().calculateListAdditionDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index, nodeAddedOrRemoved).apply(nodeText, changedList.getParentNodeForChildren());
                } else {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public void concreteListReplacement(NodeList changedList, int index, Node oldValue, Node newValue) {
                NodeText nodeText = lpp.getTextForNode(changedList.getParentNodeForChildren());
                new LexicalDifferenceCalculator().calculateListReplacementDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index, oldValue, newValue).apply(nodeText, changedList.getParentNodeForChildren());
            }
        };
    }

    private void storeInitialText(ParseResult<? extends Node> parseResult) {
        Node root = parseResult.getResult().get();
        List<JavaToken> documentTokens = parseResult.getTokens().get();
        final IdentityHashMap tokensByNode = new IdentityHashMap();
        final LinkedList nodesDepthFirst = new LinkedList();
        new TreeVisitor(){

            @Override
            public void process(Node node) {
                if (!PhantomNodeLogic.isPhantomNode(node)) {
                    nodesDepthFirst.add(node);
                }
            }
        }.visitLeavesFirst(root);
        for (JavaToken token : documentTokens) {
            Optional<Node> maybeOwner = nodesDepthFirst.stream().filter(n -> n.getRange().get().contains(token.getRange())).findFirst();
            Node owner = maybeOwner.get();
            if (!tokensByNode.containsKey(owner)) {
                tokensByNode.put(owner, new LinkedList());
            }
            ((List)tokensByNode.get(owner)).add(token);
        }
        new TreeVisitor(){

            @Override
            public void process(Node node) {
                if (!PhantomNodeLogic.isPhantomNode(node)) {
                    LexicalPreservingPrinter.this.storeInitialTextForOneNode(node, (List)tokensByNode.get(node));
                }
            }
        }.visitBreadthFirst(root);
    }

    private void storeInitialTextForOneNode(Node node, List<JavaToken> nodeTokens) {
        if (nodeTokens == null) {
            nodeTokens = Collections.emptyList();
        }
        LinkedList<Pair> elements = new LinkedList<Pair>();
        for (Node child : node.getChildNodes()) {
            if (PhantomNodeLogic.isPhantomNode(child)) continue;
            elements.add(new Pair<Range, ChildTextElement>(child.getRange().get(), new ChildTextElement(this, child)));
        }
        for (JavaToken token : nodeTokens) {
            elements.add(new Pair<Range, TokenTextElement>(token.getRange(), new TokenTextElement(token)));
        }
        elements.sort(Comparator.comparing(e -> ((Range)e.a).begin));
        this.textForNodes.put(node, new NodeText(this, elements.stream().map(p -> (TextElement)p.b).collect(Collectors.toList())));
    }

    public Iterator<TokenTextElement> tokensPreceeding(Node node) {
        if (!node.getParentNode().isPresent()) {
            return new TextElementIteratorsFactory.EmptyIterator<TokenTextElement>();
        }
        NodeText parentNodeText = this.getOrCreateNodeText(node.getParentNode().get());
        int index = parentNodeText.findChild(node);
        return new TextElementIteratorsFactory.CascadingIterator<TokenTextElement>(TextElementIteratorsFactory.partialReverseIterator(parentNodeText, index - 1), () -> this.tokensPreceeding(node.getParentNode().get()));
    }

    public String print(Node node) {
        StringWriter writer = new StringWriter();
        try {
            this.print(node, writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException on a StringWriter", e);
        }
        return writer.toString();
    }

    public void print(Node node, Writer writer) throws IOException {
        if (this.textForNodes.containsKey(node)) {
            NodeText text = this.textForNodes.get(node);
            writer.append(text.expand());
        } else {
            writer.append(node.toString());
        }
    }

    private NodeText prettyPrintingTextNode(Node node) {
        if (node instanceof PrimitiveType) {
            NodeText nodeText = new NodeText(this);
            PrimitiveType primitiveType = (PrimitiveType)node;
            switch (primitiveType.getType()) {
                case INT: {
                    nodeText.addToken(65, node.toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return nodeText;
        }
        if (node instanceof JavadocComment) {
            NodeText nodeText = new NodeText(this);
            nodeText.addToken(35, "/**" + ((JavadocComment)node).getContent() + "*/");
            return nodeText;
        }
        return this.interpret(node, ConcreteSyntaxModel.forClass(node.getClass()));
    }

    private NodeText interpret(Node node, CsmElement csm) {
        LexicalDifferenceCalculator.CalculatedSyntaxModel calculatedSyntaxModel = new LexicalDifferenceCalculator().calculatedSyntaxModelForNode(csm, node);
        NodeText nodeText = new NodeText(this);
        for (CsmElement element : calculatedSyntaxModel.elements) {
            if (element instanceof LexicalDifferenceCalculator.CsmChild) {
                nodeText.addChild(((LexicalDifferenceCalculator.CsmChild)element).getChild());
                continue;
            }
            if (element instanceof CsmToken) {
                nodeText.addToken(((CsmToken)element).getTokenType(), ((CsmToken)element).getContent(node));
                continue;
            }
            throw new UnsupportedOperationException(element.getClass().getSimpleName());
        }
        return nodeText;
    }

    NodeText getOrCreateNodeText(Node node) {
        if (!this.textForNodes.containsKey(node)) {
            this.textForNodes.put(node, this.prettyPrintingTextNode(node));
        }
        return this.textForNodes.get(node);
    }

    List<TokenTextElement> findIndentation(Node node) {
        TokenTextElement tte;
        LinkedList<TokenTextElement> followingNewlines = new LinkedList<TokenTextElement>();
        Iterator<TokenTextElement> it = this.tokensPreceeding(node);
        while (it.hasNext() && (tte = it.next()).getTokenKind() != 32 && !tte.isNewline()) {
            followingNewlines.add(tte);
        }
        Collections.reverse(followingNewlines);
        for (int i = 0; i < followingNewlines.size(); ++i) {
            if (((TokenTextElement)followingNewlines.get(i)).isSpaceOrTab()) continue;
            return followingNewlines.subList(0, i);
        }
        return followingNewlines;
    }

    private static ObservableProperty findNodeListName(NodeList nodeList) {
        Node parent = nodeList.getParentNodeForChildren();
        for (Method m : parent.getClass().getMethods()) {
            if (m.getParameterCount() != 0 || !m.getReturnType().getCanonicalName().equals(NodeList.class.getCanonicalName())) continue;
            try {
                NodeList result = (NodeList)m.invoke((Object)parent, new Object[0]);
                if (result != nodeList) continue;
                String name = m.getName();
                if (name.startsWith("get")) {
                    name = name.substring("get".length());
                }
                return ObservableProperty.fromCamelCaseName(Utils.decapitalize(name));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException();
    }

    NodeText getTextForNode(Node node) {
        return this.textForNodes.get(node);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

