/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorType;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class UnaryOperatorExpression
extends Expression {
    public static final TokenRole NOT_ROLE = new TokenRole("!");
    public static final TokenRole BITWISE_NOT_ROLE = new TokenRole("~");
    public static final TokenRole MINUS_ROLE = new TokenRole("-");
    public static final TokenRole PLUS_ROLE = new TokenRole("+");
    public static final TokenRole INCREMENT_ROLE = new TokenRole("++");
    public static final TokenRole DECREMENT_ROLE = new TokenRole("--");
    public static final TokenRole DEREFERENCE_ROLE = new TokenRole("*");
    public static final TokenRole ADDRESS_OF_ROLE = new TokenRole("&");
    private UnaryOperatorType _operator;

    public UnaryOperatorExpression(UnaryOperatorType operator, Expression expression) {
        super(expression.getOffset());
        this.setOperator(operator);
        this.setExpression(expression);
    }

    public final UnaryOperatorType getOperator() {
        return this._operator;
    }

    public final void setOperator(UnaryOperatorType operator) {
        this.verifyNotFrozen();
        this._operator = operator;
    }

    public final JavaTokenNode getOperatorToken() {
        return this.getChildByRole(UnaryOperatorExpression.getOperatorRole(this.getOperator()));
    }

    public final Expression getExpression() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setExpression(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitUnaryOperatorExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof UnaryOperatorExpression) {
            UnaryOperatorExpression otherOperator = (UnaryOperatorExpression)other;
            return !otherOperator.isNull() && (otherOperator._operator == this._operator || this._operator == UnaryOperatorType.ANY || otherOperator._operator == UnaryOperatorType.ANY) && this.getExpression().matches(otherOperator.getExpression(), match);
        }
        return false;
    }

    public static TokenRole getOperatorRole(UnaryOperatorType operator) {
        switch (operator) {
            case NOT: {
                return NOT_ROLE;
            }
            case BITWISE_NOT: {
                return BITWISE_NOT_ROLE;
            }
            case MINUS: {
                return MINUS_ROLE;
            }
            case PLUS: {
                return PLUS_ROLE;
            }
            case INCREMENT: {
                return INCREMENT_ROLE;
            }
            case DECREMENT: {
                return DECREMENT_ROLE;
            }
            case POST_INCREMENT: {
                return INCREMENT_ROLE;
            }
            case POST_DECREMENT: {
                return DECREMENT_ROLE;
            }
        }
        throw new IllegalArgumentException("Invalid value for UnaryOperatorType.");
    }
}

