/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.AbstractDocumentListener;

public abstract class AbstractAnnotationDocumentListener
extends AbstractDocumentListener {
    private Collection<AnnotationFS> filterAnnotations(Collection<FeatureStructure> structures) {
        ArrayList<AnnotationFS> annotations = new ArrayList<AnnotationFS>(structures.size());
        for (FeatureStructure structure : structures) {
            if (!(structure instanceof AnnotationFS)) continue;
            annotations.add((AnnotationFS)structure);
        }
        return annotations;
    }

    @Override
    public void added(Collection<FeatureStructure> structures) {
        Collection<AnnotationFS> annotations = this.filterAnnotations(structures);
        if (!annotations.isEmpty()) {
            this.addedAnnotation(annotations);
        }
    }

    @Override
    public void removed(Collection<FeatureStructure> structures) {
        Collection<AnnotationFS> annotations = this.filterAnnotations(structures);
        if (!annotations.isEmpty()) {
            this.removedAnnotation(annotations);
        }
    }

    @Override
    public void updated(Collection<FeatureStructure> structures) {
        Collection<AnnotationFS> annotations = this.filterAnnotations(structures);
        if (!annotations.isEmpty()) {
            this.updatedAnnotation(annotations);
        }
    }

    protected abstract void addedAnnotation(Collection<AnnotationFS> var1);

    protected abstract void removedAnnotation(Collection<AnnotationFS> var1);

    protected abstract void updatedAnnotation(Collection<AnnotationFS> var1);
}

