/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.fit.internal.ClassLoaderUtils;
import org.apache.uima.fit.internal.MetaDataType;
import org.apache.uima.fit.internal.MetaDataUtil;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypePriorityList;
import org.apache.uima.resource.metadata.impl.TypePriorities_impl;
import org.apache.uima.spi.TypePrioritiesProvider;
import org.apache.uima.spi.TypeSystemProvider;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypePrioritiesFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TypePrioritiesFactory.class);
    private static final Object SCAN_LOCK = new Object();
    private static final Object CREATE_LOCK = new Object();
    private static final TypePriorities PLACEHOLDER = new TypePriorities_impl();
    private static WeakHashMap<String, TypePriorities> typePriorities = new WeakHashMap();
    private static WeakHashMap<ClassLoader, String[]> typePrioritesLocationsByClassloader = new WeakHashMap();
    private static WeakHashMap<ClassLoader, TypePriorities> typePrioritiesByClassloader = new WeakHashMap();

    private TypePrioritiesFactory() {
    }

    @SafeVarargs
    public static TypePriorities createTypePriorities(Class<? extends TOP> ... prioritizedTypes) {
        String[] typeNames = new String[prioritizedTypes.length];
        for (int i = 0; i < prioritizedTypes.length; ++i) {
            if (!TOP.class.isAssignableFrom(prioritizedTypes[i])) {
                throw new IllegalArgumentException("[" + String.valueOf(prioritizedTypes[i]) + "] is not a JCas type");
            }
            Object typeName = prioritizedTypes[i].getName();
            if (((String)typeName).startsWith("org.apache.uima.jcas.")) {
                typeName = "uima." + ((String)typeName).substring("org.apache.uima.jcas.".length());
            }
            typeNames[i] = typeName;
        }
        return TypePrioritiesFactory.createTypePriorities(typeNames);
    }

    public static TypePriorities createTypePriorities(String ... prioritizedTypeNames) {
        TypePriorities_impl priorities = new TypePriorities_impl();
        TypePriorityList typePriorityList = priorities.addPriorityList();
        for (String typeName : prioritizedTypeNames) {
            typePriorityList.addType(typeName);
        }
        return priorities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypePriorities createTypePriorities() throws ResourceInitializationException {
        ClassLoader cl = ClassLoaderUtils.findClassloader();
        TypePriorities aggTypePriorities = typePrioritiesByClassloader.get(cl);
        if (aggTypePriorities == null) {
            Object object = CREATE_LOCK;
            synchronized (object) {
                ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
                ArrayList<TypePriorities> typePrioritiesList = new ArrayList<TypePriorities>();
                TypePrioritiesFactory.loadTypePrioritiesFromScannedLocations(typePrioritiesList, resMgr);
                TypePrioritiesFactory.loadTypePrioritiesFromSPIs(typePrioritiesList);
                aggTypePriorities = CasCreationUtils.mergeTypePriorities(typePrioritiesList, (ResourceManager)resMgr);
                typePrioritiesByClassloader.put(cl, aggTypePriorities);
            }
        }
        return (TypePriorities)aggTypePriorities.clone();
    }

    static void loadTypePrioritiesFromScannedLocations(List<TypePriorities> typePrioritiesList, ResourceManager aResMgr) throws ResourceInitializationException {
        for (String location : TypePrioritiesFactory.scanTypePrioritiesDescriptors()) {
            try {
                TypePriorities priorities = typePriorities.get(location);
                if (priorities == PLACEHOLDER) {
                    priorities = UIMAFramework.getXMLParser().parseTypePriorities(new XMLInputSource(location));
                    priorities.resolveImports(aResMgr);
                    typePriorities.put(location, priorities);
                }
                typePrioritiesList.add(priorities);
                LOG.debug("Detected type priorities at [{}]", (Object)location);
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (InvalidXMLException e) {
                LOG.warn("[{}] is not a type priorities descriptor file. Ignoring.", (Object)location, (Object)e);
            }
        }
    }

    static void loadTypePrioritiesFromSPIs(List<TypePriorities> typePrioritiesList) {
        Set loaded = Collections.newSetFromMap(new IdentityHashMap());
        ServiceLoader.load(TypePrioritiesProvider.class).forEach(provider -> {
            for (TypePriorities desc : provider.listTypePriorities()) {
                loaded.add(desc);
                typePrioritiesList.add(desc);
                LOG.debug("Loaded legacy SPI-provided type priorities at [{}]", (Object)desc.getSourceUrlString());
            }
        });
        ServiceLoader.load(TypeSystemProvider.class).forEach(provider -> {
            for (TypePriorities desc : provider.listTypePriorities()) {
                if (loaded.contains(desc)) continue;
                typePrioritiesList.add(desc);
                LOG.debug("Loaded SPI-provided type priorities at [{}]", (Object)desc.getSourceUrlString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] scanTypePrioritiesDescriptors() throws ResourceInitializationException {
        Object object = SCAN_LOCK;
        synchronized (object) {
            ClassLoader cl = ClassLoaderUtils.findClassloader();
            String[] typePrioritesLocations = typePrioritesLocationsByClassloader.get(cl);
            if (typePrioritesLocations == null) {
                typePrioritesLocations = MetaDataUtil.scanDescriptors(MetaDataType.TYPE_PRIORITIES);
                TypePrioritiesFactory.internTypePrioritiesLocations(typePrioritesLocations);
                typePrioritesLocationsByClassloader.put(cl, typePrioritesLocations);
            }
            return typePrioritesLocations;
        }
    }

    private static void internTypePrioritiesLocations(String[] typeDescriptorLocations) {
        HashMap<String, String> locationStrings = new HashMap<String, String>();
        typePriorities.keySet().stream().forEach(loc -> locationStrings.put((String)loc, (String)loc));
        for (int i = 0; i < typeDescriptorLocations.length; ++i) {
            String existingLocString = (String)locationStrings.get(typeDescriptorLocations[i]);
            if (existingLocString == null) {
                typePriorities.put(typeDescriptorLocations[i], PLACEHOLDER);
                locationStrings.put(typeDescriptorLocations[i], typeDescriptorLocations[i]);
                continue;
            }
            typeDescriptorLocations[i] = existingLocString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceTypePrioritiesDescriptorsScan() {
        Object object = SCAN_LOCK;
        synchronized (object) {
            typePrioritesLocationsByClassloader.clear();
            typePrioritiesByClassloader.clear();
            typePriorities.clear();
        }
    }
}

