/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.internal.ReflectionUtil;

public final class ResourceMetaDataFactory {
    private static final String DEFAULT_VERSION = "unknown";
    private static final String DEFAULT_DESCRIPTION = "Descriptor automatically generated by uimaFIT";

    private ResourceMetaDataFactory() {
    }

    public static void configureResourceMetaData(org.apache.uima.resource.metadata.ResourceMetaData aMetaData, Class<?> aComponentClass) {
        ResourceMetaData componentAnno = ReflectionUtil.getAnnotation(aComponentClass, ResourceMetaData.class);
        if (componentAnno == null) {
            aMetaData.setCopyright(ResourceMetaDataFactory.getDefaultCopyright(aComponentClass));
            aMetaData.setDescription(ResourceMetaDataFactory.getDefaultDescription(aComponentClass));
            aMetaData.setName(ResourceMetaDataFactory.getDefaultName(aComponentClass));
            aMetaData.setVendor(ResourceMetaDataFactory.getDefaultVendor(aComponentClass));
            aMetaData.setVersion(ResourceMetaDataFactory.getDefaultVersion(aComponentClass));
        } else {
            aMetaData.setCopyright(ResourceMetaDataFactory.emptyAsNull(componentAnno.copyright()));
            aMetaData.setDescription(ResourceMetaDataFactory.emptyAsNull(componentAnno.description()));
            aMetaData.setName(ResourceMetaDataFactory.emptyAsNull(componentAnno.name()));
            aMetaData.setVendor(ResourceMetaDataFactory.emptyAsNull(componentAnno.vendor()));
            aMetaData.setVersion(ResourceMetaDataFactory.emptyAsNull(componentAnno.version()));
        }
    }

    public static String getDefaultCopyright(Class<?> aComponentClass) {
        return null;
    }

    public static String getDefaultVersion(Class<?> aComponentClass) {
        return DEFAULT_VERSION;
    }

    public static String getDefaultDescription(Class<?> aComponentClass) {
        return DEFAULT_DESCRIPTION;
    }

    public static String getDefaultVendor(Class<?> aComponentClass) {
        if (aComponentClass.getPackage() != null) {
            return aComponentClass.getPackage().getName();
        }
        return null;
    }

    public static String getDefaultName(Class<?> aComponentClass) {
        return aComponentClass.getName();
    }

    private static String emptyAsNull(String aString) {
        if (aString == null || aString.length() == 0) {
            return null;
        }
        return aString;
    }
}

