/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.contextmenu;

import java.util.HashSet;
import java.util.Set;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.contextmenu.IModeMenuListener;
import org.apache.uima.caseditor.editor.contextmenu.TypeMenu;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ModeMenu
extends TypeMenu {
    private AnnotationEditor editor;
    private Set<IModeMenuListener> listeners = new HashSet<IModeMenuListener>();

    public ModeMenu(TypeSystem typeSystem, AnnotationEditor editor) {
        super(typeSystem.getType("uima.tcas.Annotation"), typeSystem);
        this.editor = editor;
    }

    public void addListener(IModeMenuListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IModeMenuListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void insertAction(final Type type, Menu parentMenu) {
        MenuItem actionItem = new MenuItem(parentMenu, 32);
        actionItem.setText(type.getName());
        if (type.equals(this.editor.getAnnotationMode())) {
            actionItem.setSelection(true);
        }
        actionItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                for (IModeMenuListener listener : ModeMenu.this.listeners) {
                    listener.modeChanged(type);
                }
            }
        });
    }
}

