/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.uima.json.impl.JsonContentHandlerJacksonWrapper;
import org.apache.uima.json.impl.MetaDataObjectSerializer_json;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.util.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JsonMetaDataSerializer {
    public static void toJSON(XMLizable object, Writer aWriter) throws SAXException {
        JsonMetaDataSerializer.toJSON(object, aWriter, false);
    }

    public static void toJSON(XMLizable object, Writer aWriter, boolean isFormattedOutput) throws SAXException {
        JsonGenerator jg;
        try {
            jg = new JsonFactory().createGenerator(aWriter);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        JsonMetaDataSerializer.toJSON(object, jg, isFormattedOutput);
    }

    public static void toJSON(XMLizable object, JsonGenerator jg, boolean isFormattedOutput) throws SAXException {
        JsonContentHandlerJacksonWrapper jch;
        MetaDataObject_impl.SerialContext sc = (MetaDataObject_impl.SerialContext)MetaDataObject_impl.serialContext.get();
        boolean setContext = false;
        if (null == sc) {
            jch = new JsonContentHandlerJacksonWrapper(jg, isFormattedOutput);
            sc = new MetaDataObject_impl.SerialContext((ContentHandler)jch, (MetaDataObject_impl.Serializer)new MetaDataObjectSerializer_json(jch));
            MetaDataObject_impl.serialContext.set(sc);
            setContext = true;
        } else {
            jch = (JsonContentHandlerJacksonWrapper)sc.ch;
        }
        try {
            jch.withoutNl();
            object.toXML((ContentHandler)jch);
            jg.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        finally {
            if (setContext) {
                MetaDataObject_impl.serialContext.remove();
            }
        }
    }

    public static void toJSON(XMLizable object, OutputStream aOutputStream) throws SAXException {
        JsonMetaDataSerializer.toJSON(object, aOutputStream, false);
    }

    public static void toJSON(XMLizable object, OutputStream aOutputStream, boolean isFormattedOutput) throws SAXException {
        try {
            JsonGenerator jg = new JsonFactory().createGenerator(aOutputStream);
            JsonMetaDataSerializer.toJSON(object, jg, isFormattedOutput);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public static void toJSON(XMLizable object, File file) throws SAXException {
        JsonMetaDataSerializer.toJSON(object, file, false);
    }

    public static void toJSON(XMLizable object, File file, boolean isFormattedOutput) throws SAXException {
        try {
            JsonGenerator jg = new JsonFactory().createGenerator(file, JsonEncoding.UTF8);
            JsonMetaDataSerializer.toJSON(object, jg, isFormattedOutput);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

