/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.sorts;

import java.util.ArrayList;
import org.apache.unomi.api.PersonalizationResult;
import org.apache.unomi.api.PersonalizationStrategy;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.PersonalizationService;
import org.apache.unomi.api.services.ProfileService;

public class FilterPersonalizationStrategy
implements PersonalizationStrategy {
    private ProfileService profileService;

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public PersonalizationResult personalizeList(Profile profile, Session session, PersonalizationService.PersonalizationRequest personalizationRequest) {
        ArrayList<String> sortedContent = new ArrayList<String>();
        for (PersonalizationService.PersonalizedContent personalizedContent : personalizationRequest.getContents()) {
            boolean result = true;
            if (personalizedContent.getFilters() != null) {
                for (PersonalizationService.Filter filter : personalizedContent.getFilters()) {
                    Condition condition = filter.getCondition();
                    result &= this.profileService.matchCondition(condition, profile, session);
                }
            }
            if (!result) continue;
            sortedContent.add(personalizedContent.getId());
        }
        String fallback = (String)personalizationRequest.getStrategyOptions().get("fallback");
        if (fallback != null && !sortedContent.contains(fallback)) {
            sortedContent.add(fallback);
        }
        return new PersonalizationResult(sortedContent);
    }
}

