/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config.shell.completers;

import java.util.List;
import java.util.Map;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;

@Service
public class ClusterConfigCompleter
implements Completer {
    @Reference
    protected ClusterManager clusterManager;
    @Reference
    protected GroupManager groupManager;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            Map groups = this.groupManager.listGroups();
            if (groups != null && !groups.isEmpty()) {
                for (String groupName : groups.keySet()) {
                    Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + groupName);
                    if (clusterConfigurations == null || clusterConfigurations.isEmpty()) continue;
                    for (String pid : clusterConfigurations.keySet()) {
                        if (delegate.getStrings() == null || delegate.getStrings().contains(pid)) continue;
                        delegate.getStrings().add(pid);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return delegate.complete(session, commandLine, candidates);
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }
}

