/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.GenericDocumentType;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.traversal.TraversalSupport;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.CleanerThread;
import org.apache.batik.util.SoftDoublyIndexedTable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public abstract class AbstractDocument
extends AbstractParentNode
implements Document,
DocumentEvent,
DocumentTraversal,
Localizable {
    protected static final String RESOURCES = "org.apache.batik.dom.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.resources.Messages", this.getClass().getClassLoader());
    protected transient DOMImplementation implementation;
    protected transient TraversalSupport traversalSupport;
    protected transient DocumentEventSupport documentEventSupport;
    protected transient boolean eventsEnabled;
    protected transient WeakHashMap elementsByTagNames;
    protected transient WeakHashMap elementsByTagNamesNS;
    protected transient Map elementsById;

    protected AbstractDocument() {
    }

    public AbstractDocument(DocumentType documentType, DOMImplementation dOMImplementation) {
        this.implementation = dOMImplementation;
        if (documentType != null) {
            GenericDocumentType genericDocumentType;
            if (documentType instanceof GenericDocumentType && (genericDocumentType = (GenericDocumentType)documentType).getOwnerDocument() == null) {
                genericDocumentType.setOwnerDocument(this);
            }
            this.appendChild(documentType);
        }
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean bl) {
        this.eventsEnabled = bl;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public DocumentType getDoctype() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 10) continue;
            return (DocumentType)node;
        }
        return null;
    }

    public void setDoctype(DocumentType documentType) {
        if (documentType != null) {
            this.appendChild(documentType);
            ((ExtendedNode)((Object)documentType)).setReadonly(true);
        }
    }

    public DOMImplementation getImplementation() {
        return this.implementation;
    }

    public Element getDocumentElement() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        return this.importNode(node, bl, false);
    }

    public Node importNode(Node node, boolean bl, boolean bl2) {
        Node node2;
        Node node3;
        switch (node.getNodeType()) {
            case 1: {
                node2 = node3 = this.createElementNS(node.getNamespaceURI(), node.getNodeName());
                if (!node.hasAttributes()) break;
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    if (!attr.getSpecified()) continue;
                    AbstractAttr abstractAttr = (AbstractAttr)this.importNode(attr, true);
                    if (bl2 && abstractAttr.isId()) {
                        abstractAttr.setIsId(false);
                    }
                    node3.setAttributeNodeNS(abstractAttr);
                }
                break;
            }
            case 2: {
                node2 = this.createAttributeNS(node.getNamespaceURI(), node.getNodeName());
                break;
            }
            case 3: {
                node2 = this.createTextNode(node.getNodeValue());
                bl = false;
                break;
            }
            case 4: {
                node2 = this.createCDATASection(node.getNodeValue());
                bl = false;
                break;
            }
            case 5: {
                node2 = this.createEntityReference(node.getNodeName());
                break;
            }
            case 7: {
                node2 = this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                bl = false;
                break;
            }
            case 8: {
                node2 = this.createComment(node.getNodeValue());
                bl = false;
                break;
            }
            case 11: {
                node2 = this.createDocumentFragment();
                break;
            }
            default: {
                throw this.createDOMException((short)9, "import.node", new Object[0]);
            }
        }
        if (bl) {
            for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                node2.appendChild(this.importNode(node3, true));
            }
        }
        return node2;
    }

    public Node cloneNode(boolean bl) {
        Document document = (Document)this.newNode();
        this.copyInto(document);
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                document.appendChild(document.importNode(node, bl));
            }
        }
        return document;
    }

    public abstract boolean isId(Attr var1);

    public Element getElementById(String string) {
        return this.getChildElementById(this.getDocumentElement(), string);
    }

    public Element getChildElementById(Node node, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.elementsById == null) {
            return null;
        }
        Node node2 = this.getRoot(node);
        Object object = this.elementsById.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof IdSoftRef) {
            if ((object = ((IdSoftRef)object).get()) == null) {
                this.elementsById.remove(string);
                return null;
            }
            Element element = (Element)object;
            if (this.getRoot(element) == node2) {
                return element;
            }
            return null;
        }
        List list = (List)object;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IdSoftRef idSoftRef = (IdSoftRef)iterator.next();
            object = idSoftRef.get();
            if (object == null) {
                iterator.remove();
                continue;
            }
            Element element = (Element)object;
            if (this.getRoot(element) != node2) continue;
            return element;
        }
        return null;
    }

    protected Node getRoot(Node node) {
        Node node2 = node;
        while (node != null) {
            node2 = node;
            node = node.getParentNode();
        }
        return node2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdEntry(Element element, String string) {
        if (string == null) {
            return;
        }
        if (this.elementsById == null) {
            return;
        }
        Map map = this.elementsById;
        synchronized (map) {
            Object object = this.elementsById.get(string);
            if (object == null) {
                return;
            }
            if (object instanceof IdSoftRef) {
                this.elementsById.remove(string);
                return;
            }
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IdSoftRef idSoftRef = (IdSoftRef)iterator.next();
                object = idSoftRef.get();
                if (object == null) {
                    iterator.remove();
                    continue;
                }
                if (element != object) continue;
                iterator.remove();
                break;
            }
            if (list.size() == 0) {
                this.elementsById.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdEntry(Element element, String string) {
        if (string == null) {
            return;
        }
        if (this.elementsById == null) {
            HashMap hashMap;
            HashMap hashMap2 = hashMap = new HashMap();
            synchronized (hashMap2) {
                this.elementsById = hashMap;
                this.elementsById.put(string, new IdSoftRef(element, string));
            }
            return;
        }
        Map map = this.elementsById;
        synchronized (map) {
            Object v = this.elementsById.get(string);
            if (v == null) {
                this.elementsById.put(string, new IdSoftRef(element, string));
                return;
            }
            if (v instanceof IdSoftRef) {
                IdSoftRef idSoftRef = (IdSoftRef)v;
                Object t = idSoftRef.get();
                if (t == null) {
                    this.elementsById.put(string, new IdSoftRef(element, string));
                    return;
                }
                ArrayList<IdSoftRef> arrayList = new ArrayList<IdSoftRef>(4);
                idSoftRef.setList(arrayList);
                arrayList.add(idSoftRef);
                arrayList.add(new IdSoftRef(element, string, arrayList));
                this.elementsById.put(string, arrayList);
                return;
            }
            List list = (List)v;
            list.add(new IdSoftRef(element, string, list));
        }
    }

    public void updateIdEntry(Element element, String string, String string2) {
        if (string == string2 || string != null && string.equals(string2)) {
            return;
        }
        this.removeIdEntry(element, string);
        this.addIdEntry(element, string2);
    }

    public AbstractParentNode.ElementsByTagName getElementsByTagName(Node node, String string) {
        if (this.elementsByTagNames == null) {
            return null;
        }
        SoftDoublyIndexedTable softDoublyIndexedTable = (SoftDoublyIndexedTable)this.elementsByTagNames.get(node);
        if (softDoublyIndexedTable == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagName)softDoublyIndexedTable.get(null, string);
    }

    public void putElementsByTagName(Node node, String string, AbstractParentNode.ElementsByTagName elementsByTagName) {
        SoftDoublyIndexedTable softDoublyIndexedTable;
        if (this.elementsByTagNames == null) {
            this.elementsByTagNames = new WeakHashMap(11);
        }
        if ((softDoublyIndexedTable = (SoftDoublyIndexedTable)this.elementsByTagNames.get(node)) == null) {
            softDoublyIndexedTable = new SoftDoublyIndexedTable();
            this.elementsByTagNames.put(node, softDoublyIndexedTable);
        }
        softDoublyIndexedTable.put(null, string, elementsByTagName);
    }

    public AbstractParentNode.ElementsByTagNameNS getElementsByTagNameNS(Node node, String string, String string2) {
        if (this.elementsByTagNamesNS == null) {
            return null;
        }
        SoftDoublyIndexedTable softDoublyIndexedTable = (SoftDoublyIndexedTable)this.elementsByTagNamesNS.get(node);
        if (softDoublyIndexedTable == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagNameNS)softDoublyIndexedTable.get(string, string2);
    }

    public void putElementsByTagNameNS(Node node, String string, String string2, AbstractParentNode.ElementsByTagNameNS elementsByTagNameNS) {
        SoftDoublyIndexedTable softDoublyIndexedTable;
        if (this.elementsByTagNamesNS == null) {
            this.elementsByTagNamesNS = new WeakHashMap(11);
        }
        if ((softDoublyIndexedTable = (SoftDoublyIndexedTable)this.elementsByTagNamesNS.get(node)) == null) {
            softDoublyIndexedTable = new SoftDoublyIndexedTable();
            this.elementsByTagNamesNS.put(node, softDoublyIndexedTable);
        }
        softDoublyIndexedTable.put(string, string2, elementsByTagNameNS);
    }

    public Event createEvent(String string) throws DOMException {
        if (this.documentEventSupport == null) {
            this.documentEventSupport = ((AbstractDOMImplementation)this.implementation).createDocumentEventSupport();
        }
        return this.documentEventSupport.createEvent(string);
    }

    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        if (this.traversalSupport == null) {
            this.traversalSupport = new TraversalSupport();
        }
        return this.traversalSupport.createNodeIterator(this, node, n, nodeFilter, bl);
    }

    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) throws DOMException {
        return TraversalSupport.createTreeWalker(this, node, n, nodeFilter, bl);
    }

    public void detachNodeIterator(NodeIterator nodeIterator) {
        this.traversalSupport.detachNodeIterator(nodeIterator);
    }

    public void nodeToBeRemoved(Node node) {
        if (this.traversalSupport != null) {
            this.traversalSupport.nodeToBeRemoved(node);
        }
    }

    protected AbstractDocument getCurrentDocument() {
        return this;
    }

    protected Node export(Node node, Document document) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node deepExport(Node node, Document document) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        AbstractDocument abstractDocument = (AbstractDocument)node;
        abstractDocument.implementation = this.implementation;
        abstractDocument.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        AbstractDocument abstractDocument = (AbstractDocument)node;
        abstractDocument.implementation = this.implementation;
        abstractDocument.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        return node;
    }

    protected void checkChildType(Node node, boolean bl) {
        short s = node.getNodeType();
        switch (s) {
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(s), node.getNodeName()});
            }
        }
        if (!bl && s == 1 && this.getDocumentElement() != null || s == 10 && this.getDoctype() != null) {
            throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(s), node.getNodeName()});
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.implementation.getClass().getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        Class<?> clazz = Class.forName((String)objectInputStream.readObject());
        try {
            Method method = clazz.getMethod("getDOMImplementation", null);
            this.implementation = (DOMImplementation)method.invoke(null, null);
        }
        catch (Exception exception) {
            try {
                this.implementation = (DOMImplementation)clazz.newInstance();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    protected class IdSoftRef
    extends CleanerThread.SoftReferenceCleared {
        String id;
        List list;

        IdSoftRef(Object object, String string) {
            super(object);
            this.id = string;
        }

        IdSoftRef(Object object, String string, List list) {
            super(object);
            this.id = string;
            this.list = list;
        }

        public void setList(List list) {
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleared() {
            if (AbstractDocument.this.elementsById == null) {
                return;
            }
            Map map = AbstractDocument.this.elementsById;
            synchronized (map) {
                if (this.list != null) {
                    this.list.remove(this);
                } else {
                    Object v = AbstractDocument.this.elementsById.remove(this.id);
                    if (v != this) {
                        AbstractDocument.this.elementsById.put(this.id, v);
                    }
                }
            }
        }
    }
}

