/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.service;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.WrapperServiceSelector;

public class WrapperServiceManager
implements ServiceManager {
    private final ComponentManager m_componentManager;

    public WrapperServiceManager(ComponentManager componentManager) {
        if (null == componentManager) {
            throw new NullPointerException("componentManager");
        }
        this.m_componentManager = componentManager;
    }

    public Object lookup(String key) throws ServiceException {
        try {
            Component service = this.m_componentManager.lookup(key);
            if (service instanceof ComponentSelector) {
                return new WrapperServiceSelector(key, (ComponentSelector)service);
            }
            return service;
        }
        catch (ComponentException ce) {
            throw new ServiceException(key, ce.getMessage(), (Throwable)ce);
        }
    }

    public boolean hasService(String key) {
        return this.m_componentManager.hasComponent(key);
    }

    public void release(Object service) {
        if (service instanceof WrapperServiceSelector) {
            this.m_componentManager.release((Component)((WrapperServiceSelector)service).getWrappedSelector());
        } else {
            this.m_componentManager.release((Component)service);
        }
    }
}

