/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.diskstore.browser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.devutils.diskstore.DebugDiskDataStore;
import org.apache.wicket.devutils.diskstore.browser.DataStoreHelper;
import org.apache.wicket.devutils.diskstore.browser.PageWindowDescription;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.pageStore.PageWindowManager;

class PageWindowProvider
implements ISortableDataProvider<PageWindowDescription, String> {
    private static final int MAX_PAGES_TO_READ = 1000;
    private final IModel<String> sessionId;

    PageWindowProvider(IModel<String> sessionId) {
        this.sessionId = sessionId;
    }

    public Iterator<? extends PageWindowDescription> iterator(long first, long count) {
        List<PageWindowManager.PageWindow> lastPageWindows = this.getPageWindows();
        List<PageWindowManager.PageWindow> subList = lastPageWindows.subList((int)first, (int)(first + count));
        ArrayList<PageWindowDescription> pageDescriptions = new ArrayList<PageWindowDescription>();
        for (PageWindowManager.PageWindow pw : subList) {
            pageDescriptions.add(new PageWindowDescription(pw, (String)this.sessionId.getObject()));
        }
        return pageDescriptions.iterator();
    }

    private List<PageWindowManager.PageWindow> getPageWindows() {
        ArrayList<PageWindowManager.PageWindow> lastPageWindows = new ArrayList<PageWindowManager.PageWindow>();
        if (this.sessionId != null && this.sessionId.getObject() != null) {
            String sessId = (String)this.sessionId.getObject();
            DebugDiskDataStore dataStore = DataStoreHelper.getDataStore();
            List<PageWindowManager.PageWindow> pageWindows = dataStore.getLastPageWindows(sessId, 1000);
            lastPageWindows.addAll(pageWindows);
        }
        return lastPageWindows;
    }

    public long size() {
        return this.getPageWindows().size();
    }

    public IModel<PageWindowDescription> model(PageWindowDescription description) {
        return new Model((Serializable)((Object)description));
    }

    public void detach() {
        this.sessionId.detach();
    }

    public ISortState<String> getSortState() {
        return null;
    }
}

