/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.activation;

import jakarta.activation.DataHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.ext.io.StreamCopyException;
import org.apache.axiom.util.activation.DataSourceUtils;
import org.apache.axiom.util.activation.OutputStreamWrapper;

final class DataHandlerBlob
implements Blob {
    private final DataHandler dataHandler;

    DataHandlerBlob(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    DataHandler getDataHandler() {
        return this.dataHandler;
    }

    public InputStream getInputStream() throws IOException {
        return this.dataHandler.getInputStream();
    }

    public void writeTo(OutputStream out) throws StreamCopyException {
        OutputStreamWrapper wrapper = new OutputStreamWrapper(out);
        try {
            this.dataHandler.writeTo((OutputStream)wrapper);
        }
        catch (IOException ex) {
            IOException wrapperException = wrapper.getException();
            if (wrapperException != null) {
                throw new StreamCopyException(2, wrapperException);
            }
            throw new StreamCopyException(1, ex);
        }
    }

    public long getSize() {
        return DataSourceUtils.getSize(this.dataHandler.getDataSource());
    }
}

