/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.HSpiceOut;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.PSpiceOut;
import com.sun.electric.tool.io.input.RawSpiceOut;
import com.sun.electric.tool.io.input.SmartSpiceOut;
import com.sun.electric.tool.io.input.SpiceOut;
import com.sun.electric.tool.io.input.VerilogOut;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class Simulate
extends Input {
    Simulate() {
    }

    public static void plotSpiceResults() {
        OpenFile.Type type = Simulate.getCurrentSpiceOutputType();
        if (type == null) {
            return;
        }
        Simulate.plotSimulationResults(type, null, null, null);
    }

    public static void plotSpiceResultsThisCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        OpenFile.Type type = Simulate.getCurrentSpiceOutputType();
        if (type == null) {
            return;
        }
        Simulate.plotSimulationResults(type, cell, null, null);
    }

    public static void plotVerilogResults() {
        Simulate.plotSimulationResults(OpenFile.Type.VERILOGOUT, null, null, null);
    }

    public static void plotVerilogResultsThisCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        Simulate.plotSimulationResults(OpenFile.Type.VERILOGOUT, cell, null, null);
    }

    public static void plotSimulationResults(OpenFile.Type type, Cell cell, URL fileURL, WaveformWindow ww) {
        Simulate is = null;
        if (type == OpenFile.Type.HSPICEOUT) {
            is = new HSpiceOut();
        } else if (type == OpenFile.Type.PSPICEOUT) {
            is = new PSpiceOut();
        } else if (type == OpenFile.Type.RAWSPICEOUT) {
            is = new RawSpiceOut();
        } else if (type == OpenFile.Type.RAWSSPICEOUT) {
            is = new SmartSpiceOut();
        } else if (type == OpenFile.Type.SPICEOUT) {
            is = new SpiceOut();
        } else if (type == OpenFile.Type.VERILOGOUT) {
            is = new VerilogOut();
        }
        if (is == null) {
            System.out.println("Cannot handle " + type.getName() + " files yet");
            return;
        }
        if (cell == null) {
            if (fileURL == null) {
                String fileName = OpenFile.chooseInputFile(type, null);
                if (fileName == null) {
                    return;
                }
                fileURL = TextUtils.makeURLToFile(fileName);
            }
            String cellName = TextUtils.getFileNameWithoutExtension(fileURL);
            Library curLib = Library.getCurrent();
            cell = curLib.findNodeProto(cellName);
            if (cell != null) {
                String selectedCell;
                List cellList = curLib.getCellsSortedByName();
                Object[] cellNames = new String[cellList.size()];
                int i = 0;
                Iterator it = cellList.iterator();
                while (it.hasNext()) {
                    Cell aCell = (Cell)it.next();
                    cellNames[i++] = aCell.describe();
                }
                String defaultCell = cellNames[0];
                if (cell != null) {
                    defaultCell = cell.describe();
                }
                if ((selectedCell = (String)JOptionPane.showInputDialog(null, "Which cell is associated with this data", "Cells in library " + curLib.getName(), 1, null, cellNames, defaultCell)) != null) {
                    cell = curLib.findNodeProto(selectedCell);
                }
            }
        } else if (fileURL == null) {
            String[] extensions = type.getExtensions();
            String filePath = TextUtils.getFilePath(cell.getLibrary().getLibFile());
            String fileName = cell.getName() + "." + extensions[0];
            fileURL = TextUtils.makeURLToFile(filePath + fileName);
        }
        ReadSimulationOutput job = new ReadSimulationOutput(type, is, fileURL, cell, ww);
    }

    protected Simulation.SimData readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        return null;
    }

    public static OpenFile.Type getCurrentSpiceOutputType() {
        String format = Simulation.getSpiceOutputFormat();
        int engine = Simulation.getSpiceEngine();
        if (format.equalsIgnoreCase("Standard")) {
            if (engine == 2) {
                return OpenFile.Type.HSPICEOUT;
            }
            if (engine == 1 || engine == 3) {
                return OpenFile.Type.PSPICEOUT;
            }
            return OpenFile.Type.SPICEOUT;
        }
        if (format.equalsIgnoreCase("Raw")) {
            return OpenFile.Type.RAWSPICEOUT;
        }
        if (format.equalsIgnoreCase("Raw/Smart")) {
            return OpenFile.Type.RAWSSPICEOUT;
        }
        return null;
    }

    protected String getLineFromSimulator() throws IOException {
        StringBuffer sb = new StringBuffer();
        int bytesRead = 0;
        while (true) {
            int ch;
            if ((ch = this.lineReader.read()) == -1) {
                return null;
            }
            ++bytesRead;
            if (ch == 10 || ch == 13) break;
            sb.append((char)ch);
        }
        this.updateProgressDialog(bytesRead);
        return sb.toString();
    }

    private static class ReadSimulationOutput
    extends Job {
        OpenFile.Type type;
        Simulate is;
        URL fileURL;
        Cell cell;
        WaveformWindow ww;

        protected ReadSimulationOutput(OpenFile.Type type, Simulate is, URL fileURL, Cell cell, WaveformWindow ww) {
            super("Read Simulation Output", IOTool.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.type = type;
            this.is = is;
            this.fileURL = fileURL;
            this.cell = cell;
            this.ww = ww;
            this.startJob();
        }

        public boolean doIt() {
            try {
                Simulation.SimData sd = this.is.readSimulationOutput(this.fileURL, this.cell);
                if (sd != null) {
                    sd.setDataType(this.type);
                    sd.setFileURL(this.fileURL);
                    Simulation.showSimulationData(sd, this.ww);
                }
            }
            catch (IOException e) {
                System.out.println("End of file reached while reading " + this.fileURL);
            }
            return true;
        }
    }
}

