/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CrossLibCopy
extends EDialog {
    private List libList;
    private Library curLibLeft;
    private Library curLibRight;
    private List cellListLeft;
    private List cellListRight;
    private JList listLeft;
    private JList listRight;
    private JList listCenter;
    private DefaultListModel modelLeft;
    private DefaultListModel modelRight;
    private DefaultListModel modelCenter;
    private static boolean lastDeleteAfterCopy = false;
    private static boolean lastCopyRelated = false;
    private static boolean lastCopySubcells = false;
    private static boolean lastUseExisting = true;
    private JPanel Bottom;
    private JPanel BottomLeft;
    private JPanel BottomRight;
    private JPanel Top;
    private JScrollPane cellsLeft;
    private JScrollPane cellsRight;
    private JScrollPane center;
    private JButton copyLeft;
    private JCheckBox copyRelatedViews;
    private JButton copyRight;
    private JCheckBox copySubcells;
    private JCheckBox deleteAfterCopy;
    private JButton done;
    private JButton examineContents;
    private JButton examineContentsQuietly;
    private JComboBox librariesLeft;
    private JComboBox librariesRight;
    private JButton listDifferences;
    private JCheckBox useExistingSubcells;

    public CrossLibCopy(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.libList = Library.getVisibleLibrariesSortedByName();
        Iterator it = this.libList.iterator();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            this.librariesLeft.addItem(lib.getName());
            this.librariesRight.addItem(lib.getName());
        }
        this.curLibLeft = this.curLibRight = Library.getCurrent();
        int curIndex = this.libList.indexOf(this.curLibLeft);
        if (curIndex >= 0) {
            this.librariesLeft.setSelectedIndex(curIndex);
            this.librariesRight.setSelectedIndex(curIndex);
        }
        this.modelLeft = new DefaultListModel();
        this.listLeft = new JList(this.modelLeft);
        this.listLeft.setSelectionMode(0);
        this.cellsLeft.setViewportView(this.listLeft);
        this.listLeft.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CrossLibCopy.this.leftListClick(evt);
            }
        });
        this.modelRight = new DefaultListModel();
        this.listRight = new JList(this.modelRight);
        this.listRight.setSelectionMode(0);
        this.cellsRight.setViewportView(this.listRight);
        this.listRight.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CrossLibCopy.this.rightListClick(evt);
            }
        });
        this.modelCenter = new DefaultListModel();
        this.listCenter = new JList(this.modelCenter);
        this.listCenter.setSelectionMode(0);
        this.center.setViewportView(this.listCenter);
        this.listCenter.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CrossLibCopy.this.centerListClick(evt);
            }
        });
        this.showCells(false, false);
        this.deleteAfterCopy.setSelected(lastDeleteAfterCopy);
        this.copyRelatedViews.setSelected(lastCopyRelated);
        this.copySubcells.setSelected(lastCopySubcells);
        this.useExistingSubcells.setSelected(lastUseExisting);
    }

    private void leftListClick(MouseEvent evt) {
        int index = this.listLeft.getSelectedIndex();
        this.listRight.setSelectedIndex(index);
        this.listCenter.setSelectedIndex(index);
    }

    private void rightListClick(MouseEvent evt) {
        int index = this.listRight.getSelectedIndex();
        this.listLeft.setSelectedIndex(index);
        this.listCenter.setSelectedIndex(index);
    }

    private void centerListClick(MouseEvent evt) {
        int index = this.listCenter.getSelectedIndex();
        this.listLeft.setSelectedIndex(index);
        this.listRight.setSelectedIndex(index);
    }

    private void showCells(boolean report, boolean examineContents) {
        if (this.modelLeft == null || this.modelRight == null || this.modelCenter == null) {
            return;
        }
        this.cellListLeft = this.curLibLeft.getCellsSortedByName();
        this.cellListRight = this.curLibRight.getCellsSortedByName();
        this.modelLeft.clear();
        this.modelRight.clear();
        this.modelCenter.clear();
        int leftPos = 0;
        int rightPos = 0;
        int leftCount = this.cellListLeft.size();
        int rightCount = this.cellListRight.size();
        while (leftPos < leftCount || rightPos < rightCount) {
            int op;
            if (leftPos >= leftCount) {
                op = 2;
            } else if (rightPos >= rightCount) {
                op = 1;
            } else {
                Cell leftCell = (Cell)this.cellListLeft.get(leftPos);
                Cell rightCell = (Cell)this.cellListRight.get(rightPos);
                int j = leftCell.getName().compareToIgnoreCase(rightCell.getName());
                op = j < 0 ? 1 : (j > 0 ? 2 : 3);
            }
            String leftName = " ";
            Cell leftCell = null;
            if (op == 1 || op == 3) {
                leftCell = (Cell)this.cellListLeft.get(leftPos++);
                leftName = leftCell.noLibDescribe();
            }
            this.modelLeft.addElement(leftName);
            String rightName = " ";
            Cell rightCell = null;
            if (op == 2 || op == 3) {
                rightCell = (Cell)this.cellListRight.get(rightPos++);
                rightName = rightCell.noLibDescribe();
            }
            this.modelRight.addElement(rightName);
            String pt = " ";
            if (op == 3) {
                int compare = leftCell.compareTo(rightCell);
                StringBuffer buffer = null;
                boolean result = true;
                Object difference = null;
                if (examineContents) {
                    if (report) {
                        buffer = new StringBuffer();
                    }
                    result = leftCell.compare(rightCell, buffer);
                }
                String message = result ? "(but contents are the same)" : "(and contents are different)";
                switch (compare) {
                    case -1: {
                        String string = pt = result ? "<-OLD" : "<-OLD*";
                        if (!report) break;
                        System.out.println(this.curLibLeft.getName() + ":" + leftName + " OLDER THAN " + this.curLibRight.getName() + ":" + rightName + message + ":" + (buffer != null ? buffer.toString() : "\n"));
                        break;
                    }
                    case 1: {
                        String string = pt = result ? "  OLD->" : " *OLD->";
                        if (!report) break;
                        System.out.println(this.curLibRight.getName() + ":" + rightName + " OLDER THAN " + this.curLibLeft.getName() + ":" + leftName + message + ":" + (buffer != null ? buffer.toString() : "\n"));
                        break;
                    }
                    case 0: {
                        pt = "-EQUAL-";
                        break;
                    }
                    default: {
                        System.out.println("Error: invalid case");
                    }
                }
            }
            this.modelCenter.addElement(pt);
        }
    }

    private void initComponents() {
        this.Top = new JPanel();
        this.librariesLeft = new JComboBox();
        this.librariesRight = new JComboBox();
        this.copyLeft = new JButton();
        this.copyRight = new JButton();
        this.done = new JButton();
        this.cellsLeft = new JScrollPane();
        this.center = new JScrollPane();
        this.cellsRight = new JScrollPane();
        this.Bottom = new JPanel();
        this.BottomLeft = new JPanel();
        this.examineContents = new JButton();
        this.examineContentsQuietly = new JButton();
        this.listDifferences = new JButton();
        this.BottomRight = new JPanel();
        this.deleteAfterCopy = new JCheckBox();
        this.copySubcells = new JCheckBox();
        this.useExistingSubcells = new JCheckBox();
        this.copyRelatedViews = new JCheckBox();
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.setTitle("Cross Library Copy");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CrossLibCopy.this.closeDialog(evt);
            }
        });
        this.Top.setLayout(new GridBagLayout());
        this.librariesLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.librariesLeftActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.Top.add((Component)this.librariesLeft, gridBagConstraints);
        this.librariesRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.librariesRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.Top.add((Component)this.librariesRight, gridBagConstraints);
        this.copyLeft.setText("<< Copy");
        this.copyLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.copyLeftActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.copyLeft, gridBagConstraints);
        this.copyRight.setText("Copy >>");
        this.copyRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.copyRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.copyRight, gridBagConstraints);
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.doneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.Top.add((Component)this.done, gridBagConstraints);
        this.cellsLeft.setPreferredSize(new Dimension(200, 350));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.Top.add((Component)this.cellsLeft, gridBagConstraints);
        this.center.setMinimumSize(new Dimension(22, 200));
        this.center.setPreferredSize(new Dimension(22, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.weighty = 1.0;
        this.Top.add((Component)this.center, gridBagConstraints);
        this.cellsRight.setPreferredSize(new Dimension(200, 350));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.Top.add((Component)this.cellsRight, gridBagConstraints);
        this.getContentPane().add((Component)this.Top, "Center");
        this.BottomLeft.setLayout(new GridBagLayout());
        this.examineContents.setText("Examine contents");
        this.examineContents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.examineContentsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.BottomLeft.add((Component)this.examineContents, gridBagConstraints);
        this.examineContentsQuietly.setText("Examine contents quietly");
        this.examineContentsQuietly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.examineContentsQuietlyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.BottomLeft.add((Component)this.examineContentsQuietly, gridBagConstraints);
        this.listDifferences.setText("List differences");
        this.listDifferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrossLibCopy.this.listDifferencesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.BottomLeft.add((Component)this.listDifferences, gridBagConstraints);
        this.Bottom.add(this.BottomLeft);
        this.BottomRight.setLayout(new GridBagLayout());
        this.deleteAfterCopy.setText("Delete after copy");
        this.deleteAfterCopy.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CrossLibCopy.this.deleteAfterCopyItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.BottomRight.add((Component)this.deleteAfterCopy, gridBagConstraints);
        this.copySubcells.setText("Copy subcells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.BottomRight.add((Component)this.copySubcells, gridBagConstraints);
        this.useExistingSubcells.setText("Use existing subcells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.BottomRight.add((Component)this.useExistingSubcells, gridBagConstraints);
        this.copyRelatedViews.setText("Copy related views");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.BottomRight.add((Component)this.copyRelatedViews, gridBagConstraints);
        this.Bottom.add(this.BottomRight);
        this.getContentPane().add((Component)this.Bottom, "South");
        this.pack();
    }

    private void deleteAfterCopyItemStateChanged(ItemEvent evt) {
        if (this.deleteAfterCopy.isSelected()) {
            this.copyLeft.setText("<< Move");
            this.copyRight.setText("Move >>");
        } else {
            this.copyLeft.setText("<< Copy");
            this.copyRight.setText("Copy >>");
        }
    }

    private void librariesRightActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        int index = cb.getSelectedIndex();
        this.curLibRight = (Library)this.libList.get(index);
        this.showCells(false, false);
    }

    private void librariesLeftActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        int index = cb.getSelectedIndex();
        this.curLibLeft = (Library)this.libList.get(index);
        this.showCells(false, false);
    }

    private void listDifferencesActionPerformed(ActionEvent evt) {
        String leftName = (String)this.listLeft.getSelectedValue();
        String rightName = (String)this.listLeft.getSelectedValue();
        if (leftName == null || rightName == null) {
            return;
        }
        Cell leftCell = this.curLibLeft.findNodeProto(leftName);
        Cell rightCell = this.curLibRight.findNodeProto(rightName);
        if (leftCell == null || rightCell == null) {
            return;
        }
        CrossLibraryExamineJob job = new CrossLibraryExamineJob(leftCell, rightCell, true);
    }

    private void examineContentsQuietlyActionPerformed(ActionEvent evt) {
        this.showCells(false, true);
    }

    private void examineContentsActionPerformed(ActionEvent evt) {
        this.showCells(true, true);
    }

    private void copyRightActionPerformed(ActionEvent evt) {
        String cellName = (String)this.listLeft.getSelectedValue();
        Cell fromCell = this.curLibLeft.findNodeProto(cellName);
        if (fromCell == null) {
            return;
        }
        CrossLibraryCopyJob job = new CrossLibraryCopyJob(fromCell, this.curLibRight, this);
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void copyLeftActionPerformed(ActionEvent evt) {
        String cellName = (String)this.listRight.getSelectedValue();
        Cell fromCell = this.curLibRight.findNodeProto(cellName);
        if (fromCell == null) {
            return;
        }
        CrossLibraryCopyJob job = new CrossLibraryCopyJob(fromCell, this.curLibLeft, this);
    }

    private void closeDialog(WindowEvent evt) {
        lastDeleteAfterCopy = this.deleteAfterCopy.isSelected();
        lastCopyRelated = this.copyRelatedViews.isSelected();
        lastCopySubcells = this.copySubcells.isSelected();
        lastUseExisting = this.useExistingSubcells.isSelected();
        this.setVisible(false);
        this.dispose();
    }

    private static class CrossLibraryCopyJob
    extends Job {
        Cell fromCell;
        Library toLibrary;
        CrossLibCopy dialog;

        protected CrossLibraryCopyJob(Cell fromCell, Library toLibrary, CrossLibCopy dialog) {
            super("Cross-Library copy", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fromCell = fromCell;
            this.toLibrary = toLibrary;
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            int index = this.dialog.listLeft.getSelectedIndex();
            boolean deleteAfter = this.dialog.deleteAfterCopy.isSelected();
            boolean copyRelated = this.dialog.copyRelatedViews.isSelected();
            boolean copySubs = this.dialog.copySubcells.isSelected();
            boolean useExisting = this.dialog.useExistingSubcells.isSelected();
            CircuitChanges.copyRecursively(this.fromCell, this.fromCell.getName(), this.toLibrary, this.fromCell.getView(), true, deleteAfter, "", !copyRelated, !copySubs, useExisting);
            SwingUtilities.invokeLater(new DoneCopying(this.dialog, index));
            return true;
        }
    }

    private static class CrossLibraryExamineJob
    extends Job {
        Cell leftC;
        Cell rightC;
        boolean reportResults;
        boolean result;
        StringBuffer buffer;

        protected CrossLibraryExamineJob(Cell left, Cell right, boolean report) {
            super("Cross-Library examine", User.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.leftC = left;
            this.rightC = right;
            this.reportResults = report;
            this.startJob();
        }

        public boolean doIt() {
            if (this.reportResults) {
                this.buffer = new StringBuffer("Cells " + this.leftC.getLibrary().getName() + ":" + this.leftC.getName() + " and " + this.rightC.getLibrary().getName() + ":" + this.rightC.getName() + ":");
            }
            boolean bl = this.result = this.leftC != null && this.leftC.compare(this.rightC, this.buffer);
            if (this.reportResults) {
                if (this.result) {
                    this.buffer.append("Do not differ");
                }
                System.out.println(this.buffer);
            }
            return true;
        }

        public boolean getResult() {
            return this.result;
        }

        public StringBuffer getDifference() {
            return this.buffer;
        }
    }

    private static class DoneCopying
    implements Runnable {
        CrossLibCopy dialog;
        int index;

        DoneCopying(CrossLibCopy dialog, int index) {
            this.dialog = dialog;
            this.index = index;
        }

        public void run() {
            this.dialog.showCells(false, false);
            this.dialog.listLeft.setSelectedIndex(this.index);
            this.dialog.listRight.setSelectedIndex(this.index);
            this.dialog.listCenter.setSelectedIndex(this.index);
        }
    }
}

