/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.input.Input;
import java.util.HashMap;
import java.util.Iterator;

public class LEFDEF
extends Input {
    protected static ViaDef firstViaDefFromLEF = null;
    protected static HashMap widthsFromLEF = new HashMap();

    protected static class GetLayerInformation {
        NodeProto pin = null;
        NodeProto pure = null;
        ArcProto arc = null;
        ArcProto.Function arcFun = ArcProto.Function.UNKNOWN;
        Layer.Function layerFun = Layer.Function.UNKNOWN;
        ArcProto viaArc1 = null;
        ArcProto viaArc2 = null;

        private NodeProto getPureLayerNode() {
            Iterator it = Technology.getCurrent().getLayers();
            while (it.hasNext()) {
                Layer lay = (Layer)it.next();
                if (lay.getFunction() != this.layerFun) continue;
                return lay.getPureLayerNode();
            }
            return null;
        }

        GetLayerInformation(String name) {
            ArcProto.Function aFunc1 = ArcProto.Function.UNKNOWN;
            ArcProto.Function aFunc2 = ArcProto.Function.UNKNOWN;
            int j = 0;
            name = name.toUpperCase();
            if (name.startsWith("VIA")) {
                j = 3;
            } else if (name.startsWith("V")) {
                j = 1;
            }
            if (j != 0) {
                if (j >= name.length()) {
                    aFunc1 = ArcProto.Function.METAL1;
                    aFunc2 = ArcProto.Function.METAL2;
                } else if (j + 1 >= name.length()) {
                    int level = name.charAt(j) - 48;
                    aFunc1 = ArcProto.Function.getMetal(level);
                    aFunc2 = ArcProto.Function.getMetal(level + 1);
                } else {
                    int level1 = name.charAt(j) - 48;
                    aFunc1 = ArcProto.Function.getMetal(level1);
                    int level2 = name.charAt(j + 1) - 48;
                    aFunc2 = ArcProto.Function.getMetal(level2);
                }
                Iterator it = Technology.getCurrent().getArcs();
                while (it.hasNext()) {
                    ArcProto apTry = (ArcProto)it.next();
                    if (apTry.getFunction() == aFunc1) {
                        this.viaArc1 = apTry;
                    }
                    if (apTry.getFunction() != aFunc2) continue;
                    this.viaArc2 = apTry;
                }
                if (this.viaArc1 == null || this.viaArc2 == null) {
                    return;
                }
                it = Technology.getCurrent().getNodes();
                while (it.hasNext()) {
                    NodeProto np = (NodeProto)it.next();
                    if (np.getNumPorts() != 1) continue;
                    PortProto pp = np.getPort(0);
                    boolean ap1Found = pp.connectsTo(this.viaArc1);
                    boolean ap2Found = pp.connectsTo(this.viaArc2);
                    if (!ap1Found || !ap2Found) continue;
                    this.pin = np;
                    break;
                }
                if (this.pin != null) {
                    PrimitiveNode pNp = (PrimitiveNode)this.pin;
                    Technology.NodeLayer[] nl = pNp.getLayers();
                    Layer viaLayer = null;
                    for (int i = 0; i < nl.length; ++i) {
                        Technology.NodeLayer nLay = nl[i];
                        Layer lay = nLay.getLayer();
                        Layer.Function fun = lay.getFunction();
                        if (!fun.isContact()) continue;
                        viaLayer = lay;
                        this.layerFun = fun;
                        break;
                    }
                    if (viaLayer == null) {
                        return;
                    }
                    this.pure = viaLayer.getPureLayerNode();
                }
                return;
            }
            if (name.startsWith("POLY")) {
                int layNum = TextUtils.atoi(name.substring(4));
                this.arcFun = ArcProto.Function.getPoly(layNum);
                this.layerFun = Layer.Function.getPoly(layNum);
                this.pure = this.getPureLayerNode();
                return;
            }
            if (name.equals("PDIFF")) {
                this.arcFun = ArcProto.Function.DIFFP;
                this.layerFun = Layer.Function.DIFFP;
                this.pure = this.getPureLayerNode();
                return;
            }
            if (name.equals("NDIFF")) {
                this.arcFun = ArcProto.Function.DIFFN;
                this.layerFun = Layer.Function.DIFFN;
                this.pure = this.getPureLayerNode();
                return;
            }
            if (name.equals("DIFF")) {
                this.arcFun = ArcProto.Function.DIFF;
                this.layerFun = Layer.Function.DIFF;
                this.pure = this.getPureLayerNode();
                return;
            }
            if (name.equals("CONT")) {
                this.layerFun = Layer.Function.CONTACT1;
                this.pure = this.getPureLayerNode();
                return;
            }
            j = 0;
            if (name.startsWith("METAL")) {
                j = 5;
            } else if (name.startsWith("MET")) {
                j = 3;
            } else if (name.startsWith("M")) {
                j = 1;
            }
            if (j != 0) {
                int layNum = TextUtils.atoi(name.substring(j));
                this.arcFun = ArcProto.Function.getMetal(layNum);
                this.layerFun = Layer.Function.getMetal(layNum);
                if (this.arcFun == null || this.layerFun == null) {
                    return;
                }
                Iterator it = Technology.getCurrent().getArcs();
                while (it.hasNext()) {
                    ArcProto ap = (ArcProto)it.next();
                    if (ap.getFunction() != this.arcFun) continue;
                    this.arc = ap;
                    this.pin = ((PrimitiveArc)ap).findPinProto();
                    break;
                }
                this.pure = this.getPureLayerNode();
                return;
            }
        }
    }

    protected static class ViaDef {
        protected String viaName;
        protected NodeProto via;
        protected ArcProto lay1;
        protected ArcProto lay2;
        protected double sX;
        protected double sY;
        protected ViaDef nextViaDef;

        protected ViaDef() {
        }
    }
}

