/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class TechToLib {
    public static void makeLibFromTech() {
        ArrayList<Technology> techs = new ArrayList<Technology>();
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            if (tech.isNonStandard()) continue;
            techs.add(tech);
        }
        Object[] techChoices = new String[techs.size()];
        for (int i = 0; i < techs.size(); ++i) {
            techChoices[i] = ((Technology)techs.get(i)).getTechName();
        }
        String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Technology to Edit", "Choose a technology to edit", 3, null, techChoices, Technology.getCurrent().getTechName());
        if (chosen == null) {
            return;
        }
        Technology tech = Technology.findTechnology(chosen);
        Library already = Library.findLibrary(tech.getTechName());
        if (already != null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "There is already a library called '" + tech.getTechName() + "'.  Delete it first.", "Cannot Convert Technology", 0);
            System.out.println();
            return;
        }
        LibFromTechJob job = new LibFromTechJob(tech);
    }

    private static Library makeLibFromTech(Technology tech) {
        Library lib = Library.newInstance(tech.getTechName(), null);
        if (lib == null) {
            System.out.println("Cannot create library " + tech.getTechName());
            return null;
        }
        System.out.println("Created library " + tech.getTechName() + "...");
        Cell fNp = Cell.newInstance(lib, "factors");
        if (fNp == null) {
            return null;
        }
        fNp.setInTechnologyLibrary();
        GeneralInfo gi = new GeneralInfo();
        gi.scale = tech.getScale();
        gi.description = tech.getTechDesc();
        gi.minRes = tech.getMinResistance();
        gi.minCap = tech.getMinCapacitance();
        gi.gateShrinkage = tech.getGateLengthSubtraction();
        gi.includeGateInResistance = tech.isGateIncluded();
        gi.includeGround = tech.isGroundNetIncluded();
        Color[] wholeMap = tech.getColorMap();
        int numLayers = tech.getNumTransparentLayers();
        gi.transparentColors = new Color[numLayers];
        for (int i = 0; i < numLayers; ++i) {
            gi.transparentColors[i] = wholeMap[1 << i];
        }
        gi.generate(fNp);
        int layerTotal = tech.getNumLayers();
        HashMap<Layer, Cell> layerCells = new HashMap<Layer, Cell>();
        System.out.println("Creating the layers...");
        String[] layerSequence = new String[layerTotal];
        for (int i = 0; i < layerTotal; ++i) {
            Layer layer = tech.getLayer(i);
            EGraphics desc = layer.getGraphics();
            String fName = "layer-" + layer.getName();
            if (lib.findNodeProto(fName) != null) {
                System.out.println("Warning: multiple layers named '" + fName + "'");
                break;
            }
            Cell lNp = Cell.newInstance(lib, fName);
            if (lNp == null) {
                return null;
            }
            lNp.setTechnology(Artwork.tech);
            lNp.setInTechnologyLibrary();
            layerCells.put(layer, lNp);
            LayerInfo li = new LayerInfo();
            li.fun = layer.getFunction();
            li.funExtra = layer.getFunctionExtras();
            li.desc = desc;
            li.cif = layer.getCIFLayer();
            li.gds = layer.getGDSLayer();
            li.spiRes = layer.getResistance();
            li.spiCap = layer.getCapacitance();
            li.spiECap = layer.getEdgeCapacitance();
            li.height3d = layer.getDepth();
            li.thick3d = layer.getThickness();
            li.generate(lNp);
            layerSequence[i] = lNp.getName().substring(6);
        }
        lib.newVar(Info.LAYERSEQUENCE_KEY, (Object)layerSequence);
        System.out.println("Creating the arcs...");
        int arcTotal = 0;
        HashMap<ArcProto, Cell> arcCells = new HashMap<ArcProto, Cell>();
        Iterator it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            if (ap.isNotUsed()) continue;
            String fName = "arc-" + ap.getName();
            if (lib.findNodeProto(fName) != null) {
                System.out.println("Warning: multiple arcs named '" + fName + "'");
                break;
            }
            Cell aNp = Cell.makeInstance(lib, fName);
            if (aNp == null) {
                return null;
            }
            aNp.setTechnology(Artwork.tech);
            aNp.setInTechnologyLibrary();
            ArcInfo aIn = new ArcInfo();
            aIn.func = ap.getFunction();
            aIn.fixAng = ap.isFixedAngle();
            aIn.wipes = ap.isWipable();
            aIn.noExtend = ap.isExtended();
            aIn.angInc = ap.getAngleIncrement();
            aIn.antennaRatio = ERC.getERCTool().getAntennaRatio(ap);
            arcCells.put(ap, aNp);
            aIn.generate(aNp);
            double wid = ap.getDefaultWidth() - ap.getWidthOffset();
            ArcInst ai = ArcInst.makeDummyInstance(ap, wid * 4.0);
            Poly[] polys = tech.getShapeOfArc(ai);
            double xOff = wid * 2.0 + wid / 2.0 + ap.getWidthOffset() / 2.0;
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                Layer arcLayer = poly.getLayer();
                if (arcLayer == null) continue;
                EGraphics arcDesc = arcLayer.getGraphics();
                Point2D[] points = poly.getPoints();
                for (int k = 0; k < points.length; ++k) {
                    points[k] = new Point2D.Double(points[k].getX() - xOff - 20.0, points[k].getY() - 5.0);
                }
                NodeInst ni = TechToLib.placeGeometry(poly, aNp);
                if (ni == null) continue;
                Manipulate.setPatch(ni, arcDesc);
                Cell layerCell = (Cell)layerCells.get(arcLayer);
                if (layerCell != null) {
                    ni.newVar(Info.LAYER_KEY, (Object)layerCell);
                }
                ni.newVar(Info.OPTION_KEY, (Object)new Integer(8));
            }
            double i = ai.getProto().getWidthOffset() / 2.0;
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.boxNode, new Point2D.Double(-20.0 - wid * 2.5 - i, -5.0), wid * 5.0, wid, aNp);
            if (ni == null) {
                return null;
            }
            ni.newVar(Artwork.ART_COLOR, (Object)new Integer(2));
            ni.newVar(Info.LAYER_KEY, null);
            ni.newVar(Info.OPTION_KEY, (Object)new Integer(8));
            ++arcTotal;
            ArcInfo.compactCell(aNp);
        }
        String[] arcSequence = new String[arcTotal];
        int arcIndex = 0;
        Iterator it2 = tech.getArcs();
        while (it2.hasNext()) {
            ArcProto ap = (ArcProto)it2.next();
            if (ap.isNotUsed()) continue;
            arcSequence[arcIndex++] = ap.getName();
        }
        lib.newVar(Info.ARCSEQUENCE_KEY, (Object)arcSequence);
        System.out.println("Creating the nodes...");
        int nodeTotal = 0;
        Iterator it3 = tech.getNodes();
        while (it3.hasNext()) {
            PrimitiveNode pnp = (PrimitiveNode)it3.next();
            if (pnp.isNotUsed()) continue;
            ++nodeTotal;
        }
        String[] nodeSequence = new String[nodeTotal];
        int nodeIndex = 0;
        Iterator it4 = tech.getNodes();
        while (it4.hasNext()) {
            PrimitiveNode pnp = (PrimitiveNode)it4.next();
            if (pnp.isNotUsed()) continue;
            nodeSequence[nodeIndex++] = pnp.getName();
            boolean first = true;
            NodeInst oNi = NodeInst.makeDummyInstance(pnp);
            double xS = pnp.getDefWidth() * 2.0;
            double yS = pnp.getDefHeight() * 2.0;
            if (xS < 3.0) {
                xS = 3.0;
            }
            if (yS < 3.0) {
                yS = 3.0;
            }
            double nodeXPos = -xS * 2.0;
            Point2D[] pos = new Point2D[]{new Point2D.Double(nodeXPos - xS, -5.0 + yS), new Point2D.Double(nodeXPos + xS, -5.0 + yS), new Point2D.Double(nodeXPos - xS, -5.0 - yS), new Point2D.Double(nodeXPos + xS, -5.0 - yS)};
            SizeOffset so = pnp.getProtoSizeOffset();
            xS = pnp.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
            yS = pnp.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
            double[] xsc = new double[4];
            double[] ysc = new double[4];
            xsc[0] = xS * 1.0;
            ysc[0] = yS * 1.0;
            xsc[1] = xS * 2.0;
            ysc[1] = yS * 1.0;
            xsc[2] = xS * 1.0;
            ysc[2] = yS * 2.0;
            xsc[3] = xS * 2.0;
            ysc[3] = yS * 2.0;
            if (pnp.getSpecialType() == 3) {
                double[] values = pnp.getSpecialValues();
                double min2X = values[0] * 2.0 + values[2] * 2.0 + values[5];
                double min2Y = values[1] * 2.0 + values[3] * 2.0 + values[5];
                xsc[1] = min2X;
                xsc[3] = min2X;
                ysc[2] = min2Y;
                ysc[3] = min2Y;
            }
            Cell nNp = null;
            Rectangle2D mainBounds = null;
            for (int e = 0; e < 4; ++e) {
                if (e != 0 && first || pnp.isSquare() && (e == 1 || e == 2)) continue;
                double dX = pos[e].getX() - oNi.getAnchorCenterX();
                double dY = pos[e].getY() - oNi.getAnchorCenterY();
                double dXSize = xsc[e] + so.getLowXOffset() + so.getHighXOffset() - oNi.getXSize();
                double dYSize = ysc[e] + so.getLowYOffset() + so.getHighYOffset() - oNi.getYSize();
                oNi.lowLevelModify(dX, dY, dXSize, dYSize, 0);
                Poly[] polys = tech.getShapeOfNode(oNi);
                int j = polys.length;
                for (int i = 0; i < j; ++i) {
                    Technology.NodeLayer[] nodeLayers;
                    NodeInst ni;
                    Poly poly = polys[i];
                    Layer nodeLayer = poly.getLayer();
                    if (nodeLayer == null) continue;
                    EGraphics desc = nodeLayer.getGraphics();
                    if (e == 0) {
                        Rectangle2D polyBounds = poly.getBounds2D();
                        if (i == 0) {
                            mainBounds = polyBounds;
                        } else {
                            Rectangle2D.union(mainBounds, polyBounds, mainBounds);
                        }
                    }
                    if (first) {
                        first = false;
                        String fName = "node-" + pnp.getName();
                        if (lib.findNodeProto(fName) != null) {
                            System.out.println("Warning: multiple nodes named '" + fName + "'");
                            break;
                        }
                        nNp = Cell.makeInstance(lib, fName);
                        if (nNp == null) {
                            return null;
                        }
                        nNp.setTechnology(Artwork.tech);
                        nNp.setInTechnologyLibrary();
                        NodeInfo nIn = new NodeInfo();
                        nIn.func = pnp.getFunction();
                        nIn.serp = false;
                        if ((nIn.func == PrimitiveNode.Function.TRANMOS || nIn.func == PrimitiveNode.Function.TRAPMOS || nIn.func == PrimitiveNode.Function.TRADMOS) && pnp.isHoldsOutline()) {
                            nIn.serp = true;
                        }
                        nIn.square = pnp.isSquare();
                        nIn.wipes = pnp.isWipeOn1or2();
                        nIn.lockable = pnp.isLockedPrim();
                        nIn.generate(nNp);
                    }
                    if ((ni = TechToLib.placeGeometry(poly, nNp)) == null) {
                        return null;
                    }
                    Manipulate.setPatch(ni, desc);
                    Cell layerCell = (Cell)layerCells.get(nodeLayer);
                    if (layerCell != null) {
                        ni.newVar(Info.LAYER_KEY, (Object)layerCell);
                    }
                    ni.newVar(Info.OPTION_KEY, (Object)new Integer(8));
                    if (e != 0 || i >= (nodeLayers = pnp.getLayers()).length || nodeLayers[i].getRepresentation() != 2) continue;
                    Variable var = ni.newDisplayVar(Info.MINSIZEBOX_KEY, "MIN");
                }
                if (first) continue;
                NodeInst ni = NodeInst.makeInstance(Artwork.tech.boxNode, pos[e], xsc[e], ysc[e], nNp);
                if (ni == null) {
                    return null;
                }
                ni.newVar(Artwork.ART_COLOR, (Object)new Integer(EGraphics.makeIndex(Color.WHITE)));
                ni.newVar(Info.LAYER_KEY, null);
                ni.newVar(Info.OPTION_KEY, (Object)new Integer(8));
                HashMap<PrimitivePort, NodeInst> portNodes = new HashMap<PrimitivePort, NodeInst>();
                Iterator pIt = pnp.getPorts();
                block10: while (pIt.hasNext()) {
                    PrimitivePort opp;
                    PrimitivePort pp = (PrimitivePort)pIt.next();
                    Poly poly = tech.getShapeOfPort(oNi, pp);
                    SizeOffset pSo = Generic.tech.portNode.getProtoSizeOffset();
                    double width = poly.getBounds2D().getWidth() + pSo.getLowXOffset() + pSo.getHighXOffset();
                    double height = poly.getBounds2D().getHeight() + pSo.getLowYOffset() + pSo.getHighYOffset();
                    NodeInst pNi = NodeInst.makeInstance(Generic.tech.portNode, new Point2D.Double(poly.getCenterX(), poly.getCenterY()), width, height, nNp);
                    if (pNi == null) {
                        return null;
                    }
                    portNodes.put(pp, pNi);
                    pNi.newVar(Info.OPTION_KEY, (Object)new Integer(8));
                    Variable var = pNi.newDisplayVar(Info.PORTNAME_KEY, pp.getName());
                    if (e != 0) continue;
                    if (pp.getAngle() != 0 || pp.getAngleRange() != 180) {
                        pNi.newVar(Info.PORTANGLE_KEY, (Object)new Integer(pp.getAngle()));
                        pNi.newVar(Info.PORTRANGE_KEY, (Object)new Integer(pp.getAngleRange()));
                    }
                    ArcProto[] connects = pp.getConnections();
                    ArrayList<Cell> validConns = new ArrayList<Cell>();
                    for (int i = 0; i < connects.length; ++i) {
                        Cell cell;
                        if (connects[i].getTechnology() != tech || (cell = (Cell)arcCells.get(connects[i])) == null) continue;
                        validConns.add(cell);
                    }
                    if (validConns.size() > 0) {
                        Cell[] aplist = new Cell[validConns.size()];
                        for (int i = 0; i < validConns.size(); ++i) {
                            aplist[i] = (Cell)validConns.get(i);
                        }
                        pNi.newVar(Info.CONNECTION_KEY, (Object)aplist);
                    }
                    Iterator oPIt = pnp.getPorts();
                    while (oPIt.hasNext() && (opp = (PrimitivePort)oPIt.next()) != pp) {
                        NodeInst nni;
                        if (opp.getTopology() != pp.getTopology() || (nni = (NodeInst)portNodes.get(opp)) == null) continue;
                        PortInst head = nni.getOnlyPortInst();
                        PortInst tail = pNi.getOnlyPortInst();
                        ArcInst.newInstance(Generic.tech.universal_arc, 0.0, head, tail);
                        continue block10;
                    }
                }
            }
            ++nodeTotal;
            NodeInfo.compactCell(nNp);
        }
        lib.newVar(Info.NODESEQUENCE_KEY, (Object)nodeSequence);
        System.out.println("Done.");
        return lib;
    }

    private static NodeInst placeGeometry(Poly poly, Cell cell) {
        Rectangle2D box = poly.getBox();
        Poly.Type style = poly.getStyle();
        if (style == Poly.Type.FILLED) {
            if (box != null) {
                return NodeInst.makeInstance(Artwork.tech.filledBoxNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            }
            box = poly.getBounds2D();
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.filledPolygonNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.CLOSED) {
            if (box != null) {
                return NodeInst.makeInstance(Artwork.tech.boxNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            }
            box = poly.getBounds2D();
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.closedPolygonNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.CROSSED) {
            NodeInst ni;
            if (box == null) {
                box = poly.getBounds2D();
            }
            if ((ni = NodeInst.makeInstance(Artwork.tech.crossedBoxNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell)) == null) {
                return null;
            }
            return ni;
        }
        if (style == Poly.Type.OPENED) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.openedPolygonNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.OPENEDT1) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.openedDottedPolygonNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.OPENEDT2) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.openedDashedPolygonNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.OPENEDT3) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.openedThickerPolygonNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setTrace(poly.getPoints());
            return ni;
        }
        if (style == Poly.Type.CIRCLE) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.circleNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            return ni;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.thickCircleNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            return ni;
        }
        if (style == Poly.Type.DISC) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.filledCircleNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            return ni;
        }
        if (style == Poly.Type.CIRCLEARC) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.circleNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setArcDegrees(0.0, 0.7853981633974483);
            return ni;
        }
        if (style == Poly.Type.THICKCIRCLEARC) {
            NodeInst ni = NodeInst.makeInstance(Artwork.tech.thickCircleNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            ni.setArcDegrees(0.0, 0.7853981633974483);
            return ni;
        }
        if (style == Poly.Type.TEXTCENT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            Variable var = ni.newDisplayVar(Artwork.ART_MESSAGE, poly.getString());
            if (var != null) {
                var.setPos(TextDescriptor.Position.CENT);
            }
            return ni;
        }
        if (style == Poly.Type.TEXTBOTLEFT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            Variable var = ni.newDisplayVar(Artwork.ART_MESSAGE, poly.getString());
            if (var != null) {
                var.setPos(TextDescriptor.Position.UPRIGHT);
            }
            return ni;
        }
        if (style == Poly.Type.TEXTBOTRIGHT) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            Variable var = ni.newDisplayVar(Artwork.ART_MESSAGE, poly.getString());
            if (var != null) {
                var.setPos(TextDescriptor.Position.UPLEFT);
            }
            return ni;
        }
        if (style == Poly.Type.TEXTBOX) {
            NodeInst ni = NodeInst.makeInstance(Generic.tech.invisiblePinNode, new Point2D.Double(box.getCenterX(), box.getCenterY()), box.getWidth(), box.getHeight(), cell);
            if (ni == null) {
                return null;
            }
            Variable var = ni.newDisplayVar(Artwork.ART_MESSAGE, poly.getString());
            if (var != null) {
                var.setPos(TextDescriptor.Position.BOXED);
            }
            return ni;
        }
        return null;
    }

    private static class LibFromTechJob
    extends Job {
        private Technology tech;

        private LibFromTechJob(Technology tech) {
            super("Make Technology Library from Technology", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.tech = tech;
            this.startJob();
        }

        public boolean doIt() {
            Library lib = TechToLib.makeLibFromTech(this.tech);
            if (lib == null) {
                return false;
            }
            lib.setCurrent();
            return true;
        }
    }
}

