/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.user.Highlighter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RouteElementArc
extends RouteElement {
    private ArcProto arcProto;
    private double arcWidth;
    private RouteElementPort headRE;
    private RouteElementPort tailRE;
    private EPoint headConnPoint;
    private EPoint tailConnPoint;
    private String arcName;
    private TextDescriptor arcNameDescriptor;
    private int arcAngle;
    private ArcInst inheritFrom;
    private boolean extendArc;
    private ArcInst arcInst;

    private RouteElementArc(RouteElement.RouteElementAction action, Cell cell) {
        super(action, cell);
    }

    public static RouteElementArc newArc(Cell cell, ArcProto ap, double arcWidth, RouteElementPort headRE, RouteElementPort tailRE, Point2D headConnPoint, Point2D tailConnPoint, String name, TextDescriptor nameTextDescriptor, ArcInst inheritFrom, boolean extendArc, PolyMerge stayInside) {
        EPoint headEP = EPoint.snap(headConnPoint);
        EPoint tailEP = EPoint.snap(tailConnPoint);
        if (stayInside != null) {
            double extension;
            Poly poly;
            Layer layer;
            boolean good;
            double length = headEP.distance(tailEP);
            int angle = 0;
            if (headEP.getX() != tailEP.getX() || headEP.getY() != tailEP.getY()) {
                angle = GenMath.figureAngle(headEP, tailEP);
            }
            if (!(good = stayInside.contains(layer = ap.getLayers()[0].getLayer(), poly = Poly.makeEndPointPoly(length, arcWidth, angle, headEP, extension = extendArc ? arcWidth / 2.0 : 0.0, tailEP, extension, Poly.Type.FILLED))) && arcWidth > ap.getDefaultWidth()) {
                arcWidth = ap.getDefaultWidth();
                extension = extendArc ? arcWidth / 2.0 : 0.0;
                poly = Poly.makeEndPointPoly(length, arcWidth, angle, headEP, extension, tailEP, extension, Poly.Type.FILLED);
                good = stayInside.contains(layer, poly);
            }
            if (!good && extendArc) {
                extension = 0.0;
                extendArc = false;
                poly = Poly.makeEndPointPoly(length, arcWidth, angle, headEP, extension, tailEP, extension, Poly.Type.FILLED);
                good = stayInside.contains(layer, poly);
            }
            if (!good) {
                arcWidth = ap.getWidthOffset();
            }
        }
        RouteElementArc e = new RouteElementArc(RouteElement.RouteElementAction.newArc, cell);
        e.arcProto = ap;
        e.arcWidth = arcWidth;
        e.headRE = headRE;
        e.tailRE = tailRE;
        e.arcName = name;
        e.arcNameDescriptor = nameTextDescriptor;
        if (headRE.getAction() != RouteElement.RouteElementAction.newNode && headRE.getAction() != RouteElement.RouteElementAction.existingPortInst) {
            System.out.println("  ERROR: headRE of newArc RouteElementArc must be newNode or existingPortInst");
        }
        if (tailRE.getAction() != RouteElement.RouteElementAction.newNode && tailRE.getAction() != RouteElement.RouteElementAction.existingPortInst) {
            System.out.println("  ERROR: tailRE of newArc RouteElementArc must be newNode or existingPortInst");
        }
        headRE.addConnectingNewArc(e);
        tailRE.addConnectingNewArc(e);
        e.headConnPoint = headEP;
        e.tailConnPoint = tailEP;
        assert (e.headConnPoint != null);
        assert (e.tailConnPoint != null);
        e.arcAngle = 0;
        e.arcInst = null;
        e.inheritFrom = inheritFrom;
        e.extendArc = extendArc;
        return e;
    }

    public static RouteElementArc deleteArc(ArcInst arcInstToDelete) {
        RouteElementArc e = new RouteElementArc(RouteElement.RouteElementAction.deleteArc, arcInstToDelete.getParent());
        e.arcProto = arcInstToDelete.getProto();
        e.arcWidth = arcInstToDelete.getWidth();
        e.headRE = RouteElementPort.existingPortInst(arcInstToDelete.getHeadPortInst(), arcInstToDelete.getHeadLocation());
        e.tailRE = RouteElementPort.existingPortInst(arcInstToDelete.getTailPortInst(), arcInstToDelete.getTailLocation());
        e.arcName = arcInstToDelete.getName();
        e.arcNameDescriptor = arcInstToDelete.getTextDescriptor(ArcInst.ARC_NAME);
        e.headConnPoint = arcInstToDelete.getHeadLocation();
        e.tailConnPoint = arcInstToDelete.getTailLocation();
        e.arcAngle = 0;
        e.arcInst = arcInstToDelete;
        e.inheritFrom = null;
        e.extendArc = true;
        return e;
    }

    public ArcProto getArcProto() {
        return this.arcProto;
    }

    public RouteElementPort getHead() {
        return this.headRE;
    }

    public RouteElementPort getTail() {
        return this.tailRE;
    }

    public Point2D getHeadConnPoint() {
        return this.headConnPoint;
    }

    public Point2D getTailConnPoint() {
        return this.tailConnPoint;
    }

    public double getArcWidth() {
        return this.arcWidth;
    }

    public double getOffsetArcWidth() {
        return this.arcWidth - this.arcProto.getWidthOffset();
    }

    public void setArcWidth(double width) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            this.arcWidth = width;
        }
    }

    public void setOffsetArcWidth(double width) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            this.arcWidth = width + this.arcProto.getWidthOffset();
        }
    }

    public void setArcAngle(int angle) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            this.arcAngle = angle;
        }
    }

    public boolean isArcVertical() {
        Point2D head = this.headConnPoint;
        Point2D tail = this.tailConnPoint;
        if (head == null) {
            head = this.headRE.getLocation();
        }
        if (tail == null) {
            tail = this.tailRE.getLocation();
        }
        if (head == null || tail == null) {
            return false;
        }
        return head.getX() == tail.getX();
    }

    public boolean isArcHorizontal() {
        Point2D head = this.headConnPoint;
        Point2D tail = this.tailConnPoint;
        if (head == null) {
            head = this.headRE.getLocation();
        }
        if (tail == null) {
            tail = this.tailRE.getLocation();
        }
        if (head == null || tail == null) {
            return false;
        }
        return head.getY() == tail.getY();
    }

    public boolean replaceArcEnd(RouteElementPort oldEnd, RouteElementPort newEnd) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            Poly poly = newEnd.getConnectingSite();
            if (this.headRE == oldEnd && poly != null && poly.contains(this.headConnPoint)) {
                this.headRE = newEnd;
                oldEnd.removeConnectingNewArc(this);
                newEnd.addConnectingNewArc(this);
            }
            if (this.tailRE == oldEnd && poly != null && poly.contains(this.tailConnPoint)) {
                this.tailRE = newEnd;
                oldEnd.removeConnectingNewArc(this);
                newEnd.addConnectingNewArc(this);
            }
        }
        return this.headRE != oldEnd && this.tailRE != oldEnd;
    }

    public ElectricObject doAction() {
        EDatabase.serverDatabase().checkChanging();
        if (this.isDone()) {
            return null;
        }
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            ArcInst newAi;
            PrimitiveNode pNp;
            Dimension2D autoGrowth;
            NodeInst tailNi;
            PrimitiveNode pNp2;
            Dimension2D autoGrowth2;
            NodeInst headNi;
            PortInst headPi = this.headRE.getPortInst();
            PortInst tailPi = this.tailRE.getPortInst();
            EPoint headPoint = this.headConnPoint;
            EPoint tailPoint = this.tailConnPoint;
            Poly headPoly = headPi.getPoly();
            if (!headPoly.isInside(headPoint) && !(headNi = headPi.getNodeInst()).isCellInstance() && (autoGrowth2 = (pNp2 = (PrimitiveNode)headNi.getProto()).getAutoGrowth()) != null) {
                headNi.resize(autoGrowth2.getWidth(), autoGrowth2.getHeight());
            }
            if (!(headPoly = headPi.getPoly()).isInside(headPoint)) {
                Rectangle2D headBounds = headPi.getBounds();
                System.out.println("Arc head (" + ((Point2D)headPoint).getX() + "," + ((Point2D)headPoint).getY() + ") not inside port " + headPi + " which is " + headBounds.getMinX() + "<=X<=" + headBounds.getMaxX() + " and " + headBounds.getMinY() + "<=Y<=" + headBounds.getMaxY());
                System.out.println("  Arc ran from " + headPi.getNodeInst() + ", port " + headPi.getPortProto().getName() + " to " + tailPi.getNodeInst() + ", port " + tailPi.getPortProto().getName());
                headPoly = headPi.getPoly();
                return null;
            }
            Poly tailPoly = tailPi.getPoly();
            if (!tailPoly.isInside(tailPoint) && !(tailNi = tailPi.getNodeInst()).isCellInstance() && (autoGrowth = (pNp = (PrimitiveNode)tailNi.getProto()).getAutoGrowth()) != null) {
                tailNi.resize(autoGrowth.getWidth(), autoGrowth.getHeight());
            }
            if (!(tailPoly = tailPi.getPoly()).isInside(tailPoint)) {
                Rectangle2D tailBounds = tailPi.getBounds();
                System.out.println("Arc tail (" + ((Point2D)tailPoint).getX() + "," + ((Point2D)tailPoint).getY() + ") not inside port " + headPi + " which is " + tailBounds.getMinX() + "<=X<=" + tailBounds.getMaxX() + " and " + tailBounds.getMinY() + "<=Y<=" + tailBounds.getMaxY());
                System.out.println("  Arc ran from " + headPi.getNodeInst() + ", port " + headPi.getPortProto().getName() + " to " + tailPi.getNodeInst() + ", port " + tailPi.getPortProto().getName());
                return null;
            }
            double thisWidth = this.arcWidth;
            if (headPoint.equals(tailPoint)) {
                thisWidth = this.arcProto.getDefaultWidth();
            }
            if ((newAi = ArcInst.makeInstance(this.arcProto, thisWidth, headPi, tailPi, headPoint, tailPoint, this.arcName)) == null) {
                return null;
            }
            if (((Point2D)headPoint).getX() == ((Point2D)tailPoint).getX() && ((Point2D)headPoint).getY() == ((Point2D)tailPoint).getY() && this.arcAngle == 0) {
                Rectangle2D headRect = headPi.getNodeInst().getBounds();
                Rectangle2D tailRect = tailPi.getNodeInst().getBounds();
                if (Math.abs(headRect.getCenterX() - tailRect.getCenterX()) < Math.abs(headRect.getCenterY() - tailRect.getCenterY())) {
                    this.arcAngle = 900;
                }
            }
            if (this.arcAngle != 0) {
                newAi.setAngle(this.arcAngle);
            }
            if (this.arcName != null && this.arcNameDescriptor != null) {
                newAi.setTextDescriptor(ArcInst.ARC_NAME, this.arcNameDescriptor);
            }
            this.setDone();
            this.arcInst = newAi;
            this.arcInst.copyPropertiesFrom(this.inheritFrom);
            if (this.inheritFrom == null) {
                this.arcInst.setHeadExtended(this.extendArc);
                this.arcInst.setTailExtended(this.extendArc);
            }
            return newAi;
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteArc) {
            if (this.arcInst.isLinked()) {
                this.arcInst.kill();
            }
            this.setDone();
        }
        return null;
    }

    public void addHighlightArea(Highlighter highlighter) {
        if (!this.isShowHighlight()) {
            return;
        }
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            EPoint headPoint = this.headConnPoint;
            EPoint tailPoint = this.tailConnPoint;
            double offset = 0.5 * this.getOffsetArcWidth();
            Cell cell = this.getCell();
            int angle = headPoint.equals(tailPoint) ? 0 : GenMath.figureAngle(headPoint, tailPoint);
            double length = headPoint.distance(tailPoint);
            Poly poly = Poly.makeEndPointPoly(length, this.getOffsetArcWidth(), angle, headPoint, offset, tailPoint, offset, Poly.Type.FILLED);
            Point2D[] points = poly.getPoints();
            for (int i = 0; i < points.length; ++i) {
                int last = i - 1;
                if (last < 0) {
                    last = points.length - 1;
                }
                highlighter.addLine(points[last], points[i], cell);
            }
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteArc) {
            highlighter.addElectricObject(this.arcInst, this.getCell());
        }
    }

    public String toString() {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            return "RouteElementArc-new " + this.arcProto + " width=" + this.arcWidth + ",\n   head: " + this.headRE + "\n   tail: " + this.tailRE;
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteArc) {
            return "RouteElementArc-delete " + this.arcInst;
        }
        return "RouteElement bad action";
    }
}

