/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.ClientJobManager;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.EThread;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.JobManager;
import com.sun.electric.tool.ServerJobManager;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.CantEditException;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Job
implements Serializable {
    private static boolean GLOBALDEBUG = false;
    static Mode threadMode;
    private static int socketPort;
    static final int PROTOCOL_VERSION = 13;
    public static boolean BATCHMODE;
    public static boolean LOCALDEBUGFLAG;
    private static final String CLASS_NAME;
    static final Logger logger;
    static final int MIN_NUM_SECONDS = 60000;
    static JobManager jobManager;
    static AbstractUserInterface currentUI;
    boolean deleteWhenDone;
    private boolean display;
    protected long startTime;
    protected long endTime;
    boolean started;
    boolean finished;
    boolean aborted;
    boolean scheduledToAbort;
    boolean reportExecution = false;
    Tool tool;
    transient EJob ejob;

    public static boolean getDebug() {
        return GLOBALDEBUG;
    }

    public static void setDebug(boolean f) {
        GLOBALDEBUG = f;
    }

    public static void setThreadMode(Mode mode, AbstractUserInterface userInterface) {
        threadMode = mode;
        BATCHMODE = mode == Mode.BATCH || mode == Mode.SERVER;
        currentUI = userInterface;
    }

    public static void initJobManager(int numThreads, Job initDatabaseJob, Object mode, String serverMachineName) {
        switch (threadMode) {
            case FULL_SCREEN: {
                jobManager = User.isUseClientServer() ? new ServerJobManager(numThreads, socketPort) : new ServerJobManager(numThreads);
                currentUI.initializeInitJob(initDatabaseJob, mode);
                initDatabaseJob.startJob();
                break;
            }
            case BATCH: 
            case SERVER: {
                jobManager = new ServerJobManager(numThreads, socketPort);
                initDatabaseJob.startJob();
                break;
            }
            case CLIENT: {
                logger.finer("setThreadMode");
                jobManager = new ClientJobManager(serverMachineName, socketPort);
            }
        }
        jobManager.runLoop();
    }

    public static Mode getRunMode() {
        return threadMode;
    }

    public Job(String jobName, Tool tool, Type jobType, Cell upCell, Cell downCell, Priority priority) {
        this.ejob = new EJob(this, jobType, jobName);
        this.tool = tool;
        this.display = true;
        this.deleteWhenDone = true;
        this.endTime = 0L;
        this.startTime = 0L;
    }

    public void startJob() {
        this.startJob(!BATCHMODE, true);
    }

    public void startJobOnMyResult() {
        this.startJob(!BATCHMODE, true, true);
    }

    public void startJob(boolean display, boolean deleteWhenDone) {
        this.startJob(display, deleteWhenDone, false);
    }

    private void startJob(boolean display, boolean deleteWhenDone, boolean onMySnapshot) {
        this.display = display;
        this.deleteWhenDone = deleteWhenDone;
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof EThread && ((EThread)currentThread).ejob.jobType != Type.EXAMINE) {
            this.ejob.startedByServer = true;
            this.ejob.client = ((EThread)currentThread).ejob.client;
            this.ejob.serverJob.startTime = System.currentTimeMillis();
            this.ejob.serialize(EDatabase.serverDatabase());
            this.ejob.clientJob = null;
        } else {
            this.ejob.client = Job.getExtendedUserInterface();
            this.ejob.clientJob.startTime = System.currentTimeMillis();
            this.ejob.serverJob = null;
            if (this.ejob.jobType != Type.EXAMINE) {
                this.ejob.serialize(EDatabase.clientDatabase());
            }
        }
        jobManager.addJob(this.ejob, onMySnapshot);
    }

    protected void fieldVariableChanged(String variableName) {
        this.ejob.fieldVariableChanged(variableName);
    }

    public abstract boolean doIt() throws JobException;

    public void terminateIt(Throwable jobException) {
        if (jobException == null) {
            this.terminateOK();
        } else {
            this.terminateFail(jobException);
        }
    }

    public void terminateOK() {
    }

    public void terminateFail(Throwable jobException) {
        if (jobException instanceof CantEditException) {
            ((CantEditException)jobException).presentProblem();
        } else if (jobException instanceof JobException) {
            String message = jobException.getMessage();
            if (message == null) {
                message = "Job " + this.ejob.jobName + " failed";
            }
            System.out.println(message);
        } else {
            ActivityLogger.logException(jobException);
        }
    }

    protected void setReportExecutionFlag(boolean flag) {
        this.reportExecution = flag;
    }

    protected synchronized void setProgress(String progress) {
        jobManager.setProgress(this.ejob, progress);
    }

    private synchronized String getProgress() {
        return this.ejob.progress;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void abort() {
        if (this.ejob.jobType != Type.EXAMINE) {
            return;
        }
        if (this.aborted) {
            System.out.println("Job already aborted: " + this.getStatus());
            return;
        }
        this.scheduledToAbort = true;
    }

    protected synchronized void setAborted() {
        this.aborted = true;
    }

    protected synchronized boolean getScheduledToAbort() {
        return this.scheduledToAbort;
    }

    private synchronized boolean getAborted() {
        return this.aborted;
    }

    public boolean getDisplay() {
        return this.display;
    }

    public boolean getDeleteWhenDone() {
        return this.deleteWhenDone;
    }

    public boolean checkAbort() {
        if (this.ejob.jobType != Type.EXAMINE) {
            return false;
        }
        if (this.getAborted()) {
            return true;
        }
        boolean scheduledAbort = this.getScheduledToAbort();
        if (scheduledAbort) {
            System.out.println(this + ": aborted");
            this.setReportExecutionFlag(true);
            this.setAborted();
        }
        return scheduledAbort;
    }

    public static Iterator<Job> getAllJobs() {
        return jobManager.getAllJobs();
    }

    public String getStatus() {
        switch (this.ejob.state) {
            case WAITING: {
                return "waiting";
            }
            case RUNNING: {
                return this.getProgress() == null ? "running" : this.getProgress();
            }
            case SERVER_DONE: {
                return this.getProgress() == null ? "done" : this.getProgress();
            }
            case CLIENT_DONE: {
                return "cdone";
            }
        }
        if (!this.started) {
            return "waiting";
        }
        if (this.aborted) {
            return "aborted";
        }
        if (this.finished) {
            return "done";
        }
        if (this.scheduledToAbort) {
            return "scheduled to abort";
        }
        if (this.getProgress() == null) {
            return "running";
        }
        return this.getProgress();
    }

    public boolean remove() {
        if (!this.finished && !this.aborted) {
            return false;
        }
        jobManager.removeJob(this);
        return true;
    }

    public static synchronized boolean acquireExamineLock(boolean block) {
        return true;
    }

    public static synchronized void releaseExamineLock() {
    }

    public static void invokeExamineLater(Runnable task, Object singularKey) {
        assert (false);
    }

    public static UserInterface getUserInterface() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof EThread) {
            return ((EThread)currentThread).getUserInterface();
        }
        return currentUI;
    }

    public static AbstractUserInterface getExtendedUserInterface() {
        return currentUI;
    }

    public static EDatabase threadDatabase() {
        return EDatabase.theDatabase;
    }

    public static void wantUpdateGui() {
        jobManager.wantUpdateGui();
    }

    public static void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        currentUI.updateNetworkErrors(cell, errors);
    }

    public static void updateIncrementalDRCErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        currentUI.updateIncrementalDRCErrors(cell, errors);
    }

    public String toString() {
        return this.ejob.jobName + " (" + this.getStatus() + ")";
    }

    public String getInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Job " + this.toString());
        Date start = new Date(this.startTime);
        if (this.finished) {
            long time = this.endTime - this.startTime;
            buf.append(" took: " + TextUtils.getElapsedTime(time));
            buf.append(" (started at " + start + ")");
        } else if (this.getProgress() == null) {
            long time = System.currentTimeMillis() - this.startTime;
            buf.append(" has not finished. Current running time: " + TextUtils.getElapsedTime(time));
        } else {
            buf.append(" did not successfully finish.");
        }
        return buf.toString();
    }

    static void runTerminate(EJob ejob) {
        Throwable jobException = ejob.deserializeResult();
        Job job = ejob.clientJob;
        try {
            job.terminateIt(jobException);
        }
        catch (Throwable e) {
            System.out.println("Exception executing terminateIt");
            e.printStackTrace(System.out);
        }
        job.endTime = System.currentTimeMillis();
        job.finished = true;
        if (job.reportExecution || job.endTime - job.startTime >= 60000L) {
            if (User.isBeepAfterLongJobs()) {
                Toolkit.getDefaultToolkit().beep();
            }
            System.out.println(job.getInfo());
        }
    }

    static {
        socketPort = 35742;
        BATCHMODE = false;
        CLASS_NAME = Job.class.getName();
        logger = Logger.getLogger("com.sun.electric.tool.job");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        USER,
        VISCHANGES,
        INVISCHANGES,
        ANALYSIS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CHANGE,
        UNDO,
        EXAMINE,
        REMOTE_EXAMINE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        FULL_SCREEN,
        BATCH,
        SERVER,
        CLIENT;

    }
}

