/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.CellUsage;
import com.sun.electric.database.IdManager;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.LibId;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Tool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Snapshot {
    public final IdManager idManager;
    public final int snapshotId;
    public final Tool tool;
    public final ImmutableArrayList<CellBackup> cellBackups;
    public final int[] cellGroups;
    public final ImmutableArrayList<LibraryBackup> libBackups;
    private final ERectangle[] cellBounds;

    private Snapshot(IdManager idManager, int snapshotId, Tool tool, ImmutableArrayList<CellBackup> cellBackups, int[] cellGroups, ImmutableArrayList<LibraryBackup> libBackups, ERectangle[] cellBounds) {
        this.idManager = idManager;
        this.snapshotId = snapshotId;
        this.tool = tool;
        this.cellBackups = cellBackups;
        this.cellGroups = cellGroups;
        this.libBackups = libBackups;
        this.cellBounds = new ERectangle[cellBackups.size()];
        for (int cellIndex = 0; cellIndex < cellBounds.length; ++cellIndex) {
            ERectangle r = cellBounds[cellIndex];
            if (r == null) continue;
            if (cellBackups.get(cellIndex) == null) {
                throw new IllegalArgumentException();
            }
            this.cellBounds[cellIndex] = r;
        }
    }

    Snapshot(IdManager idManager) {
        this(idManager, 0, null, CellBackup.EMPTY_LIST, new int[0], LibraryBackup.EMPTY_LIST, ERectangle.NULL_ARRAY);
    }

    public Snapshot with(Tool tool, CellBackup[] cellBackupsArray, ERectangle[] cellBoundsArray, LibraryBackup[] libBackupsArray) {
        boolean namesChanged;
        ImmutableArrayList<CellBackup> cellBackups = Snapshot.copyArray(cellBackupsArray, this.cellBackups);
        ImmutableArrayList<LibraryBackup> libBackups = Snapshot.copyArray(libBackupsArray, this.libBackups);
        boolean bl = namesChanged = this.libBackups != libBackups || this.cellBackups.size() != cellBackups.size();
        if (!namesChanged && this.cellBackups == cellBackups) {
            if (cellBoundsArray != null) {
                for (int cellIndex = 0; cellIndex < cellBoundsArray.length; ++cellIndex) {
                    ERectangle r = cellBoundsArray[cellIndex];
                    if (r == null) continue;
                    this.setCellBounds(((CellBackup)cellBackups.get((int)cellIndex)).d.cellId, r);
                }
            }
            return this;
        }
        for (int cellIndex = 0; cellIndex < cellBackups.size(); ++cellIndex) {
            CellUsage u;
            int i;
            CellId cellId;
            CellBackup newBackup = (CellBackup)cellBackups.get(cellIndex);
            CellBackup oldBackup = this.getCell(cellIndex);
            if (newBackup != null) {
                if (oldBackup == null || newBackup.d.groupName != oldBackup.d.groupName) {
                    namesChanged = true;
                }
                cellId = newBackup.d.cellId;
                if (oldBackup == null || newBackup.cellUsages != oldBackup.cellUsages) {
                    for (i = 0; i < newBackup.cellUsages.length; ++i) {
                        CellBackup.CellUsageInfo oldCui;
                        CellBackup.CellUsageInfo cui = newBackup.cellUsages[i];
                        if (cui == null || oldBackup != null && i < oldBackup.cellUsages.length && (oldCui = oldBackup.cellUsages[i]) != null && cui.usedExports == oldCui.usedExports) continue;
                        u = cellId.getUsageIn(i);
                        CellBackup protoBackup = (CellBackup)cellBackups.get(u.protoId.cellIndex);
                        cui.checkUsage(protoBackup);
                    }
                }
            } else {
                if (oldBackup == null) continue;
                cellId = oldBackup.d.cellId;
                namesChanged = true;
            }
            if (oldBackup == null || newBackup != null && newBackup.definedExportsLength >= oldBackup.definedExportsLength && (newBackup.deletedExports == oldBackup.deletedExports || !newBackup.deletedExports.intersects(oldBackup.definedExports))) continue;
            int numUsages = cellId.numUsagesOf();
            for (i = 0; i < numUsages; ++i) {
                CellBackup.CellUsageInfo cui;
                CellBackup parentBackup;
                u = cellId.getUsageOf(i);
                int parentCellIndex = u.parentId.cellIndex;
                if (parentCellIndex >= cellBackups.size() || (parentBackup = (CellBackup)cellBackups.get(parentCellIndex)) == null || u.indexInParent >= parentBackup.cellUsages.length || (cui = parentBackup.cellUsages[u.indexInParent]) == null) continue;
                cui.checkUsage(newBackup);
            }
        }
        int[] cellGroups = this.cellGroups;
        if (namesChanged) {
            cellGroups = new int[cellBackups.size()];
            Snapshot.checkNames(this.idManager, cellBackups, cellGroups, libBackups);
            if (Arrays.equals(this.cellGroups, cellGroups)) {
                cellGroups = this.cellGroups;
            }
        }
        if (cellBoundsArray == null) {
            cellBoundsArray = this.cellBounds;
        }
        Snapshot snapshot = new Snapshot(this.idManager, this.idManager.newSnapshotId(), tool, cellBackups, cellGroups, libBackups, cellBoundsArray);
        return snapshot;
    }

    public void setCellBounds(CellId cellId, ERectangle r) {
        if (r == null) {
            throw new NullPointerException();
        }
        CellBackup cellBackup = this.getCell(cellId);
        if (cellBackup == null) {
            throw new IllegalArgumentException();
        }
        int cellIndex = cellId.cellIndex;
        ERectangle oldR = this.cellBounds[cellIndex];
        if (oldR != null && oldR != r) {
            throw new IllegalArgumentException();
        }
        this.cellBounds[cellIndex] = r;
    }

    private static <T> ImmutableArrayList<T> copyArray(T[] newArray, ImmutableArrayList<T> oldList) {
        int l;
        if (newArray == null) {
            return oldList;
        }
        for (l = newArray.length; l > 0 && newArray[l - 1] == null; --l) {
        }
        if (l == oldList.size()) {
            int i;
            for (i = 0; i < oldList.size() && newArray[i] == oldList.get(i); ++i) {
            }
            if (i == l) {
                return oldList;
            }
        }
        return new ImmutableArrayList<T>(newArray, 0, l);
    }

    public Snapshot withRenamedIds(IdMapper idMapper, CellId fromGroup, String toGroup) {
        int maxCellIndex = -1;
        for (CellBackup cellBackup : this.cellBackups) {
            if (cellBackup == null) continue;
            maxCellIndex = Math.max(maxCellIndex, idMapper.get((CellId)cellBackup.d.cellId).cellIndex);
        }
        int maxLibIndex = -1;
        for (LibraryBackup libBackup : this.libBackups) {
            if (libBackup == null) continue;
            maxLibIndex = Math.max(maxLibIndex, idMapper.get((LibId)libBackup.d.libId).libIndex);
        }
        CellBackup[] cellBackupsArray = new CellBackup[maxCellIndex + 1];
        ERectangle[] cellBoundsArray = new ERectangle[maxCellIndex + 1];
        LibraryBackup[] libBackupsArray = new LibraryBackup[maxLibIndex + 1];
        boolean cellBackupsChanged = false;
        boolean cellIdsChanged = false;
        BitSet fromGroupCellIds = new BitSet();
        BitSet toGroupCellIds = new BitSet();
        CellName fromGroupName = null;
        CellName toGroupName = null;
        if (fromGroup != null) {
            assert (this.getCell(fromGroup) != null);
            CellId toGroupCellId = idMapper.get(fromGroup);
            assert (toGroupCellId != null);
            assert (this.getCell(toGroupCellId) == null);
            int fromGroupIndex = this.cellGroups[fromGroup.cellIndex];
            assert (fromGroupIndex >= 0);
            int toGroupIndex1 = -1;
            int toGroupIndex2 = -1;
            if (toGroup == null) {
                toGroupIndex2 = fromGroupIndex;
            }
            for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
                CellBackup cellBackup = (CellBackup)this.cellBackups.get(cellIndex);
                if (cellBackup == null || cellBackup.d.cellId.libId != fromGroup.libId) continue;
                if (cellBackup.d.cellId.cellName.getName().equals(toGroupCellId.cellName.getName())) {
                    toGroupIndex1 = this.cellGroups[cellIndex];
                }
                if (toGroup == null || !cellBackup.d.cellId.cellName.getName().equals(toGroup)) continue;
                toGroupIndex2 = this.cellGroups[cellIndex];
            }
            ArrayList<CellName> fromCellNames = new ArrayList<CellName>();
            ArrayList<CellName> toCellNames = new ArrayList<CellName>();
            toGroupCellIds.set(toGroupCellId.cellIndex);
            toCellNames.add(toGroupCellId.cellName);
            for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
                CellBackup cellBackup = (CellBackup)this.cellBackups.get(cellIndex);
                if (cellBackup == null || cellIndex == fromGroup.cellIndex) continue;
                if (this.cellGroups[cellIndex] == fromGroupIndex) {
                    fromGroupCellIds.set(cellIndex);
                    fromCellNames.add(cellBackup.d.cellId.cellName);
                }
                if (this.cellGroups[cellIndex] != toGroupIndex1 && this.cellGroups[cellIndex] != toGroupIndex2) continue;
                toGroupCellIds.set(cellIndex);
                toCellNames.add(cellBackup.d.cellId.cellName);
            }
            if (!fromCellNames.isEmpty()) {
                fromGroupName = Snapshot.makeCellGroupName(fromCellNames);
            }
            if (!toCellNames.isEmpty()) {
                toGroupName = Snapshot.makeCellGroupName(toCellNames);
            }
        }
        for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
            int newCellIndex;
            CellBackup newCellBackup;
            CellBackup oldCellBackup = (CellBackup)this.cellBackups.get(cellIndex);
            if (oldCellBackup == null) continue;
            CellName newGroupName = oldCellBackup.d.groupName;
            if (fromGroup != null) {
                if (toGroupCellIds.get(cellIndex) || cellIndex == fromGroup.cellIndex) {
                    newGroupName = toGroupName;
                } else if (fromGroupCellIds.get(cellIndex)) {
                    newGroupName = fromGroupName;
                }
            }
            if ((newCellBackup = oldCellBackup.withRenamedIds(idMapper, newGroupName)) != oldCellBackup) {
                cellBackupsChanged = true;
            }
            if ((newCellIndex = newCellBackup.d.cellId.cellIndex) != cellIndex) {
                cellIdsChanged = true;
            }
            cellBackupsArray[newCellIndex] = newCellBackup;
            cellBoundsArray[newCellIndex] = this.cellBounds[cellIndex];
        }
        if (!cellBackupsChanged) {
            cellBackupsArray = null;
        }
        if (!cellIdsChanged) {
            cellBoundsArray = null;
        }
        boolean libBackupsChanged = false;
        for (int libIndex = 0; libIndex < this.libBackups.size(); ++libIndex) {
            LibraryBackup oldLibBackup = (LibraryBackup)this.libBackups.get(libIndex);
            if (oldLibBackup == null) continue;
            LibraryBackup newLibBackup = oldLibBackup.withRenamedIds(idMapper);
            if (newLibBackup != oldLibBackup) {
                libBackupsChanged = true;
            }
            libBackupsArray[newLibBackup.d.libId.libIndex] = newLibBackup;
        }
        if (!libBackupsChanged) {
            libBackupsArray = null;
        }
        if (cellBackupsArray == null && this.cellBounds == null && this.libBackups == null) {
            return this;
        }
        return this.with(this.tool, cellBackupsArray, cellBoundsArray, libBackupsArray);
    }

    public List<LibId> getChangedLibraries(Snapshot oldSnapshot) {
        if (oldSnapshot == null) {
            oldSnapshot = this.idManager.getInitialSnapshot();
        }
        if (this.idManager != oldSnapshot.idManager) {
            throw new IllegalArgumentException();
        }
        List<LibId> changed = null;
        if (oldSnapshot.libBackups != this.libBackups) {
            int numLibs = Math.max(oldSnapshot.libBackups.size(), this.libBackups.size());
            for (int i = 0; i < numLibs; ++i) {
                LibraryBackup newBackup;
                LibraryBackup oldBackup = oldSnapshot.getLib(i);
                if (oldBackup == (newBackup = this.getLib(i))) continue;
                if (changed == null) {
                    changed = new ArrayList<LibId>();
                }
                changed.add(this.idManager.getLibId(i));
            }
        }
        if (changed == null) {
            changed = Collections.emptyList();
        }
        return changed;
    }

    public List<CellId> getChangedCells(Snapshot oldSnapshot) {
        if (oldSnapshot == null) {
            oldSnapshot = this.idManager.getInitialSnapshot();
        }
        List<CellId> changed = null;
        int numCells = Math.max(oldSnapshot.cellBackups.size(), this.cellBackups.size());
        for (int i = 0; i < numCells; ++i) {
            CellBackup newBackup;
            CellBackup oldBackup = oldSnapshot.getCell(i);
            if (oldBackup == (newBackup = this.getCell(i))) continue;
            if (changed == null) {
                changed = new ArrayList<CellId>();
            }
            changed.add(this.idManager.getCellId(i));
        }
        if (changed == null) {
            changed = Collections.emptyList();
        }
        return changed;
    }

    public CellBackup getCell(CellId cellId) {
        if (cellId.getIdManager() != this.idManager) {
            throw new IllegalArgumentException();
        }
        return this.getCell(cellId.cellIndex);
    }

    public CellBackup getCell(int cellIndex) {
        return cellIndex < this.cellBackups.size() ? (CellBackup)this.cellBackups.get(cellIndex) : null;
    }

    public static CellName makeCellGroupName(Collection<CellName> cellNames) {
        String name;
        if (cellNames.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String groupName = null;
        for (CellName cellName : cellNames) {
            if (cellName.getView() != View.SCHEMATIC) continue;
            name = cellName.getName();
            if (groupName != null && TextUtils.STRING_NUMBER_ORDER.compare(name, groupName) >= 0) continue;
            groupName = name;
        }
        if (groupName == null) {
            for (CellName cellName : cellNames) {
                name = cellName.getName();
                if (groupName != null && name.length() >= groupName.length() && (name.length() != groupName.length() || TextUtils.STRING_NUMBER_ORDER.compare(name, groupName) >= 0)) continue;
                groupName = name;
            }
        }
        assert (groupName != null);
        return CellName.parseName(groupName + "{sch}");
    }

    public ERectangle getCellBounds(CellId cellId) {
        return this.getCellBounds(cellId.cellIndex);
    }

    public ERectangle getCellBounds(int cellIndex) {
        return cellIndex < this.cellBounds.length ? this.cellBounds[cellIndex] : null;
    }

    public LibraryBackup getLib(LibId libId) {
        return this.getLib(libId.libIndex);
    }

    private LibraryBackup getLib(int libIndex) {
        return libIndex < this.libBackups.size() ? (LibraryBackup)this.libBackups.get(libIndex) : null;
    }

    public void writeDiffs(SnapshotWriter writer, Snapshot oldSnapshot) throws IOException {
        int i;
        Object newBackup;
        assert (oldSnapshot.cellBoundsDefined());
        assert (this.cellBoundsDefined());
        this.idManager.writeDiffs(writer);
        writer.writeInt(this.snapshotId);
        writer.writeBoolean(this.tool != null);
        if (this.tool != null) {
            writer.writeTool(this.tool);
        }
        boolean libsChanged = oldSnapshot.libBackups != this.libBackups;
        writer.writeBoolean(libsChanged);
        if (libsChanged) {
            writer.writeInt(this.libBackups.size());
            for (int i2 = 0; i2 < this.libBackups.size(); ++i2) {
                LibraryBackup oldBackup = oldSnapshot.getLib(i2);
                if (oldBackup == (newBackup = this.getLib(i2))) continue;
                if (oldBackup == null) {
                    writer.writeInt(i2);
                    ((LibraryBackup)newBackup).write(writer);
                    continue;
                }
                if (newBackup == null) {
                    writer.writeInt(~i2);
                    continue;
                }
                writer.writeInt(i2);
                ((LibraryBackup)newBackup).write(writer);
            }
            writer.writeInt(Integer.MAX_VALUE);
        }
        writer.writeInt(this.cellBackups.size());
        boolean boundsChanged = oldSnapshot.cellBounds.length != this.cellBounds.length;
        for (int cellIndex = 0; cellIndex < this.cellBounds.length; ++cellIndex) {
            if (this.cellBackups.get(cellIndex) == null) continue;
            boundsChanged = boundsChanged || this.cellBounds[cellIndex] != oldSnapshot.cellBounds[cellIndex];
        }
        writer.writeBoolean(boundsChanged);
        for (i = 0; i < this.cellBackups.size(); ++i) {
            CellBackup newBackup2;
            CellBackup oldBackup = oldSnapshot.getCell(i);
            if (oldBackup == (newBackup2 = this.getCell(i))) continue;
            if (oldBackup == null) {
                writer.writeInt(i);
                newBackup2.write(writer);
                continue;
            }
            if (newBackup2 == null) {
                writer.writeInt(~i);
                continue;
            }
            writer.writeInt(i);
            newBackup2.write(writer);
        }
        writer.writeInt(Integer.MAX_VALUE);
        if (boundsChanged) {
            for (i = 0; i < this.cellBackups.size(); ++i) {
                newBackup = this.getCell(i);
                if (newBackup == null) continue;
                ERectangle oldBounds = oldSnapshot.getCellBounds(i);
                ERectangle newBounds = this.getCellBounds(i);
                assert (newBounds != null);
                if (oldBounds == newBounds) continue;
                writer.writeInt(i);
                writer.writeRectangle(newBounds);
            }
            writer.writeInt(Integer.MAX_VALUE);
        }
        boolean cellGroupsChanged = this.cellGroups != oldSnapshot.cellGroups;
        writer.writeBoolean(cellGroupsChanged);
        if (cellGroupsChanged) {
            writer.writeInt(this.cellGroups.length);
            for (int i3 = 0; i3 < this.cellGroups.length; ++i3) {
                writer.writeInt(this.cellGroups[i3]);
            }
        }
    }

    public static Snapshot readSnapshot(SnapshotReader reader, Snapshot oldSnapshot) throws IOException {
        int cellIndex;
        assert (oldSnapshot.cellBoundsDefined());
        oldSnapshot.idManager.readDiffs(reader);
        int snapshotId = reader.readInt();
        boolean hasTool = reader.readBoolean();
        Tool tool = hasTool ? reader.readTool() : null;
        ImmutableArrayList<LibraryBackup> libBackups = oldSnapshot.libBackups;
        boolean libsChanged = reader.readBoolean();
        if (libsChanged) {
            int libIndex;
            int libLen = reader.readInt();
            LibraryBackup[] libBackupsArray = new LibraryBackup[libLen];
            int numLibs = Math.min(oldSnapshot.libBackups.size(), libLen);
            for (libIndex = 0; libIndex < numLibs; ++libIndex) {
                libBackupsArray[libIndex] = (LibraryBackup)oldSnapshot.libBackups.get(libIndex);
            }
            while ((libIndex = reader.readInt()) != Integer.MAX_VALUE) {
                if (libIndex >= 0) {
                    LibraryBackup newBackup;
                    libBackupsArray[libIndex] = newBackup = LibraryBackup.read(reader);
                    continue;
                }
                assert (libBackupsArray[libIndex ^= 0xFFFFFFFF] != null);
                libBackupsArray[libIndex] = null;
            }
            libBackups = new ImmutableArrayList<LibraryBackup>(libBackupsArray);
        }
        int cellLen = reader.readInt();
        int cellMax = Math.min(oldSnapshot.cellBackups.size(), cellLen);
        CellBackup[] cellBackupsArray = new CellBackup[cellLen];
        for (int cellIndex2 = 0; cellIndex2 < cellMax; ++cellIndex2) {
            cellBackupsArray[cellIndex2] = (CellBackup)oldSnapshot.cellBackups.get(cellIndex2);
        }
        boolean boundsChanged = reader.readBoolean();
        ERectangle[] cellBoundsArray = oldSnapshot.cellBounds;
        if (boundsChanged) {
            cellBoundsArray = new ERectangle[cellLen];
            int numCells = Math.min(oldSnapshot.cellBounds.length, cellLen);
            for (cellIndex = 0; cellIndex < numCells; ++cellIndex) {
                cellBoundsArray[cellIndex] = oldSnapshot.cellBounds[cellIndex];
            }
        }
        while ((cellIndex = reader.readInt()) != Integer.MAX_VALUE) {
            if (cellIndex >= 0) {
                CellBackup newBackup;
                cellBackupsArray[cellIndex] = newBackup = CellBackup.read(reader);
                continue;
            }
            assert (cellBackupsArray[cellIndex ^= 0xFFFFFFFF] != null);
            cellBackupsArray[cellIndex] = null;
            assert (boundsChanged);
            assert (cellBoundsArray[cellIndex] != null);
            cellBoundsArray[cellIndex] = null;
        }
        ImmutableArrayList<CellBackup> cellBackups = new ImmutableArrayList<CellBackup>(cellBackupsArray);
        if (boundsChanged) {
            int cellIndex3;
            while ((cellIndex3 = reader.readInt()) != Integer.MAX_VALUE) {
                ERectangle newBounds;
                cellBoundsArray[cellIndex3] = newBounds = reader.readRectangle();
            }
        }
        int[] cellGroups = oldSnapshot.cellGroups;
        boolean cellGroupsChanged = reader.readBoolean();
        if (cellGroupsChanged) {
            int cellGroupsLength = reader.readInt();
            cellGroups = new int[cellGroupsLength];
            for (int i = 0; i < cellGroups.length; ++i) {
                cellGroups[i] = reader.readInt();
            }
        }
        for (int i = 0; i < cellBackups.size(); ++i) {
            assert (cellBackups.get(i) != null == (cellBoundsArray[i] != null));
            assert (cellBackups.get(i) != null == cellGroups[i] >= 0);
        }
        return new Snapshot(oldSnapshot.idManager, snapshotId, tool, cellBackups, cellGroups, libBackups, cellBoundsArray);
    }

    public boolean cellBoundsDefined() {
        assert (this.cellBackups.size() == this.cellBounds.length);
        for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
            if (this.cellBackups.get(cellIndex) == null || this.cellBounds[cellIndex] != null) continue;
            return false;
        }
        return true;
    }

    public void check() {
        for (LibraryBackup libBackup : this.libBackups) {
            if (libBackup == null) continue;
            libBackup.check();
        }
        for (CellBackup cellBackup : this.cellBackups) {
            if (cellBackup == null) continue;
            cellBackup.check();
        }
        if (this.libBackups.size() > 0) assert (this.libBackups.get(this.libBackups.size() - 1) != null);
        if (this.cellBackups.size() > 0) assert (this.cellBackups.get(this.cellBackups.size() - 1) != null);
        int[] cellGroups = new int[this.cellBackups.size()];
        Snapshot.checkNames(this.idManager, this.cellBackups, cellGroups, this.libBackups);
        assert (Arrays.equals(this.cellGroups, cellGroups));
        assert (this.cellBackups.size() == this.cellBounds.length);
        for (int cellIndex = 0; cellIndex < this.cellBackups.size(); ++cellIndex) {
            CellBackup cellBackup = (CellBackup)this.cellBackups.get(cellIndex);
            if (cellBackup == null) {
                assert (this.cellBounds[cellIndex] == null);
                continue;
            }
            CellId cellId = cellBackup.d.cellId;
            for (int i = 0; i < cellBackup.cellUsages.length; ++i) {
                CellBackup.CellUsageInfo cui = cellBackup.cellUsages[i];
                if (cui == null) continue;
                CellUsage u = cellId.getUsageIn(i);
                int subCellIndex = u.protoId.cellIndex;
                cui.checkUsage((CellBackup)this.cellBackups.get(subCellIndex));
            }
        }
    }

    private static void checkNames(IdManager idManager, ImmutableArrayList<CellBackup> cellBackups, int[] cellGroups, ImmutableArrayList<LibraryBackup> libBackups) {
        HashSet<String> libNames = new HashSet<String>();
        ArrayList protoNameToGroupName = new ArrayList();
        ArrayList cellNames = new ArrayList();
        ArrayList groupNameToGroupIndex = new ArrayList();
        for (int libIndex = 0; libIndex < libBackups.size(); ++libIndex) {
            LibraryBackup libBackup = (LibraryBackup)libBackups.get(libIndex);
            if (libBackup == null) {
                protoNameToGroupName.add(null);
                cellNames.add(null);
                groupNameToGroupIndex.add(null);
                continue;
            }
            protoNameToGroupName.add(new HashMap());
            cellNames.add(new HashSet());
            groupNameToGroupIndex.add(new HashMap());
            if (libBackup.d.libId != idManager.getLibId(libIndex)) {
                throw new IllegalArgumentException("LibId");
            }
            String libName = libBackup.d.libId.libName;
            if (!libNames.add(libName)) {
                throw new IllegalArgumentException("duplicate libName");
            }
            for (LibId libId : libBackup.referencedLibs) {
                if (libId == ((LibraryBackup)libBackups.get((int)libId.libIndex)).d.libId) continue;
                throw new IllegalArgumentException("LibId in referencedLibs");
            }
        }
        assert (protoNameToGroupName.size() == libBackups.size() && cellNames.size() == libBackups.size() && groupNameToGroupIndex.size() == libBackups.size());
        assert (cellBackups.size() == cellGroups.length);
        Arrays.fill(cellGroups, -1);
        int groupCount = 0;
        for (int cellIndex = 0; cellIndex < cellBackups.size(); ++cellIndex) {
            CellBackup cellBackup = (CellBackup)cellBackups.get(cellIndex);
            if (cellBackup == null) continue;
            ImmutableCell d = cellBackup.d;
            CellId cellId = d.cellId;
            if (cellId != idManager.getCellId(cellIndex)) {
                throw new IllegalArgumentException("CellId");
            }
            LibId libId = d.getLibId();
            int libIndex = libId.libIndex;
            if (libId != ((LibraryBackup)libBackups.get((int)libIndex)).d.libId) {
                throw new IllegalArgumentException("LibId in ImmutableCell");
            }
            HashMap cellNameToGroupNameInLibrary = (HashMap)protoNameToGroupName.get(libId.libIndex);
            HashSet cellNamesInLibrary = (HashSet)cellNames.get(libId.libIndex);
            HashMap groupNameToGroupIndexInLibrary = (HashMap)groupNameToGroupIndex.get(libId.libIndex);
            String protoName = cellId.cellName.getName();
            CellName groupName = (CellName)cellNameToGroupNameInLibrary.get(protoName);
            if (groupName == null) {
                groupName = d.groupName;
                cellNameToGroupNameInLibrary.put(protoName, groupName);
            } else if (!d.groupName.equals(groupName)) {
                throw new IllegalArgumentException("cells with same proto name in different groups");
            }
            Integer gn = (Integer)groupNameToGroupIndexInLibrary.get(groupName);
            if (gn == null) {
                gn = groupCount++;
                groupNameToGroupIndexInLibrary.put(groupName, gn);
            }
            cellGroups[cellIndex] = gn;
            if (cellNamesInLibrary.add(cellId.cellName)) continue;
            throw new IllegalArgumentException("duplicate CellName in library");
        }
    }
}

