/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class HighlightMessage
extends Highlight2 {
    protected String msg;
    protected Point2D loc;

    HighlightMessage(Cell c, String m, Point2D p) {
        super(c);
        this.msg = m;
        this.loc = p;
    }

    @Override
    void internalDescribe(StringBuffer desc) {
        desc.append(", ");
        desc.append(this.msg);
    }

    @Override
    public void showInternalHighlight(EditWindow wnd, Graphics g, int highOffX, int highOffY, boolean onlyHighlight, boolean setConnected) {
        Point location = wnd.databaseToScreen(this.loc.getX(), this.loc.getY());
        Color oldColor = g.getColor();
        g.setColor(new Color(255 - oldColor.getRed(), 255 - oldColor.getGreen(), 255 - oldColor.getBlue()));
        g.drawString(this.msg, location.x + 1, location.y + 1);
        g.setColor(oldColor);
        g.drawString(this.msg, location.x, location.y);
    }

    @Override
    Rectangle2D getHighlightedArea(EditWindow wnd) {
        return new Rectangle2D.Double(this.loc.getX(), this.loc.getY(), 0.0, 0.0);
    }
}

