/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.dialogs.ProjectSettingsFrame;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ParasiticTab
extends ProjSettingsPanel {
    private JList layerList;
    private DefaultListModel layerListModel;
    private boolean changing;
    private JTextField capacitance;
    private JTextField edgeCapacitance;
    private JButton factoryReset;
    private JTextField gateLengthSubtraction;
    private JPanel globalValues;
    private JCheckBox includeGate;
    private JCheckBox includeGround;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JTextField maxSeriesResistance;
    private JTextField minCapacitance;
    private JTextField minResistance;
    private JTextField resistance;
    private JScrollPane spiceLayer;
    private JComboBox techSelection;
    private JPanel techValues;
    private JPanel topPanel;

    public ParasiticTab(ProjectSettingsFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.topPanel;
    }

    public String getName() {
        return "Parasitic";
    }

    public void init() {
        this.changing = false;
        this.layerListModel = new DefaultListModel();
        this.layerList = new JList(this.layerListModel);
        this.layerList.setSelectionMode(0);
        this.spiceLayer.setViewportView(this.layerList);
        this.layerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ParasiticTab.this.layerListClick();
            }
        });
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.techSelection.addItem(tech.getTechName());
        }
        this.techSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.techChanged();
            }
        });
        this.techSelection.setSelectedItem(Technology.getCurrent().getTechName());
        ParasiticLayerDocumentListener updateLayerParasitics = new ParasiticLayerDocumentListener();
        this.resistance.getDocument().addDocumentListener(updateLayerParasitics);
        this.capacitance.getDocument().addDocumentListener(updateLayerParasitics);
        this.edgeCapacitance.getDocument().addDocumentListener(updateLayerParasitics);
        ParasiticTechDocumentListener updateTechnologyGlobals = new ParasiticTechDocumentListener();
        this.minResistance.getDocument().addDocumentListener(updateTechnologyGlobals);
        this.minCapacitance.getDocument().addDocumentListener(updateTechnologyGlobals);
        this.maxSeriesResistance.getDocument().addDocumentListener(updateTechnologyGlobals);
        this.gateLengthSubtraction.getDocument().addDocumentListener(updateTechnologyGlobals);
        this.includeGate.addActionListener(updateTechnologyGlobals);
        this.includeGround.addActionListener(updateTechnologyGlobals);
    }

    private void techChanged() {
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.changing = true;
        this.minResistance.setText(TextUtils.formatDouble(this.getDouble(tech.getMinResistanceSetting())));
        this.minCapacitance.setText(TextUtils.formatDouble(this.getDouble(tech.getMinCapacitanceSetting())));
        this.gateLengthSubtraction.setText(TextUtils.formatDouble(this.getDouble(tech.getGateLengthSubtractionSetting())));
        this.maxSeriesResistance.setText(TextUtils.formatDouble(this.getDouble(tech.getMaxSeriesResistanceSetting())));
        this.includeGate.setSelected(this.getBoolean(tech.getGateIncludedSetting()));
        this.includeGround.setSelected(this.getBoolean(tech.getGroundNetIncludedSetting()));
        this.layerListModel.clear();
        Iterator<Layer> it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            this.layerListModel.addElement(layer.getName());
        }
        this.layerList.setSelectedIndex(0);
        this.layerListClick();
        this.changing = false;
    }

    private void layerListClick() {
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.changing = true;
        String layerName = (String)this.layerList.getSelectedValue();
        Layer layer = tech.findLayer(layerName);
        if (layer != null) {
            this.resistance.setText(TextUtils.formatDouble(this.getDouble(layer.getResistanceSetting())));
            this.capacitance.setText(TextUtils.formatDouble(this.getDouble(layer.getCapacitanceSetting())));
            this.edgeCapacitance.setText(TextUtils.formatDouble(this.getDouble(layer.getEdgeCapacitanceSetting())));
        }
        this.changing = false;
    }

    private void factoryResetActionPerformed(ActionEvent evt) {
        String techName = (String)this.techSelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        int ret = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset all layers for technology " + techName + " to their default resistance and capacitance values?", "Factory Reset", 2, 2);
        if (ret == 0) {
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                Setting resistanceSetting = layer.getResistanceSetting();
                this.setDouble(resistanceSetting, resistanceSetting.getDoubleFactoryValue());
                Setting capacitanceSetting = layer.getCapacitanceSetting();
                this.setDouble(capacitanceSetting, capacitanceSetting.getDoubleFactoryValue());
                Setting edgeCapacitanceSetting = layer.getEdgeCapacitanceSetting();
                this.setDouble(edgeCapacitanceSetting, edgeCapacitanceSetting.getDoubleFactoryValue());
            }
            this.init();
        }
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.techValues = new JPanel();
        this.spiceLayer = new JScrollPane();
        this.jLabel7 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel2 = new JLabel();
        this.resistance = new JTextField();
        this.jLabel12 = new JLabel();
        this.capacitance = new JTextField();
        this.edgeCapacitance = new JTextField();
        this.factoryReset = new JButton();
        this.globalValues = new JPanel();
        this.jLabel20 = new JLabel();
        this.minResistance = new JTextField();
        this.jLabel21 = new JLabel();
        this.minCapacitance = new JTextField();
        this.jLabel5 = new JLabel();
        this.gateLengthSubtraction = new JTextField();
        this.includeGate = new JCheckBox();
        this.includeGround = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.maxSeriesResistance = new JTextField();
        this.jLabel3 = new JLabel();
        this.techSelection = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.topPanel.setLayout(new GridBagLayout());
        this.techValues.setLayout(new GridBagLayout());
        this.techValues.setBorder(BorderFactory.createTitledBorder("Layer Values"));
        this.spiceLayer.setMinimumSize(new Dimension(200, 50));
        this.spiceLayer.setPreferredSize(new Dimension(200, 50));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.techValues.add((Component)this.spiceLayer, gridBagConstraints);
        this.jLabel7.setText("Layer:");
        this.jLabel7.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.techValues.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel11.setText("Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel2.setText("Perimeter Cap (fF/um):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.jLabel2, gridBagConstraints);
        this.resistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.resistance, gridBagConstraints);
        this.jLabel12.setText("Area Cap (fF/um^2):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.jLabel12, gridBagConstraints);
        this.capacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.capacitance, gridBagConstraints);
        this.edgeCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.techValues.add((Component)this.edgeCapacitance, gridBagConstraints);
        this.factoryReset.setText("Factory Reset");
        this.factoryReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParasiticTab.this.factoryResetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.techValues.add((Component)this.factoryReset, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.topPanel.add((Component)this.techValues, gridBagConstraints);
        this.globalValues.setLayout(new GridBagLayout());
        this.globalValues.setBorder(BorderFactory.createTitledBorder("Global Values"));
        this.jLabel20.setText("Min. Resistance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.jLabel20, gridBagConstraints);
        this.minResistance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.minResistance, gridBagConstraints);
        this.jLabel21.setText("Min. Capacitance (fF):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.jLabel21, gridBagConstraints);
        this.minCapacitance.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.globalValues.add((Component)this.minCapacitance, gridBagConstraints);
        this.jLabel5.setText("Gate Length Shrink (Subtraction) um:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.gateLengthSubtraction, gridBagConstraints);
        this.includeGate.setText("Include Gate In Resistance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.includeGate, gridBagConstraints);
        this.includeGround.setText("Include Ground Network");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globalValues.add((Component)this.includeGround, gridBagConstraints);
        this.jLabel1.setText("Max. Series Resistance: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.globalValues.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.globalValues.add((Component)this.maxSeriesResistance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.topPanel.add((Component)this.globalValues, gridBagConstraints);
        this.jLabel3.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.topPanel.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.topPanel.add((Component)this.techSelection, gridBagConstraints);
        this.getContentPane().add((Component)this.topPanel, new GridBagConstraints());
        this.pack();
    }

    private class ParasiticTechDocumentListener
    implements ActionListener,
    DocumentListener {
        private ParasiticTechDocumentListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            this.updateTechnologyGlobals();
        }

        public void changedUpdate(DocumentEvent e) {
            this.updateTechnologyGlobals();
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateTechnologyGlobals();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateTechnologyGlobals();
        }

        private void updateTechnologyGlobals() {
            if (ParasiticTab.this.changing) {
                return;
            }
            String techName = (String)ParasiticTab.this.techSelection.getSelectedItem();
            Technology tech = Technology.findTechnology(techName);
            if (tech == null) {
                return;
            }
            ParasiticTab.this.setDouble(tech.getMinResistanceSetting(), TextUtils.atof(ParasiticTab.this.minResistance.getText()));
            ParasiticTab.this.setDouble(tech.getMinCapacitanceSetting(), TextUtils.atof(ParasiticTab.this.minCapacitance.getText()));
            ParasiticTab.this.setDouble(tech.getGateLengthSubtractionSetting(), TextUtils.atof(ParasiticTab.this.gateLengthSubtraction.getText()));
            ParasiticTab.this.setDouble(tech.getMaxSeriesResistanceSetting(), TextUtils.atof(ParasiticTab.this.maxSeriesResistance.getText()));
            ParasiticTab.this.setBoolean(tech.getGateIncludedSetting(), ParasiticTab.this.includeGate.isSelected());
            ParasiticTab.this.setBoolean(tech.getGroundNetIncludedSetting(), ParasiticTab.this.includeGround.isSelected());
        }
    }

    private class ParasiticLayerDocumentListener
    implements DocumentListener {
        private ParasiticLayerDocumentListener() {
        }

        private void change() {
            if (ParasiticTab.this.changing) {
                return;
            }
            String techName = (String)ParasiticTab.this.techSelection.getSelectedItem();
            Technology tech = Technology.findTechnology(techName);
            if (tech == null) {
                return;
            }
            String layerName = (String)ParasiticTab.this.layerList.getSelectedValue();
            Layer layer = tech.findLayer(layerName);
            if (layer == null) {
                return;
            }
            ParasiticTab.this.setDouble(layer.getResistanceSetting(), TextUtils.atof(ParasiticTab.this.resistance.getText()));
            ParasiticTab.this.setDouble(layer.getCapacitanceSetting(), TextUtils.atof(ParasiticTab.this.capacitance.getText()));
            ParasiticTab.this.setDouble(layer.getEdgeCapacitanceSetting(), TextUtils.atof(ParasiticTab.this.edgeCapacitance.getText()));
        }

        public void changedUpdate(DocumentEvent e) {
            this.change();
        }

        public void insertUpdate(DocumentEvent e) {
            this.change();
        }

        public void removeUpdate(DocumentEvent e) {
            this.change();
        }
    }
}

