/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.technology.BoundsBuilder;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topology {
    final Cell cell;
    private int maxArcSuffix = -1;
    private final ArrayList<ArcInst> chronArcs = new ArrayList();
    private final ArrayList<ArcInst> arcs = new ArrayList();
    boolean validArcBounds;
    private RTNode rTree = RTNode.makeTopLevel();
    private boolean rTreeFresh;

    public Topology(Cell cell, boolean loadBackup) {
        this.cell = cell;
        if (loadBackup) {
            this.updateArcs(cell.backup().cellRevision);
        }
    }

    public synchronized Iterator<ArcInst> getArcs() {
        ArrayList<ArcInst> arcsCopy = new ArrayList<ArcInst>(this.arcs);
        return arcsCopy.iterator();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public final ArcInst getArc(int arcIndex) {
        return this.arcs.get(arcIndex);
    }

    public ArcInst getArcById(int arcId) {
        return arcId < this.chronArcs.size() ? this.chronArcs.get(arcId) : null;
    }

    public ArcInst findArc(String name) {
        ArcInst ai;
        int arcIndex = this.searchArc(name, 0);
        if (arcIndex >= 0) {
            return this.arcs.get(arcIndex);
        }
        if ((arcIndex = -arcIndex - 1) < this.arcs.size() && (ai = this.arcs.get(arcIndex)).getName().equals(name)) {
            return ai;
        }
        return null;
    }

    void addArc(ArcInst ai) {
        this.cell.setTopologyModified();
        this.validArcBounds = false;
        this.unfreshRTree();
        int arcIndex = this.searchArc(ai.getName(), ai.getD().arcId);
        assert (arcIndex < 0);
        this.arcs.add(arcIndex, ai);
        for (arcIndex = -arcIndex - 1; arcIndex < this.arcs.size(); ++arcIndex) {
            ArcInst a = this.arcs.get(arcIndex);
            a.setArcIndex(arcIndex);
        }
        int arcId = ai.getD().arcId;
        while (this.chronArcs.size() <= arcId) {
            this.chronArcs.add(null);
        }
        assert (this.chronArcs.get(arcId) == null);
        this.chronArcs.set(arcId, ai);
        if (ai.isUsernamed()) {
            return;
        }
        Name name = ai.getNameKey();
        assert (name.getBasename() == ImmutableArcInst.BASENAME);
        this.maxArcSuffix = Math.max(this.maxArcSuffix, name.getNumSuffix());
        this.cell.setDirty();
    }

    Name getArcAutoname() {
        if (this.maxArcSuffix < Integer.MAX_VALUE) {
            return ImmutableArcInst.BASENAME.findSuffixed(++this.maxArcSuffix);
        }
        int i = 0;
        Name name;
        while (this.hasTempArcName(name = ImmutableArcInst.BASENAME.findSuffixed(i))) {
            ++i;
        }
        return name;
    }

    boolean hasTempArcName(Name name) {
        return name.isTempname() && this.findArc(name.toString()) != null;
    }

    void removeArc(ArcInst ai) {
        this.cell.checkChanging();
        this.cell.setTopologyModified();
        this.unfreshRTree();
        assert (ai.isLinked());
        int arcIndex = ai.getArcIndex();
        ArcInst removedAi = this.arcs.remove(arcIndex);
        assert (removedAi == ai);
        for (int i = arcIndex; i < this.arcs.size(); ++i) {
            ArcInst a = this.arcs.get(i);
            a.setArcIndex(i);
        }
        ai.setArcIndex(-1);
        int arcId = ai.getD().arcId;
        assert (this.chronArcs.get(arcId) == ai);
        this.chronArcs.set(arcId, null);
        this.cell.setDirty();
    }

    public ImmutableArcInst[] backupArcs(ImmutableArrayList<ImmutableArcInst> oldArcs) {
        ImmutableArcInst[] newArcs = new ImmutableArcInst[this.arcs.size()];
        boolean changed = this.arcs.size() != oldArcs.size();
        for (int i = 0; i < this.arcs.size(); ++i) {
            ArcInst ai = this.arcs.get(i);
            ImmutableArcInst d = ai.getD();
            changed = changed || oldArcs.get(i) != d;
            newArcs[i] = d;
        }
        return changed ? newArcs : null;
    }

    public void updateArcs(CellRevision newRevision) {
        ArcInst ai;
        this.validArcBounds = false;
        this.arcs.clear();
        this.maxArcSuffix = -1;
        for (int i = 0; i < newRevision.arcs.size(); ++i) {
            ImmutableArcInst d = (ImmutableArcInst)newRevision.arcs.get(i);
            while (d.arcId >= this.chronArcs.size()) {
                this.chronArcs.add(null);
            }
            ai = this.chronArcs.get(d.arcId);
            PortInst headPi = this.cell.getPortInst(d.headNodeId, d.headPortId);
            PortInst tailPi = this.cell.getPortInst(d.tailNodeId, d.tailPortId);
            if (ai != null && ai.getHeadPortInst() == headPi && ai.getTailPortInst() == tailPi) {
                ai.setDInUndo(d);
            } else {
                ai = new ArcInst(this, d, headPi, tailPi);
                this.chronArcs.set(d.arcId, ai);
            }
            ai.setArcIndex(i);
            this.arcs.add(ai);
            if (ai.isUsernamed()) continue;
            Name name = ai.getNameKey();
            assert (name.getBasename() == ImmutableArcInst.BASENAME);
            this.maxArcSuffix = Math.max(this.maxArcSuffix, name.getNumSuffix());
        }
        int arcCount = 0;
        for (int i = 0; i < this.chronArcs.size(); ++i) {
            ai = this.chronArcs.get(i);
            if (ai == null) continue;
            int arcIndex = ai.getArcIndex();
            if (arcIndex >= this.arcs.size() || ai != this.arcs.get(arcIndex)) {
                ai.setArcIndex(-1);
                this.chronArcs.set(i, null);
                continue;
            }
            ++arcCount;
        }
        assert (arcCount == this.arcs.size());
    }

    public void computeArcBounds() {
        if (!this.cell.getDatabase().canComputeBounds()) {
            return;
        }
        int[] intCoords = new int[4];
        BoundsBuilder b = new BoundsBuilder(this.cell);
        for (int arcIndex = 0; arcIndex < this.arcs.size(); ++arcIndex) {
            ArcInst ai = this.arcs.get(arcIndex);
            ai.computeBounds(b, intCoords);
        }
        this.validArcBounds = true;
    }

    private int searchArc(String name, int arcId) {
        int high;
        int low = 0;
        int pick = high = this.arcs.size() - 1;
        while (low <= high) {
            ArcInst ai = this.arcs.get(pick);
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(ai.getName(), name);
            if (cmp == 0) {
                cmp = ai.getD().arcId - arcId;
            }
            if (cmp < 0) {
                low = pick + 1;
            } else if (cmp > 0) {
                high = pick - 1;
            } else {
                return pick;
            }
            pick = low + high >> 1;
        }
        return -(low + 1);
    }

    public Iterator<RTBounds> searchIterator(Rectangle2D bounds, boolean includeEdges) {
        return new RTNode.Search(bounds, this.getRTree(), includeEdges);
    }

    public void unfreshRTree() {
        this.rTreeFresh = false;
    }

    public RTNode getRTree() {
        if (this.rTreeFresh) {
            return this.rTree;
        }
        EDatabase database = this.cell.getDatabase();
        if (database.canComputeBounds()) {
            this.rebuildRTree();
            this.rTreeFresh = true;
        }
        return this.rTree;
    }

    public void rebuildRTree() {
        if (!this.validArcBounds) {
            this.computeArcBounds();
        }
        CellId cellId = this.cell.getId();
        RTNode root = RTNode.makeTopLevel();
        Iterator<Geometric> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            root = RTNode.linkGeom(cellId, root, ni);
        }
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            root = RTNode.linkGeom(cellId, root, ai);
        }
        root.checkRTree(0, cellId);
        this.rTree = root;
        this.rTreeFresh = true;
    }

    public void check() {
        ArcInst ai;
        ArcInst prevAi = null;
        Poly.Builder polyBuilder = Poly.newGridBuilder();
        for (int arcIndex = 0; arcIndex < this.arcs.size(); ++arcIndex) {
            ai = this.arcs.get(arcIndex);
            ImmutableArcInst a = ai.getD();
            assert (ai.getParent() == this.cell);
            assert (ai.getArcIndex() == arcIndex);
            assert (this.chronArcs.get(a.arcId) == ai);
            if (prevAi != null) {
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(prevAi.getName(), ai.getName());
                assert (cmp <= 0);
                if (cmp == 0) assert (prevAi.getD().arcId < a.arcId);
            }
            assert (ai.getHeadPortInst() == this.cell.getPortInst(a.headNodeId, a.headPortId));
            assert (ai.getTailPortInst() == this.cell.getPortInst(a.tailNodeId, a.tailPortId));
            ai.check(polyBuilder);
            prevAi = ai;
        }
        for (int arcId = 0; arcId < this.chronArcs.size(); ++arcId) {
            ai = this.chronArcs.get(arcId);
            if (ai == null) continue;
            assert (ai.getD().arcId == arcId);
            assert (ai == this.arcs.get(ai.getArcIndex()));
        }
        if (this.rTreeFresh) {
            this.rTree.checkRTree(0, this.cell.getId());
        }
    }
}

