/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.projectSettings.ProjSettingsNode;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Foundry {
    private final Technology tech;
    private final Type type;
    private final URL fileURL;
    private List<DRCTemplate> rules;
    private boolean rulesLoaded;
    private Setting[] gdsLayerSettings;

    Foundry(Technology tech, Type mode, URL fileURL, String[] gdsLayers) {
        this.tech = tech;
        this.type = mode;
        this.fileURL = fileURL;
        if (fileURL == null) {
            this.rulesLoaded = true;
        }
        this.setFactoryGDSLayers(gdsLayers);
    }

    Foundry(Technology tech, Type mode, List<DRCTemplate> rules, String[] gdsLayers) {
        this.tech = tech;
        this.type = mode;
        this.fileURL = null;
        this.rules = rules;
        this.rulesLoaded = true;
        this.setFactoryGDSLayers(gdsLayers);
    }

    public Type getType() {
        return this.type;
    }

    public List<DRCTemplate> getRules() {
        if (!this.rulesLoaded) {
            this.parseRules();
        }
        return this.rules;
    }

    private void parseRules() {
        this.rulesLoaded = true;
        if (this.fileURL == null) {
            System.out.println("Problems loading " + this + " deck for " + this.tech);
            return;
        }
        DRCTemplate.DRCXMLParser parser = DRCTemplate.importDRCDeck(this.fileURL, false);
        assert (parser.getRules().size() == 1);
        assert (parser.isParseOK());
        this.setRules(parser.getRules().get((int)0).drcRules);
    }

    public void setRules(List<DRCTemplate> list) {
        this.rules = list;
    }

    public String toString() {
        return this.type.name();
    }

    public Map<Layer, String> getGDSLayers() {
        LinkedHashMap<Layer, String> gdsLayers = new LinkedHashMap<Layer, String>();
        assert (this.gdsLayerSettings.length == this.tech.getNumLayers());
        for (int layerIndex = 0; layerIndex < this.gdsLayerSettings.length; ++layerIndex) {
            String gdsLayer = this.gdsLayerSettings[layerIndex].getString();
            if (gdsLayer.length() <= 0) continue;
            gdsLayers.put(this.tech.getLayer(layerIndex), gdsLayer);
        }
        return gdsLayers;
    }

    public Setting getGDSLayerSetting(Layer layer) {
        if (layer.getTechnology() != this.tech) {
            throw new IllegalArgumentException();
        }
        return this.gdsLayerSettings[layer.getIndex()];
    }

    private void setFactoryGDSLayers(String[] gdsLayers) {
        LinkedHashMap<Layer, String> gdsMap = new LinkedHashMap<Layer, String>();
        for (String gdsDef : gdsLayers) {
            int space;
            Layer layer = this.tech.findLayer(gdsDef.substring(0, space));
            for (space = gdsDef.indexOf(32); space < gdsDef.length() && gdsDef.charAt(space) == ' '; ++space) {
            }
            if (layer != null && !layer.isPseudoLayer() && gdsMap.put(layer, gdsDef.substring(space)) == null) continue;
            throw new IllegalArgumentException(gdsDef);
        }
        assert (this.gdsLayerSettings == null);
        this.gdsLayerSettings = new Setting[this.tech.getNumLayers()];
        String techName = this.tech.getTechName();
        String what = this.getGDSPrefName();
        for (int layerIndex = 0; layerIndex < this.gdsLayerSettings.length; ++layerIndex) {
            Setting setting;
            Layer layer = this.tech.getLayer(layerIndex);
            String factoryDefault = (String)gdsMap.get(layer);
            if (factoryDefault == null) {
                factoryDefault = "";
            }
            factoryDefault = factoryDefault.replaceAll(", ", ",");
            this.gdsLayerSettings[layerIndex] = setting = Setting.makeStringSetting(what + "LayerFor" + layer.getName() + "IN" + techName, Technology.getTechnologyPreferences(), this.getGDSNode(), layer.getName(), what + " tab", what + " for layer " + layer.getName() + " in technology " + techName, factoryDefault);
        }
    }

    private String getGDSPrefName() {
        return "GDS(" + this.type.name() + ")";
    }

    private ProjSettingsNode getGDSNode() {
        ProjSettingsNode node = this.tech.getProjectSettings().getNode("GDS");
        if (this.type == Type.TSMC) {
            return node.getNode("TSMC");
        }
        if (this.type == Type.MOSIS) {
            return node.getNode("MOSIS");
        }
        if (this.type == Type.ST) {
            return node.getNode("ST");
        }
        return node;
    }

    void finish() {
        if (this.gdsLayerSettings == null) {
            this.setFactoryGDSLayers(new String[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NONE(-1),
        TSMC(4096),
        ST(8192),
        MOSIS(16384);

        private final int mode;

        private Type(int mode) {
            this.mode = mode;
        }

        public int mode() {
            return this.mode;
        }

        public String toString() {
            return this.name();
        }
    }
}

