/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Stimuli;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Analysis<S extends Signal> {
    public static final AnalysisType ANALYSIS_SIGNALS = new AnalysisType("Signals");
    public static final AnalysisType ANALYSIS_TRANS = new AnalysisType("Transient");
    public static final AnalysisType ANALYSIS_AC = new AnalysisType("AC");
    public static final AnalysisType ANALYSIS_DC = new AnalysisType("DC");
    public static final AnalysisType ANALYSIS_MEAS = new AnalysisType("Measurement");
    private Stimuli sd;
    private AnalysisType type;
    private List<S> signals = new ArrayList<S>();
    private HashMap<String, S> signalNames = new HashMap();
    private Rectangle2D bounds;
    private double leftEdge;
    private double rightEdge;

    public Analysis(Stimuli sd, AnalysisType type) {
        this.sd = sd;
        this.type = type;
        sd.addAnalysis(this);
    }

    public void finished() {
        for (Signal s : this.signals) {
            s.finished();
        }
        this.signals.clear();
        this.signalNames.clear();
    }

    public Stimuli getStimuli() {
        return this.sd;
    }

    public AnalysisType getAnalysisType() {
        return this.type;
    }

    public List<S> getSignals() {
        return this.signals;
    }

    public void nameSignal(S ws, String sigName) {
        String name = TextUtils.canonicString(sigName);
        this.signalNames.put(name, ws);
        if (name.indexOf(95) >= 0 && !name.endsWith("_")) {
            this.signalNames.put(name + "_", ws);
        }
    }

    public void addSignal(S ws) {
        this.signals.add(ws);
        String sigName = ((Signal)ws).getFullName();
        if (sigName != null) {
            this.nameSignal(ws, sigName);
        }
        this.setBoundsDirty();
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = null;
            for (Signal sig : this.signals) {
                Rectangle2D sigBounds = sig.getBounds();
                if (this.bounds == null) {
                    this.bounds = new Rectangle2D.Double(sigBounds.getMinX(), sigBounds.getMinY(), sigBounds.getWidth(), sigBounds.getHeight());
                    this.leftEdge = sig.getLeftEdge();
                    this.rightEdge = sig.getRightEdge();
                    continue;
                }
                Rectangle2D.union(this.bounds, sigBounds, this.bounds);
                if (this.leftEdge < this.rightEdge) {
                    this.leftEdge = Math.min(this.leftEdge, sig.getLeftEdge());
                    this.rightEdge = Math.max(this.rightEdge, sig.getRightEdge());
                    continue;
                }
                this.leftEdge = Math.max(this.leftEdge, sig.getLeftEdge());
                this.rightEdge = Math.min(this.rightEdge, sig.getRightEdge());
            }
        }
        return this.bounds;
    }

    public double getLeftEdge() {
        this.getBounds();
        return this.leftEdge;
    }

    public double getRightEdge() {
        this.getBounds();
        return this.rightEdge;
    }

    public void setBoundsDirty() {
        this.bounds = null;
    }

    public abstract boolean isAnalog();

    public S findSignalForNetworkQuickly(String netName) {
        String lookupName = TextUtils.canonicString(netName);
        Signal sSig = (Signal)this.signalNames.get(lookupName);
        return (S)sSig;
    }

    public S findSignalForNetwork(String netName) {
        for (Signal sSig : this.getSignals()) {
            String signalName = sSig.getFullName();
            if (netName.equalsIgnoreCase(signalName)) {
                return (S)sSig;
            }
            if (signalName.length() + 1 == netName.length() && netName.charAt(signalName.length()) == ']') {
                signalName = signalName + "_";
            }
            if (signalName.length() != netName.length() || signalName.indexOf(95) < 0) continue;
            boolean matches = true;
            for (int i = 0; i < signalName.length(); ++i) {
                char sigChar = signalName.charAt(i);
                char netChar = netName.charAt(i);
                if (TextUtils.isLetterOrDigit(sigChar) != TextUtils.isLetterOrDigit(netChar)) {
                    matches = false;
                    break;
                }
                if (!TextUtils.isLetterOrDigit(sigChar) || TextUtils.canonicChar(sigChar) == TextUtils.canonicChar(netChar)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return (S)sSig;
        }
        return null;
    }

    public static class AnalysisType {
        private String name;
        private static List<AnalysisType> allTypes = new ArrayList<AnalysisType>();

        AnalysisType(String name) {
            this.name = name;
            allTypes.add(this);
        }

        public String toString() {
            return this.name;
        }

        public static AnalysisType findAnalysisType(String analysisName) {
            for (AnalysisType at : allTypes) {
                if (!at.name.equals(analysisName)) continue;
                return at;
            }
            return null;
        }
    }
}

