/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.EThread;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobManager;
import com.sun.electric.tool.StreamClient;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.JobTree;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerJobManager
extends JobManager
implements Observer,
Runnable {
    private static final String CLASS_NAME = Job.class.getName();
    private static final int DEFAULT_NUM_THREADS = 2;
    private final Condition databaseChangesMutex = this.newCondition();
    private final ServerSocket serverSocket;
    private final ArrayList<Client> serverConnections = new ArrayList();
    private int numThreads;
    private final int maxNumThreads;
    private boolean runningChangeJob;
    private boolean guiChanged;
    private boolean signalledEThread;
    private Snapshot currentSnapshot = EDatabase.serverDatabase().getInitialSnapshot();

    ServerJobManager(int recommendedNumThreads) {
        this.maxNumThreads = this.initThreads(recommendedNumThreads);
        this.serverSocket = null;
    }

    ServerJobManager(int recommendedNumThreads, int socketPort) {
        this.maxNumThreads = this.initThreads(recommendedNumThreads);
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(socketPort);
            System.out.println("ServerSocket waits for port " + socketPort);
        }
        catch (IOException e) {
            System.out.println("ServerSocket mode failure: " + e.getMessage());
        }
        this.serverSocket = serverSocket;
        if (User.isSbapshotLogging()) {
            this.initSnapshotLogging();
        }
    }

    private int initThreads(int recommendedNumThreads) {
        int maxNumThreads = 2;
        if (recommendedNumThreads > 0) {
            maxNumThreads = recommendedNumThreads;
        }
        Job.logger.logp(Level.FINE, CLASS_NAME, "initThreads", "maxNumThreads=" + maxNumThreads);
        return maxNumThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initSnapshotLogging() {
        StreamClient conn;
        int connectionId = this.serverConnections.size();
        this.lock();
        try {
            File tempFile = File.createTempFile("elec", ".slog");
            FileOutputStream out = new FileOutputStream(tempFile);
            System.out.println("Writing snapshot log to " + tempFile);
            ActivityLogger.logMessage("Writing snapshot log to " + tempFile);
            conn = new StreamClient(connectionId, null, new BufferedOutputStream(out), this.currentSnapshot);
            this.serverConnections.add(conn);
        }
        catch (IOException e) {
            System.out.println("Failed to create snapshot log file:" + e.getMessage());
            return;
        }
        finally {
            this.unlock();
        }
        System.out.println("Accepted connection " + connectionId);
        conn.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addJob(EJob ejob, boolean onMySnapshot) {
        this.lock();
        try {
            if (onMySnapshot) {
                this.waitingJobs.add(0, ejob);
            } else {
                this.waitingJobs.add(ejob);
            }
            this.setEJobState(ejob, EJob.State.WAITING, onMySnapshot ? "waiting now" : "waiting");
            this.invokeEThread();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void removeJob(Job j) {
        EJob ejob = j.ejob;
        this.lock();
        try {
            switch (j.ejob.state) {
                case WAITING: {
                    this.setEJobState(ejob, EJob.State.SERVER_DONE, null);
                }
                case SERVER_DONE: {
                    this.setEJobState(ejob, EJob.State.CLIENT_DONE, null);
                }
                case CLIENT_DONE: {
                    if (!Job.BATCHMODE && !this.guiChanged) {
                        SwingUtilities.invokeLater(this);
                    }
                    this.guiChanged = true;
                    return;
                }
            }
            return;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setProgress(EJob ejob, String progress) {
        this.lock();
        try {
            if (ejob.state == EJob.State.RUNNING) {
                this.setEJobState(ejob, EJob.State.RUNNING, progress);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Iterator<Job> getAllJobs() {
        this.lock();
        try {
            Job job;
            ArrayList<Job> jobsList = new ArrayList<Job>();
            for (EJob ejob : this.startedJobs) {
                job = ejob.getJob();
                if (job == null) continue;
                jobsList.add(job);
            }
            for (EJob ejob : this.waitingJobs) {
                job = ejob.getJob();
                if (job == null) continue;
                jobsList.add(job);
            }
            Iterator<Job> iterator = jobsList.iterator();
            return iterator;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof EThread) {
            ((EThread)currentThread).print((String)arg);
        }
    }

    private void invokeEThread() {
        if (this.signalledEThread || this.startedJobs.size() >= this.maxNumThreads) {
            return;
        }
        if (!this.canDoIt()) {
            return;
        }
        if (this.startedJobs.size() < this.numThreads) {
            this.databaseChangesMutex.signal();
        } else {
            int n = this.numThreads++;
            new EThread(n);
        }
        this.signalledEThread = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void wantUpdateGui() {
        this.lock();
        try {
            this.guiChanged = true;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean guiChanged() {
        this.lock();
        try {
            boolean b = this.guiChanged;
            this.guiChanged = false;
            boolean bl = b;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    private boolean canDoIt() {
        if (this.waitingJobs.isEmpty()) {
            return false;
        }
        EJob ejob = (EJob)this.waitingJobs.get(0);
        return this.startedJobs.isEmpty() || !this.runningChangeJob && ejob.isExamine();
    }

    private void setEJobState(EJob ejob, EJob.State newState, String info) {
        Job.logger.logp(Level.FINE, CLASS_NAME, "setEjobState", (Object)((Object)newState) + " " + ejob.jobName);
        EJob.State oldState = ejob.state;
        switch (newState) {
            case WAITING: {
                break;
            }
            case RUNNING: {
                if (oldState != EJob.State.RUNNING) break;
                assert (oldState == EJob.State.RUNNING);
                ejob.progress = info;
                if (!info.equals("aborting")) break;
                ejob.serverJob.scheduledToAbort = true;
                break;
            }
            case SERVER_DONE: {
                boolean removed;
                this.currentSnapshot = ejob.newSnapshot;
                if (oldState == EJob.State.WAITING) {
                    removed = this.waitingJobs.remove(ejob);
                } else {
                    assert (oldState == EJob.State.RUNNING);
                    removed = this.startedJobs.remove(ejob);
                    if (this.startedJobs.isEmpty()) {
                        this.runningChangeJob = false;
                    }
                }
                assert (removed);
                break;
            }
            case CLIENT_DONE: {
                assert (oldState == EJob.State.SERVER_DONE);
                break;
            }
        }
        ejob.state = newState;
        Client.fireEJobEvent(ejob);
        if (!Job.BATCHMODE && !this.guiChanged) {
            SwingUtilities.invokeLater(this);
        }
        this.guiChanged = true;
        Job.logger.exiting(CLASS_NAME, "setJobState");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isChangeJobQueuedOrRunning() {
        this.lock();
        try {
            for (EJob ejob : this.startedJobs) {
                Job job = ejob.getJob();
                if (job != null && job.finished) continue;
                if (ejob.jobType != Job.Type.CHANGE) continue;
                boolean bl = true;
                return bl;
            }
            for (EJob ejob : this.waitingJobs) {
                if (ejob.jobType != Job.Type.CHANGE) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runLoop() {
        if (this.serverSocket == null) {
            return;
        }
        MessagesStream.getMessagesStream().addObserver(this);
        try {
            while (true) {
                StreamClient conn;
                Socket socket = this.serverSocket.accept();
                int connectionId = this.serverConnections.size();
                this.lock();
                try {
                    conn = new StreamClient(connectionId, socket.getInputStream(), socket.getOutputStream(), this.currentSnapshot);
                    this.serverConnections.add(conn);
                }
                finally {
                    this.unlock();
                }
                System.out.println("Accepted connection " + connectionId);
                conn.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return;
        }
    }

    @Override
    public void run() {
        assert (!Job.BATCHMODE);
        Job.logger.logp(Level.FINE, CLASS_NAME, "run", "ENTER");
        while (this.guiChanged()) {
            ArrayList<Job> jobs = new ArrayList<Job>();
            Iterator<Job> it = Job.getAllJobs();
            while (it.hasNext()) {
                Job j = it.next();
                if (!j.getDisplay()) continue;
                jobs.add(j);
            }
            JobTree.update(jobs);
            TopLevel.setBusyCursor(this.isChangeJobQueuedOrRunning());
            Job.logger.logp(Level.FINE, CLASS_NAME, "run", "wantToRedoJobTree");
        }
        Job.logger.logp(Level.FINE, CLASS_NAME, "run", "EXIT");
    }

    public static void setUndoRedoStatus(boolean undoEnabled, boolean redoEnabled) {
        assert (Job.jobManager instanceof ServerJobManager);
        Job.currentUI.showUndoRedoStatus(undoEnabled, redoEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EJob selectEJob(EJob finishedEJob) {
        EJob selectedEJob = null;
        this.lock();
        try {
            if (finishedEJob != null) {
                this.setEJobState(finishedEJob, EJob.State.SERVER_DONE, "done");
            }
            while (true) {
                this.signalledEThread = false;
                if (this.canDoIt()) {
                    EJob ejob = (EJob)this.waitingJobs.remove(0);
                    this.startedJobs.add(ejob);
                    if (ejob.isExamine()) {
                        assert (!this.runningChangeJob);
                        this.invokeEThread();
                    } else {
                        assert (this.startedJobs.size() == 1);
                        assert (!this.runningChangeJob);
                        this.runningChangeJob = true;
                    }
                    this.setEJobState(ejob, EJob.State.RUNNING, "running");
                    selectedEJob = ejob;
                    break;
                }
                if (Job.threadMode == Job.Mode.BATCH && this.startedJobs.isEmpty()) {
                    ActivityLogger.finished();
                    System.exit(1);
                }
                Job.logger.logp(Level.FINE, CLASS_NAME, "selectConnection", "pause");
                this.databaseChangesMutex.awaitUninterruptibly();
                Job.logger.logp(Level.FINE, CLASS_NAME, "selectConnection", "resume");
            }
        }
        finally {
            this.unlock();
        }
        return selectedEJob;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UserInterfaceRedirect
    implements UserInterface {
        UserInterfaceRedirect() {
        }

        private static void printStackTrace(String methodName) {
        }

        @Override
        public void startProgressDialog(String msg, String filePath) {
            Job.currentUI.startProgressDialog(msg, filePath);
        }

        @Override
        public void stopProgressDialog() {
            Job.currentUI.stopProgressDialog();
        }

        @Override
        public void setProgressValue(long pct) {
            Job.currentUI.setProgressValue(pct);
        }

        @Override
        public void setProgressNote(String message) {
            Job.currentUI.setProgressNote(message);
        }

        @Override
        public String getProgressNote() {
            return Job.currentUI.getProgressNote();
        }

        @Override
        public EditWindow_ getCurrentEditWindow_() {
            UserInterfaceRedirect.printStackTrace("getCurrentEditWindow");
            return Job.currentUI.getCurrentEditWindow_();
        }

        @Override
        public EditWindow_ needCurrentEditWindow_() {
            UserInterfaceRedirect.printStackTrace("needCurrentEditWindow");
            return null;
        }

        @Override
        public Cell getCurrentCell() {
            UserInterfaceRedirect.printStackTrace("getCurrentCell");
            Library lib = Library.getCurrent();
            if (lib == null) {
                return null;
            }
            return lib.getCurCell();
        }

        @Override
        public Cell getCurrentCell(Library lib) {
            UserInterfaceRedirect.printStackTrace("getCurrentCell(lib)");
            return Job.currentUI.getCurrentCell(lib);
        }

        @Override
        public Cell needCurrentCell() {
            UserInterfaceRedirect.printStackTrace("needCurrentCell");
            Cell curCell = this.getCurrentCell();
            if (curCell == null) {
                System.out.println("There is no current cell for this operation.  To create one, use the 'New Cell' command from the 'Cell' menu.");
            }
            return curCell;
        }

        @Override
        public void setCurrentCell(Library lib, Cell curCell) {
            UserInterfaceRedirect.printStackTrace("setCurrentCell");
            Job.currentUI.setCurrentCell(lib, curCell);
        }

        @Override
        public void repaintAllEditWindows() {
            UserInterfaceRedirect.printStackTrace("repaintAllEditWindows");
            Job.currentUI.repaintAllEditWindows();
        }

        @Override
        public void loadComponentMenuForTechnology() {
            UserInterfaceRedirect.printStackTrace("loadComponentMenuForTechnology");
            Job.currentUI.loadComponentMenuForTechnology();
        }

        @Override
        public void adjustReferencePoint(Cell cell, double cX, double cY) {
        }

        @Override
        public void alignToGrid(Point2D pt) {
            UserInterfaceRedirect.printStackTrace("alignToGrid");
        }

        @Override
        public double getGridAlignment() {
            return 1.0;
        }

        @Override
        public int getDefaultTextSize() {
            return 14;
        }

        @Override
        public EditWindow_ displayCell(Cell cell) {
            throw new IllegalStateException();
        }

        @Override
        public void termLogging(ErrorLogger logger, boolean explain, boolean terminate) {
            Job.currentUI.termLogging(logger, explain, terminate);
        }

        public void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
            throw new IllegalStateException();
        }

        public void updateIncrementalDRCErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
            throw new IllegalStateException();
        }

        @Override
        public String reportLog(ErrorLogger.MessageLog log, boolean showhigh, Geometric[] gPair) {
            UserInterfaceRedirect.printStackTrace("reportLog");
            return log.getMessageString();
        }

        @Override
        public void showErrorMessage(Object message, String title) {
            Job.currentUI.showErrorMessage(message, title);
        }

        @Override
        public void showInformationMessage(Object message, String title) {
            Job.currentUI.showInformationMessage(message, title);
        }

        @Override
        public boolean confirmMessage(Object message) {
            UserInterfaceRedirect.printStackTrace("confirmMessage");
            return true;
        }

        @Override
        public int askForChoice(String message, String title, String[] choices, String defaultChoice) {
            throw new IllegalStateException(message);
        }

        @Override
        public String askForInput(Object message, String title, String def) {
            throw new IllegalStateException();
        }

        public void restoreSavedBindings(boolean initialCall) {
            UserInterfaceRedirect.printStackTrace("restoreSavedBindings");
        }

        @Override
        public void importPrefs() {
            UserInterfaceRedirect.printStackTrace("importPrefs");
        }

        @Override
        public void exportPrefs() {
            UserInterfaceRedirect.printStackTrace("exportPrefs");
        }

        public int saveHighlights() {
            return -1;
        }

        public void restoreHighlights(int highlightsId) {
        }

        public void showUndoRedoStatus(boolean newUndoEnabled, boolean newRedoEnabled) {
        }
    }
}

