/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.GetInfoText;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuBar;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.MeasureListener;
import com.sun.electric.tool.user.ui.OutlineListener;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBar
extends JToolBar {
    private static ImageIcon unknownIcon = Resources.getResource(ToolBar.class, "ButtonUnknown.gif");
    private static Pref toolbarOrderPref = Pref.makeStringPref("ToolbarOrder", User.getUserTool().prefs, "");
    private static Pref toolbarFilesPref = Pref.makeStringPref("ToolbarIconFiles", User.getUserTool().prefs, "");
    private static EToolBarButton[] currentToolbarButtons;
    private static List<EToolBarButton> allButtons;
    private static Map<String, String> commandToIconMap;
    public static final EToolBarButton openLibraryCommand;
    public static final EToolBarButton saveLibraryCommand;
    private static CursorMode curMode;
    static final Cursor zoomCursor;
    static final Cursor zoomOutCursor;
    static final Cursor panCursor;
    static final Cursor wiringCursor;
    static final Cursor outlineCursor;
    static final Cursor measureCursor;
    private static EventListener lastListener;
    private static final CursorModeButton clickZoomWireCommand;
    private static final CursorModeButton panCommand;
    private static final CursorModeButton zoomCommand;
    private static final CursorModeButton outlineCommand;
    private static final CursorModeButton measureCommand;
    private static EMenuItem gridDistance1Command;
    private static EMenuItem gridDistance2Command;
    private static EMenuItem gridDistance3Command;
    private static EMenuItem gridDistance4Command;
    private static EMenuItem gridDistance5Command;
    private JButton currentGridAmount = new JButton();
    private boolean currentGridAmountInited = false;
    private static final EToolBarButton gridLarger;
    private static final EToolBarButton gridSmaller;
    private static SelectMode curSelectMode;
    private static final SelectModeButton selectObjectsCommand;
    private static final SelectModeButton selectAreaCommand;
    private static boolean selectSpecial;
    private static final ImageIcon selectSpecialIconOn;
    private static final ImageIcon selectSpecialIconOff;
    private static EToolBarButton toggleSelectSpecialCommand;
    public static final EMenu modesSubMenu;
    public static final EToolBarButton preferencesCommand;
    public static final EToolBarButton expandOneLevelCommand;
    public static final EToolBarButton unexpandOneLevelCommand;
    public static final EToolBarButton undoCommand;
    public static final EToolBarButton redoCommand;
    private static final EToolBarButton goBackButtonStatic;
    private static final EToolBarButton goForwardButtonStatic;
    private CellHistoryButton goBackButton = new CellHistoryButton("Go Back a Cell", "ButtonGoBack", "Cell:Cell Viewing History"){

        public void run() {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null) {
                wf.cellHistoryGoBack();
            }
        }
    };
    private CellHistoryButton goForwardButton = new CellHistoryButton("Go Forward a Cell", "ButtonGoForward", "Cell:Cell Viewing History"){

        public void run() {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null) {
                wf.cellHistoryGoForward();
            }
        }
    };

    public static ToolBar createToolBar() {
        return new ToolBar();
    }

    private ToolBar() {
        this.setFloatable(true);
        this.setRollover(true);
        this.redoToolbar();
        this.setFocusable(false);
    }

    public static EToolBarButton[] getFactoryButtons() {
        EToolBarButton[] buttons = new EToolBarButton[]{openLibraryCommand, saveLibraryCommand, null, clickZoomWireCommand, panCommand, zoomCommand, outlineCommand, measureCommand, null, gridLarger, gridSmaller, null, selectObjectsCommand, selectAreaCommand, null, toggleSelectSpecialCommand, null, preferencesCommand, null, undoCommand, redoCommand, null, goBackButtonStatic, goForwardButtonStatic, null, expandOneLevelCommand, unexpandOneLevelCommand};
        return buttons;
    }

    public static List<EToolBarButton> getAllButtons() {
        if (allButtons.size() == 0) {
            allButtons.add(openLibraryCommand);
            allButtons.add(saveLibraryCommand);
            allButtons.add(clickZoomWireCommand);
            allButtons.add(panCommand);
            allButtons.add(zoomCommand);
            allButtons.add(outlineCommand);
            allButtons.add(measureCommand);
            allButtons.add(gridLarger);
            allButtons.add(gridSmaller);
            allButtons.add(selectObjectsCommand);
            allButtons.add(selectAreaCommand);
            allButtons.add(toggleSelectSpecialCommand);
            allButtons.add(preferencesCommand);
            allButtons.add(undoCommand);
            allButtons.add(redoCommand);
            allButtons.add(goBackButtonStatic);
            allButtons.add(goForwardButtonStatic);
            allButtons.add(expandOneLevelCommand);
            allButtons.add(unexpandOneLevelCommand);
        }
        return allButtons;
    }

    public static EToolBarButton[] getToolbarButtons() {
        if (currentToolbarButtons == null) {
            currentToolbarButtons = ToolBar.getDefaultToolbarButtons();
        }
        return currentToolbarButtons;
    }

    public static ImageIcon getUnknownIcon() {
        return unknownIcon;
    }

    public static void setToolbarButtons(EToolBarButton[] buttons) {
        currentToolbarButtons = buttons;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buttons.length; ++i) {
            if (i > 0) {
                sb.append('|');
            }
            if (buttons[i] == null) continue;
            if (buttons[i].fullPathToIcon != null) {
                String commandName = buttons[i].menuName + ":" + buttons[i].getText();
                sb.append("U=");
                sb.append(commandName);
                sb.append("=U=");
                sb.append(buttons[i].fullPathToIcon);
                continue;
            }
            if (buttons[i].iconName.equals("ButtonUnknown")) {
                sb.append("U=");
                sb.append(buttons[i].menuName + ":" + buttons[i].getText());
                continue;
            }
            sb.append("B=");
            sb.append(buttons[i].iconName);
        }
        toolbarOrderPref.setString(sb.toString());
        if (TopLevel.isMDIMode()) {
            ToolBar tb = TopLevel.getCurrentJFrame().getToolBar();
            tb.redoToolbar();
        } else {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                ToolBar tb = wf.getFrame().getToolBar();
                tb.redoToolbar();
            }
        }
    }

    public static ImageIcon getProperSizeIcon(String fileName) {
        String errorMessage = null;
        try {
            File f = new File(fileName);
            if (f.exists()) {
                BufferedImage img = ImageIO.read(f);
                ImageIcon icon = new ImageIcon(img);
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                int width = iconWidth;
                int height = iconHeight;
                if (height > 16) {
                    double ratio = 16.0 / (double)height;
                    width = (int)((double)width * ratio);
                    height = (int)((double)height * ratio);
                    int iconWid = Math.max(width, 16);
                    BufferedImage originalImage = new BufferedImage(iconWid, 16, 2);
                    Graphics g = originalImage.getGraphics();
                    int dx = (iconWid - width) / 2;
                    int dy = (16 - height) / 2;
                    g.drawImage(icon.getImage(), dx, dy, dx + width, dy + height, 0, 0, iconWidth, iconHeight, null);
                    icon = new ImageIcon(originalImage);
                }
                return icon;
            }
            errorMessage = "Missing file";
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        catch (OutOfMemoryError e) {
            errorMessage = "Out of Memory";
        }
        System.out.println("Unable to read icon file: " + fileName + " (" + errorMessage + ")");
        return null;
    }

    public static Map<String, String> getCommandToIconMap() {
        if (commandToIconMap == null) {
            commandToIconMap = new HashMap<String, String>();
            String fileMap = toolbarFilesPref.getString();
            String[] entries = fileMap.split("\t");
            for (int i = 0; i < entries.length; ++i) {
                int barPos = entries[i].indexOf(124);
                if (barPos < 0) continue;
                String commandName = entries[i].substring(0, barPos);
                String fileName = entries[i].substring(barPos + 1);
                commandToIconMap.put(commandName, fileName);
            }
        }
        return commandToIconMap;
    }

    public static void setCommandToIconMap(Map<String, String> newMap) {
        commandToIconMap = newMap;
        StringBuffer sb = new StringBuffer();
        for (String commandName : commandToIconMap.keySet()) {
            String fileName = commandToIconMap.get(commandName);
            if (sb.length() > 0) {
                sb.append('\t');
            }
            sb.append(commandName);
            sb.append('|');
            sb.append(fileName);
        }
        toolbarFilesPref.setString(sb.toString());
    }

    private static EToolBarButton[] getDefaultToolbarButtons() {
        String prefOrder = toolbarOrderPref.getString();
        boolean buttonError = false;
        if (prefOrder.length() > 0) {
            List<EToolBarButton> knownButtons = ToolBar.getAllButtons();
            EMenuBar.Instance bar = MenuCommands.menuBar().genInstance(null);
            String[] entries = prefOrder.split("\\|");
            EToolBarButton[] buttons = new EToolBarButton[entries.length];
            for (int i = 0; i < entries.length; ++i) {
                EMenuItem menu;
                String entry = entries[i];
                if (entry.length() == 0) continue;
                if (entry.startsWith("B=")) {
                    String buttonName = entry.substring(2);
                    for (EToolBarButton known : knownButtons) {
                        if (!known.iconName.equals(buttonName)) continue;
                        buttons[i] = known;
                        break;
                    }
                    if (buttons[i] != null) continue;
                    System.out.println("WARNING: saved tool bar button '" + buttonName + "' is unknown");
                    buttonError = true;
                    continue;
                }
                if (!entry.startsWith("U=")) continue;
                String fullCommandName = entry.substring(2);
                String iconFile = null;
                int endPath = entry.indexOf("=U=");
                if (endPath >= 0) {
                    fullCommandName = entry.substring(2, endPath);
                    iconFile = entry.substring(endPath + 3);
                }
                ImageIcon icon = unknownIcon;
                if (iconFile != null) {
                    icon = ToolBar.getProperSizeIcon(iconFile);
                }
                if (icon == null) continue;
                int lastColon = fullCommandName.lastIndexOf(58);
                String menuName = lastColon < 0 ? "" : fullCommandName.substring(0, lastColon);
                String commandName = fullCommandName.substring(lastColon + 1);
                EMenuItem mi = null;
                Iterator<EMenuItem> i$ = bar.getMenuBarGroup().getItems().iterator();
                while (i$.hasNext() && (mi = ToolBar.findMenuItem((EMenu)(menu = i$.next()), menu.getText(), fullCommandName)) == null) {
                }
                if (mi == null) continue;
                buttons[i] = ToolBar.makeButtonFromMenuItem(mi, commandName, menuName);
                if (iconFile != null) {
                    buttons[i].setIcon(icon, iconFile);
                }
                boolean alreadyKnown = false;
                for (EToolBarButton known : allButtons) {
                    if (known.iconName == null || !known.iconName.equals(fullCommandName)) continue;
                    alreadyKnown = true;
                    break;
                }
                if (alreadyKnown) continue;
                allButtons.add(buttons[i]);
            }
            if (!buttonError) {
                return buttons;
            }
            toolbarOrderPref.setString("");
            System.out.println("WARNING: saved toolbar configuration has errors...using factory settings");
        }
        return ToolBar.getFactoryButtons();
    }

    private static EToolBarButton makeButtonFromMenuItem(EMenuItem mi, String command, String menu) {
        final EMenuItem item = mi;
        EToolBarButton but = new EToolBarButton(command, null, null, menu){

            public void run() {
                item.run();
            }
        };
        return but;
    }

    private void redoToolbar() {
        this.removeAll();
        EToolBarButton[] buttons = ToolBar.getToolbarButtons();
        boolean placedGridDistance = false;
        for (int i = 0; i < buttons.length; ++i) {
            EToolBarButton b = buttons[i];
            if (b == null) {
                this.addSeparator();
                continue;
            }
            if (b == goBackButtonStatic) {
                b = this.goBackButton;
            }
            if (b == goForwardButtonStatic) {
                b = this.goForwardButton;
            }
            AbstractButton j = b.genToolBarButton();
            this.add(j);
            j.setFocusable(false);
            if (placedGridDistance || b != gridSmaller && b != gridLarger) continue;
            placedGridDistance = true;
            ToolBar.rewriteGridDistance();
            if (!this.currentGridAmountInited) {
                this.currentGridAmountInited = true;
                this.currentGridAmount.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        ToolBar.this.chooseGridAmount();
                    }
                });
            }
            this.add(this.currentGridAmount);
        }
        this.updateUI();
    }

    private void chooseGridAmount() {
        JPopupMenu gridMenu = new JPopupMenu("Grid Spacing");
        JMenuItem menuItem = new JMenuItem("Grid Alignment 1 (largest)");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.changeGridSize(0);
            }
        });
        gridMenu.add(menuItem);
        menuItem = new JMenuItem("Grid Alignment 2");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.changeGridSize(1);
            }
        });
        gridMenu.add(menuItem);
        menuItem = new JMenuItem("Grid Alignment 3");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.changeGridSize(2);
            }
        });
        gridMenu.add(menuItem);
        menuItem = new JMenuItem("Grid Alignment 4");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.changeGridSize(3);
            }
        });
        gridMenu.add(menuItem);
        menuItem = new JMenuItem("Grid Alignment 5 (smallest)");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.changeGridSize(4);
            }
        });
        gridMenu.add(menuItem);
        gridMenu.addSeparator();
        menuItem = new JMenuItem("Grid Preferences...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesFrame.preferencesCommand("Grid", "Display");
            }
        });
        gridMenu.add(menuItem);
        Point pt = this.currentGridAmount.getLocation();
        gridMenu.show(this, pt.x, pt.y);
    }

    private static void rewriteGridDistance() {
        Dimension2D val = User.getAlignmentToGrid();
        String valStr = " " + val.getWidth();
        if (val.getWidth() != val.getHeight()) {
            valStr = valStr + "/" + val.getHeight();
        }
        valStr = valStr + " ";
        if (TopLevel.isMDIMode()) {
            TopLevel tl = TopLevel.getCurrentJFrame();
            if (tl != null) {
                ToolBar tb = tl.getToolBar();
                tb.currentGridAmount.setText(valStr);
            }
        } else {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                ToolBar tb = wf.getFrame().getToolBar();
                tb.currentGridAmount.setText(valStr);
            }
        }
    }

    private static EMenuItem findMenuItem(EMenu menu, String menuName, String command) {
        for (EMenuItem menuItem : menu.getItems()) {
            String menuItemName = menuName + ":" + menuItem.getText();
            if (menuItem instanceof EMenu) {
                EMenuItem found = ToolBar.findMenuItem((EMenu)menuItem, menuItemName, command);
                if (found == null) continue;
                return found;
            }
            if (!menuItemName.equals(command)) continue;
            return menuItem;
        }
        return null;
    }

    public static void setSaveLibraryButton() {
        ToolBar.updateToolBarButtons();
    }

    public static Cursor readCursor(String cursorName, int hotX, int hotY) {
        ImageIcon imageIcon = Resources.getResource(ToolBar.class, cursorName);
        Image image = imageIcon.getImage();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Dimension bestSize = Toolkit.getDefaultToolkit().getBestCursorSize(width, height);
        int bestWidth = (int)bestSize.getWidth();
        int bestHeight = (int)bestSize.getHeight();
        if (bestWidth != 0 && bestHeight != 0 && (bestWidth != width || bestHeight != height)) {
            if (bestWidth > width && bestHeight > height) {
                BufferedImage newImage = new BufferedImage(bestWidth, bestHeight, 2);
                Graphics g = ((Image)newImage).getGraphics();
                g.drawImage(image, (bestWidth - width) / 2, (bestHeight - height) / 2, null);
                image = newImage;
                hotX += (bestWidth - width) / 2;
                hotY += (bestHeight - height) / 2;
            } else {
                image = image.getScaledInstance(bestWidth, bestHeight, 0);
                hotX = hotX * bestWidth / width;
                hotY = hotY * bestHeight / height;
            }
        }
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(hotX, hotY), cursorName);
        return cursor;
    }

    public static CursorMode getCursorMode() {
        return curMode;
    }

    private static void setCursorMode(CursorMode cm) {
        switch (cm) {
            case CLICKZOOMWIRE: {
                ToolBar.checkLeavingOutlineMode();
                WindowFrame.setListener(ClickZoomWireListener.theOne);
                TopLevel.setCurrentCursor(Cursor.getPredefinedCursor(0));
                curMode = CursorMode.CLICKZOOMWIRE;
                lastListener = null;
                break;
            }
            case PAN: {
                if (WindowFrame.getListener() == ZoomAndPanListener.theOne && curMode == CursorMode.PAN) {
                    if (lastListener != null && lastListener != ClickZoomWireListener.theOne && lastListener != OutlineListener.theOne && lastListener != MeasureListener.theOne) {
                        WindowFrame.setListener(lastListener);
                        curMode = CursorMode.CLICKZOOMWIRE;
                        lastListener = null;
                        TopLevel.setCurrentCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    return;
                }
                lastListener = WindowFrame.getListener();
                WindowFrame.setListener(ZoomAndPanListener.theOne);
                TopLevel.setCurrentCursor(panCursor);
                curMode = CursorMode.PAN;
                break;
            }
            case ZOOM: {
                if (WindowFrame.getListener() == ZoomAndPanListener.theOne && curMode == CursorMode.ZOOM) {
                    if (lastListener != null && lastListener != ClickZoomWireListener.theOne && lastListener != OutlineListener.theOne && lastListener != MeasureListener.theOne) {
                        WindowFrame.setListener(lastListener);
                        curMode = CursorMode.CLICKZOOMWIRE;
                        lastListener = null;
                        TopLevel.setCurrentCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    return;
                }
                lastListener = WindowFrame.getListener();
                ToolBar.checkLeavingOutlineMode();
                WindowFrame.setListener(ZoomAndPanListener.theOne);
                TopLevel.setCurrentCursor(zoomCursor);
                curMode = CursorMode.ZOOM;
                break;
            }
            case OUTLINE: {
                lastListener = null;
                if (WindowFrame.getListener() == OutlineListener.theOne) {
                    ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    return;
                }
                EditWindow wnd = EditWindow.needCurrent();
                if (wnd == null) {
                    return;
                }
                Highlighter highlighter = wnd.getHighlighter();
                CursorMode oldMode = curMode;
                NodeInst ni = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
                if (ni == null) {
                    if (oldMode == CursorMode.OUTLINE) {
                        ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    } else {
                        ToolBar.setCursorMode(oldMode);
                    }
                    return;
                }
                NodeProto np = ni.getProto();
                if (ni.isCellInstance() || !((PrimitiveNode)np).isHoldsOutline()) {
                    System.out.println("Sorry, " + np + " does not hold outline information");
                    if (oldMode == CursorMode.OUTLINE) {
                        ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    } else {
                        ToolBar.setCursorMode(oldMode);
                    }
                    return;
                }
                if (WindowFrame.getListener() != OutlineListener.theOne) {
                    OutlineListener.theOne.setNode(ni);
                }
                WindowFrame.setListener(OutlineListener.theOne);
                TopLevel.setCurrentCursor(outlineCursor);
                curMode = CursorMode.OUTLINE;
                break;
            }
            case MEASURE: {
                lastListener = null;
                if (WindowFrame.getListener() == MeasureListener.theOne) {
                    ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    return;
                }
                ToolBar.checkLeavingOutlineMode();
                MeasureListener.theOne.reset();
                WindowFrame.setListener(MeasureListener.theOne);
                TopLevel.setCurrentCursor(measureCursor);
                curMode = CursorMode.MEASURE;
            }
        }
    }

    private static void checkLeavingOutlineMode() {
        Highlight2 high;
        Highlighter highlighter;
        NodeInst ni;
        EditWindow wnd;
        if (WindowFrame.getListener() == OutlineListener.theOne && curMode == CursorMode.OUTLINE && (wnd = EditWindow.needCurrent()) != null && (ni = (NodeInst)(highlighter = wnd.getHighlighter()).getOneElectricObject(NodeInst.class)) != null && (high = highlighter.getOneHighlight()) != null) {
            high.setPoint(-1);
            wnd.repaint();
        }
    }

    public static void setGridAligment() {
        ToolBar.updateToolBarButtons();
    }

    private static void changeGridSize(int size) {
        Dimension2D[] vals = User.getAlignmentToGridVector();
        User.setAlignmentToGridVector(vals, size);
        ToolBar.rewriteGridDistance();
        ToolBar.updateToolBarButtons();
    }

    private static void changeGridSize(boolean larger) {
        Dimension2D[] vals = User.getAlignmentToGridVector();
        int i = User.getAlignmentToGridIndex();
        if (larger) {
            if (i > 0) {
                User.setAlignmentToGridVector(vals, i - 1);
                ToolBar.rewriteGridDistance();
            }
        } else if (i < vals.length - 1) {
            User.setAlignmentToGridVector(vals, i + 1);
            ToolBar.rewriteGridDistance();
        }
    }

    public static SelectMode getSelectMode() {
        return curSelectMode;
    }

    private static void setSelectMode(SelectMode selectMode) {
        curSelectMode = selectMode;
    }

    public static boolean isSelectSpecial() {
        return selectSpecial;
    }

    private static void setSelectSpecial(boolean b) {
        selectSpecial = b;
    }

    public static void updateUndoRedoButtons(boolean undo, boolean redo) {
        ToolBar.updateToolBarButtons();
    }

    public void updateCellHistoryStatus(boolean backEnabled, boolean forwardEnabled) {
        this.goBackButton.setEnabled(backEnabled);
        this.goForwardButton.setEnabled(forwardEnabled);
        ToolBar.updateToolBarButtons();
    }

    private static void showHistoryPopup(MouseEvent e) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        List<WindowFrame.CellHistory> historyList = wf.getCellHistoryList();
        int location = wf.getCellHistoryLocation();
        JPopupMenu popup = new JPopupMenu();
        HashMap<Cell, Cell> listed = new HashMap<Cell, Cell>();
        for (int i = historyList.size() - 1; i > -1; --i) {
            WindowFrame.CellHistory entry = historyList.get(i);
            Cell cell = entry.getCell();
            if (cell == null || listed.get(cell) != null) continue;
            listed.put(cell, cell);
            boolean shown = i == location;
            JMenuItem m = new JMenuItem(cell.noLibDescribe() + (shown ? "  (shown)" : ""));
            m.addActionListener(new HistoryPopupAction(wf, i));
            popup.add(m);
        }
        Component invoker = e.getComponent();
        if (invoker != null) {
            popup.setInvoker(invoker);
            Point loc = invoker.getLocationOnScreen();
            popup.setLocation((int)((Point2D)loc).getX() + invoker.getWidth() / 2, (int)((Point2D)loc).getY() + invoker.getHeight() / 2);
        }
        popup.setVisible(true);
    }

    public static void updateToolBarButtons() {
        for (ToolBar toolBar : TopLevel.getToolBars()) {
            for (Component c : toolBar.getComponents()) {
                if (c == toolBar.currentGridAmount) {
                    ToolBar.rewriteGridDistance();
                    continue;
                }
                if (!(c instanceof AbstractButton)) continue;
                AbstractButton b = (AbstractButton)c;
                for (ActionListener a : b.getActionListeners()) {
                    if (!(a instanceof EToolBarButton)) continue;
                    EToolBarButton tbb = (EToolBarButton)a;
                    if (tbb == goBackButtonStatic) {
                        tbb = toolBar.goBackButton;
                    }
                    if (tbb == goForwardButtonStatic) {
                        tbb = toolBar.goForwardButton;
                    }
                    tbb.updateToolBarButton(b);
                }
            }
        }
        MenuCommands.menuBar().updateAllButtons();
    }

    public void finished() {
    }

    static {
        allButtons = new ArrayList<EToolBarButton>();
        openLibraryCommand = new EToolBarButton("_Open Library...", 'O', "ButtonOpenLibrary", "File"){

            public void run() {
                FileMenu.openLibraryCommand();
            }
        };
        saveLibraryCommand = new EToolBarButton("Sa_ve Library", null, "ButtonSaveLibrary", "File"){

            public boolean isEnabled() {
                return Library.getCurrent() != null;
            }

            public void run() {
                FileMenu.saveLibraryCommand(Library.getCurrent());
            }
        };
        curMode = CursorMode.CLICKZOOMWIRE;
        zoomCursor = ToolBar.readCursor("CursorZoom.gif", 6, 6);
        zoomOutCursor = ToolBar.readCursor("CursorZoomOut.gif", 6, 6);
        panCursor = ToolBar.readCursor("CursorPan.gif", 8, 8);
        wiringCursor = ToolBar.readCursor("CursorWiring.gif", 0, 0);
        outlineCursor = ToolBar.readCursor("CursorOutline.gif", 0, 8);
        measureCursor = ToolBar.readCursor("CursorMeasure.gif", 0, 0);
        lastListener = null;
        clickZoomWireCommand = new CursorModeButton("Click/Zoom/Wire", 'S', "ButtonClickZoomWire", "Edit:Modes:Edit", CursorMode.CLICKZOOMWIRE);
        panCommand = new CursorModeButton("Toggle Pan", 'P', "ButtonPan", "Edit:Modes:Edit", CursorMode.PAN);
        zoomCommand = new CursorModeButton("Toggle Zoom", 'Z', "ButtonZoom", "Edit:Modes:Edit", CursorMode.ZOOM);
        outlineCommand = new CursorModeButton("Toggle Outline Edit", 'Y', "ButtonOutline", "Edit:Modes:Edit", CursorMode.OUTLINE);
        measureCommand = new CursorModeButton("Toggle Measure Distance", 'M', "ButtonMeasure", "Edit:Modes:Edit", CursorMode.MEASURE);
        gridDistance1Command = new EMenuItem("Grid Alignment 1 (largest)"){

            public void run() {
                ToolBar.changeGridSize(0);
            }
        };
        gridDistance2Command = new EMenuItem("Grid Alignment 2"){

            public void run() {
                ToolBar.changeGridSize(1);
            }
        };
        gridDistance3Command = new EMenuItem("Grid Alignment 3"){

            public void run() {
                ToolBar.changeGridSize(2);
            }
        };
        gridDistance4Command = new EMenuItem("Grid Alignment 4"){

            public void run() {
                ToolBar.changeGridSize(3);
            }
        };
        gridDistance5Command = new EMenuItem("Grid Alignment 5 (smallest)"){

            public void run() {
                ToolBar.changeGridSize(4);
            }
        };
        gridLarger = new EToolBarButton("Make Grid Larger", KeyStroke.getKeyStroke(70, 0), "ButtonGridCoarser", "Edit:Modes:Movement"){

            public void run() {
                ToolBar.changeGridSize(true);
            }

            public boolean isEnabled() {
                int index = User.getAlignmentToGridIndex();
                return index != 0;
            }
        };
        gridSmaller = new EToolBarButton("Make Grid Smaller", KeyStroke.getKeyStroke(72, 0), "ButtonGridFiner", "Edit:Modes:Movement"){

            public void run() {
                ToolBar.changeGridSize(false);
            }

            public boolean isEnabled() {
                Dimension2D[] vals = User.getAlignmentToGridVector();
                int index = User.getAlignmentToGridIndex();
                return index != vals.length - 1;
            }
        };
        curSelectMode = SelectMode.OBJECTS;
        selectObjectsCommand = new SelectModeButton("Select Objects", "ButtonObjects", "Edit:Modes:Select", SelectMode.OBJECTS);
        selectAreaCommand = new SelectModeButton("Select Area", "ButtonArea", "Edit:Modes:Select", SelectMode.AREA);
        selectSpecial = false;
        selectSpecialIconOn = Resources.getResource(ToolBar.class, "ButtonSelectSpecialOn.gif");
        selectSpecialIconOff = Resources.getResource(ToolBar.class, "ButtonSelectSpecialOff.gif");
        toggleSelectSpecialCommand = new EToolBarButton("Toggle Special Select", null, "ButtonSelectSpecialOff", "Edit:Modes:Select"){

            public boolean isSelected() {
                return ToolBar.isSelectSpecial();
            }

            protected JMenuItem createMenuItem() {
                return new JCheckBoxMenuItem();
            }

            AbstractButton createToolBarButton() {
                return new JToggleButton();
            }

            public void run() {
                ToolBar.setSelectSpecial(!ToolBar.isSelectSpecial());
            }

            void updateToolBarButton(AbstractButton item) {
                super.updateToolBarButton(item);
                item.setSelected(this.isSelected());
                item.setIcon(this.isSelected() ? selectSpecialIconOn : selectSpecialIconOff);
            }
        };
        modesSubMenu = new EMenu("M_odes", new EMenu("_Edit", clickZoomWireCommand, panCommand, zoomCommand, outlineCommand, measureCommand), new EMenu("_Movement", gridLarger, gridDistance1Command, gridDistance2Command, gridDistance3Command, gridDistance4Command, gridDistance5Command, gridSmaller), new EMenu("_Select", selectObjectsCommand, selectAreaCommand, toggleSelectSpecialCommand));
        preferencesCommand = new EToolBarButton("P_references...", null, "ButtonPreferences", "File"){

            public void run() {
                PreferencesFrame.preferencesCommand();
            }
        };
        expandOneLevelCommand = new EToolBarButton("_One Level Down", null, "ButtonExpand", "Cell:Expand Cell Instances"){

            public void run() {
                CircuitChanges.DoExpandCommands(false, 1);
            }
        };
        unexpandOneLevelCommand = new EToolBarButton("_One Level Up", null, "ButtonUnexpand", "Cell:Unexpand Cell Instances"){

            public void run() {
                CircuitChanges.DoExpandCommands(true, 1);
            }
        };
        undoCommand = new EToolBarButton("_Undo", 'Z', "ButtonUndo", "Edit"){

            public void run() {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                if (wf != null && wf.getContent() instanceof TextWindow) {
                    TextWindow tw = (TextWindow)wf.getContent();
                    tw.undo();
                } else {
                    GetInfoText.EditInPlaceListener eip;
                    EditWindow wnd = EditWindow.getCurrent();
                    if (wnd != null && (eip = wnd.getInPlaceTextObject()) != null) {
                        eip.undo();
                        return;
                    }
                    Undo.undo();
                }
            }

            public boolean isEnabled() {
                return UserInterfaceMain.getUndoEnabled();
            }
        };
        redoCommand = new EToolBarButton("Re_do", 'Y', "ButtonRedo", "Edit"){

            public void run() {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                if (wf != null && wf.getContent() instanceof TextWindow) {
                    TextWindow tw = (TextWindow)wf.getContent();
                    tw.redo();
                } else {
                    GetInfoText.EditInPlaceListener eip;
                    EditWindow wnd = EditWindow.getCurrent();
                    if (wnd != null && (eip = wnd.getInPlaceTextObject()) != null) {
                        eip.redo();
                        return;
                    }
                    Undo.redo();
                }
            }

            public boolean isEnabled() {
                return UserInterfaceMain.getRedoEnabled();
            }
        };
        goBackButtonStatic = new EToolBarButton("Go Back a Cell", null, "ButtonGoBack", "Cell:Cell Viewing History"){

            public void run() {
            }
        };
        goForwardButtonStatic = new EToolBarButton("Go Forward a Cell", null, "ButtonGoForward", "Cell:Cell Viewing History"){

            public void run() {
            }
        };
    }

    private static class HistoryPopupAction
    implements ActionListener {
        private final WindowFrame wf;
        private final int historyLocation;

        private HistoryPopupAction(WindowFrame wf, int loc) {
            this.wf = wf;
            this.historyLocation = loc;
        }

        public void actionPerformed(ActionEvent e) {
            this.wf.setCellByHistory(this.historyLocation);
        }
    }

    private static abstract class CellHistoryButton
    extends EToolBarButton
    implements MouseListener {
        private boolean enabled;

        CellHistoryButton(String text, String iconName, String menuName) {
            super(text, null, iconName, menuName);
        }

        public AbstractButton genToolBarButton() {
            AbstractButton b = super.genToolBarButton();
            b.addMouseListener(this);
            return b;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        void setEnabled(boolean b) {
            this.enabled = b;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            if (ClickZoomWireListener.isRightMouse(e) && b.contains(e.getX(), e.getY())) {
                ToolBar.showHistoryPopup(e);
            }
        }
    }

    public static class SelectModeButton
    extends EToolBarRadioButton {
        private final SelectMode sm;

        SelectModeButton(String text, String iconName, String menuName, SelectMode sm) {
            super(text, null, iconName, menuName);
            this.sm = sm;
        }

        public boolean isSelected() {
            return ToolBar.getSelectMode() == this.sm;
        }

        public void run() {
            ToolBar.setSelectMode(this.sm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectMode {
        OBJECTS,
        AREA;

    }

    private static class CursorModeButton
    extends EToolBarRadioButton {
        private final CursorMode cm;

        CursorModeButton(String text, char acceleratorChar, String iconName, String menuName, CursorMode cm) {
            super(text, KeyStroke.getKeyStroke((int)acceleratorChar, 0), iconName, menuName);
            this.cm = cm;
        }

        public boolean isSelected() {
            return ToolBar.getCursorMode() == this.cm;
        }

        public void run() {
            ToolBar.setCursorMode(this.cm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CursorMode {
        CLICKZOOMWIRE,
        PAN,
        ZOOM,
        OUTLINE,
        MEASURE;

    }

    private static abstract class EToolBarRadioButton
    extends EToolBarButton {
        EToolBarRadioButton(String text, KeyStroke accelerator, String iconName, String menuName) {
            super(text, accelerator, iconName, menuName);
        }

        EToolBarRadioButton(String text, char acceleratorChar, String iconName, String menuName) {
            super(text, acceleratorChar, iconName, menuName);
        }

        protected JMenuItem createMenuItem() {
            if (Client.isOSMac()) {
                return new JMenuItem();
            }
            return new JRadioButtonMenuItem();
        }

        JToggleButton createToolBarButton() {
            return new JToggleButton();
        }
    }

    public static class EToolBarGeneralMenuButton
    extends EToolBarButton {
        private EMenuItem item;

        public EToolBarGeneralMenuButton(String text, String iconName, String menuName, EMenuItem item) {
            super(text, null, iconName, menuName);
            this.item = item;
        }

        public void run() {
            this.item.run();
        }
    }

    public static abstract class EToolBarButton
    extends EMenuItem {
        private ImageIcon defaultIcon;
        private String iconName;
        private String menuName;
        private String fullPathToIcon;

        EToolBarButton(String text, KeyStroke accelerator, String iconName, String menuName) {
            super(text, accelerator);
            this.iconName = iconName;
            this.menuName = menuName;
            this.defaultIcon = iconName == null ? unknownIcon : Resources.getResource(ToolBar.class, iconName + ".gif");
        }

        EToolBarButton(String text, char acceleratorChar, String iconName, String menuName) {
            super(text, acceleratorChar);
            this.iconName = iconName;
            this.menuName = menuName;
            this.defaultIcon = iconName == null ? unknownIcon : Resources.getResource(ToolBar.class, iconName + ".gif");
        }

        public String getMenuName() {
            return this.menuName;
        }

        public ImageIcon getIcon() {
            return this.defaultIcon;
        }

        public void setIcon(ImageIcon i, String path) {
            this.defaultIcon = i;
            this.fullPathToIcon = path;
        }

        public AbstractButton genToolBarButton() {
            AbstractButton b = this.createToolBarButton();
            b.setToolTipText(this.getToolTipText());
            b.setIcon(this.defaultIcon);
            b.addActionListener(this);
            this.updateToolBarButton(b);
            return b;
        }

        AbstractButton createToolBarButton() {
            return new JButton();
        }

        void updateToolBarButton(AbstractButton item) {
            item.setEnabled(this.isEnabled());
            item.setSelected(this.isSelected());
            item.setToolTipText(this.getToolTipText());
        }

        protected void registerItem() {
            super.registerItem();
            this.registerUpdatable();
        }

        protected void updateButtons() {
            ToolBar.updateToolBarButtons();
        }
    }
}

