/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.io.output.Output;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class ArchSim
extends Output {
    private ArchSimPreferences localPrefs;

    ArchSim(ArchSimPreferences ap) {
        this.localPrefs = ap;
    }

    private void writeFlatCell(Cell cell) {
        this.printWriter.println("<?xml version='1.0' encoding='utf-8'?>");
        this.printWriter.println();
        this.printWriter.println("<!DOCTYPE model SYSTEM \"ArchSimModel.dtd\">");
        this.printWriter.println();
        this.printWriter.println("<!-- Cell: " + cell.describe(true) + " -->");
        this.emitCopyright("<!-- ", " -->");
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.printWriter.println("<!-- Created on " + TextUtils.formatDate(cell.getCreationDate()) + " -->");
            this.printWriter.println("<!-- Last revised on " + TextUtils.formatDate(cell.getRevisionDate()) + " -->");
            this.printWriter.println("<!-- Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion() + " -->");
        } else {
            this.printWriter.println("<!-- Written by Electric VLSI Design System -->");
        }
        this.printWriter.println();
        this.printWriter.println("<model name= \"" + cell.getName() + "\">");
        this.printWriter.println();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
            Cell subCell = (Cell)ni.getProto();
            this.printWriter.println("<component name= \"" + ni.getName() + "\" type= \"" + subCell.getName() + "\" />");
        }
        this.printWriter.println();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            this.reportError("Sorry, a deadlock aborted netlisting (network information unavailable).  Please try again");
            return;
        }
        Iterator<Network> it2 = netlist.getNetworks();
        while (it2.hasNext()) {
            Network net = it2.next();
            ArrayList<PortInst> inputs = new ArrayList<PortInst>();
            ArrayList<PortInst> outputs = new ArrayList<PortInst>();
            Iterator<NodeInst> oIt = cell.getNodes();
            while (oIt.hasNext()) {
                NodeInst ni = oIt.next();
                if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    PortInst pi = con.getPortInst();
                    Network nodeNet = netlist.getNetwork(pi);
                    if (nodeNet != net) continue;
                    PortCharacteristic pc = pi.getPortProto().getCharacteristic();
                    if (pc == PortCharacteristic.IN) {
                        inputs.add(pi);
                        continue;
                    }
                    if (pc == PortCharacteristic.OUT) {
                        outputs.add(pi);
                        continue;
                    }
                    this.reportWarning("Export " + pi.getPortProto().getName() + " of " + ni.getProto() + " is neither input or output (it is " + pc.getFullName() + ")");
                }
            }
            if (inputs.size() == 0 && outputs.size() == 0) continue;
            Iterator<String> nIt = net.getNames();
            String netName = nIt.hasNext() ? nIt.next() : net.describe(true);
            this.printWriter.println();
            this.printWriter.println("<connection name= \"" + netName + "\">");
            for (PortInst pi : outputs) {
                this.printWriter.println("\t<from component= \"" + pi.getNodeInst().getName() + "\" terminal=\"" + pi.getPortProto().getName() + "\" />");
            }
            for (PortInst pi : inputs) {
                this.printWriter.println("\t<to component= \"" + pi.getNodeInst().getName() + "\" terminal=\"" + pi.getPortProto().getName() + "\" />");
            }
            this.printWriter.println("</connection>");
        }
        this.printWriter.println();
        this.printWriter.println("</model>");
    }

    public static class ArchSimPreferences
    extends Output.OutputPreferences {
        public ArchSimPreferences(boolean factory) {
            super(factory);
        }

        public Output doOutput(Cell cell, VarContext context, String filePath) {
            ArchSim out = new ArchSim(this);
            if (!out.openTextOutputStream(filePath)) {
                out.writeFlatCell(cell);
                if (!out.closeTextOutputStream()) {
                    System.out.println(filePath + " written");
                }
            }
            return out.finishWrite();
        }
    }
}

