/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import java.awt.geom.Point2D;

public class Artwork
extends Technology {
    public static final Variable.Key ART_DEGREES = Variable.newKey("ART_degrees");
    public static final Variable.Key ART_MESSAGE = Variable.newKey("ART_message");
    public static final Variable.Key ART_COLOR = Variable.newKey("ART_color");
    public static final Variable.Key ART_PATTERN = Variable.newKey("ART_pattern");
    private static final int ELLIPSEPOINTS = 30;
    private static final int SPLINEGRAIN = 20;
    public final PrimitiveNode pinNode;
    public final PrimitiveNode boxNode;
    public final PrimitiveNode crossedBoxNode;
    public final PrimitiveNode filledBoxNode;
    public final PrimitiveNode circleNode;
    public final PrimitiveNode filledCircleNode;
    public final PrimitiveNode splineNode;
    public final PrimitiveNode triangleNode;
    public final PrimitiveNode filledTriangleNode;
    public final PrimitiveNode arrowNode;
    public final PrimitiveNode openedPolygonNode;
    public final PrimitiveNode openedDottedPolygonNode;
    public final PrimitiveNode openedDashedPolygonNode;
    public final PrimitiveNode openedThickerPolygonNode;
    public final PrimitiveNode closedPolygonNode;
    public final PrimitiveNode filledPolygonNode;
    public final PrimitiveNode thickCircleNode;
    public final ArcProto solidArc;
    public final ArcProto dottedArc;
    public final ArcProto dashedArc;
    public final ArcProto thickerArc;
    public final Layer defaultLayer;

    public static Artwork tech() {
        return TechPool.getThreadTechPool().getArtwork();
    }

    public Artwork(Generic generic, TechFactory techFactory) {
        super(generic, techFactory);
        this.setTechShortName("Artwork");
        this.setTechDesc("General-purpose artwork components");
        this.setFactoryScale(2000.0, false);
        this.setNonStandard();
        this.setNonElectrical();
        this.setNoNegatedArcs();
        this.setStaticTechnology();
        this.defaultLayer = Layer.newInstance(this, "Graphics", new EGraphics(false, false, null, 0, 0, 0, 0, 0.8, true, new int[]{65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535}));
        this.defaultLayer.setFunction(Layer.Function.ART, 8192);
        this.defaultLayer.setFactoryDXFLayer("OBJECT");
        this.solidArc = this.newArcProto("Solid", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(this.defaultLayer, 0.0, Poly.Type.FILLED));
        this.solidArc.setFactoryFixedAngle(false);
        this.solidArc.setCurvable();
        this.solidArc.setWipable();
        this.solidArc.setFactoryAngleIncrement(0);
        this.dottedArc = this.newArcProto("Dotted", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(this.defaultLayer, 0.0, Poly.Type.OPENEDT1));
        this.dottedArc.setFactoryFixedAngle(false);
        this.dottedArc.setCurvable();
        this.dottedArc.setWipable();
        this.dottedArc.setFactoryAngleIncrement(0);
        this.dashedArc = this.newArcProto("Dashed", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(this.defaultLayer, 0.0, Poly.Type.OPENEDT2));
        this.dashedArc.setFactoryFixedAngle(false);
        this.dashedArc.setCurvable();
        this.dashedArc.setWipable();
        this.dashedArc.setFactoryAngleIncrement(0);
        this.thickerArc = this.newArcProto("Thicker", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(this.defaultLayer, 0.0, Poly.Type.OPENEDT3));
        this.thickerArc.setFactoryFixedAngle(false);
        this.thickerArc.setCurvable();
        this.thickerArc.setWipable();
        this.thickerArc.setFactoryAngleIncrement(0);
        Technology.TechPoint[] box_1 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeTopEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeBottomEdge())};
        Technology.TechPoint[] box_2 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(new EdgeH(-0.125, 0.0), EdgeV.makeTopEdge()), new Technology.TechPoint(new EdgeH(0.125, 0.0), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeTopEdge())};
        Technology.TechPoint[] box_4 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeTopEdge())};
        Technology.TechPoint[] box_6 = new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())};
        this.pinNode = PrimitiveNode.newInstance0("Pin", this, 1.0, 1.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.DISC, 0, box_6)});
        this.pinNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.pinNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        this.pinNode.setFunction(PrimitiveNode.Function.PIN);
        this.pinNode.setArcsWipe();
        this.pinNode.setArcsShrink();
        this.boxNode = PrimitiveNode.newInstance0("Box", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.CLOSED, 1, Technology.TechPoint.makeFullBox())});
        this.boxNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.boxNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "box", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.boxNode.setFunction(PrimitiveNode.Function.ART);
        this.boxNode.setEdgeSelect();
        this.crossedBoxNode = PrimitiveNode.newInstance0("Crossed-Box", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.CROSSED, 1, Technology.TechPoint.makeFullBox())});
        this.crossedBoxNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.crossedBoxNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "fbox", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.crossedBoxNode.setFunction(PrimitiveNode.Function.ART);
        this.filledBoxNode = PrimitiveNode.newInstance0("Filled-Box", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        this.filledBoxNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.filledBoxNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "fbox", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.filledBoxNode.setFunction(PrimitiveNode.Function.ART);
        this.filledBoxNode.setEdgeSelect();
        this.circleNode = PrimitiveNode.newInstance0("Circle", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.CIRCLE, 0, box_6)});
        this.circleNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.circleNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.circleNode.setFunction(PrimitiveNode.Function.ART);
        this.circleNode.setEdgeSelect();
        this.filledCircleNode = PrimitiveNode.newInstance0("Filled-Circle", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.DISC, 0, box_6)});
        this.filledCircleNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.filledCircleNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.filledCircleNode.setFunction(PrimitiveNode.Function.ART);
        this.filledCircleNode.setSquare();
        this.filledCircleNode.setEdgeSelect();
        this.splineNode = PrimitiveNode.newInstance0("Spline", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.OPENED, 0, box_2)});
        this.splineNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.splineNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.splineNode.setFunction(PrimitiveNode.Function.ART);
        this.splineNode.setHoldsOutline();
        this.splineNode.setEdgeSelect();
        this.triangleNode = PrimitiveNode.newInstance0("Triangle", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.CLOSED, 0, box_4)});
        this.triangleNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.triangleNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "triangle", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.triangleNode.setFunction(PrimitiveNode.Function.ART);
        this.triangleNode.setEdgeSelect();
        this.filledTriangleNode = PrimitiveNode.newInstance0("Filled-Triangle", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.FILLED, 0, box_4)});
        this.filledTriangleNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.filledTriangleNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "ftriangle", 180, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.filledTriangleNode.setFunction(PrimitiveNode.Function.ART);
        this.filledTriangleNode.setEdgeSelect();
        this.arrowNode = PrimitiveNode.newInstance0("Arrow", this, 2.0, 2.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.FILLED, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeTopEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter())}), new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.FILLED, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter())})});
        this.arrowNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.arrowNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "arrow", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeRightEdge(), EdgeV.makeCenter(), EdgeH.makeRightEdge(), EdgeV.makeCenter())});
        this.arrowNode.setFunction(PrimitiveNode.Function.ART);
        this.arrowNode.setEdgeSelect();
        this.openedPolygonNode = PrimitiveNode.newInstance0("Opened-Polygon", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.OPENED, 0, box_2)});
        this.openedPolygonNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.openedPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.openedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedPolygonNode.setHoldsOutline();
        this.openedPolygonNode.setEdgeSelect();
        this.openedDottedPolygonNode = PrimitiveNode.newInstance0("Opened-Dotted-Polygon", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.OPENEDT1, 0, box_2)});
        this.openedDottedPolygonNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.openedDottedPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.openedDottedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedDottedPolygonNode.setHoldsOutline();
        this.openedDottedPolygonNode.setEdgeSelect();
        this.openedDashedPolygonNode = PrimitiveNode.newInstance0("Opened-Dashed-Polygon", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.OPENEDT2, 0, box_2)});
        this.openedDashedPolygonNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.openedDashedPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.openedDashedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedDashedPolygonNode.setHoldsOutline();
        this.openedDashedPolygonNode.setEdgeSelect();
        this.openedThickerPolygonNode = PrimitiveNode.newInstance0("Opened-Thicker-Polygon", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.OPENEDT3, 0, box_2)});
        this.openedThickerPolygonNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.openedThickerPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.openedThickerPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.openedThickerPolygonNode.setHoldsOutline();
        this.openedThickerPolygonNode.setEdgeSelect();
        this.closedPolygonNode = PrimitiveNode.newInstance0("Closed-Polygon", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.CLOSED, 0, box_1)});
        this.closedPolygonNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.closedPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.closedPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.closedPolygonNode.setHoldsOutline();
        this.closedPolygonNode.setEdgeSelect();
        this.filledPolygonNode = PrimitiveNode.newInstance0("Filled-Polygon", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.FILLED, 0, box_1)});
        this.filledPolygonNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.filledPolygonNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.filledPolygonNode.setFunction(PrimitiveNode.Function.ART);
        this.filledPolygonNode.setHoldsOutline();
        this.filledPolygonNode.setEdgeSelect();
        this.thickCircleNode = PrimitiveNode.newInstance0("Thick-Circle", this, 6.0, 6.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.defaultLayer, 0, Poly.Type.THICKCIRCLE, 0, box_6)});
        this.thickCircleNode.addPrimitivePortsFixed(new PrimitivePort[]{PrimitivePort.newInstance(this, this.thickCircleNode, new ArcProto[]{this.solidArc, this.dottedArc, this.dashedArc, this.thickerArc}, "site", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge(), EdgeH.makeRightEdge(), EdgeV.makeTopEdge())});
        this.thickCircleNode.setFunction(PrimitiveNode.Function.ART);
        this.thickCircleNode.setEdgeSelect();
        this.newFoundry(Foundry.Type.NONE, null, "Graphics 1");
        this.oldArcNames.put("Dash-1", this.dottedArc);
        this.oldArcNames.put("Dash-2", this.dashedArc);
        this.oldArcNames.put("Dash-3", this.thickerArc);
        this.oldNodeNames.put("Message", generic.invisiblePinNode);
        this.oldNodeNames.put("Centered-Message", generic.invisiblePinNode);
        this.oldNodeNames.put("Left-Message", generic.invisiblePinNode);
        this.oldNodeNames.put("Right-Message", generic.invisiblePinNode);
        this.oldNodeNames.put("Opened-FarDotted-Polygon", this.openedThickerPolygonNode);
        this.loadFactoryMenuPalette(Artwork.class.getResource("artworkMenu.xml"));
    }

    protected void genShapeOfNode(AbstractShapeBuilder b, ImmutableNodeInst n, PrimitiveNode pn, Technology.NodeLayer[] primLayers) {
        Point2D[] tracePoints;
        if (b.skipLayer(this.defaultLayer)) {
            return;
        }
        EGraphics graphicsOverride = this.makeGraphics(n);
        if (pn == this.circleNode || pn == this.thickCircleNode) {
            double[] angles = n.getArcDegrees();
            if (n.size.getGridX() != n.size.getGridY()) {
                Point2D[] pointList;
                for (Point2D p : pointList = Artwork.fillEllipse(EPoint.ORIGIN, n.size.getLambdaX(), n.size.getLambdaY(), angles[0], angles[1])) {
                    b.pushPoint(p.getX() * 400.0, p.getY() * 400.0);
                }
                Poly.Type style = pn == this.circleNode ? Poly.Type.OPENED : Poly.Type.OPENEDT3;
                b.pushPoly(style, this.defaultLayer, graphicsOverride, null);
                return;
            }
            if (angles[0] != 0.0 || angles[1] != 0.0) {
                double dist = (double)n.size.getGridX() * 0.5;
                b.pushPoint(EPoint.ORIGIN);
                b.pushPoint(Math.cos(angles[0] + angles[1]) * dist, Math.sin(angles[0] + angles[1]) * dist);
                b.pushPoint(Math.cos(angles[0]) * dist, Math.sin(angles[0]) * dist);
                Poly.Type style = pn == this.circleNode ? Poly.Type.CIRCLEARC : Poly.Type.THICKCIRCLEARC;
                b.pushPoly(style, this.defaultLayer, graphicsOverride, null);
                return;
            }
        } else if (pn == this.splineNode && (tracePoints = n.getTrace()) != null) {
            Point2D[] pointList;
            for (Point2D p : pointList = this.fillSpline(0.0, 0.0, tracePoints)) {
                b.pushPoint(p.getX() * 400.0, p.getY() * 400.0);
            }
            b.pushPoly(Poly.Type.OPENED, this.defaultLayer, graphicsOverride, null);
            return;
        }
        b.genShapeOfNode(n, pn, primLayers, graphicsOverride);
    }

    protected void genShapeOfPort(AbstractShapeBuilder b, ImmutableNodeInst n, PrimitiveNode pn, PrimitivePort pp, Point2D selectPt) {
        Point2D[] tracePoints;
        if (pn == this.pinNode || pn == this.arrowNode || pn == this.circleNode || pn == this.thickCircleNode || pn == this.filledCircleNode) {
            b.genShapeOfPort(n, pn, pp);
            return;
        }
        if (pn == this.splineNode && (tracePoints = n.getTrace()) != null) {
            Point2D[] pointList;
            for (Point2D p : pointList = this.fillSpline(0.0, 0.0, tracePoints)) {
                b.pushPoint(p.getX() * 400.0, p.getY() * 400.0);
            }
            b.pushPoly(Poly.Type.OPENED, null, null, null);
            return;
        }
        b.genShapeOfNode(n, pn, pn.getNodeLayers(), null);
    }

    protected void getShapeOfArc(AbstractShapeBuilder b, ImmutableArcInst a) {
        this.getShapeOfArc(b, a, this.makeGraphics(a));
    }

    public boolean isEasyShape(ImmutableArcInst a, boolean explain) {
        if (a.getVar(ART_COLOR) != null) {
            if (explain) {
                System.out.println("ART_COLOR");
            }
            return false;
        }
        if (a.getVar(ART_PATTERN) != null) {
            if (explain) {
                System.out.println("ART_PATTERN");
            }
            return false;
        }
        return super.isEasyShape(a, explain);
    }

    public static Point2D[] fillEllipse(Point2D center, double sX, double sY, double startoffset, double endangle) {
        boolean closed = true;
        if (startoffset == 0.0 && endangle == 0.0) {
            endangle = Math.PI * 2;
        } else {
            closed = false;
        }
        int pts = (int)(endangle * 30.0 / (Math.PI * 2));
        if (pts < 3) {
            pts = 3;
        }
        if (closed) {
            ++pts;
        }
        Point2D[] points = new Point2D.Double[pts];
        double a = sX / 2.0;
        double b = sY / 2.0;
        if (closed) {
            double p = 0.21666156231653746;
            double c2 = Math.cos(p);
            double s2 = Math.sin(p);
            double c3 = 1.0;
            double s3 = 0.0;
            for (int m = 0; m < 30; ++m) {
                points[m] = new Point2D.Double(center.getX() + a * c3, center.getY() + b * s3);
                double t1 = c3 * c2 - s3 * s2;
                s3 = s3 * c2 + c3 * s2;
                c3 = t1;
            }
        } else {
            for (int m = 0; m < pts; ++m) {
                double p = startoffset + (double)m * endangle / (double)(pts - 1);
                double c2 = Math.cos(p);
                double s2 = Math.sin(p);
                points[m] = new Point2D.Double(center.getX() + a * c2, center.getY() + b * s2);
            }
        }
        return points;
    }

    private double getTracePointX(Point2D[] tracePoints, int index, double cX) {
        double v = tracePoints[index].getX();
        return v + cX;
    }

    private double getTracePointY(Point2D[] tracePoints, int index, double cY) {
        double v = tracePoints[index].getY();
        return v + cY;
    }

    public void setDefaultOutline(NodeInst ni) {
        Point2D[] outline;
        if (ni.isCellInstance()) {
            return;
        }
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        double x = ni.getAnchorCenterX();
        double y = ni.getAnchorCenterY();
        if (np == this.openedPolygonNode || np == this.openedDottedPolygonNode || np == this.openedDashedPolygonNode || np == this.openedThickerPolygonNode || np == this.splineNode) {
            outline = new EPoint[]{new EPoint(x - 3.0, y - 3.0), new EPoint(x - 1.0, y + 3.0), new EPoint(x + 1.0, y - 3.0), new EPoint(x + 3.0, y + 3.0)};
            ni.setTrace(outline);
        }
        if (np == this.closedPolygonNode || np == this.filledPolygonNode) {
            outline = new EPoint[]{new EPoint(x + 0.0, y - 3.0), new EPoint(x - 3.0, y + 0.0), new EPoint(x + 0.0, y + 3.0), new EPoint(x + 3.0, y - 3.0)};
            ni.setTrace(outline);
        }
    }

    public Point2D[] fillSpline(double cX, double cY, Point2D[] tracePoints) {
        int steps = 20;
        int count = tracePoints.length;
        int outPoints = (count - 1) * steps + 1;
        Point2D[] points = new Point2D.Double[outPoints];
        int out = 0;
        double splineStep = 1.0 / (double)steps;
        double x2 = this.getTracePointX(tracePoints, 0, cX) * 2.0 - this.getTracePointX(tracePoints, 1, cX);
        double y2 = this.getTracePointY(tracePoints, 0, cY) * 2.0 - this.getTracePointY(tracePoints, 1, cY);
        double x3 = this.getTracePointX(tracePoints, 0, cX);
        double y3 = this.getTracePointY(tracePoints, 0, cY);
        double x4 = this.getTracePointX(tracePoints, 1, cX);
        double y4 = this.getTracePointY(tracePoints, 1, cY);
        for (int k = 2; k <= count; ++k) {
            double x1 = x2;
            x2 = x3;
            x3 = x4;
            double y1 = y2;
            y2 = y3;
            y3 = y4;
            if (k == count) {
                x4 = this.getTracePointX(tracePoints, k - 1, cX) * 2.0 - this.getTracePointX(tracePoints, k - 2, cX);
                y4 = this.getTracePointY(tracePoints, k - 1, cY) * 2.0 - this.getTracePointY(tracePoints, k - 2, cY);
            } else {
                x4 = this.getTracePointX(tracePoints, k, cX);
                y4 = this.getTracePointY(tracePoints, k, cY);
            }
            int i = 0;
            double t = 0.0;
            while (i < steps) {
                double tsq = t * t;
                double t4 = tsq * t;
                double t3 = -3.0 * t4 + 3.0 * tsq + 3.0 * t + 1.0;
                double t2 = 3.0 * t4 - 6.0 * tsq + 4.0;
                double t1 = -t4 + 3.0 * tsq - 3.0 * t + 1.0;
                double x = (x1 * t1 + x2 * t2 + x3 * t3 + x4 * t4) / 6.0;
                double y = (y1 * t1 + y2 * t2 + y3 * t3 + y4 * t4) / 6.0;
                points[out++] = new Point2D.Double(x, y);
                ++i;
                t += splineStep;
            }
        }
        points[out++] = new Point2D.Double(this.getTracePointX(tracePoints, count - 1, cX), this.getTracePointY(tracePoints, count - 1, cY));
        return points;
    }

    public EGraphics makeGraphics(ElectricObject eObj) {
        return this.makeGraphics(eObj.getD());
    }

    private EGraphics makeGraphics(ImmutableElectricObject d) {
        Integer color = (Integer)d.getVarValue(ART_COLOR, Integer.class);
        Variable patternVar = d.getVar(ART_PATTERN);
        if (color == null && patternVar == null) {
            return null;
        }
        EGraphics graphics = this.defaultLayer.getFactoryGraphics();
        if (color != null) {
            graphics = graphics.withColorIndex(color);
        }
        if (patternVar != null) {
            int i;
            Number[] pat;
            int len = patternVar.getLength();
            if (len != 8 && len != 16 && len != 17) {
                System.out.println("'ART_pattern' length is incorrect");
                return null;
            }
            graphics = graphics.withPatternedOnDisplay(true);
            graphics = graphics.withPatternedOnPrinter(true);
            graphics = graphics.withOutlined(null);
            int[] pattern = new int[16];
            Object obj = patternVar.getObject();
            if (obj instanceof Integer[]) {
                pat = (Integer[])obj;
                if (len == 17) {
                    int outlineIndex = (Integer)pat[16];
                    graphics = graphics.withOutlined(EGraphics.Outline.findOutline(outlineIndex));
                    len = 16;
                }
                for (i = 0; i < len; ++i) {
                    pattern[i] = (Integer)pat[i];
                }
            } else if (obj instanceof Short[]) {
                pat = (Short[])obj;
                for (i = 0; i < len; ++i) {
                    pattern[i] = ((Short)pat[i]).shortValue();
                }
                graphics = graphics.withOutlined(EGraphics.Outline.PAT_S);
            }
            if (len == 8) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    pattern[i2 + 8] = pattern[i2];
                }
            }
            graphics = graphics.withPattern(pattern);
        }
        return graphics;
    }

    public static boolean isArtworkArc(ArcProto p) {
        return p == Artwork.tech().solidArc || p == Artwork.tech().dottedArc || p == Artwork.tech().dashedArc || p == Artwork.tech().thickerArc;
    }
}

