/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.Highlighter;
import java.io.IOException;
import java.io.PrintStream;

class ErrorHighLine
extends ErrorHighlight {
    private final EPoint p1;
    private final EPoint p2;
    private final boolean thickLine;

    public ErrorHighLine(Cell c, EPoint x1, EPoint x2, boolean thick) {
        super(c, null);
        this.thickLine = thick;
        this.p1 = x1;
        this.p2 = x2;
    }

    ErrorHighLine(CellId cellId, EPoint x1, EPoint x2, boolean thick) {
        super(cellId);
        this.thickLine = thick;
        this.p1 = x1;
        this.p2 = x2;
    }

    public static void writeXmlHeader(String indent, PrintStream ps) {
        ps.println(indent + "<!ELEMENT ERRORTYPELINE ANY>");
        ps.println(indent + "<!ATTLIST ERRORTYPELINE");
        ps.println(indent + "   p1 CDATA #REQUIRED");
        ps.println(indent + "   p2 CDATA #REQUIRED");
        ps.println(indent + "   cellName CDATA #REQUIRED");
        ps.println(indent + ">");
        ps.println(indent + "<!ELEMENT ERRORTYPETHICKLINE ANY>");
        ps.println(indent + "<!ATTLIST ERRORTYPETHICKLINE");
        ps.println(indent + "   p1 CDATA #REQUIRED");
        ps.println(indent + "   p2 CDATA #REQUIRED");
        ps.println(indent + "   cellName CDATA #REQUIRED");
        ps.println(indent + ">");
    }

    void writeXmlDescription(String tabs, PrintStream msg, EDatabase database) {
        msg.append(tabs + "<" + (this.thickLine ? "ERRORTYPETHICKLINE " : "ERRORTYPELINE "));
        msg.append("p1=\"(" + this.p1.getX() + "," + this.p1.getY() + ")\" ");
        msg.append("p2=\"(" + this.p2.getX() + "," + this.p2.getY() + ")\" ");
        msg.append("cellName=\"" + this.getCell(database).describe(false) + "\"");
        msg.append(" />\n");
    }

    public void addToHighlighter(Highlighter h, EDatabase database) {
        Cell cell = this.getCell(database);
        h.addLine(this.p1, this.p2, cell, this.thickLine, true);
    }

    void write(IdWriter writer) throws IOException {
        this.writeTag(writer, (byte)3);
        writer.writePoint(this.p1);
        writer.writePoint(this.p2);
        writer.writeBoolean(this.thickLine);
    }
}

