/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.CapCell;
import com.sun.electric.tool.generator.layout.fill.CapFloorplan;
import com.sun.electric.tool.generator.layout.fill.FillCell;
import com.sun.electric.tool.generator.layout.fill.G;
import java.util.Iterator;

class CapCellMosis
extends CapCell {
    private final double POLY_CONT_WIDTH = 10.0;
    private final String TOP_DIFF = "diff-top";
    private final String BOT_DIFF = "diff-bottom";
    private final String LEFT_POLY = "poly-left";
    private final String RIGHT_POLY = "poly-right";
    private final ProtoPlan plan;
    private final TechType tech;

    private PortInst[] diffCont(double y, ProtoPlan plan, Cell cell) {
        PortInst[] conts = new PortInst[plan.numMosX];
        double x = (double)(-plan.numMosX) * plan.mosPitchX / 2.0;
        PortInst wellCont = LayoutLib.newNodeInst(this.tech.pwm1(), x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        Export e = Export.newInstance(cell, wellCont, "gnd_" + this.gndNum++);
        e.setCharacteristic(FillCell.GND_CHARACTERISTIC);
        for (int i = 0; i < plan.numMosX; ++i) {
            conts[i] = LayoutLib.newNodeInst(this.tech.ndm1(), x += plan.mosPitchX / 2.0, y, plan.gateWidth, 5.0, 0.0, cell).getOnlyPortInst();
            LayoutLib.newArcInst(this.tech.m1(), plan.gndWidth, wellCont, conts[i]);
            wellCont = LayoutLib.newNodeInst(this.tech.pwm1(), x += plan.mosPitchX / 2.0, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
            LayoutLib.newArcInst(this.tech.m1(), plan.gndWidth, conts[i], wellCont);
        }
        x = -plan.protoWidth / 2.0 + plan.gndWidth / 2.0;
        PortInst pi = LayoutLib.newNodeInst(this.tech.m1pin(), x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        LayoutLib.newArcInst(this.tech.m1(), plan.gndWidth, pi, conts[0]);
        x = plan.protoWidth / 2.0 - plan.gndWidth / 2.0;
        pi = LayoutLib.newNodeInst(this.tech.m1pin(), x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        LayoutLib.newArcInst(this.tech.m1(), plan.gndWidth, pi, conts[conts.length - 1]);
        return conts;
    }

    private PortInst findPortInst(NodeInst mos, String name) {
        Iterator<PortInst> it = mos.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = it.next();
            if (!pi.getPortProto().getName().contains(name)) continue;
            return pi;
        }
        assert (false);
        return null;
    }

    private void mos(PortInst[] botDiffs, PortInst[] topDiffs, double y, ProtoPlan plan, Cell cell) {
        PortInst poly;
        double POLY_CONT_HEIGHT = plan.vddWidth + 1.0;
        double x = plan.leftWellContX;
        PortInst leftCont = poly = LayoutLib.newNodeInst(this.tech.p1m1(), x, y, 10.0, POLY_CONT_HEIGHT, 0.0, cell).getOnlyPortInst();
        Export e = Export.newInstance(cell, poly, "vdd_" + this.vddNum++);
        e.setCharacteristic(FillCell.VDD_CHARACTERISTIC);
        for (int i = 0; i < plan.numMosX; ++i) {
            NodeInst mos = LayoutLib.newNodeInst(this.tech.nmos(), x += plan.mosPitchX / 2.0, y, plan.gateWidth, plan.gateLength, 0.0, cell);
            G.noExtendArc(this.tech.p1(), POLY_CONT_HEIGHT, poly, this.findPortInst(mos, "poly-left"));
            PortInst polyR = LayoutLib.newNodeInst(this.tech.p1m1(), x += plan.mosPitchX / 2.0, y, 10.0, POLY_CONT_HEIGHT, 0.0, cell).getOnlyPortInst();
            G.noExtendArc(this.tech.m1(), plan.vddWidth, poly, polyR);
            poly = polyR;
            G.noExtendArc(this.tech.p1(), POLY_CONT_HEIGHT, poly, this.findPortInst(mos, "poly-right"));
            botDiffs[i] = this.findPortInst(mos, "diff-bottom");
            topDiffs[i] = this.findPortInst(mos, "diff-top");
        }
        PortInst rightCont = poly;
        x = -plan.protoWidth / 2.0 + plan.vddWidth / 2.0;
        PortInst pi = LayoutLib.newNodeInst(this.tech.m1pin(), x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        LayoutLib.newArcInst(this.tech.m1(), plan.vddWidth, pi, leftCont);
        x = plan.protoWidth / 2.0 - plan.vddWidth / 2.0;
        pi = LayoutLib.newNodeInst(this.tech.m1pin(), x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        LayoutLib.newArcInst(this.tech.m1(), plan.vddWidth, pi, rightCont);
    }

    double roundToHalfLambda(double x) {
        return Math.rint(x * 2.0) / 2.0;
    }

    private void newDiffArc(PortInst p1, PortInst p2) {
        EPoint p1P = p1.getCenter();
        double x = p1P.getX();
        double y1 = this.roundToHalfLambda(p1P.getY());
        double y2 = this.roundToHalfLambda(LayoutLib.roundCenterY(p2));
        LayoutLib.newArcInst(this.tech.ndiff(), Double.POSITIVE_INFINITY, p1, x, y1, p2, x, y2);
    }

    private void connectDiffs(PortInst[] a, PortInst[] b) {
        for (int i = 0; i < a.length; ++i) {
            this.newDiffArc(a[i], b[i]);
        }
    }

    public CapCellMosis(Library lib, CapFloorplan instPlan, TechType t) {
        this.plan = new ProtoPlan(instPlan, t);
        this.tech = t;
        PortInst[] botDiffs = new PortInst[this.plan.numMosX];
        PortInst[] topDiffs = new PortInst[this.plan.numMosX];
        this.cell = Cell.newInstance(lib, "fillCap{lay}");
        double y = this.plan.botWellContY;
        PortInst[] lastCont = this.diffCont(y, this.plan, this.cell);
        for (int i = 0; i < this.plan.numMosY; ++i) {
            this.mos(botDiffs, topDiffs, y += this.plan.mosPitchY / 2.0, this.plan, this.cell);
            this.connectDiffs(lastCont, botDiffs);
            lastCont = this.diffCont(y += this.plan.mosPitchY / 2.0, this.plan, this.cell);
            this.connectDiffs(topDiffs, lastCont);
        }
        LayoutLib.newNodeInst(t.pwell(), 0.0, 0.0, this.plan.protoWidth, this.plan.protoHeight, 0.0, this.cell);
    }

    public int numVdd() {
        return this.plan.numMosY;
    }

    public int numGnd() {
        return this.plan.numMosY + 1;
    }

    public double getVddWidth() {
        return this.plan.vddWidth;
    }

    public double getGndWidth() {
        return this.plan.gndWidth;
    }

    private static class ProtoPlan {
        private final double MAX_MOS_WIDTH = 40.0;
        private final double SEL_WIDTH_OF_PWM1;
        private final double SEL_TO_MOS;
        public final double protoWidth;
        public final double protoHeight;
        public final double vddWidth = 9.0;
        public final double gndWidth = 4.0;
        public final double vddGndSpace = 3.0;
        public final double gateWidth;
        public final int numMosX;
        public final double mosPitchX;
        public final double leftWellContX;
        public final double gateLength;
        public final int numMosY;
        public final double mosPitchY;
        public final double botWellContY;

        public ProtoPlan(CapFloorplan instPlan, TechType tech) {
            this.SEL_WIDTH_OF_PWM1 = tech.getWellContWidth() + tech.selectSurroundDiffInWellContact() * 2.0;
            this.SEL_TO_MOS = tech.selectSurroundDiffAlongGateInTrans();
            this.protoWidth = instPlan.horizontal ? instPlan.cellWidth : instPlan.cellHeight;
            this.protoHeight = instPlan.horizontal ? instPlan.cellHeight : instPlan.cellWidth;
            this.mosPitchY = 19.0;
            this.gateLength = this.mosPitchY - 4.0 - 2.0;
            this.numMosY = (int)Math.floor((this.protoHeight - tech.getWellWidth()) / this.mosPitchY);
            this.botWellContY = (double)(-this.numMosY) * this.mosPitchY / 2.0;
            double cellEdgeToDiffContCenter = tech.getWellSurroundDiffInWellContact() + tech.getDiffContWidth() / 2.0;
            double polyContWidth = Math.floor(this.gateLength / tech.getP1M1Width()) * tech.getP1M1Width();
            double cellEdgeToPolyContCenter = tech.getP1ToP1Space() / 2.0 + polyContWidth / 2.0;
            double cellEdgeToContCenter = Math.max(cellEdgeToDiffContCenter, cellEdgeToPolyContCenter);
            double availForCap = this.protoWidth - 2.0 * cellEdgeToContCenter;
            double numMosD = availForCap / (40.0 + this.SEL_WIDTH_OF_PWM1 + 2.0 * this.SEL_TO_MOS);
            this.numMosX = (int)Math.ceil(numMosD);
            Job.error(this.numMosX < 1, "not enough space for cap cell. Increase template size.");
            double mosWidth1 = availForCap / (double)this.numMosX - this.SEL_WIDTH_OF_PWM1 - 2.0 * this.SEL_TO_MOS;
            this.gateWidth = Math.floor(mosWidth1);
            this.mosPitchX = this.gateWidth + this.SEL_WIDTH_OF_PWM1 + 2.0 * this.SEL_TO_MOS;
            this.leftWellContX = (double)(-this.numMosX) * this.mosPitchX / 2.0;
        }
    }
}

