/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ExitableBlock;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpVisitor;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Keyword;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.expr.TryExp;
import gnu.kawa.functions.AppendValues;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.functions.ConstantFunction0;
import gnu.kawa.functions.Convert;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.MakePromise;
import gnu.kawa.functions.Map;
import gnu.kawa.functions.Not;
import gnu.kawa.functions.NumberCompare;
import gnu.kawa.functions.NumberPredicate;
import gnu.kawa.functions.ValuesMap;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.reflect.CompileReflect;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.LazyType;
import gnu.kawa.reflect.SlotGet;
import gnu.lists.LList;
import gnu.mapping.Namespace;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.WrongArguments;
import gnu.math.IntNum;
import kawa.standard.Scheme;
import kawa.standard.SchemeCompilation;

public class CompileMisc
implements Inlineable {
    static final int CONVERT = 2;
    static final int NOT = 3;
    static final int EQ = 4;
    static final int NUMBER_COMPARE = 5;
    static final int NUMBER_PREDICATE = 6;
    int code;
    Procedure proc;
    static ClassType typeType;
    static Method coerceMethod;
    public static final ClassType typeContinuation;

    public CompileMisc(Procedure proc, int code) {
        this.proc = proc;
        this.code = code;
    }

    public static CompileMisc forConvert(Object proc) {
        return new CompileMisc((Procedure)proc, 2);
    }

    public static CompileMisc forNot(Object proc) {
        return new CompileMisc((Procedure)proc, 3);
    }

    public static CompileMisc forEq(Object proc) {
        return new CompileMisc((Procedure)proc, 4);
    }

    public static CompileMisc forNumberCompare(Object proc) {
        return new CompileMisc((Procedure)proc, 5);
    }

    public static CompileMisc forNumberPredicate(Object proc) {
        return new CompileMisc((Procedure)proc, 6);
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        switch (this.code) {
            case 2: {
                CompileMisc.compileConvert((Convert)this.proc, exp, comp, target);
                return;
            }
            case 3: {
                this.compileNot((Not)this.proc, exp, comp, target);
                return;
            }
            case 4: {
                CompileMisc.compileEq(exp.getArgs(), comp, target, ((IsEq)this.proc).language);
                return;
            }
            case 5: {
                CompileMisc.compileNumberCompare((NumberCompare)this.proc, exp, comp, target);
                return;
            }
            case 6: {
                CompileMisc.compileNumberPredicate((NumberPredicate)this.proc, exp, comp, target);
                return;
            }
        }
        throw new Error();
    }

    public static Expression validateApplyConstantFunction0(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        exp.visitArgs(visitor);
        int nargs = exp.getArgCount();
        if (nargs != 0 && visitor != null) {
            String message = WrongArguments.checkArgCount(proc, nargs);
            return visitor.noteError(message);
        }
        return ((ConstantFunction0)proc).constant;
    }

    public static Expression validateApplyConvert(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        Compilation comp = visitor.getCompilation();
        Language language = comp.getLanguage();
        Expression[] args = exp.getArgs();
        if (args.length == 2) {
            args[0] = visitor.visit(args[0], null);
            Type type = language.getTypeFor(args[0]);
            if (type instanceof Type) {
                args[0] = new QuoteExp(type);
                args[1] = visitor.visit(args[1], type);
                CompileReflect.checkKnownClass(type, comp);
                exp.setType(type);
                return exp;
            }
        }
        exp.visitArgs(visitor);
        return exp;
    }

    public static Expression validateApplySimpleBoolean(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        exp.visitArgs(visitor);
        exp.setType(visitor.getCompilation().getLanguage().getTypeFor(Boolean.TYPE));
        return exp.inlineIfConstant(proc, visitor);
    }

    public static Expression validateApplyFormat(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        exp.visitArgs(visitor);
        Type retType = Type.objectType;
        Expression[] args = exp.getArgs();
        if (args.length > 0) {
            ClassType typeFormat = ClassType.make("gnu.kawa.functions.Format");
            Object f = args[0].valueIfConstant();
            Type ftype = args[0].getType();
            if (f == Boolean.FALSE || ftype.isSubtype(LangObjType.stringType)) {
                int skip = f == Boolean.FALSE ? 1 : 0;
                Expression[] xargs = new Expression[args.length + 1 - skip];
                xargs[0] = new QuoteExp(0, Type.intType);
                System.arraycopy(args, skip, xargs, 1, xargs.length - 1);
                ApplyExp ae = new ApplyExp(typeFormat.getDeclaredMethod("formatToString", 2), xargs);
                ae.setType(Type.javalangStringType);
                return ae;
            }
            if (f == Boolean.TRUE || ftype.isSubtype(ClassType.make("java.io.Writer"))) {
                if (f == Boolean.TRUE) {
                    Expression[] xargs = new Expression[args.length];
                    xargs[0] = QuoteExp.nullExp;
                    System.arraycopy(args, 1, xargs, 1, args.length - 1);
                    args = xargs;
                }
                ApplyExp ae = new ApplyExp(typeFormat.getDeclaredMethod("formatToWriter", 3), args);
                ae.setType(Type.voidType);
                return ae;
            }
            if (ftype.isSubtype(ClassType.make("java.io.OutputStream"))) {
                retType = Type.voidType;
            }
        }
        exp.setType(retType);
        return null;
    }

    public static Expression validateApplyAppendValues(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        exp.visitArgs(visitor);
        Expression[] args = exp.getArgs();
        if (args.length == 1) {
            return args[0];
        }
        if (args.length == 0) {
            return QuoteExp.voidExp;
        }
        Expression folded = exp.inlineIfConstant(proc, visitor);
        if (folded != exp) {
            return folded;
        }
        return exp;
    }

    public static Expression validateApplyMakeProcedure(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        exp.visitArgs(visitor);
        Expression[] args = exp.getArgs();
        int alen = args.length;
        Expression method = null;
        int countMethods = 0;
        String name = null;
        for (int i = 0; i < alen; ++i) {
            Object key;
            Expression arg = args[i];
            if (arg instanceof QuoteExp && (key = ((QuoteExp)arg).getValue()) instanceof Keyword) {
                String keyword = ((Keyword)key).getName();
                Expression next = args[++i];
                if (keyword == "name") {
                    if (!(next instanceof QuoteExp)) continue;
                    name = ((QuoteExp)next).getValue().toString();
                    continue;
                }
                if (keyword != "method") continue;
                ++countMethods;
                method = next;
                continue;
            }
            ++countMethods;
            method = arg;
        }
        if (countMethods == 1 && method instanceof LambdaExp) {
            LambdaExp lexp = (LambdaExp)method;
            for (int i = 0; i < alen; ++i) {
                Object key;
                Expression arg = args[i];
                if (!(arg instanceof QuoteExp) || !((key = ((QuoteExp)arg).getValue()) instanceof Keyword)) continue;
                String keyword = ((Keyword)key).getName();
                Expression next = args[++i];
                if (keyword == "name") {
                    lexp.setName(name);
                    continue;
                }
                if (keyword == "method") continue;
                lexp.setProperty(Namespace.EmptyNamespace.getSymbol(keyword), next);
            }
            return method;
        }
        return exp;
    }

    public static Expression validateApplyValuesMap(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        exp.visitArgs(visitor);
        LambdaExp lexp = ValuesMap.canInline(exp, (ValuesMap)proc);
        if (lexp != null) {
            lexp.setInlineOnly(true);
            lexp.returnContinuation = exp;
            lexp.inlineHome = visitor.getCurrentLambda();
        }
        return exp;
    }

    public static void compileConvert(Convert proc, ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        if (args.length != 2) {
            throw new Error("wrong number of arguments to " + proc.getName());
        }
        CodeAttr code = comp.getCode();
        Type type = Scheme.getTypeValue(args[0]);
        if (type != null) {
            args[1].compile(comp, Target.pushValue(type));
            if (code.reachableHere()) {
                target.compileFromStack(comp, type);
            }
        } else {
            if (typeType == null) {
                typeType = ClassType.make("gnu.bytecode.Type");
            }
            if (coerceMethod == null) {
                coerceMethod = typeType.addMethod("coerceFromObject", Compilation.apply1args, Type.pointer_type, 1);
            }
            args[0].compile(comp, LangObjType.typeClassType);
            args[1].compile(comp, Target.pushObject);
            code.emitInvokeVirtual(coerceMethod);
            target.compileFromStack(comp, Type.pointer_type);
        }
    }

    public void compileNot(Not proc, ApplyExp exp, Compilation comp, Target target) {
        Expression arg = exp.getArgs()[0];
        Language language = proc.language;
        if (target instanceof ConditionalTarget) {
            ConditionalTarget ctarget = (ConditionalTarget)target;
            ConditionalTarget sub_target = new ConditionalTarget(ctarget.ifFalse, ctarget.ifTrue, language);
            sub_target.trueBranchComesFirst = !ctarget.trueBranchComesFirst;
            arg.compile(comp, sub_target);
            return;
        }
        CodeAttr code = comp.getCode();
        Type type = target.getType();
        if (target instanceof StackTarget && type.getSignature().charAt(0) == 'Z') {
            arg.compile(comp, target);
            code.emitNot(target.getType());
        } else {
            QuoteExp trueExp = QuoteExp.getInstance(language.booleanObject(true));
            QuoteExp falseExp = QuoteExp.getInstance(language.booleanObject(false));
            IfExp.compile(arg, falseExp, trueExp, comp, target);
        }
    }

    public static void compileEq(Expression[] args, Compilation comp, Target target, Language language) {
        CodeAttr code = comp.getCode();
        args[0].compile(comp, Target.pushObject);
        args[1].compile(comp, Target.pushObject);
        if (target instanceof ConditionalTarget) {
            ConditionalTarget ctarget = (ConditionalTarget)target;
            if (ctarget.trueBranchComesFirst) {
                code.emitGotoIfNE(ctarget.ifFalse);
            } else {
                code.emitGotoIfEq(ctarget.ifTrue);
            }
            ctarget.emitGotoFirstBranch(code);
        } else {
            Type type;
            code.emitIfEq();
            if (target.getType() instanceof ClassType) {
                Object trueValue = language.booleanObject(true);
                Object falseValue = language.booleanObject(false);
                comp.compileConstant(trueValue, Target.pushObject);
                code.emitElse();
                comp.compileConstant(falseValue, Target.pushObject);
                type = trueValue instanceof Boolean && falseValue instanceof Boolean ? Compilation.scmBooleanType : Type.pointer_type;
            } else {
                code.emitPushInt(1);
                code.emitElse();
                code.emitPushInt(0);
                type = language.getTypeFor(Boolean.TYPE);
            }
            code.emitFi();
            target.compileFromStack(comp, type);
        }
    }

    public static void compileNumberCompare(NumberCompare proc, ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        if (args.length == 2) {
            Expression arg0 = args[0];
            Expression arg1 = args[1];
            int kind0 = CompileMisc.classifyForNumCompare(arg0);
            int kind1 = CompileMisc.classifyForNumCompare(arg1);
            CodeAttr code = comp.getCode();
            if (kind0 > 0 && kind1 > 0 && kind0 <= 10 && kind1 <= 10 && (kind0 != 6 || kind1 != 6)) {
                Object value;
                int opcode;
                Label label1;
                if (!(target instanceof ConditionalTarget)) {
                    IfExp.compile(exp, QuoteExp.trueExp, QuoteExp.falseExp, comp, target);
                    return;
                }
                int mask = proc.flags;
                if (mask == 1) {
                    mask = 20;
                }
                if (kind0 <= 4 && kind1 <= 4 && (kind0 > 2 || kind1 > 2)) {
                    Type[] ctypes = new Type[2];
                    ctypes[0] = Arithmetic.typeIntNum;
                    if (kind1 <= 2) {
                        ctypes[1] = Type.longType;
                    } else if (kind0 <= 2 && (arg0 instanceof QuoteExp || arg1 instanceof QuoteExp || arg0 instanceof ReferenceExp || arg1 instanceof ReferenceExp)) {
                        ctypes[1] = Type.longType;
                        args = new Expression[]{arg1, arg0};
                        if (mask != 8 && mask != 20) {
                            mask ^= 0x14;
                        }
                    } else {
                        ctypes[1] = Arithmetic.typeIntNum;
                    }
                    Method cmeth = Arithmetic.typeIntNum.getMethod("compare", ctypes);
                    PrimProcedure compare = new PrimProcedure(cmeth);
                    arg0 = new ApplyExp(compare, args);
                    arg1 = new QuoteExp(IntNum.zero());
                    kind1 = 1;
                    kind0 = 1;
                }
                PrimType commonType = kind0 <= 1 && kind1 <= 1 ? Type.intType : (kind0 <= 2 && kind1 <= 2 ? Type.longType : Type.doubleType);
                StackTarget subTarget = new StackTarget(commonType);
                ConditionalTarget ctarget = (ConditionalTarget)target;
                if (arg0 instanceof QuoteExp && !(arg1 instanceof QuoteExp)) {
                    Expression tmp = arg1;
                    arg1 = arg0;
                    arg0 = tmp;
                    if (mask != 8 && mask != 20) {
                        mask ^= 0x14;
                    }
                }
                Label label = label1 = ctarget.trueBranchComesFirst ? ctarget.ifFalse : ctarget.ifTrue;
                if (ctarget.trueBranchComesFirst) {
                    mask ^= 0x1C;
                }
                switch (mask) {
                    case 16: {
                        opcode = 157;
                        break;
                    }
                    case 8: {
                        opcode = 153;
                        break;
                    }
                    case 4: {
                        opcode = 155;
                        break;
                    }
                    case 20: {
                        opcode = 154;
                        break;
                    }
                    case 24: {
                        opcode = 156;
                        break;
                    }
                    case 12: {
                        opcode = 158;
                        break;
                    }
                    default: {
                        opcode = 0;
                    }
                }
                arg0.compile(comp, subTarget);
                if (kind0 <= 1 && kind1 <= 1 && arg1 instanceof QuoteExp && (value = ((QuoteExp)arg1).getValue()) instanceof IntNum && ((IntNum)value).isZero()) {
                    code.emitGotoIfCompare1(label1, opcode);
                } else {
                    arg1.compile(comp, subTarget);
                    code.emitGotoIfCompare2(label1, opcode);
                }
                ctarget.emitGotoFirstBranch(code);
                return;
            }
        }
        ApplyExp.compile(exp, comp, target);
    }

    static int classifyForNumCompare(Expression exp) {
        Object value;
        Type type = exp.getType();
        int kind = Arithmetic.classifyType(type);
        if (kind == 4 && exp instanceof QuoteExp && (value = ((QuoteExp)exp).getValue()) instanceof IntNum) {
            int ilength = ((IntNum)value).intLength();
            if (ilength < 32) {
                return 1;
            }
            if (ilength < 64) {
                return 2;
            }
        }
        return kind;
    }

    public static void compileNumberPredicate(NumberPredicate proc, ApplyExp exp, Compilation comp, Target target) {
        Expression arg0;
        int kind;
        Expression[] args = exp.getArgs();
        int op = proc.op;
        if (args.length == 1 && (op == 1 || op == 2) && (kind = Arithmetic.classifyType((arg0 = args[0]).getType())) <= 4) {
            PrimType wtype = Type.intType;
            Target wtarget = StackTarget.getInstance(wtype);
            CodeAttr code = comp.getCode();
            if (op == 2) {
                code.emitPushInt(1);
            }
            arg0.compile(comp, wtarget);
            code.emitPushInt(1);
            code.emitAnd();
            if (op == 2) {
                code.emitSub(Type.intType);
            }
            target.compileFromStack(comp, Type.booleanType);
            return;
        }
        ApplyExp.compile(exp, comp, target);
    }

    public static Expression validateApplyCallCC(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        LambdaExp lexp = CompileMisc.canInlineCallCC(exp);
        if (lexp != null) {
            lexp.setInlineOnly(true);
            lexp.returnContinuation = exp;
            lexp.inlineHome = visitor.getCurrentLambda();
            Declaration contDecl = lexp.firstDecl();
            if (!contDecl.getFlag(8192L)) {
                contDecl.setType(typeContinuation);
            }
        }
        exp.visitArgs(visitor);
        return exp;
    }

    public static void compileCallCC(ApplyExp exp, Compilation comp, Target target, Procedure proc) {
        LambdaExp lambda = CompileMisc.canInlineCallCC(exp);
        if (lambda == null) {
            ApplyExp.compile(exp, comp, target);
            return;
        }
        CodeAttr code = comp.getCode();
        Declaration param = lambda.firstDecl();
        if (param.isSimple() && !param.getCanRead() && !param.getCanWrite()) {
            ExitableBlock bl;
            CompileTimeContinuation contProxy = new CompileTimeContinuation();
            Type rtype = target instanceof StackTarget ? target.getType() : null;
            boolean runFinallyBlocks = ExitThroughFinallyChecker.check(param, lambda.body);
            contProxy.exitableBlock = bl = code.startExitableBlock(rtype, runFinallyBlocks);
            contProxy.blockTarget = target;
            param.setValue(new QuoteExp(contProxy));
            lambda.body.compile(comp, target);
            code.endExitableBlock();
            return;
        }
        Scope sc = code.pushScope();
        Variable contVar = sc.addVariable(code, typeContinuation, null);
        Declaration contDecl = new Declaration(contVar);
        code.emitNew(typeContinuation);
        code.emitDup(typeContinuation);
        comp.loadCallContext();
        code.emitInvokeSpecial(typeContinuation.getDeclaredMethod("<init>", 1));
        code.emitStore(contVar);
        code.emitTryStart(false, target instanceof IgnoreTarget || target instanceof ConsumerTarget ? null : Type.objectType);
        ApplyExp app = new ApplyExp(lambda, new ReferenceExp(contDecl));
        app.compile(comp, target);
        if (code.reachableHere()) {
            code.emitLoad(contVar);
            code.emitPushInt(1);
            code.emitPutField(typeContinuation.getField("invoked"));
        }
        code.emitTryEnd();
        code.emitCatchStart(null);
        code.emitLoad(contVar);
        if (target instanceof ConsumerTarget) {
            comp.loadCallContext();
            Method handleMethod = typeContinuation.getDeclaredMethod("handleException$X", 3);
            code.emitInvokeStatic(handleMethod);
        } else {
            Method handleMethod = typeContinuation.getDeclaredMethod("handleException", 2);
            code.emitInvokeStatic(handleMethod);
            target.compileFromStack(comp, Type.objectType);
        }
        code.emitCatchEnd();
        code.emitTryCatchEnd();
        code.popScope();
    }

    private static LambdaExp canInlineCallCC(ApplyExp exp) {
        Expression arg0;
        Expression[] args = exp.getArgs();
        if (args.length == 1 && (arg0 = args[0]) instanceof LambdaExp) {
            LambdaExp lexp = (LambdaExp)arg0;
            if (lexp.min_args == 1 && lexp.max_args == 1 && !lexp.firstDecl().getCanWrite()) {
                return lexp;
            }
        }
        return null;
    }

    public static Expression validateApplyMap(ApplyExp exp, InlineCalls visitor, Type required, Procedure xproc) {
        Map mproc = (Map)xproc;
        boolean collect = mproc.collect;
        Expression[] args = exp.getArgs();
        int nargs = args.length;
        if (nargs < 2) {
            return exp;
        }
        Type r = InlineCalls.typeForCalledFunction(args[0]);
        if (r != null) {
            for (int i = 1; i < nargs; ++i) {
                visitor.visit(args[i], null);
            }
            visitor.visit(args[0], r);
        } else {
            exp.visitArgs(visitor);
        }
        --nargs;
        Expression proc = args[0];
        boolean procSafeForMultipleEvaluation = !proc.side_effects();
        Compilation comp = visitor.getCompilation();
        comp.letStart();
        Declaration procDecl = comp.letVariable("%proc", Compilation.typeProcedure, proc);
        comp.letStart();
        LambdaExp lexp = new LambdaExp(collect ? nargs + 1 : nargs);
        Declaration loopDecl = comp.letVariable("%loop", null, lexp);
        comp.letEnter();
        comp.letStart();
        Declaration[] largs = new Declaration[nargs];
        Declaration[] pargs = new Declaration[nargs];
        for (int i = 0; i < nargs; ++i) {
            String argName = "arg" + i;
            largs[i] = lexp.addDeclaration(argName);
            pargs[i] = comp.letVariable(argName, Compilation.typePair, new ReferenceExp(largs[i]));
        }
        Declaration resultDecl = collect ? lexp.addDeclaration("result") : null;
        Expression[] doArgs = new Expression[1 + nargs];
        Expression[] recArgs = new Expression[collect ? nargs + 1 : nargs];
        for (int i = 0; i < nargs; ++i) {
            doArgs[i + 1] = visitor.visitApplyOnly(SlotGet.makeGetField(new ReferenceExp(pargs[i]), "car"), null);
            recArgs[i] = visitor.visitApplyOnly(SlotGet.makeGetField(new ReferenceExp(pargs[i]), "cdr"), null);
        }
        if (!procSafeForMultipleEvaluation) {
            proc = new ReferenceExp(procDecl);
        }
        doArgs[0] = proc;
        ReferenceExp applyFunc = new ReferenceExp(SchemeCompilation.applyFieldDecl);
        Expression doit = visitor.visitApplyOnly(new ApplyExp(applyFunc, doArgs), null);
        if (collect) {
            Expression[] consArgs = new Expression[]{doit, new ReferenceExp(resultDecl)};
            recArgs[nargs] = Invoke.makeInvokeStatic(Compilation.typePair, "make", consArgs);
        }
        Expression rec = visitor.visitApplyOnly(new ApplyExp(new ReferenceExp(loopDecl), recArgs), null);
        lexp.body = comp.letDone(collect ? rec : new BeginExp(doit, rec));
        Expression[] initArgs = new Expression[collect ? nargs + 1 : nargs];
        QuoteExp empty = new QuoteExp(LList.Empty);
        int i = nargs;
        while (--i >= 0) {
            Expression[] compArgs = new Expression[]{new ReferenceExp(largs[i]), empty};
            Expression result = collect ? new ReferenceExp(resultDecl) : QuoteExp.voidExp;
            lexp.body = new IfExp(visitor.visitApplyOnly(new ApplyExp(mproc.isEq, compArgs), null), result, lexp.body);
            initArgs[i] = args[i + 1];
        }
        if (collect) {
            initArgs[nargs] = empty;
        }
        Expression body = visitor.visitApplyOnly(new ApplyExp(new ReferenceExp(loopDecl), initArgs), null);
        if (collect) {
            Expression[] reverseArgs = new Expression[]{body};
            body = Invoke.makeInvokeStatic(Compilation.scmListType, "reverseInPlace", reverseArgs);
        }
        LetExp let2 = comp.letDone(body);
        LetExp let1 = comp.letDone(let2);
        if (procSafeForMultipleEvaluation) {
            return let2;
        }
        return let1;
    }

    public static Expression validateApplyMakePromise(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        Expression[] args = exp.getArgs();
        if (args.length == 1 && args[0] instanceof LambdaExp) {
            Type bodyRequired;
            boolean forceValueIfPromise;
            boolean bl = forceValueIfPromise = proc == MakePromise.makeLazy;
            if (required instanceof LazyType) {
                Type valueType = ((LazyType)required).getValueType();
                bodyRequired = forceValueIfPromise ? LazyType.getLazyType(valueType) : valueType;
            } else {
                bodyRequired = null;
            }
            LambdaExp lexp = (LambdaExp)args[0];
            lexp.body = visitor.visit(lexp.body, bodyRequired);
            args[0] = visitor.visit((Expression)lexp, null);
            Type rtype = lexp.getReturnType();
            if (forceValueIfPromise) {
                rtype = rtype instanceof LazyType ? ((LazyType)rtype).getValueType() : Type.objectType;
            }
            LazyType type = LazyType.getLazyType(rtype);
            String mname = forceValueIfPromise ? "makePromiseLazy" : "makePromise";
            Method meth = ClassType.make("gnu.kawa.functions.MakePromise").getDeclaredMethod(mname, 1);
            PrimProcedure mproc = new PrimProcedure(meth);
            mproc.setReturnType(type);
            exp = new ApplyExp(mproc, args);
            exp.setType(type);
        } else {
            exp.visitArgs(visitor);
        }
        return exp;
    }

    static {
        typeContinuation = ClassType.make("kawa.lang.Continuation");
    }

    static class CompileTimeContinuation
    extends ProcedureN
    implements Inlineable {
        Target blockTarget;
        ExitableBlock exitableBlock;

        CompileTimeContinuation() {
        }

        public Object applyN(Object[] args) throws Throwable {
            throw new Error("internal error");
        }

        public void compile(ApplyExp exp, Compilation comp, Target target) {
            Type typeNeeded;
            CodeAttr code = comp.getCode();
            Expression[] args = exp.getArgs();
            int nargs = args.length;
            boolean noStack = this.blockTarget instanceof IgnoreTarget || this.blockTarget instanceof ConsumerTarget;
            Type type = typeNeeded = noStack ? null : target.getType();
            if (noStack || nargs == 1) {
                for (int i = 0; i < nargs; ++i) {
                    args[i].compileWithPosition(comp, this.blockTarget);
                }
            } else {
                AppendValues app = AppendValues.appendValues;
                app.compile(new ApplyExp(app, args), comp, this.blockTarget);
            }
            this.exitableBlock.exit();
        }

        public Type getReturnType(Expression[] args) {
            return Type.neverReturnsType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExitThroughFinallyChecker
    extends ExpVisitor<Expression, TryExp> {
        Declaration decl;

        ExitThroughFinallyChecker() {
        }

        public static boolean check(Declaration decl, Expression body) {
            ExitThroughFinallyChecker visitor = new ExitThroughFinallyChecker();
            visitor.decl = decl;
            visitor.visit(body, null);
            return visitor.exitValue != null;
        }

        @Override
        protected Expression defaultValue(Expression r, TryExp d) {
            return r;
        }

        @Override
        protected Expression visitReferenceExp(ReferenceExp exp, TryExp currentTry) {
            if (this.decl == exp.getBinding() && currentTry != null) {
                this.exitValue = Boolean.TRUE;
            }
            return exp;
        }

        @Override
        protected Expression visitTryExp(TryExp exp, TryExp currentTry) {
            this.visitExpression(exp, exp.getFinallyClause() != null ? exp : currentTry);
            return exp;
        }
    }
}

