/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.ParameterizedType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.functions.IsEqv;
import gnu.kawa.functions.SetArrayExp;
import gnu.kawa.functions.SetListExp;
import gnu.kawa.functions.Setter;
import gnu.kawa.reflect.ArrayGet;
import gnu.kawa.reflect.CompileReflect;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.LazyType;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.text.Char;
import java.io.Externalizable;

public class CompilationHelpers {
    static final ClassType setterType = ClassType.make("gnu.kawa.functions.Setter");
    static final Field setterField = setterType.getDeclaredField("setter");
    public static final Declaration setterDecl = new Declaration((Object)"setter", setterField);

    public static boolean maybeLazy(Expression exp) {
        if (exp instanceof QuoteExp) {
            return false;
        }
        return LazyType.maybeLazy(exp.getType());
    }

    private static boolean nonNumeric(Expression exp) {
        if (exp instanceof QuoteExp) {
            Object value = ((QuoteExp)exp).getValue();
            return !(value instanceof Number) && !(value instanceof Char) && !(value instanceof Symbol);
        }
        return false;
    }

    public static Expression validateApplyToArgs(ApplyExp exp, InlineCalls visitor, Type required, Procedure applyToArgs) {
        Expression[] args = exp.getArgs();
        int nargs = args.length - 1;
        if (nargs >= 0) {
            Expression proc = args[0];
            if (!proc.getFlag(1)) {
                Declaration decl;
                Expression pval = proc;
                if (proc instanceof ReferenceExp && (decl = ((ReferenceExp)proc).getBinding()) != null) {
                    pval = decl.getValue();
                }
                if (pval != null && pval.getClass() == LambdaExp.class) {
                    Expression[] rargs = new Expression[nargs];
                    System.arraycopy(args, 1, rargs, 0, nargs);
                    exp.setFuncArgs(proc, rargs);
                    return visitor.visit((Expression)exp, required);
                }
                args[0] = proc = visitor.visit(proc, InlineCalls.typeForCalledFunction(proc));
            }
            Type ptype = proc.getType().getRealType();
            Compilation comp = visitor.getCompilation();
            Language language = comp.getLanguage();
            if (ptype.isSubtype(Compilation.typeProcedure)) {
                Expression[] rargs = new Expression[nargs];
                System.arraycopy(args, 1, rargs, 0, nargs);
                exp.setFuncArgs(proc, rargs);
                return proc.validateApply(exp, visitor, required, null);
            }
            ClassType ctype = ptype instanceof ClassType ? (ClassType)ptype : (ptype instanceof ParameterizedType ? ((ParameterizedType)ptype).getRawType() : null);
            Expression result = null;
            if (CompileReflect.checkKnownClass(ptype, comp) >= 0) {
                if (ptype.isSubtype(Compilation.typeType) || language.getTypeFor(proc, false) != null) {
                    result = exp.setFuncArgs(Invoke.make, args);
                } else if (ptype instanceof ArrayType) {
                    Type elementType = ((ArrayType)ptype).getComponentType();
                    exp.setFuncArgs(new ArrayGet(elementType), args);
                    result = exp;
                } else if (ctype != null && ctype.isSubclass(Compilation.typeList) && nargs == 1) {
                    Method get = ctype.getMethod("get", new Type[]{Type.intType});
                    ParameterizedType prtype = ptype instanceof ParameterizedType ? (ParameterizedType)ptype : null;
                    result = exp.setFuncArgs(new PrimProcedure(get, 'V', language, prtype), args);
                }
            }
            if (result != null) {
                result.setLine(exp);
                return visitor.visitApplyOnly((ApplyExp)result, required);
            }
        }
        exp.visitArgs(visitor);
        return exp;
    }

    public static Expression validateSetter(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        exp.visitArgs(visitor);
        Expression[] args = exp.getArgs();
        if (args.length == 1) {
            Object value;
            Declaration decl;
            ClassType ctype;
            Expression arg = args[0];
            Type argType = arg.getType();
            if (argType instanceof ArrayType) {
                return new SetArrayExp(arg, (ArrayType)argType);
            }
            if (argType instanceof ClassType && (ctype = (ClassType)argType).isSubclass(Compilation.typeList)) {
                if (exp instanceof SetListExp) {
                    return exp;
                }
                return new SetListExp(exp.getFunction(), args);
            }
            if (arg instanceof ReferenceExp && (decl = ((ReferenceExp)arg).getBinding()) != null) {
                arg = decl.getValue();
            }
            if (arg instanceof QuoteExp && (value = ((QuoteExp)arg).getValue()) instanceof Procedure) {
                Procedure setter;
                Procedure pvalue = (Procedure)value;
                try {
                    setter = pvalue.getSetter();
                }
                catch (RuntimeException ex) {
                    setter = null;
                    visitor.getCompilation().error('w', "procedure '" + pvalue.getName() + "' has no setter");
                }
                if (setter != null) {
                    if (setter instanceof Externalizable) {
                        return new QuoteExp(setter);
                    }
                    Declaration decl2 = Declaration.getDeclaration(setter);
                    if (decl2 != null) {
                        return new ReferenceExp(decl2);
                    }
                }
            }
        }
        return exp;
    }

    public static Expression validateIsEqv(ApplyExp exp, InlineCalls visitor, Type required, Procedure proc) {
        exp.visitArgs(visitor);
        Expression[] args = exp.getArgs();
        if ((CompilationHelpers.nonNumeric(args[0]) || CompilationHelpers.nonNumeric(args[1])) && !CompilationHelpers.maybeLazy(args[0]) && !CompilationHelpers.maybeLazy(args[1])) {
            return new ApplyExp(((IsEqv)proc).isEq, args);
        }
        return exp;
    }

    static {
        setterDecl.noteValue(new QuoteExp(Setter.setter));
    }
}

