/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.ConsumerWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class PrintConsumer
extends PrintWriter
implements Appendable,
Consumer {
    public PrintConsumer(Consumer out, boolean autoFlush) {
        super(out instanceof Writer ? (Writer)((Object)out) : new ConsumerWriter(out), autoFlush);
    }

    public PrintConsumer(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public PrintConsumer(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public PrintConsumer(Writer out) {
        super(out);
    }

    protected void startNumber() {
    }

    protected void endNumber() {
    }

    public PrintConsumer append(char c) {
        this.print(c);
        return this;
    }

    public PrintConsumer append(CharSequence csq) {
        if (csq == null) {
            csq = "null";
        }
        this.append(csq, 0, csq.length());
        return this;
    }

    public PrintConsumer append(CharSequence csq, int start, int end) {
        if (csq == null) {
            csq = "null";
        }
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    public void write(CharSequence csq, int start, int end) {
        if (csq instanceof String) {
            this.write((String)csq, start, end);
        } else {
            for (int i = start; i < end; ++i) {
                this.write(csq.charAt(i));
            }
        }
    }

    public void writeBoolean(boolean v) {
        this.print(v);
    }

    public void writeFloat(float v) {
        this.startNumber();
        this.print(v);
        this.endNumber();
    }

    public void writeDouble(double v) {
        this.startNumber();
        this.print(v);
        this.endNumber();
    }

    public void writeInt(int v) {
        this.startNumber();
        this.print(v);
        this.endNumber();
    }

    public void writeLong(long v) {
        this.startNumber();
        this.print(v);
        this.endNumber();
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(Object type) {
    }

    public void endElement() {
    }

    public void startAttribute(Object attrType) {
    }

    public void endAttribute() {
    }

    public void writeObject(Object v) {
        this.print(v);
    }

    public boolean ignoring() {
        return false;
    }
}

