/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.SeriesTarget;
import gnu.expr.Target;

public class ConsumerTarget
extends Target {
    Variable consumer;
    boolean isContextTarget;

    public ConsumerTarget(Variable variable) {
        this.consumer = variable;
    }

    public Variable getConsumerVariable() {
        return this.consumer;
    }

    public final boolean isContextTarget() {
        return this.isContextTarget;
    }

    public static Target makeContextTarget(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        compilation.loadCallContext();
        codeAttr.emitGetField(Compilation.typeCallContext.getDeclaredField("consumer"));
        Scope scope = codeAttr.getCurrentScope();
        Variable variable = scope.addVariable(codeAttr, Compilation.typeConsumer, "$result");
        codeAttr.emitStore(variable);
        ConsumerTarget consumerTarget = new ConsumerTarget(variable);
        consumerTarget.isContextTarget = true;
        return consumerTarget;
    }

    public static void compileUsingConsumer(Expression expression, Compilation compilation, Target target) {
        if (target instanceof ConsumerTarget || target instanceof IgnoreTarget) {
            expression.compile(compilation, target);
        } else {
            ClassType classType = Compilation.typeValues;
            ConsumerTarget.compileUsingConsumer(expression, compilation, target, classType.getDeclaredMethod("make", 0), classType.getDeclaredMethod("canonicalize", 0));
        }
    }

    public static void compileUsingConsumer(Expression expression, Compilation compilation, Target target, Method method, Method method2) {
        Type type;
        Object object2;
        CodeAttr codeAttr = compilation.getCode();
        Scope scope = codeAttr.pushScope();
        if (method.getName() == "<init>") {
            object2 = method.getDeclaringClass();
            type = object2;
            codeAttr.emitNew((ClassType)object2);
            codeAttr.emitDup(type);
            codeAttr.emitInvoke(method);
        } else {
            type = method.getReturnType();
            codeAttr.emitInvokeStatic(method);
        }
        object2 = scope.addVariable(codeAttr, type, null);
        ConsumerTarget consumerTarget = new ConsumerTarget((Variable)object2);
        codeAttr.emitStore((Variable)object2);
        expression.compile(compilation, consumerTarget);
        codeAttr.emitLoad((Variable)object2);
        if (method2 != null) {
            codeAttr.emitInvoke(method2);
        }
        codeAttr.popScope();
        target.compileFromStack(compilation, method2 == null ? type : method2.getReturnType());
    }

    public void compileFromStack(Compilation compilation, Type type) {
        CodeAttr codeAttr = compilation.getCode();
        String string = null;
        Method method = null;
        boolean bl = false;
        if (type instanceof PrimType) {
            char c = type.getSignature().charAt(0);
            switch (c) {
                case 'B': 
                case 'I': 
                case 'S': {
                    string = "writeInt";
                    break;
                }
                case 'J': {
                    string = "writeLong";
                    bl = true;
                    break;
                }
                case 'F': {
                    string = "writeFloat";
                    break;
                }
                case 'D': {
                    string = "writeDouble";
                    bl = true;
                    break;
                }
                case 'C': {
                    string = "writeChar";
                    break;
                }
                case 'Z': {
                    string = "writeBoolean";
                    break;
                }
                case 'V': {
                    return;
                }
            }
        } else if (SeriesTarget.isSingletonType(type)) {
            string = "writeObject";
        } else {
            method = Compilation.typeValues.getDeclaredMethod("writeValues", 2);
            codeAttr.emitLoad(this.consumer);
            codeAttr.emitInvokeStatic(method);
            return;
        }
        if (bl) {
            codeAttr.pushScope();
            Variable variable = codeAttr.addLocal(type);
            codeAttr.emitStore(variable);
            codeAttr.emitLoad(this.consumer);
            codeAttr.emitLoad(variable);
            codeAttr.popScope();
        } else {
            codeAttr.emitLoad(this.consumer);
            codeAttr.emitSwap();
        }
        if (method == null && string != null) {
            method = Compilation.typeConsumer.getDeclaredMethod(string, 1);
        }
        if (method != null) {
            codeAttr.emitInvokeInterface(method);
        }
    }

    public Type getType() {
        return Compilation.scmSequenceType;
    }
}

