/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.RunnableModule;
import gnu.kawa.io.OutPort;
import gnu.kawa.io.WriterManager;
import gnu.kawa.util.ExitCalled;
import gnu.lists.Consumer;
import gnu.lists.VoidConsumer;
import gnu.mapping.CallContext;
import gnu.mapping.WrappedException;
import kawa.Shell;

public abstract class ModuleBody
implements RunnableModule {
    protected boolean runDone;
    private static boolean mainPrintValues;
    private static int exitCounter;

    @Override
    public boolean checkRunDone(boolean value) {
        boolean tmp = this.runDone;
        this.runDone = value;
        return tmp;
    }

    @Override
    public void run(CallContext ctx) throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ModuleBody moduleBody = this;
        synchronized (moduleBody) {
            if (this.runDone) {
                return;
            }
            this.runDone = true;
        }
        ModuleBody.run(this, VoidConsumer.instance);
    }

    public static void runToVoid(RunnableModule mod) {
        ModuleBody.run(mod, VoidConsumer.instance);
    }

    public void run(Consumer out) {
        ModuleBody.run(this, out);
    }

    public static void run(RunnableModule mod, Consumer out) {
        Throwable th;
        CallContext ctx = CallContext.getInstance();
        Consumer save = ctx.consumer;
        ctx.consumer = out;
        try {
            mod.run(ctx);
            th = null;
        }
        catch (Throwable ex) {
            th = ex;
        }
        ModuleBody.runCleanup(ctx, th, save);
    }

    public static void runCleanup(CallContext ctx, Throwable th, Consumer save) {
        if (th == null) {
            try {
                ctx.runUntilDone();
            }
            catch (Throwable ex) {
                th = ex;
            }
        }
        ctx.consumer = save;
        if (th != null) {
            WrappedException.rethrow(th);
        }
    }

    public static boolean getMainPrintValues() {
        return mainPrintValues;
    }

    public static void setMainPrintValues(boolean value) {
        mainPrintValues = value;
    }

    public static synchronized void exitIncrement() {
        if (exitCounter == 0) {
            ++exitCounter;
        }
        ++exitCounter;
    }

    public static synchronized void exitDecrement() {
        int counter = exitCounter;
        if (counter > 0) {
            if (--counter == 0) {
                System.exit(0);
            } else {
                exitCounter = counter;
            }
        }
    }

    public final void runAsMain() {
        ModuleBody.runAsMain(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAsMain(RunnableModule module) {
        boolean registered = WriterManager.instance.registerShutdownHook();
        try {
            ExitCalled.push();
            CallContext ctx = CallContext.getInstance();
            if (ModuleBody.getMainPrintValues()) {
                OutPort out = OutPort.outDefault();
                ctx.consumer = Shell.getOutputConsumer(out);
                module.run(ctx);
                ctx.runUntilDone();
                out.freshLine();
            } else {
                ctx.consumer = VoidConsumer.instance;
                module.run(ctx);
                ctx.runUntilDone();
            }
            if (!registered) {
                OutPort.runCleanups();
            }
            ModuleBody.exitDecrement();
        }
        catch (ExitCalled ex) {
            throw ex;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            OutPort.runCleanups();
            System.exit(-1);
        }
        finally {
            ExitCalled.pop();
        }
    }
}

