/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NodeUsage {
    private NodeProto protoType;
    private Cell parent;
    private List insts;

    NodeUsage(NodeProto protoType, Cell parent) {
        this.protoType = protoType;
        this.parent = parent;
        this.insts = new ArrayList();
    }

    void addInst(NodeInst ni) {
        this.insts.add(ni);
    }

    void removeInst(NodeInst ni) {
        this.insts.remove(ni);
    }

    public int checkAndRepair() {
        int error = 0;
        for (int i = 0; i < this.insts.size(); ++i) {
            NodeInst ni = (NodeInst)this.insts.get(i);
            if (ni.getNodeUsage() == this && ni.getProto() == this.protoType && ni.getParent() == this.parent) continue;
            System.out.println("Error in NodeUsage.chechAndRepair");
            ++error;
        }
        return error;
    }

    public NodeProto getProto() {
        return this.protoType;
    }

    public Cell getParent() {
        return this.parent;
    }

    public final NodeInst getInst(int i) {
        return (NodeInst)this.insts.get(i);
    }

    public Iterator getInsts() {
        return this.insts.iterator();
    }

    public int getNumInsts() {
        return this.insts.size();
    }

    public boolean contains(NodeInst ni) {
        return this.insts.contains(ni);
    }

    public boolean isEmpty() {
        return this.insts.size() == 0;
    }

    public boolean isIconOfParent() {
        return this.protoType.isIconOf(this.parent);
    }

    public boolean isIcon() {
        return this.protoType.isIcon();
    }

    public String toString() {
        return "NodeUsage of " + this.protoType + " in " + this.parent.describe();
    }
}

