/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.prototype;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class NodeProto
extends ElectricObject {
    private static final int NODESHRINK = 1;
    private static final int WANTNEXPAND = 2;
    private static final int NFUNCTION = 508;
    private static final int NFUNCTIONSH = 2;
    private static final int ARCSWIPE = 512;
    private static final int NSQUARE = 1024;
    private static final int HOLDSTRACE = 2048;
    private static final int CANBEZEROSIZE = 4096;
    private static final int WIPEON1OR2 = 8192;
    private static final int LOCKEDPRIM = 16384;
    private static final int NEDGESELECT = 32768;
    private static final int ARCSHRINK = 65536;
    private static final int NNOTUSED = 524288;
    private static final int NPLOCKED = 0x100000;
    private static final int NPILOCKED = 0x200000;
    private static final int INCELLLIBRARY = 0x400000;
    private static final int TECEDITCELL = 0x800000;
    private static FlagSet.Generator flagGenerator = new FlagSet.Generator("NodeProto");
    protected String protoName;
    protected Technology tech;
    private List ports = new ArrayList();
    private List usagesOf = new ArrayList();
    protected int userBits;
    private Function function = Function.UNKNOWN;
    private int tempInt;
    private Object tempObj = null;
    private int flagBits;

    protected NodeProto() {
    }

    public void addPort(PortProto port, Collection oldPortInsts) {
        this.checkChanging();
        port.setPortIndex(this.ports.size());
        this.ports.add(port);
        if (oldPortInsts != null) {
            Iterator it = oldPortInsts.iterator();
            while (it.hasNext()) {
                PortInst pi = (PortInst)it.next();
                pi.getNodeInst().linkPortInst(pi);
            }
        } else {
            Iterator it = this.getInstancesOf();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                ni.addPortInst(port);
            }
        }
    }

    public Collection removePort(PortProto port) {
        int portIndex;
        this.checkChanging();
        this.ports.remove(portIndex);
        for (portIndex = port.getPortIndex(); portIndex < this.ports.size(); ++portIndex) {
            ((PortProto)this.ports.get(portIndex)).setPortIndex(portIndex);
        }
        ArrayList<PortInst> portInsts = new ArrayList<PortInst>();
        Iterator it = this.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            portInsts.add(ni.removePortInst(port));
        }
        port.setPortIndex(-1);
        return portInsts;
    }

    public void addUsageOf(NodeUsage nu) {
        this.usagesOf.add(nu);
    }

    public void removeUsageOf(NodeUsage nu) {
        this.usagesOf.remove(nu);
    }

    boolean containsPort(PortProto port) {
        return this.ports.contains(port);
    }

    protected int checkAndRepair() {
        int errorCount = 0;
        for (int i = 0; i < this.ports.size(); ++i) {
            PortProto pp = (PortProto)this.ports.get(i);
            if (pp.getPortIndex() == i) continue;
            System.out.println(this + ", " + pp + " has wrong index");
            ++errorCount;
        }
        return errorCount;
    }

    public void setCanShrink() {
        this.checkChanging();
        this.userBits |= 1;
    }

    public void clearCanShrink() {
        this.checkChanging();
        this.userBits &= 0xFFFFFFFE;
    }

    public boolean canShrink() {
        return (this.userBits & 1) != 0;
    }

    public void setWantExpanded() {
        this.checkChanging();
        this.userBits |= 2;
    }

    public void clearWantExpanded() {
        this.checkChanging();
        this.userBits &= 0xFFFFFFFD;
    }

    public boolean isWantExpanded() {
        return (this.userBits & 2) != 0;
    }

    public void setFunction(Function function) {
        this.checkChanging();
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public Function getGroupFunction() {
        if (this.function == Function.TRANMOS || this.function == Function.TRA4NMOS || this.function == Function.TRAPMOS || this.function == Function.TRA4PMOS || this.function == Function.TRADMOS || this.function == Function.TRA4DMOS || this.function == Function.TRANPN || this.function == Function.TRA4NPN || this.function == Function.TRAPNP || this.function == Function.TRA4PNP || this.function == Function.TRANJFET || this.function == Function.TRA4NJFET || this.function == Function.TRAPJFET || this.function == Function.TRA4PJFET || this.function == Function.TRADMES || this.function == Function.TRA4DMES || this.function == Function.TRAEMES || this.function == Function.TRA4EMES || this.function == Function.TRANS4) {
            return Function.TRANS;
        }
        if (this.function == Function.RESIST || this.function == Function.CAPAC || this.function == Function.ECAPAC || this.function == Function.DIODE || this.function == Function.DIODEZ || this.function == Function.INDUCT) {
            return Function.INDUCT;
        }
        if (this.function == Function.CCVS || this.function == Function.CCCS || this.function == Function.VCVS || this.function == Function.VCCS || this.function == Function.TLINE) {
            return Function.TLINE;
        }
        if (this.function == Function.BASE || this.function == Function.EMIT || this.function == Function.COLLECT) {
            return Function.COLLECT;
        }
        if (this.function == Function.BUFFER || this.function == Function.GATEAND || this.function == Function.GATEOR || this.function == Function.MUX || this.function == Function.GATEXOR) {
            return Function.GATEXOR;
        }
        if (this.function == Function.CONPOWER || this.function == Function.CONGROUND) {
            return Function.CONGROUND;
        }
        if (this.function == Function.METER || this.function == Function.SOURCE) {
            return Function.SOURCE;
        }
        if (this.function == Function.SUBSTRATE || this.function == Function.WELL) {
            return Function.WELL;
        }
        return this.function;
    }

    public void setArcsWipe() {
        this.checkChanging();
        this.userBits |= 0x200;
    }

    public void clearArcsWipe() {
        this.checkChanging();
        this.userBits &= 0xFFFFFDFF;
    }

    public boolean isArcsWipe() {
        return (this.userBits & 0x200) != 0;
    }

    public void setSquare() {
        this.checkChanging();
        this.userBits |= 0x400;
    }

    public void clearSquare() {
        this.checkChanging();
        this.userBits &= 0xFFFFFBFF;
    }

    public boolean isSquare() {
        return (this.userBits & 0x400) != 0;
    }

    public void setHoldsOutline() {
        this.checkChanging();
        this.userBits |= 0x800;
    }

    public void clearHoldsOutline() {
        this.checkChanging();
        this.userBits &= 0xFFFFF7FF;
    }

    public boolean isHoldsOutline() {
        return (this.userBits & 0x800) != 0;
    }

    public void setCanBeZeroSize() {
        this.checkChanging();
        this.userBits |= 0x1000;
    }

    public void clearCanBeZeroSize() {
        this.checkChanging();
        this.userBits &= 0xFFFFEFFF;
    }

    public boolean isCanBeZeroSize() {
        return (this.userBits & 0x1000) != 0;
    }

    public void setWipeOn1or2() {
        this.checkChanging();
        this.userBits |= 0x2000;
    }

    public void clearWipeOn1or2() {
        this.checkChanging();
        this.userBits &= 0xFFFFDFFF;
    }

    public boolean isWipeOn1or2() {
        return (this.userBits & 0x2000) != 0;
    }

    public void setLockedPrim() {
        this.checkChanging();
        this.userBits |= 0x4000;
    }

    public void clearLockedPrim() {
        this.checkChanging();
        this.userBits &= 0xFFFFBFFF;
    }

    public boolean isLockedPrim() {
        return (this.userBits & 0x4000) != 0;
    }

    public void setEdgeSelect() {
        this.checkChanging();
        this.userBits |= 0x8000;
    }

    public void clearEdgeSelect() {
        this.checkChanging();
        this.userBits &= 0xFFFF7FFF;
    }

    public boolean isEdgeSelect() {
        return (this.userBits & 0x8000) != 0;
    }

    public void setArcsShrink() {
        this.checkChanging();
        this.userBits |= 0x10000;
    }

    public void clearArcsShrink() {
        this.checkChanging();
        this.userBits &= 0xFFFEFFFF;
    }

    public boolean isArcsShrink() {
        return (this.userBits & 0x10000) != 0;
    }

    public void setAllLocked() {
        this.checkChanging();
        this.userBits |= 0x100000;
    }

    public void clearAllLocked() {
        this.checkChanging();
        this.userBits &= 0xFFEFFFFF;
    }

    public boolean isAllLocked() {
        return (this.userBits & 0x100000) != 0;
    }

    public void setInstancesLocked() {
        this.checkChanging();
        this.userBits |= 0x200000;
    }

    public void clearInstancesLocked() {
        this.checkChanging();
        this.userBits &= 0xFFDFFFFF;
    }

    public boolean isInstancesLocked() {
        return (this.userBits & 0x200000) != 0;
    }

    public void setNotUsed() {
        this.checkChanging();
        this.userBits |= 0x80000;
    }

    public void clearNotUsed() {
        this.checkChanging();
        this.userBits &= 0xFFF7FFFF;
    }

    public boolean isNotUsed() {
        return (this.userBits & 0x80000) != 0;
    }

    public void setInCellLibrary() {
        this.checkChanging();
        this.userBits |= 0x400000;
    }

    public void clearInCellLibrary() {
        this.checkChanging();
        this.userBits &= 0xFFBFFFFF;
    }

    public boolean isInCellLibrary() {
        return (this.userBits & 0x400000) != 0;
    }

    public void setInTechnologyLibrary() {
        this.checkChanging();
        this.userBits |= 0x800000;
    }

    public void clearInTechnologyLibrary() {
        this.checkChanging();
        this.userBits &= 0xFF7FFFFF;
    }

    public boolean isInTechnologyLibrary() {
        return (this.userBits & 0x800000) != 0;
    }

    public boolean isMultiPartIcon() {
        return false;
    }

    public static FlagSet getFlagSet(int numBits) {
        return FlagSet.getFlagSet(flagGenerator, numBits);
    }

    public void setBit(FlagSet set) {
        this.flagBits |= set.getMask();
    }

    public void clearBit(FlagSet set) {
        this.flagBits &= set.getUnmask();
    }

    public boolean isBit(FlagSet set) {
        return (this.flagBits & set.getMask()) != 0;
    }

    public void setTempInt(int tempInt) {
        this.checkChanging();
        this.tempInt = tempInt;
    }

    public int getTempInt() {
        return this.tempInt;
    }

    public void setTempObj(Object tempObj) {
        this.checkChanging();
        this.tempObj = tempObj;
    }

    public Object getTempObj() {
        return this.tempObj;
    }

    public int getDefPlacementAngle() {
        int defAngle = User.getNewNodeRotation();
        Variable var = this.getVar(User.PLACEMENT_ANGLE, Integer.class);
        if (var != null) {
            Integer rot = (Integer)var.getObject();
            defAngle = rot;
        }
        return defAngle;
    }

    public abstract double getDefWidth();

    public abstract double getDefHeight();

    public abstract SizeOffset getProtoSizeOffset();

    public abstract Technology getTechnology();

    public void setTechnology(Technology tech) {
        if (this instanceof Cell) {
            this.tech = tech;
        }
    }

    public PortProto connectsTo(ArcProto arc) {
        for (int i = 0; i < this.ports.size(); ++i) {
            PortProto pp = (PortProto)this.ports.get(i);
            if (!pp.connectsTo(arc)) continue;
            return pp;
        }
        return null;
    }

    public PortProto findPortProto(String name) {
        if (name == null) {
            return null;
        }
        return this.findPortProto(Name.findName(name));
    }

    public PortProto findPortProto(Name name) {
        if (name == null) {
            return null;
        }
        name = name.lowerCase();
        for (int i = 0; i < this.ports.size(); ++i) {
            PortProto pp = (PortProto)this.ports.get(i);
            if (pp.getNameKey().lowerCase() != name) continue;
            return pp;
        }
        return null;
    }

    public static NodeProto findNodeProto(String line) {
        NodeProto np;
        String withoutPrefix;
        Technology tech = Technology.getCurrent();
        Library lib = Library.getCurrent();
        boolean saidtech = false;
        boolean saidlib = false;
        int colon = line.indexOf(58);
        if (colon == -1) {
            withoutPrefix = line;
        } else {
            Library l;
            String prefix = line.substring(0, colon);
            Technology t = Technology.findTechnology(prefix);
            if (t != null) {
                tech = t;
                saidtech = true;
            }
            if ((l = Library.findLibrary(prefix)) != null) {
                lib = l;
                saidlib = true;
            }
            withoutPrefix = line.substring(colon + 1);
        }
        if (!saidlib && (np = tech.findNodeProto(withoutPrefix)) != null) {
            return np;
        }
        if (!saidtech && (np = lib.findNodeProto(withoutPrefix)) != null) {
            return np;
        }
        return null;
    }

    public Iterator getPorts() {
        return this.ports.iterator();
    }

    public List getPortsList() {
        return this.ports;
    }

    public int getNumPorts() {
        return this.ports.size();
    }

    public final PortProto getPort(int portIndex) {
        return (PortProto)this.ports.get(portIndex);
    }

    public boolean hasIsolatedPorts() {
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!this.getPort(i).isIsolated()) continue;
            return true;
        }
        return false;
    }

    public Iterator getInstancesOf() {
        return new NodeInstsIterator();
    }

    public Iterator getUsagesOf() {
        return this.usagesOf.iterator();
    }

    public boolean isIcon() {
        return false;
    }

    public boolean isIconOf(Cell cell) {
        return false;
    }

    public abstract String describe();

    public String getName() {
        return this.protoName;
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        String name = key.getName();
        return name.equals("NET_last_good_ncc") || name.equals("NET_last_good_ncc_facet") || name.equals("SIM_window_signal_order");
    }

    public int lowLevelGetUserbits() {
        return this.userBits;
    }

    public void lowLevelSetUserbits(int userBits) {
        this.checkChanging();
        this.userBits = userBits;
    }

    public String toString() {
        return "NodeProto " + this.describe();
    }

    private class NodeInstsIterator
    implements Iterator {
        private Iterator uit;
        private NodeUsage nu;
        private int i;
        private int n;

        NodeInstsIterator() {
            this.uit = NodeProto.this.getUsagesOf();
            this.n = 0;
            this.i = 0;
            while (this.i >= this.n && this.uit.hasNext()) {
                this.nu = (NodeUsage)this.uit.next();
                this.n = this.nu.getNumInsts();
            }
        }

        public boolean hasNext() {
            return this.i < this.n;
        }

        public Object next() {
            if (this.i >= this.n) {
                this.uit.next();
            }
            NodeInst ni = this.nu.getInst(this.i);
            ++this.i;
            while (this.i >= this.n && this.uit.hasNext()) {
                this.nu = (NodeUsage)this.uit.next();
                this.n = this.nu.getNumInsts();
                this.i = 0;
            }
            return ni;
        }

        public void remove() {
            throw new UnsupportedOperationException("NodeInstsIterator.remove()");
        }
    }

    public static class Function {
        private final String name;
        private final String shortName;
        private final Name basename;
        private final String constantName;
        public static final Function UNKNOWN = new Function("unknown", "node", "NPUNKNOWN");
        public static final Function PIN = new Function("pin", "pin", "NPPIN");
        public static final Function CONTACT = new Function("contact", "contact", "NPCONTACT");
        public static final Function NODE = new Function("pure-layer-node", "plnode", "NPNODE");
        public static final Function CONNECT = new Function("connection", "conn", "NPCONNECT");
        public static final Function TRANMOS = new Function("nMOS-transistor", "nmos", "NPTRANMOS");
        public static final Function TRADMOS = new Function("DMOS-transistor", "dmos", "NPTRADMOS");
        public static final Function TRAPMOS = new Function("pMOS-transistor", "pmos", "NPTRAPMOS");
        public static final Function TRANPN = new Function("NPN-transistor", "npn", "NPTRANPN");
        public static final Function TRAPNP = new Function("PNP-transistor", "pnp", "NPTRAPNP");
        public static final Function TRANJFET = new Function("n-type-JFET-transistor", "njfet", "NPTRANJFET");
        public static final Function TRAPJFET = new Function("p-type-JFET-transistor", "pjfet", "NPTRAPJFET");
        public static final Function TRADMES = new Function("depletion-mesfet", "dmes", "NPTRADMES");
        public static final Function TRAEMES = new Function("enhancement-mesfet", "emes", "NPTRAEMES");
        public static final Function TRANSREF = new Function("prototype-defined-transistor", "tref", "NPTRANSREF");
        public static final Function TRANS = new Function("transistor", "trans", "NPTRANS");
        public static final Function TRA4NMOS = new Function("4-port-nMOS-transistor", "nmos4p", "NPTRA4NMOS");
        public static final Function TRA4DMOS = new Function("4-port-DMOS-transistor", "dmos4p", "NPTRA4DMOS");
        public static final Function TRA4PMOS = new Function("4-port-pMOS-transistor", "pmos4p", "NPTRA4PMOS");
        public static final Function TRA4NPN = new Function("4-port-NPN-transistor", "npn4p", "NPTRA4NPN");
        public static final Function TRA4PNP = new Function("4-port-PNP-transistor", "pnp4p", "NPTRA4PNP");
        public static final Function TRA4NJFET = new Function("4-port-n-type-JFET-transistor", "njfet4p", "NPTRA4NJFET");
        public static final Function TRA4PJFET = new Function("4-port-p-type-JFET-transistor", "pjfet4p", "NPTRA4PJFET");
        public static final Function TRA4DMES = new Function("4-port-depletion-mesfet", "dmes4p", "NPTRA4DMES");
        public static final Function TRA4EMES = new Function("4-port-enhancement-mesfet", "emes4p", "NPTRA4EMES");
        public static final Function TRANS4 = new Function("4-port-transistor", "trans4p", "NPTRANS4");
        public static final Function RESIST = new Function("resistor", "res", "NPRESIST");
        public static final Function CAPAC = new Function("capacitor", "cap", "NPCAPAC");
        public static final Function ECAPAC = new Function("electrolytic-capacitor", "ecap", "NPECAPAC");
        public static final Function DIODE = new Function("diode", "diode", "NPDIODE");
        public static final Function DIODEZ = new Function("zener-diode", "zdiode", "NPDIODEZ");
        public static final Function INDUCT = new Function("inductor", "ind", "NPINDUCT");
        public static final Function METER = new Function("meter", "meter", "NPMETER");
        public static final Function BASE = new Function("base", "base", "NPBASE");
        public static final Function EMIT = new Function("emitter", "emit", "NPEMIT");
        public static final Function COLLECT = new Function("collector", "coll", "NPCOLLECT");
        public static final Function BUFFER = new Function("buffer", "buf", "NPBUFFER");
        public static final Function GATEAND = new Function("AND-gate", "and", "NPGATEAND");
        public static final Function GATEOR = new Function("OR-gate", "or", "NPGATEOR");
        public static final Function GATEXOR = new Function("XOR-gate", "xor", "NPGATEXOR");
        public static final Function FLIPFLOPRSMS = new Function("flip-flop-RS-MS", "ffRSms", "NPFLIPFLOP");
        public static final Function FLIPFLOPRSP = new Function("flip-flop-RS-P", "ffRSp", "NPFLIPFLOP");
        public static final Function FLIPFLOPRSN = new Function("flip-flop-RS-N", "ffRSn", "NPFLIPFLOP");
        public static final Function FLIPFLOPJKMS = new Function("flip-flop-JK-MS", "ffJKms", "NPFLIPFLOP");
        public static final Function FLIPFLOPJKP = new Function("flip-flop-JK-P", "ffJKp", "NPFLIPFLOP");
        public static final Function FLIPFLOPJKN = new Function("flip-flop-JK-N", "ffJKn", "NPFLIPFLOP");
        public static final Function FLIPFLOPDMS = new Function("flip-flop-D-MS", "ffDms", "NPFLIPFLOP");
        public static final Function FLIPFLOPDP = new Function("flip-flop-D-P", "ffDp", "NPFLIPFLOP");
        public static final Function FLIPFLOPDN = new Function("flip-flop-D-N", "ffDn", "NPFLIPFLOP");
        public static final Function FLIPFLOPTMS = new Function("flip-flop-T-MS", "ffTms", "NPFLIPFLOP");
        public static final Function FLIPFLOPTP = new Function("flip-flop-T-P", "ffTp", "NPFLIPFLOP");
        public static final Function FLIPFLOPTN = new Function("flip-flop-T-N", "ffTn", "NPFLIPFLOP");
        public static final Function MUX = new Function("multiplexor", "mux", "NPMUX");
        public static final Function CONPOWER = new Function("power", "pwr", "NPCONPOWER");
        public static final Function CONGROUND = new Function("ground", "gnd", "NPCONGROUND");
        public static final Function SOURCE = new Function("source", "source", "NPSOURCE");
        public static final Function SUBSTRATE = new Function("substrate", "substr", "NPSUBSTRATE");
        public static final Function WELL = new Function("well", "well", "NPWELL");
        public static final Function ART = new Function("artwork", "art", "NPART");
        public static final Function ARRAY = new Function("array", "array", "NPARRAY");
        public static final Function ALIGN = new Function("align", "align", "NPALIGN");
        public static final Function CCVS = new Function("ccvs", "ccvs", "NPCCVS");
        public static final Function CCCS = new Function("cccs", "cccs", "NPCCCS");
        public static final Function VCVS = new Function("vcvs", "vcvs", "NPVCVS");
        public static final Function VCCS = new Function("vccs", "vccs", "NPVCCS");
        public static final Function TLINE = new Function("transmission-line", "transm", "NPTLINE");

        private Function(String name, String shortName, String constantName) {
            this.name = name;
            this.shortName = shortName;
            this.constantName = constantName;
            this.basename = Name.findName(shortName + '@').getBasename();
        }

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.shortName;
        }

        public Name getBasename() {
            return this.basename;
        }

        public boolean isTransistor() {
            return this == TRANMOS || this == TRAPMOS || this == TRADMOS || this == TRA4NMOS || this == TRA4PMOS || this == TRA4DMOS || this == TRANPN || this == TRAPNP || this == TRANJFET || this == TRAPJFET || this == TRAEMES || this == TRADMES || this == TRA4NPN || this == TRA4PNP || this == TRA4NJFET || this == TRA4PJFET || this == TRA4EMES || this == TRA4DMES || this == TRANSREF || this == TRANS || this == TRANS4;
        }

        public boolean isFlipFlop() {
            return this == FLIPFLOPRSMS || this == FLIPFLOPRSP || this == FLIPFLOPRSN || this == FLIPFLOPJKMS || this == FLIPFLOPJKP || this == FLIPFLOPJKN || this == FLIPFLOPDMS || this == FLIPFLOPDP || this == FLIPFLOPDN || this == FLIPFLOPTMS || this == FLIPFLOPTP || this == FLIPFLOPTN;
        }

        public String toString() {
            return this.name;
        }
    }
}

