/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Strategy {
    protected int depth;
    public NccGlobals globals;
    private Date theStartDate = null;
    public static final Integer CODE_ERROR = null;
    public static final Integer CODE_NO_CHANGE = new Integer(0);

    protected int getDepth() {
        return this.depth;
    }

    public void error(boolean pred, String msg) {
        this.globals.error(pred, msg);
    }

    protected Strategy(NccGlobals globals) {
        this.globals = globals;
    }

    public LeafList doFor(RecordList r) {
        ++this.depth;
        LeafList out = r.apply(this);
        --this.depth;
        return out;
    }

    public LeafList doFor(EquivRecord rr) {
        ++this.depth;
        LeafList out = rr.apply(this);
        --this.depth;
        return out;
    }

    public HashMap doFor(Circuit c) {
        ++this.depth;
        HashMap codeToNetObjs = c.apply(this);
        --this.depth;
        return codeToNetObjs;
    }

    public Integer doFor(NetObject n) {
        return CODE_NO_CHANGE;
    }

    EquivRecord pickAnOffspring(Integer code, LeafList g, String label) {
        int value = code;
        Iterator it = g.iterator();
        while (it.hasNext()) {
            EquivRecord er = (EquivRecord)it.next();
            if (er.getValue() != value) continue;
            this.globals.println(label + ": " + er.nameString());
            return er;
        }
        this.globals.println(label + ": none");
        return null;
    }

    protected String offspringStats(LeafList el) {
        int retired = 0;
        int mismatched = 0;
        int active = 0;
        Iterator it = el.iterator();
        while (it.hasNext()) {
            EquivRecord er = (EquivRecord)it.next();
            if (er.isMismatched()) {
                ++mismatched;
                continue;
            }
            if (er.isRetired()) {
                ++retired;
                continue;
            }
            ++active;
        }
        String msg = "  offspring counts: #retired=" + retired + " #mismatched=" + mismatched + " #active=" + active;
        return msg;
    }

    protected void startTime(String strat, String target) {
        this.theStartDate = new Date();
        this.globals.println(this.globals.passNumber++ + " " + strat + " doing " + target);
    }

    protected long elapsedTime() {
        Date d = new Date();
        long time = d.getTime() - this.theStartDate.getTime();
        this.globals.println(" took " + time + " miliseconds");
        this.globals.println();
        return time;
    }
}

