/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.Router;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VerticalRoute {
    private RouteElement startRE;
    private RouteElement endRE;
    private SpecifiedRoute specifiedRoute;
    private List allSpecifiedRoutes;
    private ArcProto startArc;
    private ArcProto endArc;
    private ElectricObject startObj;
    private ElectricObject endObj;
    private int searchNumber;
    private static final int SEARCHLIMIT = 100;
    private static final boolean DEBUG = false;
    private static final boolean DEBUGSEARCH = false;

    public VerticalRoute(RouteElement startRE, RouteElement endRE) {
        this.startRE = startRE;
        this.endRE = endRE;
        this.specifiedRoute = null;
        this.allSpecifiedRoutes = null;
        this.startArc = null;
        this.endArc = null;
    }

    public VerticalRoute(RouteElement startRE, ArcProto endArc) {
        this.startRE = startRE;
        this.endRE = null;
        this.specifiedRoute = null;
        this.allSpecifiedRoutes = null;
        this.startArc = null;
        this.endArc = endArc;
    }

    public VerticalRoute(ArcProto startArc, ArcProto endArc) {
        this.startRE = null;
        this.endRE = null;
        this.specifiedRoute = null;
        this.allSpecifiedRoutes = null;
        this.startArc = startArc;
        this.endArc = endArc;
    }

    public ArcProto getStartArc() {
        return this.startArc;
    }

    public ArcProto getEndArc() {
        return this.endArc;
    }

    public boolean specifyRoute() {
        ArcProto[] startArcs = null;
        ArcProto[] endArcs = null;
        if (this.startRE != null) {
            PortProto startPort = this.startRE.getPortProto();
            if (startPort != null) {
                startArcs = startPort.getBasePort().getConnections();
                this.startObj = startPort;
            } else {
                startArcs = new ArcProto[]{this.startRE.getArcProto()};
                this.startObj = this.startRE.getArcProto();
            }
        } else if (this.startArc != null) {
            startArcs = new ArcProto[]{this.startArc};
        }
        if (this.endRE != null) {
            PortProto endPort = this.endRE.getPortProto();
            if (endPort != null) {
                endArcs = endPort.getBasePort().getConnections();
                this.endObj = endPort;
            } else {
                endArcs = new ArcProto[]{this.endRE.getArcProto()};
                this.endObj = this.endRE.getArcProto();
            }
        } else if (this.endArc != null) {
            endArcs = new ArcProto[]{this.endArc};
        }
        startArcs = VerticalRoute.nullBadArcs(startArcs);
        endArcs = VerticalRoute.nullBadArcs(endArcs);
        if (endArcs == null || startArcs == null) {
            System.out.println("VerticalRoute: invalid start or end point");
            return false;
        }
        return this.specifyRoute(startArcs, endArcs);
    }

    private static ArcProto[] nullBadArcs(ArcProto[] arcs) {
        for (int i = 0; i < arcs.length; ++i) {
            if (arcs[i] == Generic.tech.universal_arc) {
                arcs[i] = null;
            }
            if (arcs[i] == Generic.tech.invisible_arc) {
                arcs[i] = null;
            }
            if (arcs[i] == Generic.tech.unrouted_arc) {
                arcs[i] = null;
            }
            if (arcs[i] == null || !arcs[i].isNotUsed()) continue;
            arcs[i] = null;
        }
        return arcs;
    }

    public void buildRoute(Route route, Cell cell, Point2D location) {
        double width;
        if (this.specifiedRoute == null) {
            System.out.println("Error: Trying to build VerticalRoute without a call to specifyRoute() first");
            return;
        }
        if (this.specifiedRoute.size() == 0) {
            return;
        }
        if (this.startRE != null && !route.contains(this.startRE)) {
            route.add(this.startRE);
        }
        if (this.endRE != null && !route.contains(this.endRE)) {
            route.add(this.endRE);
        }
        int arcAngle = 0;
        if (this.startRE != null && this.startRE.getLocation().getX() == location.getX() && this.startRE.getLocation().getY() != location.getY()) {
            arcAngle = 900;
        }
        Route vertRoute = this.buildRoute(cell, location, new Dimension2D.Double(-1.0, -1.0), arcAngle);
        if (this.startRE != null) {
            if (this.startRE.isBisectArcPin() && location.equals(this.startRE.getLocation())) {
                Router.replaceRouteElementArcPin(route, this.startRE, vertRoute.getStart());
                route.remove(this.startRE);
                if (route.getStart() == this.startRE) {
                    route.setStart(vertRoute.getStart());
                }
            } else {
                width = Router.getArcWidthToUse(this.startRE, this.startArc);
                RouteElement arc1 = RouteElement.newArc(cell, this.startArc, width, this.startRE, vertRoute.getStart(), null);
                route.add(arc1);
            }
        }
        if (this.endRE != null) {
            if (this.endRE.isBisectArcPin() && location.equals(this.endRE.getLocation())) {
                Router.replaceRouteElementArcPin(route, this.endRE, vertRoute.getEnd());
                route.remove(this.endRE);
                if (route.getEnd() == this.endRE) {
                    route.setEnd(vertRoute.getEnd());
                }
            } else {
                width = Router.getArcWidthToUse(this.endRE, this.endArc);
                RouteElement arc2 = RouteElement.newArc(cell, this.endArc, width, this.endRE, vertRoute.getEnd(), null);
                route.add(arc2);
            }
        }
        Dimension2D size = Router.getContactSize(vertRoute.getStart(), vertRoute.getEnd());
        Iterator it = vertRoute.iterator();
        while (it.hasNext()) {
            RouteElement re = (RouteElement)it.next();
            re.setNodeSize(size);
            route.add(re);
        }
        route.setEnd(vertRoute.getEnd());
    }

    public Route buildRoute(Cell cell, Point2D location, Dimension2D contactSize, int arcAngle) {
        if (this.specifiedRoute == null) {
            System.out.println("Error: Trying to build VerticalRoute without a call to specifyRoute() first");
            return null;
        }
        Route route = new Route();
        if (this.specifiedRoute.size() == 0) {
            return route;
        }
        PrimitivePort pp = (PrimitivePort)this.specifiedRoute.remove(0);
        RouteElement node = RouteElement.newNode(cell, pp.getParent(), pp, location, contactSize.getWidth(), contactSize.getHeight());
        route.add(node);
        route.setStart(node);
        route.setEnd(node);
        Iterator it = this.specifiedRoute.iterator();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            PrimitivePort port = (PrimitivePort)it.next();
            RouteElement newNode = RouteElement.newNode(cell, port.getParent(), port, location, contactSize.getWidth(), contactSize.getHeight());
            route.add(newNode);
            route.setEnd(newNode);
            double arcWidth = Router.getArcWidthToUse(node, ap);
            RouteElement arc = RouteElement.newArc(cell, ap, arcWidth, node, newNode, null);
            arc.setArcAngle(arcAngle);
            route.add(arc);
            node = newNode;
        }
        return route;
    }

    private boolean specifyRoute(ArcProto[] startArcs, ArcProto[] endArcs) {
        int i;
        this.specifiedRoute = new SpecifiedRoute();
        this.allSpecifiedRoutes = new ArrayList();
        this.startArc = null;
        this.endArc = null;
        for (i = 0; i < startArcs.length; ++i) {
            for (int j = 0; j < endArcs.length; ++j) {
                ArcProto startArc = startArcs[i];
                ArcProto endArc = endArcs[j];
                if (startArc == null || endArc == null) continue;
                this.specifiedRoute.clear();
                this.specifiedRoute.startArc = startArc;
                this.specifiedRoute.endArc = endArc;
                this.searchNumber = 0;
                this.findConnectingPorts(startArc, endArc, "");
            }
        }
        if (this.allSpecifiedRoutes.size() == 0) {
            return false;
        }
        this.specifiedRoute = (SpecifiedRoute)this.allSpecifiedRoutes.get(0);
        for (i = 0; i < this.allSpecifiedRoutes.size(); ++i) {
            SpecifiedRoute r = (SpecifiedRoute)this.allSpecifiedRoutes.get(i);
            if (r.size() >= this.specifiedRoute.size()) continue;
            this.specifiedRoute = r;
        }
        this.allSpecifiedRoutes.clear();
        this.startArc = this.specifiedRoute.startArc;
        this.endArc = this.specifiedRoute.endArc;
        return true;
    }

    private void findConnectingPorts(ArcProto startArc, ArcProto endArc, String ds) {
        PrimitivePort pp;
        if (startArc == endArc) {
            this.saveRoute(this.specifiedRoute);
            return;
        }
        ds = ds + "  ";
        if (this.searchNumber > 100) {
            return;
        }
        ++this.searchNumber;
        Technology tech = startArc.getTechnology();
        Iterator portsIt = tech.getPorts();
        while (portsIt.hasNext()) {
            pp = (PrimitivePort)portsIt.next();
            if (pp.getParent().getFunction() != NodeProto.Function.CONTACT || !pp.connectsTo(startArc) || !pp.connectsTo(endArc)) continue;
            this.specifiedRoute.add(pp);
            this.saveRoute(this.specifiedRoute);
            return;
        }
        portsIt = tech.getPorts();
        while (portsIt.hasNext()) {
            pp = (PrimitivePort)portsIt.next();
            if (pp.getParent().getFunction() != NodeProto.Function.CONTACT || !pp.connectsTo(startArc) || pp == this.startObj || pp == this.endObj || this.specifiedRoute.contains(pp)) continue;
            int prePortSize = this.specifiedRoute.size();
            this.specifiedRoute.add(pp);
            int preArcSize = this.specifiedRoute.size();
            ArcProto[] arcs = pp.getConnections();
            for (int i = 0; i < arcs.length; ++i) {
                ArcProto tryarc = arcs[i];
                if (tryarc == Generic.tech.universal_arc || tryarc == Generic.tech.invisible_arc || tryarc == Generic.tech.unrouted_arc || tryarc.isNotUsed() || tryarc == startArc || tryarc == this.startArc || this.specifiedRoute.contains(tryarc)) continue;
                this.specifiedRoute.add(tryarc);
                this.findConnectingPorts(tryarc, endArc, ds);
                while (this.specifiedRoute.size() > preArcSize) {
                    this.specifiedRoute.remove(this.specifiedRoute.size() - 1);
                }
            }
            while (this.specifiedRoute.size() > prePortSize) {
                this.specifiedRoute.remove(this.specifiedRoute.size() - 1);
            }
        }
    }

    private void saveRoute(SpecifiedRoute route) {
        SpecifiedRoute loggedRoute = new SpecifiedRoute();
        loggedRoute.startArc = route.startArc;
        loggedRoute.endArc = route.endArc;
        loggedRoute.addAll(route);
        this.allSpecifiedRoutes.add(loggedRoute);
    }

    private static class SpecifiedRoute
    extends ArrayList {
        ArcProto startArc;
        ArcProto endArc;

        private SpecifiedRoute() {
        }

        void printRoute() {
            for (int k = 0; k < this.size(); ++k) {
                System.out.println("   " + k + ": " + this.get(k));
            }
        }
    }
}

