/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.PixelDrawing;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.util.Iterator;

public class User
extends Listener {
    public static User tool = new User();
    public static final Variable.Key PLACEMENT_ANGLE = ElectricObject.newKey("USER_placement_angle");
    public static final Variable.Key FRAME_SIZE = ElectricObject.newKey("FACET_schematic_page_size");
    public static final Variable.Key FRAME_COMPANY_NAME = ElectricObject.newKey("USER_drawing_company_name");
    public static final Variable.Key FRAME_DESIGNER_NAME = ElectricObject.newKey("USER_drawing_designer_name");
    public static final Variable.Key FRAME_PROJECT_NAME = ElectricObject.newKey("USER_drawing_project_name");
    private ArcProto currentArcProto = null;
    private NodeProto currentNodeProto = null;
    private static Pref cacheIconGenDrawLeads = Pref.makeBooleanPref("IconGenDrawLeads", User.tool.prefs, true);
    private static Pref cacheIconGenDrawBody = Pref.makeBooleanPref("IconGenDrawBody", User.tool.prefs, true);
    private static Pref cacheIconGenReverseExportOrder = Pref.makeBooleanPref("IconGenReverseExportOrder", User.tool.prefs, false);
    private static Pref cacheIconGenInputSide = Pref.makeIntPref("IconGenInputSide", User.tool.prefs, 0);
    private static Pref cacheIconGenOutputSide = Pref.makeIntPref("IconGenOutputSide", User.tool.prefs, 1);
    private static Pref cacheIconGenBidirSide = Pref.makeIntPref("IconGenBidirSide", User.tool.prefs, 2);
    private static Pref cacheIconGenPowerSide = Pref.makeIntPref("IconGenPowerSide", User.tool.prefs, 3);
    private static Pref cacheIconGenGroundSide = Pref.makeIntPref("IconGenGroundSide", User.tool.prefs, 3);
    private static Pref cacheIconGenClockSide = Pref.makeIntPref("IconGenClockSide", User.tool.prefs, 0);
    private static Pref cacheIconGenExportLocation = Pref.makeIntPref("IconGenExportLocation", User.tool.prefs, 1);
    private static Pref cacheIconGenExportStyle = Pref.makeIntPref("IconGenExportStyle", User.tool.prefs, 0);
    private static Pref cacheIconGenExportTech = Pref.makeIntPref("IconGenExportTech", User.tool.prefs, 0);
    private static Pref cacheIconGenInstanceLocation = Pref.makeIntPref("IconGenInstanceLocation", User.tool.prefs, 0);
    private static Pref cacheIconGenLeadLength = Pref.makeDoublePref("IconGenLeadLength", User.tool.prefs, 2.0);
    private static Pref cacheIconGenLeadSpacing = Pref.makeDoublePref("IconGenLeadSpacing", User.tool.prefs, 2.0);
    private static Pref cachePortDisplayLevel = Pref.makeIntPref("PortDisplayLevel", User.tool.prefs, 0);
    private static Pref cacheExportDisplayLevel = Pref.makeIntPref("ExportDisplayLevel", User.tool.prefs, 0);
    private static Pref cacheMoveNodeWithExport = Pref.makeBooleanPref("MoveNodeWithExport", User.tool.prefs, false);
    private static Pref cacheEasySelectionOfCellInstances = Pref.makeBooleanPref("EasySelectionOfCellInstances", User.tool.prefs, true);
    private static Pref cacheEasySelectionOfAnnotationText = Pref.makeBooleanPref("EasySelectionOfAnnotationText", User.tool.prefs, true);
    private static Pref cacheDraggingMustEncloseObjects = Pref.makeBooleanPref("DraggingMustEncloseObjects", User.tool.prefs, false);
    private static Pref cacheDefGridXSpacing = Pref.makeDoublePref("DefGridXSpacing", User.tool.prefs, 1.0);
    private static Pref cacheDefGridYSpacing = Pref.makeDoublePref("DefGridYSpacing", User.tool.prefs, 1.0);
    private static Pref cacheDefGridXBoldFrequency = Pref.makeIntPref("DefGridXBoldFrequency", User.tool.prefs, 10);
    private static Pref cacheDefGridYBoldFrequency = Pref.makeIntPref("DefGridYBoldFrequency", User.tool.prefs, 10);
    private static Pref cacheShowCursorCoordinates = Pref.makeBooleanPref("ShowCursorCoordinates", User.tool.prefs, true);
    private static Pref cacheAlignmentToGrid = Pref.makeDoublePref("AlignmentToGrid", User.tool.prefs, 1.0);
    private static Pref cacheTextVisibilityNode = Pref.makeBooleanPref("TextVisibilityNode", User.tool.prefs, true);
    private static Pref cacheTextVisibilityArc = Pref.makeBooleanPref("TextVisibilityArc", User.tool.prefs, true);
    private static Pref cacheTextVisibilityPort = Pref.makeBooleanPref("TextVisibilityPort", User.tool.prefs, true);
    private static Pref cacheTextVisibilityExport = Pref.makeBooleanPref("TextVisibilityExport", User.tool.prefs, true);
    private static Pref cacheTextVisibilityAnnotation = Pref.makeBooleanPref("TextVisibilityAnnotation", User.tool.prefs, true);
    private static Pref cacheTextVisibilityInstance = Pref.makeBooleanPref("TextVisibilityInstance", User.tool.prefs, true);
    private static Pref cacheTextVisibilityCell = Pref.makeBooleanPref("TextVisibilityCell", User.tool.prefs, true);
    private static Pref cacheSmartVerticalPlacement = Pref.makeIntPref("TextSmartVerticalPlacement", User.tool.prefs, 0);
    private static Pref cacheSmartHorizontalPlacement = Pref.makeIntPref("TextSmartHorizontalPlacement", User.tool.prefs, 0);
    private static Pref cacheDefaultFont = Pref.makeStringPref("DefaultFont", User.tool.prefs, "SansSerif");
    private static Pref cacheFrameCompanyName = Pref.makeStringPref("FrameCompanyName", User.tool.prefs, "");
    private static Pref cacheFrameDesignerName = Pref.makeStringPref("FrameDesignerName", User.tool.prefs, "");
    private static Pref cacheFrameProjectName = Pref.makeStringPref("FrameProjectName", User.tool.prefs, "");
    private static Pref cacheColorBackground = Pref.makeIntPref("ColorBackground", User.tool.prefs, Color.LIGHT_GRAY.getRGB());
    private static Pref cacheColorGrid = Pref.makeIntPref("ColorGrid", User.tool.prefs, Color.BLACK.getRGB());
    private static Pref cacheColorHighlight = Pref.makeIntPref("ColorHighlight", User.tool.prefs, Color.WHITE.getRGB());
    private static Pref cacheColorPortHighlight = Pref.makeIntPref("ColorPortHighlight", User.tool.prefs, Color.YELLOW.getRGB());
    private static Pref cacheColorText = Pref.makeIntPref("ColorText", User.tool.prefs, Color.BLACK.getRGB());
    private static Pref cacheColorInstanceOutline = Pref.makeIntPref("ColorInstanceOutline", User.tool.prefs, Color.BLACK.getRGB());
    private static Pref cacheDistanceUnits = Pref.makeIntPref("DistanceUnits", User.tool.prefs, TextUtils.UnitScale.NANO.getIndex());
    private static Pref cacheResistanceUnits = Pref.makeIntPref("ResistanceUnits", User.tool.prefs, TextUtils.UnitScale.NONE.getIndex());
    private static Pref cacheCapacitanceUnits = Pref.makeIntPref("CapacitanceUnits", User.tool.prefs, TextUtils.UnitScale.PICO.getIndex());
    private static Pref cacheInductanceUnits = Pref.makeIntPref("InductanceUnits", User.tool.prefs, TextUtils.UnitScale.NANO.getIndex());
    private static Pref cacheAmperageUnits = Pref.makeIntPref("AmperageUnits", User.tool.prefs, TextUtils.UnitScale.MILLI.getIndex());
    private static Pref cacheVoltageUnits = Pref.makeIntPref("VoltageUnits", User.tool.prefs, TextUtils.UnitScale.NONE.getIndex());
    private static Pref cacheTimeUnits = Pref.makeIntPref("TimeUnits", User.tool.prefs, TextUtils.UnitScale.NONE.getIndex());
    private static Pref cacheSchematicTechnology = Pref.makeStringPref("SchematicTechnology", User.tool.prefs, "mocmos");
    private static Pref cacheWorkingDirectory;
    private static Pref cacheBeepAfterLongJobs;
    private static Pref cache3DPerspective;
    private static Pref cachePlayClickSoundsWhenCreatingArcs;
    private static Pref cacheIncludeDateAndVersionInOutput;
    private static Pref cacheShowCursorCoordinatesInStatus;
    private static Pref cacheShowFileSelectionForNetlists;
    private static Pref cachePanningDistance;
    private static Pref cacheErrorLimit;
    private static Pref cacheMaxUndoHistory;
    private static Pref cacheMemorySize;
    private static Pref cacheAutoTechnologySwitch;
    private static Pref cachePlaceCellCenter;
    private static Pref cacheCheckCellDates;
    private static Pref cacheDisallowModificationLockedPrims;
    private static Pref cacheMoveAfterDuplicate;
    private static Pref cacheDupCopiesExports;
    private static Pref cacheExtractCopiesExports;
    private static Pref cacheNewNodeRotation;
    private static Pref cacheNewNodeMirrorX;

    private User() {
        super("user");
    }

    public void init() {
        this.setOn();
        this.setIncremental();
        TopLevel.Initialize();
        TopLevel.getPaletteFrame().loadForTechnology();
    }

    public NodeProto getCurrentNodeProto() {
        return this.currentNodeProto;
    }

    public void setCurrentNodeProto(NodeProto np) {
        this.currentNodeProto = np;
    }

    public ArcProto getCurrentArcProto() {
        return this.currentArcProto;
    }

    public void setCurrentArcProto(ArcProto ap) {
        this.currentArcProto = ap;
        TopLevel.getPaletteFrame().arcProtoChanged();
    }

    public void redrawObject(ElectricObject obj) {
        Cell parent;
        if (obj instanceof Geometric) {
            Geometric geom = (Geometric)obj;
            parent = geom.getParent();
            this.markCellForRedraw(parent, true);
        }
        if (obj instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            parent = pi.getNodeInst().getParent();
            this.markCellForRedraw(parent, true);
        }
    }

    public void renameObject(ElectricObject obj, Name oldName) {
        if (obj instanceof Cell) {
            Cell cell = (Cell)obj;
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                WindowContent content = wf.getContent();
                if (content.getCell() != cell) continue;
                content.setWindowTitle();
            }
        }
    }

    public void writeLibrary(Library lib) {
        TextWindow.saveAllTextWindows();
    }

    private void markCellForRedraw(Cell cell, boolean recurseUp) {
        Iterator wit = WindowFrame.getWindows();
        while (wit.hasNext()) {
            Cell winCell;
            WindowFrame wf = (WindowFrame)wit.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || (winCell = content.getCell()) != cell) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.repaintContents(null);
        }
        if (recurseUp) {
            Iterator it = cell.getInstancesOf();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (!ni.isExpanded()) continue;
                this.markCellForRedraw(ni.getParent(), recurseUp);
            }
        }
    }

    public void endBatch() {
        Iterator it = Undo.ChangeCell.getIterator();
        while (it.hasNext()) {
            Undo.ChangeCell cc = (Undo.ChangeCell)it.next();
            Cell cell = cc.getCell();
            this.markCellForRedraw(cell, false);
        }
    }

    public static boolean isIconGenDrawLeads() {
        return cacheIconGenDrawLeads.getBoolean();
    }

    public static void setIconGenDrawLeads(boolean on) {
        cacheIconGenDrawLeads.setBoolean(on);
    }

    public static boolean isIconGenDrawBody() {
        return cacheIconGenDrawBody.getBoolean();
    }

    public static void setIconGenDrawBody(boolean on) {
        cacheIconGenDrawBody.setBoolean(on);
    }

    public static boolean isIconGenReverseExportOrder() {
        return cacheIconGenReverseExportOrder.getBoolean();
    }

    public static void setIconGenReverseExportOrder(boolean on) {
        cacheIconGenReverseExportOrder.setBoolean(on);
    }

    public static int getIconGenInputSide() {
        return cacheIconGenInputSide.getInt();
    }

    public static void setIconGenInputSide(int side) {
        cacheIconGenInputSide.setInt(side);
    }

    public static int getIconGenOutputSide() {
        return cacheIconGenOutputSide.getInt();
    }

    public static void setIconGenOutputSide(int side) {
        cacheIconGenOutputSide.setInt(side);
    }

    public static int getIconGenBidirSide() {
        return cacheIconGenBidirSide.getInt();
    }

    public static void setIconGenBidirSide(int side) {
        cacheIconGenBidirSide.setInt(side);
    }

    public static int getIconGenPowerSide() {
        return cacheIconGenPowerSide.getInt();
    }

    public static void setIconGenPowerSide(int side) {
        cacheIconGenPowerSide.setInt(side);
    }

    public static int getIconGenGroundSide() {
        return cacheIconGenGroundSide.getInt();
    }

    public static void setIconGenGroundSide(int side) {
        cacheIconGenGroundSide.setInt(side);
    }

    public static int getIconGenClockSide() {
        return cacheIconGenClockSide.getInt();
    }

    public static void setIconGenClockSide(int side) {
        cacheIconGenClockSide.setInt(side);
    }

    public static int getIconGenExportLocation() {
        return cacheIconGenExportLocation.getInt();
    }

    public static void setIconGenExportLocation(int loc) {
        cacheIconGenExportLocation.setInt(loc);
    }

    public static int getIconGenExportStyle() {
        return cacheIconGenExportStyle.getInt();
    }

    public static void setIconGenExportStyle(int style) {
        cacheIconGenExportStyle.setInt(style);
    }

    public static int getIconGenExportTech() {
        return cacheIconGenExportTech.getInt();
    }

    public static void setIconGenExportTech(int t) {
        cacheIconGenExportTech.setInt(t);
    }

    public static int getIconGenInstanceLocation() {
        return cacheIconGenInstanceLocation.getInt();
    }

    public static void setIconGenInstanceLocation(int loc) {
        cacheIconGenInstanceLocation.setInt(loc);
    }

    public static double getIconGenLeadLength() {
        return cacheIconGenLeadLength.getDouble();
    }

    public static void setIconGenLeadLength(double len) {
        cacheIconGenLeadLength.setDouble(len);
    }

    public static double getIconGenLeadSpacing() {
        return cacheIconGenLeadSpacing.getDouble();
    }

    public static void setIconGenLeadSpacing(double dist) {
        cacheIconGenLeadSpacing.setDouble(dist);
    }

    public static int getPortDisplayLevel() {
        return cachePortDisplayLevel.getInt();
    }

    public static void setPortDisplayLevels(int level) {
        cachePortDisplayLevel.setInt(level);
    }

    public static int getExportDisplayLevel() {
        return cacheExportDisplayLevel.getInt();
    }

    public static void setExportDisplayLevels(int level) {
        cacheExportDisplayLevel.setInt(level);
    }

    public static boolean isMoveNodeWithExport() {
        return cacheMoveNodeWithExport.getBoolean();
    }

    public static void setMoveNodeWithExport(boolean on) {
        cacheMoveNodeWithExport.setBoolean(on);
    }

    public static boolean isEasySelectionOfCellInstances() {
        return cacheEasySelectionOfCellInstances.getBoolean();
    }

    public static void setEasySelectionOfCellInstances(boolean on) {
        cacheEasySelectionOfCellInstances.setBoolean(on);
    }

    public static boolean isEasySelectionOfAnnotationText() {
        return cacheEasySelectionOfAnnotationText.getBoolean();
    }

    public static void setEasySelectionOfAnnotationText(boolean on) {
        cacheEasySelectionOfAnnotationText.setBoolean(on);
    }

    public static boolean isDraggingMustEncloseObjects() {
        return cacheDraggingMustEncloseObjects.getBoolean();
    }

    public static void setDraggingMustEncloseObjects(boolean on) {
        cacheDraggingMustEncloseObjects.setBoolean(on);
    }

    public static double getDefGridXSpacing() {
        return cacheDefGridXSpacing.getDouble();
    }

    public static void setDefGridXSpacing(double dist) {
        cacheDefGridXSpacing.setDouble(dist);
    }

    public static double getDefGridYSpacing() {
        return cacheDefGridYSpacing.getDouble();
    }

    public static void setDefGridYSpacing(double dist) {
        cacheDefGridYSpacing.setDouble(dist);
    }

    public static int getDefGridXBoldFrequency() {
        return cacheDefGridXBoldFrequency.getInt();
    }

    public static void setDefGridXBoldFrequency(int dist) {
        cacheDefGridXBoldFrequency.setInt(dist);
    }

    public static int getDefGridYBoldFrequency() {
        return cacheDefGridYBoldFrequency.getInt();
    }

    public static void setDefGridYBoldFrequency(int dist) {
        cacheDefGridYBoldFrequency.setInt(dist);
    }

    public static boolean isShowCursorCoordinates() {
        return cacheShowCursorCoordinates.getBoolean();
    }

    public static void setShowCursorCoordinates(boolean on) {
        cacheShowCursorCoordinates.setBoolean(on);
    }

    public static double getAlignmentToGrid() {
        return cacheAlignmentToGrid.getDouble();
    }

    public static void setAlignmentToGrid(double dist) {
        cacheAlignmentToGrid.setDouble(dist);
    }

    public static boolean isTextVisibilityOnNode() {
        return cacheTextVisibilityNode.getBoolean();
    }

    public static void setTextVisibilityOnNode(boolean on) {
        cacheTextVisibilityNode.setBoolean(on);
    }

    public static boolean isTextVisibilityOnArc() {
        return cacheTextVisibilityArc.getBoolean();
    }

    public static void setTextVisibilityOnArc(boolean on) {
        cacheTextVisibilityArc.setBoolean(on);
    }

    public static boolean isTextVisibilityOnPort() {
        return cacheTextVisibilityPort.getBoolean();
    }

    public static void setTextVisibilityOnPort(boolean on) {
        cacheTextVisibilityPort.setBoolean(on);
    }

    public static boolean isTextVisibilityOnExport() {
        return cacheTextVisibilityExport.getBoolean();
    }

    public static void setTextVisibilityOnExport(boolean on) {
        cacheTextVisibilityExport.setBoolean(on);
    }

    public static boolean isTextVisibilityOnAnnotation() {
        return cacheTextVisibilityAnnotation.getBoolean();
    }

    public static void setTextVisibilityOnAnnotation(boolean on) {
        cacheTextVisibilityAnnotation.setBoolean(on);
    }

    public static boolean isTextVisibilityOnInstance() {
        return cacheTextVisibilityInstance.getBoolean();
    }

    public static void setTextVisibilityOnInstance(boolean on) {
        cacheTextVisibilityInstance.setBoolean(on);
    }

    public static boolean isTextVisibilityOnCell() {
        return cacheTextVisibilityCell.getBoolean();
    }

    public static void setTextVisibilityOnCell(boolean on) {
        cacheTextVisibilityCell.setBoolean(on);
    }

    public static int getSmartVerticalPlacement() {
        return cacheSmartVerticalPlacement.getInt();
    }

    public static void setSmartVerticalPlacement(int s) {
        cacheSmartVerticalPlacement.setInt(s);
    }

    public static int getSmartHorizontalPlacement() {
        return cacheSmartHorizontalPlacement.getInt();
    }

    public static void setSmartHorizontalPlacement(int s) {
        cacheSmartHorizontalPlacement.setInt(s);
    }

    public static String getDefaultFont() {
        return cacheDefaultFont.getString();
    }

    public static void setDefaultFont(String f) {
        cacheDefaultFont.setString(f);
    }

    public static String getFrameCompanyName() {
        return cacheFrameCompanyName.getString();
    }

    public static void setFrameCompanyName(String c) {
        cacheFrameCompanyName.setString(c);
    }

    public static String getFrameDesignerName() {
        return cacheFrameDesignerName.getString();
    }

    public static void setFrameDesignerName(String c) {
        cacheFrameDesignerName.setString(c);
    }

    public static String getFrameProjectName() {
        return cacheFrameProjectName.getString();
    }

    public static void setFrameProjectName(String c) {
        cacheFrameProjectName.setString(c);
    }

    public static int getColorBackground() {
        return cacheColorBackground.getInt();
    }

    public static void setColorBackground(int c) {
        cacheColorBackground.setInt(c);
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            if (!(wf.getContent() instanceof EditWindow)) continue;
            EditWindow wnd = (EditWindow)wf.getContent();
            PixelDrawing offscreen = wnd.getOffscreen();
            offscreen.setBackgroundColor(new Color(c));
        }
    }

    public static int getColorGrid() {
        return cacheColorGrid.getInt();
    }

    public static void setColorGrid(int c) {
        cacheColorGrid.setInt(c);
    }

    public static int getColorHighlight() {
        return cacheColorHighlight.getInt();
    }

    public static void setColorHighlight(int c) {
        cacheColorHighlight.setInt(c);
    }

    public static int getColorPortHighlight() {
        return cacheColorPortHighlight.getInt();
    }

    public static void setColorPortHighlight(int c) {
        cacheColorPortHighlight.setInt(c);
    }

    public static int getColorText() {
        return cacheColorText.getInt();
    }

    public static void setColorText(int c) {
        cacheColorText.setInt(c);
    }

    public static int getColorInstanceOutline() {
        return cacheColorInstanceOutline.getInt();
    }

    public static void setColorInstanceOutline(int c) {
        cacheColorInstanceOutline.setInt(c);
    }

    public static TextUtils.UnitScale getDistanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheDistanceUnits.getInt());
    }

    public static void setDistanceUnits(TextUtils.UnitScale us) {
        cacheDistanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getResistanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheResistanceUnits.getInt());
    }

    public static void setResistanceUnits(TextUtils.UnitScale us) {
        cacheResistanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getCapacitanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheCapacitanceUnits.getInt());
    }

    public static void setCapacitanceUnits(TextUtils.UnitScale us) {
        cacheCapacitanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getInductanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheInductanceUnits.getInt());
    }

    public static void setInductanceUnits(TextUtils.UnitScale us) {
        cacheInductanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getAmperageUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheAmperageUnits.getInt());
    }

    public static void setAmperageUnits(TextUtils.UnitScale us) {
        cacheAmperageUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getVoltageUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheVoltageUnits.getInt());
    }

    public static void setVoltageUnits(TextUtils.UnitScale us) {
        cacheVoltageUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getTimeUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheTimeUnits.getInt());
    }

    public static void setTimeUnits(TextUtils.UnitScale us) {
        cacheTimeUnits.setInt(us.getIndex());
    }

    public static String getSchematicTechnology() {
        return cacheSchematicTechnology.getString();
    }

    public static void setSchematicTechnology(String t) {
        cacheSchematicTechnology.setString(t);
    }

    public static String getWorkingDirectory() {
        return cacheWorkingDirectory.getString();
    }

    public static void setWorkingDirectory(String dir) {
        cacheWorkingDirectory.setString(dir);
    }

    public static boolean isBeepAfterLongJobs() {
        return cacheBeepAfterLongJobs.getBoolean();
    }

    public static void setBeepAfterLongJobs(boolean on) {
        cacheBeepAfterLongJobs.setBoolean(on);
    }

    public static boolean is3DPerspective() {
        return cache3DPerspective.getBoolean();
    }

    public static void set3DPerspective(boolean on) {
        cache3DPerspective.setBoolean(on);
    }

    public static boolean isPlayClickSoundsWhenCreatingArcs() {
        return cachePlayClickSoundsWhenCreatingArcs.getBoolean();
    }

    public static void setPlayClickSoundsWhenCreatingArcs(boolean on) {
        cachePlayClickSoundsWhenCreatingArcs.setBoolean(on);
    }

    public static boolean isIncludeDateAndVersionInOutput() {
        return cacheIncludeDateAndVersionInOutput.getBoolean();
    }

    public static void setIncludeDateAndVersionInOutput(boolean on) {
        cacheIncludeDateAndVersionInOutput.setBoolean(on);
    }

    public static boolean isShowCursorCoordinatesInStatus() {
        return cacheShowCursorCoordinatesInStatus.getBoolean();
    }

    public static void setShowCursorCoordinatesInStatus(boolean on) {
        cacheShowCursorCoordinatesInStatus.setBoolean(on);
        StatusBar.setShowCoordinates(on);
    }

    public static boolean isShowFileSelectionForNetlists() {
        return cacheShowFileSelectionForNetlists.getBoolean();
    }

    public static void setShowFileSelectionForNetlists(boolean on) {
        cacheShowFileSelectionForNetlists.setBoolean(on);
    }

    public static int getPanningDistance() {
        return cachePanningDistance.getInt();
    }

    public static void setPanningDistance(int d) {
        cachePanningDistance.setInt(d);
    }

    public static int getErrorLimit() {
        return cacheErrorLimit.getInt();
    }

    public static void setErrorLimit(int limit) {
        cacheErrorLimit.setInt(limit);
    }

    public static int getMaxUndoHistory() {
        return cacheMaxUndoHistory.getInt();
    }

    public static void setMaxUndoHistory(int n) {
        cacheMaxUndoHistory.setInt(n);
    }

    public static int getMemorySize() {
        return cacheMemorySize.getInt();
    }

    public static void setMemorySize(int limit) {
        cacheMemorySize.setInt(limit);
    }

    public static boolean isAutoTechnologySwitch() {
        return cacheAutoTechnologySwitch.getBoolean();
    }

    public static void setAutoTechnologySwitch(boolean on) {
        cacheAutoTechnologySwitch.setBoolean(on);
    }

    public static boolean isPlaceCellCenter() {
        return cachePlaceCellCenter.getBoolean();
    }

    public static void setPlaceCellCenter(boolean on) {
        cachePlaceCellCenter.setBoolean(on);
    }

    public static boolean isCheckCellDates() {
        return cacheCheckCellDates.getBoolean();
    }

    public static void setCheckCellDates(boolean on) {
        cacheCheckCellDates.setBoolean(on);
    }

    public static boolean isDisallowModificationLockedPrims() {
        return cacheDisallowModificationLockedPrims.getBoolean();
    }

    public static void setDisallowModificationLockedPrims(boolean on) {
        cacheDisallowModificationLockedPrims.setBoolean(on);
    }

    public static boolean isMoveAfterDuplicate() {
        return cacheMoveAfterDuplicate.getBoolean();
    }

    public static void setMoveAfterDuplicate(boolean on) {
        cacheMoveAfterDuplicate.setBoolean(on);
    }

    public static boolean isDupCopiesExports() {
        return cacheDupCopiesExports.getBoolean();
    }

    public static void setDupCopiesExports(boolean on) {
        cacheDupCopiesExports.setBoolean(on);
    }

    public static boolean isExtractCopiesExports() {
        return cacheExtractCopiesExports.getBoolean();
    }

    public static void setExtractCopiesExports(boolean on) {
        cacheExtractCopiesExports.setBoolean(on);
    }

    public static int getNewNodeRotation() {
        return cacheNewNodeRotation.getInt();
    }

    public static void setNewNodeRotation(int rot) {
        cacheNewNodeRotation.setInt(rot);
    }

    public static boolean isNewNodeMirrorX() {
        return cacheNewNodeMirrorX.getBoolean();
    }

    public static void setNewNodeMirrorX(boolean on) {
        cacheNewNodeMirrorX.setBoolean(on);
    }

    static {
        cacheSchematicTechnology.attachToObject(tool, "Technology/Technology tab", "Schematics use scale values from this technology");
        cacheWorkingDirectory = Pref.makeStringPref("WorkingDirectory", User.tool.prefs, System.getProperty("user.dir"));
        cacheBeepAfterLongJobs = Pref.makeBooleanPref("BeepAfterLongJobs", User.tool.prefs, false);
        cache3DPerspective = Pref.makeBooleanPref("Perspective3D", User.tool.prefs, true);
        cachePlayClickSoundsWhenCreatingArcs = Pref.makeBooleanPref("PlayClickSoundsWhenCreatingArcs", User.tool.prefs, true);
        cacheIncludeDateAndVersionInOutput = Pref.makeBooleanPref("IncludeDateAndVersionInOutput", User.tool.prefs, true);
        cacheIncludeDateAndVersionInOutput.attachToObject(tool, "General/General tab", "Include date and version in output");
        cacheShowCursorCoordinatesInStatus = Pref.makeBooleanPref("ShowCursorCoordinatesInStatus", User.tool.prefs, false);
        cacheShowFileSelectionForNetlists = Pref.makeBooleanPref("ShowFileSelectionForNetlists", User.tool.prefs, true);
        cachePanningDistance = Pref.makeIntPref("PanningDistance", User.tool.prefs, 1);
        cacheErrorLimit = Pref.makeIntPref("ErrorLimit", User.tool.prefs, 0);
        cacheMaxUndoHistory = Pref.makeIntPref("MaxUndoHistory", User.tool.prefs, 40);
        cacheMemorySize = Pref.makeIntPref("MemorySize", User.tool.prefs, 1000);
        cacheAutoTechnologySwitch = Pref.makeBooleanPref("AutoTechnologySwitch", User.tool.prefs, true);
        cachePlaceCellCenter = Pref.makeBooleanPref("PlaceCellCenter", User.tool.prefs, true);
        cacheCheckCellDates = Pref.makeBooleanPref("CheckCellDates", User.tool.prefs, false);
        cacheDisallowModificationLockedPrims = Pref.makeBooleanPref("DisallowModificationLockedPrims", User.tool.prefs, false);
        cacheMoveAfterDuplicate = Pref.makeBooleanPref("MoveAfterDuplicate", User.tool.prefs, true);
        cacheDupCopiesExports = Pref.makeBooleanPref("DupCopiesExports", User.tool.prefs, false);
        cacheExtractCopiesExports = Pref.makeBooleanPref("ExtractCopiesExports", User.tool.prefs, false);
        cacheNewNodeRotation = Pref.makeIntPref("NewNodeRotation", User.tool.prefs, 0);
        cacheNewNodeMirrorX = Pref.makeBooleanPref("NewNodeMirrorX", User.tool.prefs, false);
    }
}

