/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.LibId;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.text.CellName;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class IdManager {
    private final ArrayList<LibId> libIds = new ArrayList();
    private final HashMap<String, LibId> libIdsByName = new HashMap();
    private final ArrayList<CellId> cellIds = new ArrayList();
    private final AtomicInteger snapshotCount = new AtomicInteger();
    private final Snapshot initialSnapshot = new Snapshot(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibId newLibId(String libName) {
        ArrayList<LibId> arrayList = this.libIds;
        synchronized (arrayList) {
            LibId libId = this.libIdsByName.get(libName);
            return libId != null ? libId : this.newLibIdInternal(libName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibId getLibId(int libIndex) {
        ArrayList<LibId> arrayList = this.libIds;
        synchronized (arrayList) {
            return this.libIds.get(libIndex);
        }
    }

    private LibId newLibIdInternal(String libName) {
        int libIndex = this.libIds.size();
        LibId libId = new LibId(this, libName, libIndex);
        this.libIds.add(libId);
        this.libIdsByName.put(libName, libId);
        assert (this.libIds.size() == this.libIdsByName.size());
        return libId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CellId newCellId(CellName cellName) {
        ArrayList<CellId> arrayList = this.cellIds;
        synchronized (arrayList) {
            return this.newCellIdInternal(cellName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellId getCellId(int cellIndex) {
        ArrayList<CellId> arrayList = this.cellIds;
        synchronized (arrayList) {
            return this.cellIds.get(cellIndex);
        }
    }

    private CellId newCellIdInternal(CellName cellName) {
        int cellIndex = this.cellIds.size();
        CellId cellId = new CellId(this, cellName, cellIndex);
        this.cellIds.add(cellId);
        return cellId;
    }

    public Snapshot getInitialSnapshot() {
        return this.initialSnapshot;
    }

    int newSnapshotId() {
        return this.snapshotCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDiffs(SnapshotWriter writer) throws IOException {
        CellId cellId;
        int cellIndex;
        CellId[] cellIdsArray;
        LibId[] libIdsArray;
        ArrayList<Serializable> arrayList = this.libIds;
        synchronized (arrayList) {
            libIdsArray = this.libIds.toArray(LibId.NULL_ARRAY);
        }
        arrayList = this.cellIds;
        synchronized (arrayList) {
            cellIdsArray = this.cellIds.toArray(CellId.NULL_ARRAY);
        }
        writer.writeInt(libIdsArray.length);
        for (int libIndex = writer.libCount; libIndex < libIdsArray.length; ++libIndex) {
            LibId libId = libIdsArray[libIndex];
            writer.writeString(libId.libName);
        }
        writer.setLibCount(libIdsArray.length);
        writer.writeInt(cellIdsArray.length);
        for (cellIndex = writer.exportCounts.length; cellIndex < cellIdsArray.length; ++cellIndex) {
            cellId = cellIdsArray[cellIndex];
            writer.writeString(cellId.cellName.toString());
        }
        writer.setCellCount(cellIdsArray.length);
        for (cellIndex = 0; cellIndex < cellIdsArray.length; ++cellIndex) {
            int exportCount;
            cellId = cellIdsArray[cellIndex];
            ExportId[] exportIds = cellId.getExportIds();
            if (exportIds.length == (exportCount = writer.exportCounts[cellIndex])) continue;
            writer.writeInt(cellIndex);
            int numNewExportIds = exportIds.length - exportCount;
            assert (numNewExportIds > 0);
            writer.writeInt(numNewExportIds);
            for (int i = 0; i < numNewExportIds; ++i) {
                writer.writeString(exportIds[exportCount + i].externalId);
            }
            writer.exportCounts[cellIndex] = exportIds.length;
        }
        writer.writeInt(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readDiffs(SnapshotReader reader) throws IOException {
        int cellIndex;
        int libIdsCount = reader.readInt();
        ArrayList<LibId> arrayList = this.libIds;
        synchronized (arrayList) {
            while (libIdsCount > this.libIds.size()) {
                this.newLibIdInternal(reader.readString());
            }
        }
        int cellIdsCount = reader.readInt();
        ArrayList<CellId> arrayList2 = this.cellIds;
        synchronized (arrayList2) {
            while (cellIdsCount > this.cellIds.size()) {
                this.newCellIdInternal(CellName.parseName(reader.readString()));
            }
        }
        while ((cellIndex = reader.readInt()) != -1) {
            CellId cellId = this.getCellId(cellIndex);
            int numNewExportIds = reader.readInt();
            String[] newExportIds = new String[numNewExportIds];
            for (int i = 0; i < newExportIds.length; ++i) {
                newExportIds[i] = reader.readString();
            }
            cellId.newExportIds(newExportIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkInvariants() {
        int numCellIds;
        Serializable libId;
        int numLibIds;
        ArrayList<LibId> arrayList = this.libIds;
        synchronized (arrayList) {
            numLibIds = this.libIds.size();
            assert (numLibIds == this.libIdsByName.size());
        }
        for (int i = 0; i < numLibIds; ++i) {
            ArrayList<LibId> arrayList2 = this.libIds;
            synchronized (arrayList2) {
                libId = this.libIds.get(i);
            }
            ((LibId)libId).check();
        }
        libId = this.cellIds;
        synchronized (libId) {
            numCellIds = this.cellIds.size();
        }
        for (int i = 0; i < numCellIds; ++i) {
            CellId cellId;
            ArrayList<CellId> arrayList3 = this.cellIds;
            synchronized (arrayList3) {
                cellId = this.cellIds.get(i);
            }
            assert (cellId.cellIndex == i);
            cellId.check();
        }
    }
}

