/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.fill.ExportBar;
import com.sun.electric.tool.generator.layout.fill.Floorplan;
import com.sun.electric.tool.generator.layout.fill.G;
import com.sun.electric.tool.generator.layout.fill.MetalFloorplan;
import com.sun.electric.tool.generator.layout.fill.MetalFloorplanBase;
import com.sun.electric.tool.generator.layout.fill.VddGndStraps;
import java.util.ArrayList;

class MetalLayer
implements VddGndStraps {
    protected final MetalFloorplanBase plan;
    protected final int layerNum;
    protected final PrimitiveNode pin;
    protected final ArcProto metal;
    protected ArrayList<ExportBar> vddBars = new ArrayList();
    protected ArrayList<ExportBar> gndBars = new ArrayList();

    @Override
    public boolean addExtraArc() {
        return true;
    }

    private void buildGnd(Cell cell) {
        double pinY;
        double pinX;
        MetalFloorplan plan = (MetalFloorplan)this.plan;
        if (plan.horizontal) {
            pinX = plan.cellWidth / 2.0;
            pinY = plan.gndCenter;
        } else {
            pinX = plan.gndCenter;
            pinY = plan.cellHeight / 2.0;
        }
        PortInst tl = LayoutLib.newNodeInst(this.pin, -pinX, pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        PortInst tr = LayoutLib.newNodeInst(this.pin, pinX, pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        PortInst bl = LayoutLib.newNodeInst(this.pin, -pinX, -pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        PortInst br = LayoutLib.newNodeInst(this.pin, pinX, -pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        if (plan.horizontal) {
            G.noExtendArc(this.metal, plan.gndWidth, tl, tr);
            G.noExtendArc(this.metal, plan.gndWidth, bl, br);
            this.gndBars.add(new ExportBar(bl, br, -plan.gndCenter));
            this.gndBars.add(new ExportBar(tl, tr, plan.gndCenter));
        } else {
            G.noExtendArc(this.metal, plan.gndWidth, bl, tl);
            G.noExtendArc(this.metal, plan.gndWidth, br, tr);
            this.gndBars.add(new ExportBar(bl, tl, -plan.gndCenter));
            this.gndBars.add(new ExportBar(br, tr, plan.gndCenter));
        }
    }

    private void buildVdd(Cell cell) {
        double pinY;
        double pinX;
        MetalFloorplan plan = (MetalFloorplan)this.plan;
        if (plan.horizontal) {
            pinX = plan.cellWidth / 2.0;
            pinY = plan.vddCenter;
        } else {
            pinX = plan.vddCenter;
            pinY = plan.cellHeight / 2.0;
        }
        if (plan.mergedVdd) {
            PortInst tr = LayoutLib.newNodeInst(this.pin, pinX, pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
            PortInst bl = LayoutLib.newNodeInst(this.pin, -pinX, -pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
            G.noExtendArc(this.metal, plan.vddWidth, bl, tr);
            this.vddBars.add(new ExportBar(bl, tr, plan.vddCenter));
        } else {
            PortInst tl = LayoutLib.newNodeInst(this.pin, -pinX, pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
            PortInst tr = LayoutLib.newNodeInst(this.pin, pinX, pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
            PortInst bl = LayoutLib.newNodeInst(this.pin, -pinX, -pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
            PortInst br = LayoutLib.newNodeInst(this.pin, pinX, -pinY, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
            if (plan.horizontal) {
                G.noExtendArc(this.metal, plan.vddWidth, tl, tr);
                G.noExtendArc(this.metal, plan.vddWidth, bl, br);
                this.vddBars.add(new ExportBar(bl, br, -plan.vddCenter));
                this.vddBars.add(new ExportBar(tl, tr, plan.vddCenter));
            } else {
                G.noExtendArc(this.metal, plan.vddWidth, bl, tl);
                G.noExtendArc(this.metal, plan.vddWidth, br, tr);
                this.vddBars.add(new ExportBar(bl, tl, -plan.vddCenter));
                this.vddBars.add(new ExportBar(br, tr, plan.vddCenter));
            }
        }
    }

    protected void buildGndAndVdd(Cell cell) {
        this.buildGnd(cell);
        this.buildVdd(cell);
    }

    public MetalLayer(int layerNum, Floorplan plan, Cell cell) {
        this.plan = (MetalFloorplanBase)plan;
        this.layerNum = layerNum;
        this.metal = METALS[layerNum];
        this.pin = PINS[layerNum];
        this.buildGndAndVdd(cell);
    }

    @Override
    public boolean isHorizontal() {
        return this.plan.horizontal;
    }

    @Override
    public int numVdd() {
        return this.vddBars.size();
    }

    @Override
    public double getVddCenter(int n) {
        return this.vddBars.get((int)n).center;
    }

    @Override
    public PortInst getVdd(int n, int pos) {
        return this.vddBars.get((int)n).ports[pos];
    }

    @Override
    public double getVddWidth(int n) {
        return this.plan.vddWidth;
    }

    @Override
    public int numGnd() {
        return this.gndBars.size();
    }

    @Override
    public double getGndCenter(int n) {
        return this.gndBars.get((int)n).center;
    }

    @Override
    public PortInst getGnd(int n, int pos) {
        return this.gndBars.get((int)n).ports[pos];
    }

    @Override
    public double getGndWidth(int n) {
        return this.plan.gndWidth;
    }

    @Override
    public PrimitiveNode getPinType() {
        return this.pin;
    }

    @Override
    public ArcProto getMetalType() {
        return this.metal;
    }

    @Override
    public double getCellWidth() {
        return this.plan.cellWidth;
    }

    @Override
    public double getCellHeight() {
        return this.plan.cellHeight;
    }

    public int getLayerNumber() {
        return this.layerNum;
    }
}

