/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sc;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.sc.GetNetlist;
import com.sun.electric.tool.sc.Place;
import com.sun.electric.tool.sc.Route;
import com.sun.electric.tool.sc.SilComp;
import com.sun.electric.tool.user.User;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class Maker {
    private static final int VIASPECIAL = 1;
    private static final int VIAEXPORT = 2;
    private static final int VIAPOWER = 4;
    private PrimitiveNode layer1Proto;
    private PrimitiveNode layer2Proto;
    private PrimitiveNode viaProto;
    private PrimitiveNode pWellProto;
    private PrimitiveNode nWellProto;
    private ArcProto layer1Arc;
    private ArcProto layer2Arc;

    public Object makeLayout(Library destLib, GetNetlist gnl) {
        if (gnl.curSCCell == null) {
            return "No cell selected";
        }
        if (gnl.curSCCell.placement == null) {
            return "No PLACEMENT structure for cell '" + gnl.curSCCell.name + "'";
        }
        if (gnl.curSCCell.route == null) {
            return "No ROUTE structure for cell '" + gnl.curSCCell.name + "'";
        }
        MakerData makeData = this.setUp(gnl.curSCCell);
        Object result = this.createLayout(destLib, makeData);
        if (result instanceof String) {
            return result;
        }
        return result;
    }

    private MakerData setUp(GetNetlist.SCCell cell) {
        MakerData data = new MakerData();
        data.cell = cell;
        data.rows = null;
        data.channels = null;
        data.power = null;
        data.ground = null;
        data.minX = Double.MAX_VALUE;
        data.maxX = Double.MIN_VALUE;
        data.minY = Double.MAX_VALUE;
        data.maxY = Double.MIN_VALUE;
        double rowToTrack = SilComp.getViaSize() / 2.0 + SilComp.getMinMetalSpacing();
        double minTrackToTrack = SilComp.getViaSize() / 2.0 + SilComp.getMinMetalSpacing() + SilComp.getHorizArcWidth() / 2.0;
        double maxTrackToTrack = SilComp.getViaSize() + SilComp.getMinMetalSpacing();
        MakerChannel lastMChan = null;
        Route.RouteChannel chan = cell.route.channels;
        while (chan != null) {
            MakerChannel mChan = new MakerChannel();
            mChan.number = chan.number;
            mChan.tracks = null;
            mChan.numTracks = 0;
            mChan.ySize = 0.0;
            mChan.flags = 0;
            mChan.next = null;
            mChan.last = lastMChan;
            if (lastMChan != null) {
                lastMChan.next = mChan;
            } else {
                data.channels = mChan;
            }
            lastMChan = mChan;
            MakerTrack lastMTrack = null;
            double yPos = 0.0;
            Route.RouteTrack track = chan.tracks;
            while (track != null) {
                MakerTrack mTrack = new MakerTrack();
                mTrack.number = track.number;
                mTrack.nodes = null;
                mTrack.track = track;
                mTrack.flags = 0;
                mTrack.next = null;
                mTrack.last = lastMTrack;
                if (lastMTrack != null) {
                    lastMTrack.next = mTrack;
                } else {
                    mChan.tracks = mTrack;
                }
                lastMTrack = mTrack;
                ++mChan.numTracks;
                if (mTrack.number == 0) {
                    mTrack.yPos = yPos += rowToTrack;
                } else {
                    double deltaY = minTrackToTrack;
                    Route.RouteTrackMem tr1Mem = track.nodes;
                    Route.RouteTrackMem tr2Mem = track.last.nodes;
                    Route.RouteChPort tr1Port = tr1Mem.node.firstPort;
                    Route.RouteChPort tr2Port = tr2Mem.node.firstPort;
                    while (tr1Port != null && tr2Port != null) {
                        if (Math.abs(tr1Port.xPos - tr2Port.xPos) < maxTrackToTrack) {
                            deltaY = maxTrackToTrack;
                            break;
                        }
                        if (tr1Port.xPos < tr2Port.xPos) {
                            tr1Port = tr1Port.next;
                            if (tr1Port != null || (tr1Mem = tr1Mem.next) == null) continue;
                            tr1Port = tr1Mem.node.firstPort;
                            continue;
                        }
                        tr2Port = tr2Port.next;
                        if (tr2Port != null || (tr2Mem = tr2Mem.next) == null) continue;
                        tr2Port = tr2Mem.node.firstPort;
                    }
                    mTrack.yPos = yPos += deltaY;
                }
                if (track.next == null) {
                    yPos += rowToTrack;
                }
                track = track.next;
            }
            mChan.ySize = yPos;
            chan = chan.next;
        }
        MakerChannel mChan = data.channels;
        mChan.minY = 0.0;
        double yPos = mChan.ySize;
        MakerRow lastMRow = null;
        for (Place.RowList row : cell.placement.theRows) {
            MakerRow mRow = new MakerRow();
            mRow.number = row.rowNum;
            mRow.members = null;
            mRow.minX = Double.MAX_VALUE;
            mRow.maxX = Double.MIN_VALUE;
            mRow.minY = Double.MAX_VALUE;
            mRow.maxY = Double.MIN_VALUE;
            mRow.flags = 0;
            mRow.next = null;
            mRow.last = lastMRow;
            if (lastMRow != null) {
                lastMRow.next = mRow;
            } else {
                data.rows = mRow;
            }
            lastMRow = mRow;
            double tOffset = Double.MIN_VALUE;
            double bOffset = Double.MAX_VALUE;
            Place.NBPlace place = row.start;
            while (place != null) {
                if (place.cell.type == 0) {
                    GetNetlist.SCCellNums cNums = GetNetlist.getLeafCellNums((Cell)place.cell.np);
                    tOffset = Math.max(tOffset, SilComp.leafCellYSize((Cell)place.cell.np) - (double)cNums.topActive);
                    bOffset = Math.min(bOffset, (double)cNums.bottomActive);
                }
                place = place.next;
            }
            yPos -= bOffset;
            MakerInst lastMInst = null;
            Place.NBPlace place2 = row.start;
            while (place2 != null) {
                if (place2.cell.type == 0 || place2.cell.type == 3 || place2.cell.type == 5) {
                    MakerInst mInst = new MakerInst();
                    mInst.place = place2;
                    mInst.row = mRow;
                    mInst.xPos = place2.xPos;
                    mInst.yPos = yPos;
                    mInst.xSize = place2.cell.size;
                    if (place2.cell.type == 0) {
                        MakerPowerPort nextPort;
                        MakerPowerPort lastPort;
                        MakerPower nextPList;
                        MakerPower lastPList;
                        MakerPower pList;
                        double portYPos;
                        MakerPowerPort powerPort;
                        mInst.ySize = SilComp.leafCellYSize((Cell)place2.cell.np);
                        GetNetlist.SCNiPort iport = place2.cell.power;
                        while (iport != null) {
                            powerPort = new MakerPowerPort();
                            powerPort.inst = mInst;
                            powerPort.port = iport;
                            powerPort.xPos = mRow.number % 2 != 0 ? mInst.xPos + mInst.xSize - iport.xPos : mInst.xPos + iport.xPos;
                            powerPort.next = null;
                            powerPort.last = null;
                            portYPos = mInst.yPos + SilComp.leafPortYPos((Export)iport.port);
                            pList = data.power;
                            while (pList != null && pList.yPos != portYPos) {
                                pList = pList.next;
                            }
                            if (pList == null) {
                                pList = new MakerPower();
                                pList.ports = null;
                                pList.yPos = portYPos;
                                lastPList = null;
                                nextPList = data.power;
                                while (nextPList != null && !(portYPos < nextPList.yPos)) {
                                    lastPList = nextPList;
                                    nextPList = nextPList.next;
                                }
                                pList.next = nextPList;
                                pList.last = lastPList;
                                if (lastPList != null) {
                                    lastPList.next = pList;
                                } else {
                                    data.power = pList;
                                }
                                if (nextPList != null) {
                                    nextPList.last = pList;
                                }
                            }
                            lastPort = null;
                            nextPort = pList.ports;
                            while (nextPort != null && !(powerPort.xPos < nextPort.xPos)) {
                                lastPort = nextPort;
                                nextPort = nextPort.next;
                            }
                            powerPort.next = nextPort;
                            powerPort.last = lastPort;
                            if (lastPort != null) {
                                lastPort.next = powerPort;
                            } else {
                                pList.ports = powerPort;
                            }
                            if (nextPort != null) {
                                nextPort.last = powerPort;
                            }
                            iport = iport.next;
                        }
                        GetNetlist.SCNiPort iPort = place2.cell.ground;
                        while (iPort != null) {
                            powerPort = new MakerPowerPort();
                            powerPort.inst = mInst;
                            powerPort.port = iPort;
                            powerPort.xPos = mRow.number % 2 != 0 ? mInst.xPos + mInst.xSize - iPort.xPos : mInst.xPos + iPort.xPos;
                            powerPort.next = null;
                            powerPort.last = null;
                            portYPos = mInst.yPos + SilComp.leafPortYPos((Export)iPort.port);
                            pList = data.ground;
                            while (pList != null && pList.yPos != portYPos) {
                                pList = pList.next;
                            }
                            if (pList == null) {
                                pList = new MakerPower();
                                pList.ports = null;
                                pList.yPos = portYPos;
                                lastPList = null;
                                nextPList = data.ground;
                                while (nextPList != null && !(portYPos < nextPList.yPos)) {
                                    lastPList = nextPList;
                                    nextPList = nextPList.next;
                                }
                                pList.next = nextPList;
                                pList.last = lastPList;
                                if (lastPList != null) {
                                    lastPList.next = pList;
                                } else {
                                    data.ground = pList;
                                }
                                if (nextPList != null) {
                                    nextPList.last = pList;
                                }
                            }
                            lastPort = null;
                            nextPort = pList.ports;
                            while (nextPort != null && !(powerPort.xPos < nextPort.xPos)) {
                                lastPort = nextPort;
                                nextPort = nextPort.next;
                            }
                            powerPort.next = nextPort;
                            powerPort.last = lastPort;
                            if (lastPort != null) {
                                lastPort.next = powerPort;
                            } else {
                                pList.ports = powerPort;
                            }
                            if (nextPort != null) {
                                nextPort.last = powerPort;
                            }
                            iPort = iPort.next;
                        }
                    } else if (place2.cell.type == 3) {
                        mInst.ySize = bOffset;
                    } else if (place2.cell.type == 5) {
                        Route.RoutePort rPort = (Route.RoutePort)place2.cell.ports.port;
                        mInst.ySize = SilComp.leafPortYPos((Export)rPort.port.port);
                    } else {
                        System.out.println("ERROR - unknown cell type in maker set up");
                        mInst.ySize = 0.0;
                    }
                    mInst.instance = null;
                    mInst.flags = 0;
                    place2.cell.tp = mInst;
                    mInst.next = null;
                    if (lastMInst != null) {
                        lastMInst.next = mInst;
                    } else {
                        mRow.members = mInst;
                    }
                    lastMInst = mInst;
                    mRow.minX = Math.min(mRow.minX, mInst.xPos);
                    mRow.maxX = Math.max(mRow.maxX, mInst.xPos + mInst.xSize);
                    mRow.minY = Math.min(mRow.minY, mInst.yPos);
                    mRow.maxY = Math.max(mRow.maxY, mInst.yPos + mInst.ySize);
                }
                place2 = place2.next;
            }
            data.minX = Math.min(data.minX, mRow.minX);
            data.maxX = Math.max(data.maxX, mRow.maxX);
            data.minY = Math.min(data.minY, mRow.minY);
            data.maxY = Math.max(data.maxY, mRow.maxY);
            mChan = mChan.next;
            mChan.minY = yPos += tOffset;
            yPos += mChan.ySize;
        }
        mChan = data.channels;
        while (mChan != null) {
            MakerTrack mTrack = mChan.tracks;
            while (mTrack != null && mTrack.next != null) {
                mTrack = mTrack.next;
            }
            while (mTrack != null) {
                mTrack.yPos = yPos = mChan.minY + (mChan.ySize - mTrack.yPos);
                Route.RouteTrackMem mem = mTrack.track.nodes;
                while (mem != null) {
                    MakerNode mNode = new MakerNode();
                    mNode.vias = null;
                    mNode.next = mTrack.nodes;
                    mTrack.nodes = mNode;
                    MakerVia lastVia = null;
                    Route.RouteChPort chPort = mem.node.firstPort;
                    while (chPort != null) {
                        int type;
                        MakerVia mVia = new MakerVia();
                        mVia.xPos = chPort.xPos;
                        mVia.chPort = chPort;
                        mVia.instance = null;
                        mVia.flags = 0;
                        mVia.xPort = null;
                        mVia.next = null;
                        if (lastVia != null) {
                            lastVia.next = mVia;
                        } else {
                            mNode.vias = mVia;
                        }
                        lastVia = mVia;
                        if (mVia.chPort.port.place.cell.type == 0 && ((type = GetNetlist.getLeafPortType((Export)mVia.chPort.port.port.port)) == 32 || type == 16)) {
                            mVia.flags |= 4;
                        }
                        Route.RouteExport xPort = data.cell.route.exports;
                        while (xPort != null) {
                            if (xPort.chPort == mVia.chPort) {
                                mVia.flags |= 2;
                                mVia.xPort = xPort;
                                break;
                            }
                            xPort = xPort.next;
                        }
                        data.minX = Math.min(data.minX, chPort.xPos);
                        data.maxX = Math.max(data.maxX, chPort.xPos);
                        data.minY = Math.min(data.minY, chPort.xPos);
                        data.maxY = Math.max(data.maxY, chPort.xPos);
                        chPort = chPort.next;
                    }
                    mem = mem.next;
                }
                mTrack = mTrack.last;
            }
            mChan = mChan.next;
        }
        return data;
    }

    private Object createLayout(Library destLib, MakerData data) {
        MakerInst inst;
        MakerVia via;
        MakerNode mNode;
        double rowToTrack = SilComp.getViaSize() / 2.0 + SilComp.getMinMetalSpacing();
        double trackToTtrack = SilComp.getViaSize() + SilComp.getMinMetalSpacing();
        String err = this.setupForMaker();
        if (err != null) {
            return err;
        }
        Cell bCell = Cell.makeInstance(destLib, data.cell.name + "{lay}");
        if (bCell == null) {
            return "Cannot create leaf cell '" + data.cell.name + "{lay}' in MAKER";
        }
        MakerRow row = data.rows;
        while (row != null) {
            boolean flipX = false;
            if (row.number % 2 != 0) {
                flipX = true;
            }
            MakerInst inst2 = row.members;
            while (inst2 != null) {
                Point2D.Double ctr;
                GetNetlist.SCNiTree node = inst2.place.cell;
                if (node.type == 0) {
                    Cell subCell = (Cell)node.np;
                    ERectangle bounds = subCell.getBounds();
                    Orientation orient = Orientation.IDENT;
                    double hEdge = -bounds.getMinX();
                    if (flipX) {
                        orient = Orientation.X;
                        hEdge = ((RectangularShape)bounds).getMaxX();
                    }
                    Point2D.Double ctr2 = new Point2D.Double(inst2.xPos + hEdge, inst2.yPos - bounds.getMinY());
                    inst2.instance = NodeInst.makeInstance(subCell, ctr2, inst2.xSize, inst2.ySize, bCell, orient, node.name, 0);
                    if (inst2.instance == null) {
                        return "Cannot create leaf instance '" + node.name + "' in MAKER";
                    }
                } else if (node.type == 3) {
                    ctr = new Point2D.Double(inst2.xPos + inst2.xSize / 2.0, inst2.yPos + inst2.ySize + SilComp.getVertArcWidth() / 2.0);
                    inst2.instance = NodeInst.makeInstance(this.layer2Proto, ctr, SilComp.getVertArcWidth(), SilComp.getVertArcWidth(), bCell);
                    if (inst2.instance == null) {
                        return "Cannot create leaf feed in MAKER";
                    }
                } else if (node.type == 5) {
                    ctr = new Point2D.Double(inst2.xPos + inst2.xSize / 2.0, inst2.yPos + inst2.ySize);
                    inst2.instance = NodeInst.makeInstance(this.viaProto, ctr, this.viaProto.getDefWidth(), this.viaProto.getDefHeight(), bCell);
                    if (inst2.instance == null) {
                        return "Cannot create via in MAKER";
                    }
                }
                inst2 = inst2.next;
            }
            row = row.next;
        }
        MakerChannel chan = data.channels;
        while (chan != null) {
            MakerTrack track = chan.tracks;
            while (track != null) {
                mNode = track.nodes;
                while (mNode != null) {
                    via = mNode.vias;
                    while (via != null) {
                        if ((via.flags & 4) != 0) {
                            via.instance = NodeInst.makeInstance(this.layer1Proto, new Point2D.Double(via.xPos, track.yPos), SilComp.getHorizArcWidth(), SilComp.getHorizArcWidth(), bCell);
                            if (via.instance == null) {
                                return "Cannot create via in MAKER";
                            }
                            inst = (MakerInst)via.chPort.port.place.cell.tp;
                            if (this.trackLayer1(inst.instance, (PortProto)via.chPort.port.port.port, via.instance, null, SilComp.getHorizArcWidth(), bCell) == null) {
                                return "Cannot create layer2 track in MAKER";
                            }
                        } else {
                            MakerInst inst3;
                            if (via.next != null && (via.next.flags & 4) == 0 && Math.abs(via.next.xPos - via.xPos) < trackToTtrack) {
                                if ((via.flags & 2) != 0) {
                                    via.next.flags |= 1;
                                } else {
                                    via.flags |= 1;
                                }
                            }
                            if ((via.flags & 1) != 0) {
                                via.instance = NodeInst.makeInstance(this.layer2Proto, new Point2D.Double(via.xPos, track.yPos), SilComp.getVertArcWidth(), SilComp.getVertArcWidth(), bCell);
                                if (via.instance == null) {
                                    return "Cannot create leaf feed in MAKER";
                                }
                            } else {
                                via.instance = NodeInst.makeInstance(this.viaProto, new Point2D.Double(via.xPos, track.yPos), this.viaProto.getDefWidth(), this.viaProto.getDefHeight(), bCell);
                                if (via.instance == null) {
                                    return "Cannot create via in MAKER";
                                }
                            }
                            GetNetlist.SCNiTree node = via.chPort.port.place.cell;
                            if (node.type == 0) {
                                inst3 = (MakerInst)node.tp;
                                if (this.trackLayer2(inst3.instance, (PortProto)via.chPort.port.port.port, via.instance, null, SilComp.getVertArcWidth(), bCell) == null) {
                                    return "Cannot create layer2 track in MAKER";
                                }
                            } else if (node.type == 3 || node.type == 5) {
                                inst3 = (MakerInst)node.tp;
                                if (this.trackLayer2(inst3.instance, null, via.instance, null, SilComp.getVertArcWidth(), bCell) == null) {
                                    return "Cannot create layer2 track in MAKER";
                                }
                            }
                        }
                        via = via.next;
                    }
                    mNode = mNode.next;
                }
                track = track.next;
            }
            chan = chan.next;
        }
        chan = data.channels;
        while (chan != null) {
            MakerTrack track = chan.tracks;
            while (track != null) {
                mNode = track.nodes;
                while (mNode != null) {
                    via = mNode.vias;
                    while (via != null) {
                        if (via.next != null) {
                            if ((via.flags & 1) != 0) {
                                if (Math.abs(via.next.xPos - via.xPos) < trackToTtrack && this.trackLayer2(via.instance, null, via.next.instance, null, SilComp.getVertArcWidth(), bCell) == null) {
                                    return "Cannot create layer1 track in MAKER";
                                }
                            } else {
                                if ((via.flags & 4) == 0 && (via.next.flags & 4) == 0 && via.next.xPos - via.xPos < trackToTtrack && this.trackLayer2(via.instance, null, via.next.instance, null, SilComp.getVertArcWidth(), bCell) == null) {
                                    return "Cannot create layer1 track in MAKER";
                                }
                                MakerVia via2 = via.next;
                                while (via2 != null) {
                                    if ((via2.flags & 1) == 0) {
                                        if (this.trackLayer1(via.instance, null, via2.instance, null, SilComp.getHorizArcWidth(), bCell) != null) break;
                                        return "Cannot create layer1 track in MAKER";
                                    }
                                    via2 = via2.next;
                                }
                            }
                        }
                        via = via.next;
                    }
                    mNode = mNode.next;
                }
                track = track.next;
            }
            chan = chan.next;
        }
        for (Place.RowList rlist : data.cell.placement.theRows) {
            Place.NBPlace place = rlist.start;
            while (place != null) {
                NodeInst inst2;
                PortProto port1;
                NodeInst inst1;
                Route.RoutePort rPort;
                if (place.cell.type == 4) {
                    rPort = (Route.RoutePort)place.cell.ports.port;
                    inst = (MakerInst)rPort.place.cell.tp;
                    inst1 = inst.instance;
                    port1 = (PortProto)rPort.port.port;
                    rPort = (Route.RoutePort)place.cell.ports.next.port;
                    inst = (MakerInst)rPort.place.cell.tp;
                    inst2 = inst.instance;
                    PortProto port2 = (PortProto)rPort.port.port;
                    if (this.trackLayer1(inst1, port1, inst2, port2, SilComp.getHorizArcWidth(), bCell) == null) {
                        return "Cannot create layer1 track in MAKER";
                    }
                } else if (place.cell.type == 5) {
                    rPort = (Route.RoutePort)place.cell.ports.port;
                    inst = (MakerInst)rPort.place.cell.tp;
                    inst1 = inst.instance;
                    port1 = (PortProto)rPort.port.port;
                    inst = (MakerInst)place.cell.tp;
                    inst2 = inst.instance;
                    if (this.trackLayer1(inst1, port1, inst2, null, SilComp.getHorizArcWidth(), bCell) == null) {
                        return "Cannot create layer2 track in MAKER";
                    }
                }
                place = place.next;
            }
        }
        chan = data.channels;
        while (chan != null) {
            MakerTrack track = chan.tracks;
            while (track != null) {
                mNode = track.nodes;
                while (mNode != null) {
                    via = mNode.vias;
                    while (via != null) {
                        if ((via.flags & 2) != 0 && this.exportPort(via.instance, null, via.xPort.xPort.name, via.xPort.xPort.bits & 0x3F0, bCell) == null) {
                            return "Cannot create export port '" + via.xPort.xPort.name + "' in MAKER";
                        }
                        via = via.next;
                    }
                    mNode = mNode.next;
                }
                track = track.next;
            }
            chan = chan.next;
        }
        NodeInst lastPower = null;
        double xPos = data.minX - rowToTrack - SilComp.getMainPowerWireWidth() / 2.0;
        String mainPowerArc = SilComp.getMainPowerArc();
        boolean mainPwrRailHoriz = mainPowerArc.equals("Horizontal Arc");
        MakerPower pList = data.power;
        while (pList != null) {
            double yPos = pList.yPos;
            NodeInst bInst = null;
            bInst = mainPwrRailHoriz ? NodeInst.makeInstance(this.layer1Proto, new Point2D.Double(xPos, yPos), SilComp.getMainPowerWireWidth(), SilComp.getMainPowerWireWidth(), bCell) : NodeInst.makeInstance(this.layer2Proto, new Point2D.Double(xPos, yPos), SilComp.getMainPowerWireWidth(), SilComp.getMainPowerWireWidth(), bCell);
            if (bInst == null) {
                return "Cannot create via in MAKER";
            }
            if (lastPower != null && (mainPwrRailHoriz ? this.trackLayer1(bInst, null, lastPower, null, SilComp.getMainPowerWireWidth(), bCell) == null : this.trackLayer2(bInst, null, lastPower, null, SilComp.getMainPowerWireWidth(), bCell) == null)) {
                return "Cannot create layer1 track in MAKER";
            }
            lastPower = bInst;
            MakerPowerPort pPort = pList.ports;
            while (pPort != null) {
                if (pPort.last == null && this.trackLayer1(lastPower, null, pPort.inst.instance, (PortProto)pPort.port.port, SilComp.getPowerWireWidth(), bCell) == null) {
                    return "Cannot create layer1 track in MAKER";
                }
                if (pPort.next != null && this.trackLayer1(pPort.inst.instance, (PortProto)pPort.port.port, pPort.next.inst.instance, (PortProto)pPort.next.port.port, SilComp.getPowerWireWidth(), bCell) == null) {
                    return "Cannot create layer1 track in MAKER";
                }
                pPort = pPort.next;
            }
            pList = pList.next;
        }
        NodeInst lastGround = null;
        xPos = data.maxX + rowToTrack + SilComp.getMainPowerWireWidth() / 2.0;
        MakerPower pList2 = data.ground;
        while (pList2 != null) {
            double yPos = pList2.yPos;
            NodeInst bInst = null;
            bInst = mainPwrRailHoriz ? NodeInst.makeInstance(this.layer1Proto, new Point2D.Double(xPos, yPos), SilComp.getMainPowerWireWidth(), SilComp.getMainPowerWireWidth(), bCell) : NodeInst.makeInstance(this.layer2Proto, new Point2D.Double(xPos, yPos), SilComp.getMainPowerWireWidth(), SilComp.getMainPowerWireWidth(), bCell);
            if (bInst == null) {
                return "Cannot create via in MAKER";
            }
            if (lastGround != null) {
                if (mainPwrRailHoriz ? this.trackLayer1(bInst, null, lastGround, null, SilComp.getMainPowerWireWidth(), bCell) == null : this.trackLayer2(bInst, null, lastGround, null, SilComp.getMainPowerWireWidth(), bCell) == null) {
                    return "Cannot create layer1 track in MAKER";
                }
            } else if (this.exportPort(bInst, null, "gnd", 16, bCell) == null) {
                return "Cannot create export port 'gnd' in MAKER";
            }
            lastGround = bInst;
            MakerPowerPort pPort = pList2.ports;
            while (pPort != null) {
                if (pPort.next == null ? this.trackLayer1(lastGround, null, pPort.inst.instance, (PortProto)pPort.port.port, SilComp.getPowerWireWidth(), bCell) == null : this.trackLayer1(pPort.inst.instance, (PortProto)pPort.port.port, pPort.next.inst.instance, (PortProto)pPort.next.port.port, SilComp.getPowerWireWidth(), bCell) == null) {
                    return "Cannot create layer1 track in MAKER";
                }
                pPort = pPort.next;
            }
            pList2 = pList2.next;
        }
        if (lastPower != null && this.exportPort(lastPower, null, "vdd", 32, bCell) == null) {
            return "Cannot create export port 'vdd' in MAKER";
        }
        if (SilComp.getPWellHeight() != 0.0) {
            MakerRow row2 = data.rows;
            while (row2 != null) {
                MakerInst firstInst = null;
                MakerInst prevInst = null;
                MakerInst inst4 = row2.members;
                while (inst4 != null) {
                    if (inst4.place.cell.type == 0) {
                        if (firstInst == null) {
                            firstInst = inst4;
                        } else {
                            prevInst = inst4;
                        }
                    }
                    inst4 = inst4.next;
                }
                if (prevInst != null) {
                    NodeInst bInst;
                    double yPos;
                    xPos = (firstInst.xPos + prevInst.xPos + prevInst.xSize) / 2.0;
                    double xSize = prevInst.xPos + prevInst.xSize - firstInst.xPos;
                    double ySize = SilComp.getPWellHeight();
                    if (ySize > 0.0) {
                        yPos = firstInst.yPos + SilComp.getPWellOffset() + SilComp.getPWellHeight() / 2.0;
                        if (this.pWellProto != null && (bInst = NodeInst.makeInstance(this.pWellProto, new Point2D.Double(xPos, yPos), xSize, ySize, bCell)) == null) {
                            return "Unable to create P-WELL in MAKER";
                        }
                    }
                    if ((ySize = SilComp.getNWellHeight()) > 0.0) {
                        yPos = firstInst.yPos + firstInst.ySize - SilComp.getNWellOffset() - SilComp.getNWellHeight() / 2.0;
                        if (this.nWellProto != null && (bInst = NodeInst.makeInstance(this.nWellProto, new Point2D.Double(xPos, yPos), xSize, ySize, bCell)) == null) {
                            return "Unable to create N-WELL in MAKER";
                        }
                    }
                }
                row2 = row2.next;
            }
        }
        return bCell;
    }

    private Export exportPort(NodeInst inst, PortProto port, String name, int type, Cell bCell) {
        PortInst pi;
        Export xPort;
        if (port == null) {
            port = inst.getProto().getPort(0);
        }
        if ((xPort = Export.newInstance(bCell, pi = inst.findPortInstFromProto(port), name)) == null) {
            return null;
        }
        switch (type) {
            case 256: {
                xPort.setCharacteristic(PortCharacteristic.IN);
                break;
            }
            case 128: {
                xPort.setCharacteristic(PortCharacteristic.OUT);
                break;
            }
            case 64: {
                xPort.setCharacteristic(PortCharacteristic.BIDIR);
                break;
            }
            case 32: {
                xPort.setCharacteristic(PortCharacteristic.PWR);
                break;
            }
            default: {
                xPort.setCharacteristic(PortCharacteristic.GND);
            }
        }
        return xPort;
    }

    private ArcInst trackLayer1(NodeInst instA, PortProto portA, NodeInst instB, PortProto portB, double width, Cell bCell) {
        if (portA == null) {
            portA = instA.getProto().getPort(0);
        }
        if (portB == null) {
            portB = instB.getProto().getPort(0);
        }
        PortInst piA = instA.findPortInstFromProto(portA);
        PortInst piB = instB.findPortInstFromProto(portB);
        Poly polyA = piA.getPoly();
        Poly polyB = piA.getPoly();
        double xA = polyA.getCenterX();
        double yA = polyA.getCenterY();
        double xB = polyB.getCenterX();
        double yB = polyB.getCenterY();
        if (!portA.getBasePort().connectsTo(this.layer1Arc)) {
            piA = this.createConnection(piA, xA, yA, this.layer1Arc);
        }
        if (!portB.getBasePort().connectsTo(this.layer1Arc)) {
            piB = this.createConnection(piB, xB, yB, this.layer1Arc);
        }
        ArcInst inst = ArcInst.makeInstanceBase(this.layer1Arc, width, piA, piB);
        return inst;
    }

    private ArcInst trackLayer2(NodeInst instA, PortProto portA, NodeInst instB, PortProto portB, double width, Cell bCell) {
        if (portA == null) {
            portA = instA.getProto().getPort(0);
        }
        if (portB == null) {
            portB = instB.getProto().getPort(0);
        }
        PortInst piA = instA.findPortInstFromProto(portA);
        PortInst piB = instB.findPortInstFromProto(portB);
        Poly polyA = piA.getPoly();
        Poly polyB = piA.getPoly();
        double xA = polyA.getCenterX();
        double yA = polyA.getCenterY();
        double xB = polyB.getCenterX();
        double yB = polyB.getCenterY();
        if (!portA.getBasePort().connectsTo(this.layer2Arc)) {
            piA = this.createConnection(piA, xA, yA, this.layer1Arc);
        }
        if (!portB.getBasePort().connectsTo(this.layer2Arc)) {
            piB = this.createConnection(piB, xB, yB, this.layer1Arc);
        }
        ArcInst inst = ArcInst.makeInstanceBase(this.layer2Arc, width, piA, piB);
        return inst;
    }

    private PortInst createConnection(PortInst pi, double x, double y, ArcProto arc) {
        if (this.viaProto == null) {
            return null;
        }
        PrimitiveNode.Function fun = this.viaProto.getFunction();
        if (fun != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.CONNECT) {
            return null;
        }
        if (pi.getPortProto() instanceof PrimitivePort) {
            arc = ((PrimitivePort)pi.getPortProto()).getConnections()[0];
        }
        if (!this.viaProto.getPort(0).connectsTo(arc)) {
            return null;
        }
        NodeInst viaNode = NodeInst.makeInstance(this.viaProto, new Point2D.Double(x, y), this.viaProto.getDefWidth(), this.viaProto.getDefHeight(), pi.getNodeInst().getParent());
        if (viaNode == null) {
            return null;
        }
        PortInst newPi = viaNode.getOnlyPortInst();
        ArcInst zeroArc = ArcInst.makeInstance(arc, pi, newPi);
        if (zeroArc == null) {
            return null;
        }
        return newPi;
    }

    private String setupForMaker() {
        Technology tech = Technology.getCurrent();
        if (tech == Schematics.tech) {
            tech = User.getSchematicTechnology();
        }
        String layer1 = SilComp.getHorizRoutingArc();
        String layer2 = SilComp.getVertRoutingArc();
        this.layer1Arc = tech.findArcProto(layer1);
        this.layer2Arc = tech.findArcProto(layer2);
        if (this.layer1Arc == null) {
            return "Unable to find Horizontal Arc " + layer1 + " for MAKER";
        }
        if (this.layer2Arc == null) {
            return "Unable to find Vertical Arc " + layer2 + " for MAKER";
        }
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitivePort pp;
            PrimitiveNode via = it.next();
            PrimitiveNode.Function fun = via.getFunction();
            if (fun != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.CONNECT || !(pp = via.getPort(0)).connectsTo(this.layer1Arc) || !pp.connectsTo(this.layer2Arc)) continue;
            this.viaProto = via;
            break;
        }
        if (this.viaProto == null) {
            return "Unable to get VIA for MAKER";
        }
        this.layer1Proto = this.layer1Arc.findPinProto();
        if (this.layer1Proto == null) {
            return "Unable to get LAYER1-NODE for MAKER";
        }
        this.layer2Proto = this.layer2Arc.findPinProto();
        if (this.layer2Proto == null) {
            return "Unable to get LAYER2-NODE for MAKER";
        }
        if (SilComp.getPWellHeight() == 0.0) {
            this.pWellProto = null;
        } else {
            this.pWellProto = null;
            Layer pWellLay = tech.findLayerFromFunction(Layer.Function.WELLP);
            if (pWellLay != null) {
                this.pWellProto = pWellLay.getPureLayerNode();
            }
            if (this.pWellProto == null) {
                return "Unable to get LAYER P-WELL for MAKER";
            }
        }
        if (SilComp.getNWellHeight() == 0.0) {
            this.nWellProto = null;
        } else {
            this.nWellProto = null;
            Layer nWellLay = tech.findLayerFromFunction(Layer.Function.WELLN);
            if (nWellLay != null) {
                this.nWellProto = nWellLay.getPureLayerNode();
            }
            if (this.nWellProto == null) {
                return "Unable to get LAYER P-WELL for MAKER";
            }
        }
        return null;
    }

    private static class MakerPowerPort {
        MakerInst inst;
        GetNetlist.SCNiPort port;
        double xPos;
        MakerPowerPort next;
        MakerPowerPort last;

        private MakerPowerPort() {
        }
    }

    private static class MakerPower {
        MakerPowerPort ports;
        double yPos;
        MakerPower next;
        MakerPower last;

        private MakerPower() {
        }
    }

    private static class MakerVia {
        double xPos;
        Route.RouteChPort chPort;
        NodeInst instance;
        int flags;
        Route.RouteExport xPort;
        MakerVia next;

        private MakerVia() {
        }
    }

    private static class MakerNode {
        MakerVia vias;
        MakerNode next;

        private MakerNode() {
        }
    }

    private static class MakerTrack {
        int number;
        MakerNode nodes;
        Route.RouteTrack track;
        double yPos;
        int flags;
        MakerTrack last;
        MakerTrack next;

        private MakerTrack() {
        }
    }

    private static class MakerChannel {
        int number;
        MakerTrack tracks;
        int numTracks;
        double minY;
        double ySize;
        int flags;
        MakerChannel last;
        MakerChannel next;

        private MakerChannel() {
        }
    }

    private static class MakerInst {
        Place.NBPlace place;
        MakerRow row;
        double xPos;
        double yPos;
        double xSize;
        double ySize;
        int flags;
        NodeInst instance;
        MakerInst next;

        private MakerInst() {
        }
    }

    private static class MakerRow {
        int number;
        MakerInst members;
        double minX;
        double maxX;
        double minY;
        double maxY;
        int flags;
        MakerRow last;
        MakerRow next;

        private MakerRow() {
        }
    }

    private static class MakerData {
        GetNetlist.SCCell cell;
        MakerRow rows;
        MakerChannel channels;
        MakerPower power;
        MakerPower ground;
        double minX;
        double maxX;
        double minY;
        double maxY;

        private MakerData() {
        }
    }
}

