/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.DBMath;
import java.awt.geom.Point2D;
import java.io.Serializable;

public final class EPoint
extends Point2D
implements Serializable {
    public static final EPoint ORIGIN = new EPoint(0L, 0L);
    private final int gridX;
    private final int gridY;
    private final double lambdaX;
    private final double lambdaY;
    private static int createdEPoints;

    public EPoint(double lambdaX, double lambdaY) {
        this(DBMath.lambdaToGrid(lambdaX), DBMath.lambdaToGrid(lambdaY));
    }

    private EPoint(long gridX, long gridY) {
        this.gridX = (int)gridX;
        this.gridY = (int)gridY;
        if ((long)this.gridX != gridX || (long)this.gridY != gridY) {
            throw new IllegalArgumentException("Too large coordinates (" + gridX + "," + gridY + ")");
        }
        this.lambdaX = DBMath.gridToLambda(gridX);
        this.lambdaY = DBMath.gridToLambda(gridY);
        ++createdEPoints;
    }

    public static EPoint fromLambda(double lambdaX, double lambdaY) {
        return lambdaX == 0.0 && lambdaY == 0.0 ? ORIGIN : EPoint.fromGrid(DBMath.lambdaToGrid(lambdaX), DBMath.lambdaToGrid(lambdaY));
    }

    public static EPoint fromGrid(long gridX, long gridY) {
        return gridX == 0L && gridY == 0L ? ORIGIN : new EPoint(gridX, gridY);
    }

    public static EPoint snap(Point2D p) {
        return p instanceof EPoint ? (EPoint)p : EPoint.fromLambda(p.getX(), p.getY());
    }

    public double getX() {
        return this.getLambdaX();
    }

    public double getY() {
        return this.getLambdaY();
    }

    public double getLambdaX() {
        return this.lambdaX;
    }

    public double getLambdaY() {
        return this.lambdaY;
    }

    public long getGridX() {
        return this.gridX;
    }

    public long getGridY() {
        return this.gridY;
    }

    public void setLocation(double x, double y) {
        throw new UnsupportedOperationException();
    }

    public Point2D.Double lambdaMutable() {
        return new Point2D.Double(this.getLambdaX(), this.getLambdaY());
    }

    public Point2D.Double gridMutable() {
        return new Point2D.Double(this.getGridX(), this.getGridY());
    }

    public double lambdaDistance(EPoint pt) {
        return DBMath.gridToLambda(this.gridDistance(pt));
    }

    public double gridDistance(EPoint pt) {
        long PX = pt.getGridX() - this.getGridX();
        long PY = pt.getGridY() - this.getGridY();
        return PY == 0L ? (double)Math.abs(PX) : (PX == 0L ? (double)Math.abs(PY) : Math.hypot(PX, PY));
    }

    public boolean isSmall() {
        return ((this.gridX - -1073741824 | this.gridY - -1073741824) & Integer.MIN_VALUE) == 0;
    }

    public boolean equals(EPoint that) {
        return this.gridX == that.gridX && this.gridY == that.gridY;
    }

    public String toString() {
        return "EPoint[" + this.getX() + ", " + this.getY() + "]";
    }

    public static void printStatistics() {
        System.out.println(createdEPoints + " EPoints created");
    }
}

